/*

 Ŀ
                                                                        
  File Name...: CVTBASE.PRG                                             
  Author......: Vernon E. Six, Jr.                                      
  Date created: 07-28-94              Date updated: 08-27-94           
  Time created: 02:19:55pm            Time updated: 09:19:19am         
  CopyRight...: (c) 1994 by FrontLine Software                          
                                                                        
 
  

*/

#include "BAS_VERN.CH"

/* HYPERTEXT START
!short: basCvtBase()    Convert between two numeric bases
basCvtBase()    Convert between two numeric bases

^BDescription: ^B

   basCvtBase() allows you to convert a number from one numeric base to any
   other numeric base.


^BSyntax:^B

   xValue := basCvtBase( nFrom, nTo, xOld )


^BPass:^B

   ^BnFrom^B is a numeric expression that should contain the numeric base you
   are converting from  ie: 16 for hexidecimal, 8 for octal, etc.

   ^BnTo^B is a numeric expression that should contain the numeric base you
   are converting to   ie: 16 for hexidecimal, 8 for octal, etc.

   ^BxOld^B is a character expression (unless you are converting from base 10
   in which case it's a numeric expression) that should contain the number you
   are converting.


^BReturns:^B

   ^BxValue^B is a character expression (unless you are converting to base 10
   in which case it's a numeric expression) that will contain the number you
   want converted in the desired numeric base.


^BSource:^B

   CVTBASE.PRG

HYPERTEXT END */
function basCvtBase( pnFrom, pnTo, pOld )

   local nInteger := 0
   local xValue   := nil

   if pnFrom == 10
      nInteger := int( pOld )
   else
      nInteger := basBase2Dec( pnFrom, pOld )
   endif

   if pnTo == 10
      xValue   := nInteger
   else
      xValue   := basDec2Base( pnTo, nInteger )
   endif

   return xValue



/* HYPERTEXT START
!short: basDec2Base()   Convert an integer to any other base
basDec2Base()   Convert an integer to any other base

^BDescription: ^B

   basDec2Base() allows you to convert an integer to any other numeric base
   you want.


^BSyntax:^B

   cValue := basDec2Base( nBase, nInteger )


^BPass:^B

   ^BnBase^B is a numeric expression that should contain the numeric base you
   are converting to  ie: 16 for hexidecimal, 8 for octal, etc.

   ^BnInteger^B is a numeric expression that should contain the integer you
   want to convert.


^BReturns:^B

   ^BcValue^B is a character expression that will contain the number you want
   converted in the desired numeric base.


^BSource:^B

   CVTBASE.PRG

HYPERTEXT END */
function basDec2Base( pnBase, pnInteger )

   local cDigits  := "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ"
   local cValue   := ""
   local nEvenly  := 0
   local nColumn  := 1

   // Find out how big we have to go!
   while nColumn < pnInteger
      nColumn *= pnBase
   enddo

   while nColumn > 0

      nEvenly   := int( pnInteger / nColumn )

      cValue    += substr( cDigits, nEvenly + 1, 1 )

      pnInteger -= ( nEvenly * nColumn )

      nColumn   := int( nColumn / pnBase )

   enddo

   return cValue




/* HYPERTEXT START
!short: basBase2Dec()   Convert any numeric base expression to an integer
basBase2Dec()   Convert any numeric base expression to an integer

^BDescription: ^B

   basBase2Dec() allows you to convert any numeric expression of any numeric
   base to a integer


^BSyntax:^B

   nInteger := basBase2Dec( nBase, cNumber )


^BPass:^B

   ^BnBase^B is a numeric expression that should contain the numeric base you
   are converting from  ie: 16 for hexidecimal, 8 for octal, etc.

   ^BcNumber^B is a character expression that should contain the numeric
   expression that you want to convert.


^BReturns:^B

   ^BcInteger^B is a numeric expression that will contain the number you want
   converted.


^BSource:^B

   CVTBASE.PRG

HYPERTEXT END */
function basBase2Dec( pnBase, pcValue )

   local nInteger := 0
   local cDigits  := "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ"

   while len( pcValue ) != 0

      nInteger *= pnBase
      nInteger += at( left(pcValue,1), cDigits ) - 1

      pcValue  := right( pcValue, len(pcValue) - 1 )

   enddo

   return nInteger


/* HYPERTEXT START
!short: basDecTo36()    Convert an integer to a base 36 numeric expression
basDecTo36()    Convert an integer to a base 36 numeric expression

^BDescription: ^B

   basDecTo36() allows you to convert an integer to a base 36 numeric
   expression.


^BSyntax:^B

   cValue := basDecTo36( nInteger )


^BPass:^B

   ^BbInteger^B is a numeric expression that should contain the integer you
   want to convert.


^BReturns:^B

   ^BcValue^B is a character expression that will contain the base 36
   equivilant of ^BnInteger^B.


^BSource:^B

   CVTBASE.PRG

HYPERTEXT END */
function basDecTo36(pnInteger)

   return right(basDec2Base(36,pnInteger),6)

