/*

  Program Ŀ
                                                                        
  File Name...: INKEY.PRG                                               
  Author......: Vernon E. Six, Jr.                                      
  Date created: 02-20-94              Date updated: 04-04-94           
  Time created: 02:07:28pm            Time updated: 09:11:09pm         
  CopyRight...: (c) 1994 by FrontLine Software                          
                                                                        
 
  

*/


// NOTE: This is written to solve a bug with Lantastic and INKEY()

#include "BAS_VERN.CH"
#include "inkey.ch"

/* HYPERTEXT START
!short: basInkey()      Replacement for INKEY() to make it into a wait-state
basInkey()      Replacement for INKEY to make it into a wait-state

^BDescription: ^B

   basInkey() is a direct replacement Clipper's own INKEY() function.  The
   only difference is that your SetKey()'s will respond properly now whereas
   with INKEY() they don't.


^BSyntax:^B

   nKey := basInkey( [nTime] )


^BPass:^B

   ^BnTime^B is a numeric expression that should contain the number of
   seconds you want basInkey() to wait for a keypress.  A value of zero
   will wait forever, whereas no value will only strobe the keyboard and
   return immediately.


^BReturns:^B

   ^BnKey^B is a numeric expression that will contain the INKEY() value of
   the key the user pressed.  If the user does not press a key within the
   specified ^BnTime^B seconds, ^BnKey^B will be zero.


^BSource:^B

   INKEY.PRG


HYPERTEXT END */
function basInkey(pnTime)

   local nKey    := 0
   local bKeyBlk := nil
   local nStart  := _TIME_NOW

   while .t.

      if pcount() == 0

         while nextkey() == 0
         enddo

      else

         while .not. basElapSecs( nStart, _TIME_NOW ) > pnTime
            if nextkey() != 0
               exit
            endif
         enddo

      endif

      nKey := inkey()

      bKeyBlk := SetKey(nKey)

      if .not. bKeyBlk == nil

         eval( bKeyBlk,ProcName(1),ProcLine(1),"basInkey" )
         loop

      endif

      exit

   enddo

   return nKey


