/*

  Program Ŀ
                                                                        
  File Name...: MSG.PRG                                                 
  Author......: Vernon E. Six, Jr.                                      
  Date created: 03-12-94              Date updated: 09-28-94           
  Time created: 03:58:42pm            Time updated: 05:43:37pm         
  CopyRight...: (c) 1994 by FrontLine Software                          
                                                                        
 
  

*/

#include "BAS_VERN.CH"
#include "setcurs.ch"



/* HYPERTEXT START
!short: basMsg()        Display a simple message window
basMsg()        Display a simple message window

^BDescription: ^B

   basMsg() allows your programs to display a quick-n-dirty message window
   that waits for the user to press a key to continue.


^BSyntax:^B

   basMsg( [cTitle], [nPalette], [cLine1], [cLine2], [cLine3] )


^BPass:^B

   ^BcTitle^B is an optional character expression that should contain the
   title for the message window.

   ^BnPalette^B is an optional numeric expression that should contain the
   color palette you want this message displayed in.  The current color
   palette is assumed if you don't pass ^BnPalette^B.

   ^BcLine1^B is an optional character expression that should contain a line
   of text you want displayed in the the message window.

   ^BcLine2^B is an optional character expression that should contain a line
   of text you want displayed in the the message window.

   ^BcLine3^B is an optional character expression that should contain a line
   of text you want displayed in the the message window.


^BReturns:^B

   Nothing


^BSource:^B

   MSG.PRG

HYPERTEXT END */
function basMsg( pcTitle, pnPalette, pcLine1, pcLine2, pcLine3 )

   local nLines  := 0
   local acLines := {}
   local nCntr   := 0

   if .not. empty(pcLine1)
      nLines++
      aAdd( acLines, pcLine1 )
   endif

   if .not. empty(pcLine2)
      nLines++
      aAdd( acLines, pcLine2 )
   endif

   if .not. empty(pcLine3)
      nLines++
      aAdd( acLines, pcLine3 )
   endif

   basSaveScrn()

   SetCursor(SC_NONE)

   basWind( 18-nLines,10,21,70,pcTitle,"Press any key to continue",pnPalette )

   for nCntr := 1 to nLines

      @ 19-nLines + (nCntr), 12 say padc(acLines[nCntr],57) color basStdColor()

   next nCntr

   basInkeyZero()

   basRestScrn()

   return nil


