/*

 Ŀ
                                                                        
  File Name...: REMOTE.PRG                                              
  Author......: Vern Six                                                
  Date created: 09-30-94                Date updated: 09-30-94         
  Time created: 11:20:39am              Time updated: 11:20:39am       
  CopyRight...: (c) 1994 by FrontLine Software                          
                                                                        
 
  

*/



// host mode command line utility
function Remote(pcCmd,pcFileName,pcUser,pcKillSent)

   cls
   ? "Remote v1.1 - Command Line Version"
   ? "CopyRight (c) 1994 by FrontLine Software"
   ? "All Rights Reserved World Wide"
   ?
   ?

   begin sequence

      do case

         case pcount() == 0

            sSyntax()

         case upper(pcCmd) == "CALL"

            remRemote()

         case upper(pcCmd) == "SEND"

            if pcount() < 4
               sSyntax()
               break
            endif

            remAddFile( pcUser, pcFileName, (pcKillSent $ "YyTt") )


         case upper(pcCmd) == "FILESENT"

            if pcount() != 3
               sSyntax()
               break
            endif

            remFileSent(pcUSer,pcFileName)


         case upper(pcCmd) == "REMFILE"

            if pcount() != 3
               sSyntax()
               break
            endif

            remRemFile(pcUSer,pcFileName)


         otherwise

            sSyntax()


      endcase

   end sequence

   return nil


static function sSyntax()

   ? "Proper Syntax:"
   ?
   ? "REMOTE CALL                                - Place a call to host"
   ?
   ? "REMOTE SEND {filename} {user} {killsent}   - Send a file to a user"
   ? "  Example:  REMOTE SEND C:\AUTOEXEC.BAT VERNSIX Y"
   ?
   ? "REMOTE FILESENT {filename} {user}          - Mark file as sent"
   ? "  Example:  REMOTE FILESENT C:\AUTOEXEC.BAT VERNSIX"
   ?
   ? "REMOTE REMFILE {filename} {user}           - Remove file from queue"
   ? "  Example:  REMOTE REMFILE C:\AUTOEXEC.BAT VERNSIX"
   ?
   ?

   return nil

