/*

 Ŀ
                                                                        
  File Name...: SKIPPER.PRG                                             
  Author......: Vernon E. Six, Jr.                                      
  Date created: 08-27-94              Date updated: 08-27-94           
  Time created: 11:53:09am            Time updated: 11:53:09am         
  CopyRight...: (c) 1994 by FrontLine Software                          
                                                                        
 
  

*/




/* HYPERTEXT START
!short: basSkipper()    Generic "skipblock" for browsing arrays
basSkipper()    Generic "skipblock" for browsing arrays

^BDescription: ^B

   basSkipper() is a generic "skipblock" function designed for use when
   using tBrowse() to browse an array.


^BSyntax:^B

   nActual := basSkipper( nLength, @nCurrPos, nHowMany )


^BPass:^B

   ^BnLength^B is a numeric expression that should contain the length of
   the array you are browsing.

   ^B@nCurrPos^B is a numeric expression that must be passed by reference
   and should contain the current index into the array you are browsing.

   ^BnHowMany^B is a numeric expression that should contain the number of
   rows you want to move within the tBrowse()


^BReturns:^B

   ^BnActual^B is a numeric expression that will contain the actual number
   of rows moved.


^BExample:^B

   function ArrayBrow()

   local array   := {"JOHN","HENRY", ... } // Create the array
   local nKey    := 0
   local nPos    := 1
   local oBrowse := TBrowseNew(5,5,20,75)

   oBrowse:AddColumn( tbColumnNew( "Name", array[nPos] ) )

   oBrowse:GoTopBlock    := {| | nPos := 1          }
   oBrowse:GoBottomBlock := {| | nPos := len(Array) }

   oBrowse:SkipBlock     := {|n| basSkipper( len(Array), @nPos, n ) }

   while .t.

      while .not. oBrowse:stablize()
      enddo

      nKey := inkey(0)

      do case
         case nKey == K_UP     ; oBrowse:Up()
         case nKey == K_DOWN   ; oBrowse:Down()
         case nKey == K_PGUP   ; oBrowse:PageUp()
         case nKey == K_PGDN   ; oBrowse:PageDown()
         case nKey == K_ESC    ; exit
      endcase

   enddo

   return nil


^BSource:^B

   SKIPPER.PRG

HYPERTEXT END */
function basSkipper( pnLength, pnCurrPos, pnHowMany )

   local nActual := 0

   if pnHowMany >= 0                   // Moving downward

      if (pnCurrPos + pnHowMany) > pnLength

         nActual   := pnLength - pnCurrPos
         pnCurrPos := pnLength

      else

         nActual   := pnHowMany
         pnCurrPos += pnHowMany

      endif

   else                                // Moving upward

      if (pnCurrPos + pnHowMany) < 1

         nActual   := 1 - pnCurrPos
         pnCurrPos := 1

      else

         nActual   := pnHowMany
         pnCurrPos += pnHowMany

      endif

   endif

   return nActual


