/*

 Ŀ
                                                                        
  File Name...: WIND.PRG                                                
  Author......: Vernon E. Six, Jr.                                      
  Date created: 04-04-94              Date updated: 04-04-94           
  Time created: 09:30:12pm            Time updated: 09:30:12pm         
  CopyRight...: (c) 1994 by FrontLine Software                          
                                                                        
 
  

*/

#include "BAS_VERN.CH"
#include "box.ch"


/* HYPERTEXT START
!short: basWind()       Draw a window
basWind()       Draw a window

^BDescription: ^B

   basWind() allows you to draw a window with a shadow, title and footer.


^BSyntax:^B

   basWind( nTop, nLeft, nBottom, nRight, [cTitle], [cFooter], [nPalette] )


^BPass:^B

   ^BnTop, nLeft, nBottom and nRight^B are all numeric expression that
   should contain the four coordinates for the window.

   ^BcTitle^B is an optional character expression that should contain the
   title to be displayed at the top left of the window.  None is assumed if
   you don't pass ^BcTitle^B.

   ^BcFooter^B is an optional character expression that should contain the
   footer to be displayed at the bottom cente of the window.  None is
   assumed if you don't pass ^BcFooter^B.

   ^BnPalette^B is an optional numeric expression that should contain the
   color palette you want this window drawn in.  The current color palette
   is assumed if you don't pass ^BnPalette^B.  A call is also made to
   basSetColor() with the specified ^BnPalette^B.


^BReturns:^B

   Always nil


^BSource:^B

   WIND.PRG

HYPERTEXT END */
function basWind(pnTop,pnLeft,pnBottom,pnRight,pcTitle,pcFootNote,pnPalette)

   assume pnTop      is 0                    if missing
   assume pnLeft     is 0                    if missing
   assume pnBottom   is MaxRow()             if missing
   assume pnRight    is MaxCol()             if missing
   assume pcTitle    is ""                   if missing
   assume pcFootNote is ""                   if missing

   basDim( pnBottom+1, pnLeft+1,  pnBottom+1, pnRight+1 )
   basDim( pnTop+1,    pnRight+1, pnBottom+1, pnRight+1 )

   DispBox( pnTop, pnLeft, pnBottom, pnRight, B_DOUBLE + " ", ;
      basBoxColor(pnPalette) )

   if .not. empty(pcTitle)

      @ pnTop, pnLeft+1 say padr( " " + pcTitle + " ", pnRight-pnLeft-1, ;
         "" ) color basBoxColor(pnPalette)

   endif

   if .not. empty(pcFootNote)

      @ pnBottom,pnLeft+1 say padc( " " + pcFootNote + " ", ;
         pnRight-pnLeft-1, "" ) color basBoxColor(pnPalette)

   endif

   basSetColor(pnPalette)

   return nil







/* HYPERTEXT START
!short: basDim()        Dim a region of the screen
basDim()        Dim a region of the screen

^BDescription: ^B

   basDim() allows you to dim a specified region of the screen.


^BSyntax:^B

   basDim( nTop, nLeft, nBottom, nRight, [nAttribute] )


^BPass:^B

   ^BnTop, nLeft, nBottom and nRight^B are all numeric expression that
   should contain the four coordinates for the window.

   ^BnAttribute^B is an optional numeric expression that should contain the
   color attribute number to paint in the specified screen region.  This
   number is the same number that Clipper uses for SETCOLOR() calls.  The
   default is eight (8) if you don't pass ^BnAttribute^B.

^BReturns:^B

   Always nil


^BSource:^B

   WIND.PRG

HYPERTEXT END */
function basDim(pnTop, pnLeft, pnBottom, pnRight, pnAttribute)

   local nCntr     := 0
   local cScrImage := SaveScreen(pnTop, pnLeft, pnBottom, pnRight)
   local cDimArea  := ""
   local nLength   := 0

   assume pnAttribute is 8 if missing

   nLength := len(cScrImage)

   for nCntr := 1 to nLength step 2

      cDimArea += substr(cScrImage, nCntr, 1) + chr(pnAttribute)

   next nCntr

   RestScreen(pnTop, pnLeft, pnBottom, pnRight, cDimArea)

   return nil




