PROGRAM Find_and_Eliminate_NonUnique_Lines;
USES Dos;
CONST
  ProgDesc = 'FDUPLINS - Free DOS utility: eliminate non-unique lines from a SORTED text file';
  Author   = 'v1.01: September 15, 1994. (c) 1994 by David Daniel Anderson - Reign Ware.';

PROCEDURE showhelp (problem:byte);
{---- If any *foreseen* errors arise,
        give a little help and exit (relatively) peacefully. ----}
CONST
  Usage1 = 'Usage: FDUPLINS infile outfile [/c[y|n]] [/d#]';

  Usage1b= 'Where: infile = the OLD file - the file MUST exist.  Must also be sorted.';
  Usage1c= '      outfile = the NEW file - the file MUST NOT exist.';
  Usage2 = '          /cn = ignore case (default - unless /c or /cy specified)';
  Usage3 = '      /c, /cy = case sensitive (ie. "ZIP" does not equal "Zip")';
  Usage4 = '          /d# = number of characters at beginning of lines to disregard';
  Usage5 = '                (/d8 will disregard the first 8 characters of each line)';
VAR
  message : STRING[79];
BEGIN
  writeln;
  IF problem > 0 THEN BEGIN
    CASE problem OF
      3 : message:= 'Insufficient number of parameters.';
      5 : message:= 'The "outfile" already exists.  Rename or delete it.';
      6 : message:= 'The "infile" was not found.  Please try again.';
      7 : message:= 'Error opening or closing a file.';
     ELSE message:= 'Undefined error.'
    END;
    writeln (#7, 'Error encountered:'); writeln (message); writeln;
  END;
  writeln (usage1); writeln; writeln (usage1b); writeln (usage1c);
  writeln (usage2); writeln (usage3); writeln (usage4); writeln (usage5);
  halt (problem);
END;

FUNCTION StrToByte (s:STRING) : Byte;
VAR code : integer;
    mid  : byte;
BEGIN
  Val (s, mid, code);
  StrToByte:= mid;
END;

FUNCTION Upper (w:STRING) : STRING;
VAR
  cp  : Integer;        {The position of the character to change.}
BEGIN
  FOR cp:= 1 TO Length (w) DO
    w[cp]:= UpCase (w[cp]);
  Upper:= w;
END;

FUNCTION fileexists (filename:STRING):boolean;
VAR
  attr : word;
  f    : FILE;
BEGIN
  assign (f, filename);
  getfattr (f, attr);
  fileexists:= ( DOSerror = 0);
END;

FUNCTION AdjustLine (next:STRING; icase:boolean; dchars:byte):STRING;
VAR
  templine : STRING;
BEGIN
  IF icase THEN templine:= Upper (next)
           ELSE templine:= next;
  IF dchars > 0 THEN
    Delete (templine, 1, dchars);
  AdjustLine:= templine;
END;

PROCEDURE ElimDups (VAR ifile, ofile:text; cignore:boolean; dischars:byte);
VAR
  CrnLine, NxtLine,
  CrnLineT, NxtLineT : STRING;
BEGIN
  ReadLn (ifile, NxtLine);
  NxtLineT:= AdjustLine (NxtLine, cignore, dischars);

  WHILE NOT Eof (ifile) DO BEGIN
    CrnLine:= NxtLine;
    CrnLineT:= NxtLineT;

    ReadLn (ifile, NxtLine);
    NxtLineT:= AdjustLine (NxtLine, cignore, dischars);

    IF CrnLineT <> NxtLineT THEN
      WriteLn (ofile, CrnLine);
  END;
  WriteLn (ofile, NxtLine);
END;

VAR
  PStr, CParm,
  fname1, fname2  : STRING;
  case_ignore     : Boolean;
  count,
  NumbDisChars    : Byte;
  infile, outfile : Text;
BEGIN
  writeln;
  writeln (progdesc);
  writeln (author);

  PStr:=string(ptr(prefixseg,$0080)^);
  IF ((Length (PStr) = 0) OR
      (Pos('?',PStr) > 0) OR
      (Pos('*',PStr) > 0))
        THEN showhelp(0);

  IF ParamCount < 2 THEN showhelp (3);
  fname1:= ParamStr (1);
  fname2:= ParamStr (2);

  IF NOT fileexists (fname1) THEN showhelp (6);
  IF fileexists (fname2) THEN showhelp (5);

  case_ignore:= TRUE;
  NumbDisChars:= 0;

  FOR count:= 3 TO ParamCount DO BEGIN
    CParm:= ParamStr (count);
    CASE UpCase (CParm[2]) OF
      'C' : case_ignore := UpCase (CParm[3]) = 'N';
      'D' : NumbDisChars:= StrToByte (Copy (CParm, 3, Length(CParm)-2));
    END;
  END;

{$i-}
  Assign (infile, fname1);  Reset (infile);    IF (IOResult <> 0) THEN showhelp (7);
  Assign (outfile, fname2); Rewrite (outfile); IF (IOResult <> 0) THEN showhelp (7);
{$i+}

  Writeln;
  Writeln ('Infile            = ', fname1);
  Writeln ('Outfile           = ', fname2);
  Writeln ('Ignoring case     = ', case_ignore);
  Writeln ('Disregarded chars = ', NumbDisChars);

  ElimDups (infile, outfile, case_ignore, NumbDisChars);

  Close (infile);
  Close (outfile);
  Writeln;
  Writeln ('Successful completion!');
END.
