#pragma page(1)
#define LINT_ARGS
#define INCL_DOS
#define INCL_VIO
#define DLL

/********************************/
/* Include System Library Stuff */
/********************************/
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>


void main()
/************************************************************************/
/* Program to show presence of Intel Pentium Floating Point Divide Bug  */
/*                                                                      */
/*   Based on C++ program from  phaniraj@badlands.nodak.edu             */
/*                                                                      */
/************************************************************************/
{  /* main */
double x,y,z;

   /****************************/
   /* Set up division          */
   /****************************/

   x = 4195835.0;
   y = 3145727.0;

   /********************************************************************/
   /* The correct answer is 1.333 820 449 136 241. Bad Pentiums'll     */
   /* 1.333 739 068 902 038. That's wrong.                             */
   /* Divide x by y                                                    */
   /********************************************************************/

   z = x - (x / y) * y;

   if ( fabs(z) >= 1.e-1)
   {
      printf(" This CPU has the FDIV bug\n\n");
      printf("    4195835 / 3145727 should equal 1.333820449136241\n");
      printf("       while your processor yields %16.15f\n", (x/y));
   }
   else
      printf("This processor is mercifully free from the FDIV bug\n");


   /********************************************************************/
   /* Some more examples                                               */
   /********************************************************************/

   printf("\n");

   x = 824633702449.0;
   printf("%f should be zero\n", x - (1.0/x)*x*x);


   return;
} /* main */
