PROGRAM remove_line;
USES dos;
CONST
  progdesc = 'KLine v1.01 - Free DOS utility: Kills lines which contain a specified string.';
  author   = 'Released: September 02, 1994. (c) 1994 by David Daniel Anderson - Reign Ware.';

PROCEDURE showhelp (problem :byte);
{----
 If any *foreseen* errors arise, we are sent here,
  to give a little help and exit (relatively) peacefully
----}
CONST
  usage    = 'Usage:  KLine text_file(s) "offending string" [/c (case sensitive)]';
VAR
  message : STRING[79];
BEGIN
  writeln;
  IF (problem > 0) THEN BEGIN
    CASE (problem) OF
      1 : message:='Command line contains improper parameters.';
      2 : message:='Deletion string non-existent or not properly delimited.';
      3 : message:='No files found.  One parameter must be a valid file specification.';
      6 : message:='You cannot just specify a path, add "*.*" or "\*.*" for all files.';
      7 : message:='Error opening, closing, or renaming a file.  Original may be renamed!'
    ELSE  message:='Undefined error.'
    END;
    writeln (#7,'Error encountered:'); writeln (message); writeln;
  END;
  writeln (usage);
  halt (problem);
END;

PROCEDURE iocheck (iores :byte);
BEGIN
  IF (iores <> 0) THEN showhelp (7);
END;

FUNCTION ConvertToUpper (w :STRING) : STRING;
VAR
   cp  :Integer;        {The position of the character to change.}
BEGIN
  FOR cp:=1 TO Length (w) DO
    w[cp]:=UpCase (w[cp]);
  ConvertToUpper:=w;
END;

FUNCTION nameof (fn :STRING):STRING;
BEGIN
  IF (pos ('.', fn) > 0) THEN
    nameof:=copy (fn, 1, (pos ('.', fn)-1))
  ELSE
    nameof:=fn;
END;

FUNCTION extof (fn :STRING):STRING;
BEGIN
  IF (pos ('.', fn) > 0) THEN
    extof:=copy (fn, pos ('.', fn), length (fn))
  ELSE
    extof:='';
END;

PROCEDURE getparams (pstring :STRING; VAR fpath :pathstr; VAR kline :STRING; VAR case_s :boolean);
VAR
  cmdline :STRING;
  ffound  :boolean;  { has first filename been found? }
  counter :byte;
BEGIN
  cmdline:=pstring;
  ffound:=FALSE;
  counter:=0;
  fpath:='';
  kline:='';
  case_s:=FALSE;
  inc (counter);
  WHILE (counter < (length (cmdline)+1)) DO BEGIN
    CASE (cmdline[counter]) OF
      #32     : inc (counter);
      '"'     : BEGIN
                  IF (kline <> '') THEN showhelp (2);
                  inc (counter);
                  WHILE ((counter < (length (cmdline)+1)) AND
                      (cmdline[counter] <> '"')) DO BEGIN
                    kline:=kline+cmdline[counter];
                    inc (counter);
                  END;
                  IF (cmdline[counter] <> '"') THEN
                    showhelp (2)
                  ELSE
                    inc (counter);
                END;
      '/','-' : BEGIN
                  IF (counter < length (cmdline)) THEN BEGIN
                    inc (counter);
                    CASE (cmdline[counter]) OF
                      '?', 'H', 'h' : showhelp (0);
                      'c', 'C',
                      's', 'S'      : case_s:=TRUE;
                      'i', 'I'      : case_s:=FALSE;
                      ELSE
                        showhelp (1)
                    END;
                  END;
                  WHILE ((counter < (length (cmdline)+1)) AND
                      (cmdline[counter] <> #32)) DO inc (counter);
                END;
      ELSE      IF (NOT ffound) THEN BEGIN
                  ffound:=TRUE;
                  WHILE ((counter < (length (cmdline)+1)) AND
                      (cmdline[counter] <> #32)) DO BEGIN
                    fpath:=fpath+cmdline[counter];
                    inc (counter);
                  END;
                END
                ELSE
                  showhelp (1)
    END;
  END;
  IF (kline = '') THEN showhelp (2);
  IF (fpath = '') THEN showhelp (1);
END;

PROCEDURE openfiles (VAR file_in, file_out :text; name1, name2 :STRING);
BEGIN
  assign (file_in, name1);
  reset (file_in);           iocheck (ioresult);
  assign (file_out, name2);
  rewrite (file_out);        iocheck (ioresult);
END;

PROCEDURE swapnames (VAR file1, file2 :text; name1, name2 :pathstr);
VAR
  dir1, dir2 : dirstr;
  fn1, fn2   : namestr;
  ext1, ext2 : extstr;
BEGIN
  fsplit (fexpand (name1), dir1, fn1, ext1);
  fsplit (fexpand (name2), dir2, fn2, ext2);
  rename (file1, dir1+fn1+'.swp');  iocheck (ioresult);
  rename (file2, dir2+fn2+ext1);    iocheck (ioresult);
  rename (file1, dir1+fn1+ext2);    iocheck (ioresult);
END;

FUNCTION KillLines (VAR file1, file2 :text; badline :STRING; case_s :boolean):longint;
CONST
  kl:longint=0;
VAR
  c_line :STRING;
  t_line :STRING;
BEGIN
  IF (NOT case_s) THEN
    badline:=converttoupper (badline);
  WHILE (NOT eof (file1)) DO BEGIN
    readln (file1, c_line);
    IF (NOT case_s) THEN t_line:=converttoupper (c_line)
    ELSE t_line:=c_line;
    IF (pos (badline, t_line) = 0) THEN
      writeln (file2, c_line)
    ELSE
      inc(kl);
  END;
  KillLines:=kl
END;

{---- TYPEs, CONSTs and VARs for "main" program ----}
TYPE
  link = ^node;
  node = RECORD
           name : STRING[8];
           next : link;
         END;
VAR
  dirinfo    : searchrec; { contains filespec info.    }
  inpath     : pathstr;   { source file path,          }
  outdir,
  indir      : dirstr;    {             directory,     }
  fname,
  outname,
  inname     : namestr;   {             name,          }
  outext,
  inext      : extstr;    {             extension.     }
  ifn, ofn   : pathstr;   { Source/ Dest/ Temp FileName, including dir }
  infile, outfile : text; { files read from/ written to                }
  numdone    : word;      { numdone is number of files processed       }
  kline      : STRING;
  case_sens  : boolean;
  linesk     : longint;   { number of lines killed }
{----
  The boolean var "done" and pointers (type of 'link') of "anchor" and
   "chain" are used to cope with a bothersome quirk of DOS (I think),
   which allows "findnext" to find files more than once (under certain
   circumstances).  This quirk seems to be due to the order of the file
   names in the FAT, which is altered when a file is written to disk and
   then renamed.
----}
  done      : boolean;
  anchor, chain : link;

{---- BEGIN the "main" program ----}
BEGIN
  writeln (progdesc);
  writeln (author);

{---- Get file specifications, initialize some variables
      --------------------------------------------------
  The user must pass a filename specification, and must also pass
  a quote (") delimited string to indicate the lines to delete.
  The original file is renamed to original_name.bak, and the output
  file will have the exact same name as the original file.
----}
  getparams (STRING(ptr (prefixseg, $0080)^), inpath, kline, case_sens);
  fsplit (fexpand (inpath), indir, inname, inext);
  IF (inname = '') THEN showhelp (6);
  findfirst (inpath, archive, dirinfo);
  IF (doserror <> 0) THEN showhelp (3);
  writeln;
  writeln ('Specified string:');
  writeln (kline);

  numdone:=0;
  new (anchor);
  anchor^.name:='';
  anchor^.next:=NIL;

{---- Okay, let's go! ----}
  WHILE (doserror = 0) DO BEGIN
    done:=false;                      { initialize for each "new" file found }
    ifn:=indir+dirinfo.name;
    fname:=nameof (dirinfo.name);
    IF (extof (dirinfo.name) = '.bak') THEN done:=TRUE;
    chain:=anchor;                { check if file was processed file already }
    WHILE ((chain^.next <> NIL) AND (NOT done)) DO
      IF (chain^.name = fname) THEN done:=true
      ELSE chain:=chain^.next;

{---- Only process if not processed before ----}
    IF (NOT done) THEN BEGIN
      inc (numdone);
      new (chain);
      chain^.name:=fname;            { add current name to beginning of list }
      chain^.next:=anchor;
      anchor:=chain;

{---- Process the file! ----}
      ofn:=indir+fname+'.bak';
      write ('Removing lines from ', ifn); {tell user file is being processed}
      openfiles (infile, outfile, ifn, ofn);
      linesk:=KillLines (infile, outfile, kline, case_sens);
      writeln (', done!  Lines killed: ',linesk);  { tell file was processed }

{---- Close files, then find next file to process ----}
      close (infile);     iocheck (ioresult);
      close (outfile);    iocheck (ioresult);
      swapnames (infile, outfile, ifn, ofn);
    END;
    findnext (dirinfo);
  END;     { now loop back with name of next file to process }
  REPEAT   { dispose of pointers - not necessary at end, but good practice }
    chain:=anchor^.next;
    dispose (anchor);
    anchor:=chain;
  UNTIL (anchor = NIL) ;
  writeln ('Processed ', numdone, ' file(s).');
END.
