' Submitted by Harold Druss
'
' This program was made for a final project in Basic I.

' The program is designed to be fun, as well as useful, for a wide variety of users. Young students can
' gather information on Presidents for schoolwork, or enjoy just browsing. Everyone will enjoy inputing the
' Presidents name in any letter order, and getting the name outputed correctly, or trying to unscramble
' the letters the computer gives. Many sorting routines make the data available in a number of forms.

' Some of the programming functions and statements are as follows:

'       READ...DATA statements
'       DIM (arrays)
'       DO....LOOP (some nested)
'       FOR...NEXT (some nested)
'       GOSUB....RETURN
'       DECLARE SUB
'       SELECT CASE...END SELECT
'       SWAP (Bubble and Shell)
'       String manipulations
'       Randomizing

' The use of menus makes navigation intuitive. All menu selections are programmed defensively to guard
' against improper input. Most menus are distinctive in appearance, either by color, or by format
' so the user knows where he is at all times. Going to another menu, or returning from a menu is
' always done with just a key press to keep navagation simple.

DECLARE SUB PartyChoices ()
DECLARE SUB MenuTwo ()
DECLARE SUB NoMatch ()
DECLARE SUB GetScrambled ()
DECLARE SUB CompUnscramb ()
DECLARE SUB Greeting ()
DECLARE SUB MainMenu ()
DECLARE SUB Unscramble ()
DECLARE SUB FinalScreen ()
DECLARE SUB GameMenu ()
COMMON SHARED D$, SC$, VS$, VL$, VF$, PY$, PA$, PS$, AG$, CH$, Switch, E$
COMMON SHARED F$, AC$, RL$, WF$, DB$, N$, NF$, LN$, P$, s, S1$, Scramb$, PC$
DATA 01,George,Washington,2/22/1732,Virginia,Martha Dandridge Curtis,Episcopalian,English,None (Adopted 2 from wife's first marriage),57,Federalist,1789-97,John,Adams,Massachusetts,1789-97,ntnhaogisw
DATA 02,John,Adams,10/30/1735,Massachusetts,Abigail Smith,Unitarian,English,Five,61,Federalist,1797-1801,Thomas,Jefferson,Virginia,1797-1801,saamd
DATA 03,Thomas,Jefferson,4/13/1743,Virginia,Martha Wayles Skelton (Patty),No formal affiliation,Welsh,Six,57,Republican (Jeffersonian),1801-09,Aaron,Burr,New Jersey,1801-05,nsefjorfe
DATA 04,James,Madison,3/16/1751,Virginia,Dorothea (Dolly) Payne Todd,Episcopalian,English,None,57,Republican (Jeffersonian),1809-17,George,Clinton,New York,1809-12 (Died),nsdmoia
DATA 05,James,Monroe,4/28/1758,Virginia,Elizabeth Kortright,Episcopalian,Scottish,Two,58,Republican (Jeffersonian),1817-25,Daniel D.,Tompkins,New York,1817-25,eroonm
DATA 06,John Quincy,Adams,7/11/1767,Massachusetts,Louisa Catherine Johnson,Unitarian,English,Four,57,National Republican,1825-29,John C.,Calhoun,South Carolina,1825-29,saamd
DATA 07,Andrew,Jackson,3/15/1767,South Carolina,Rachel Donelson Robards,Presbyterian,Scottish-Irish,One (Adopted),61,Democratic,1829-37,John C.,Calhoun,South Carolina,1829-32 (Resigned),nscjoka
DATA 08,Martin,Van Buren,12/5/1782,New York,Hannah Hoes,Dutch Reformed,Dutch,Four,54,Democratic,1837-41,Richard M.,Johnson,Kentucky,1837-41,rubv naen
DATA 09,William Henry,Harrison,2/9/1773,Virginia,Anna Tuthil Symmes,Episcopalian,English,Ten,68,Whig,1841 (Died),John,Tyler,Virginia,1841,nsraoirh
DATA 10,John,Tyler,3/29/1790,Virginia,Letitia Christian and Julia Gardner,Episcopalian,English,Eight (First wife) - Seven (Second wife),51,Whig,1841-45,None, ,N/A,N/A,rltey
DATA 11,James K.,Polk,11/2/1795,North Carolina,Sarah Childress,Presbyterian,Scottish-Irish,None,49,Democratic,1845-49,George Miffin,Dallas,Pennsylvania,1845-49,kolp
DATA 12,Zachary,Taylor,11/24/1784,Virginia,Margaret Mackall Smith,Episcopalian,English,Six,64,Whig,1849-50 (Died),Millard,Fillmore,New York,1849-50,rlaoyt
DATA 13,Millard,Filmore,1/7/1800,New York,Abigail Powers/Caroline Carmichael McIntosh,Unitarian,English,Two,50,Whig,1850-53,None, ,N/A,N/A,eolfrmi
DATA 14,Franklin,Pierce,11/23/1804,New Hampshire,Jane Means Appleton,Episcopalian,English,Three,48,Democratic,1853-57,Willian Rufus,de Vane King,North Carolina,1853 (Died),ericep
DATA 15,James,Buchanan,4/23/1791,Pennsylvania,None,Presbyterian,Scottish-Irish,None,65,Democratic,1857-61,John C.,Beckinridge,Kentucky,1857-61,ahcunban
DATA 16,Abraham,Lincoln,2/12/1809,Kentucky,Mary Todd,No formal affiliation,English,Four,52,Republican,1861-65 (Assasinated),Hanibal,Hamlin,Maine,1861-65,nonllci
DATA 17,Andrew,Johnson,12/29/1808,North Carolina,Eliza McCardle,No formal affilliation,Scottish-Irish-English,Five,56,Democratic (Union),1865-69,None, ,N/A,N/A,nshjono
DATA 18,Ulysses S.,Grant,4/27/1822,Ohio,Julia Boggs Grant,Methodist,English-Scottish,Four,46,Republican,1869-77,Schuyler,Colfax,New York,1869-73,tagnr
DATA 19,Rutherford B.,Hayes,10/4/1822,Ohio,Lucy Ware Webb,No formal affiliation,English,Eight,54,Republican,1877-81,William A.,Wheeler,New York,1877-81,syhea
DATA 20,James A.,Garfield,11/19/1831,Ohio,Lucretia Rudolph,Disciples of Christ,English-Huguenot,Seven,49,Republican,1881 (Assassinated),Chester A.,Arthur,Vermont,1881,defalirg
DATA 21,Chester A.,Arthur,10/5/1829,Vermont,Ellen Lewis Herndon,Episcopalian,Scottish-Irish-English,Three,50,Republican,1881-85,None, ,N/A,N/A,rhruta
DATA 22,Grover,Cleveland,3/18/1837,New Jersey,Frances Folsom,Presbyterian,English-Scottish-Irish,Five,47,Democratic,1885-89,Thomas A.,Hendricks,Ohio,1885 (Died),daeecnlvl
DATA 23,Benjamin,Harrison,8/20/1883,Ohio,Caroline Scott and Mary Scott LordDimmick,Presbyterian,English-Scottish,Two (First wife) - One (Second wife),55,Republican,1889-93,Levi Parsons,Morton,Vermont,1889-93,nsraoirh
DATA 24,Grover,Cleveland,3/18/1837,New Jersey,Frances Folsom,Presbyterian,English-Scottish-Irish,Five,55,Democratic,1893-97,Adlai E.,Stevenson,Kentucky,1893-97,daeecnlvl
DATA 25,William,McKinley,1/29/1843,Ohio,Ida Saxton,Methodist,Scottish-Irish-English,Two,54,Republican,1897-1901 (Assassinated),Garret A.,Hobart,New Jersey,1897-99 (Died),ylicenkm
DATA 26,Theodore,Roosevelt,10/27/1858,New York,Alice Hathaway Lee and Edith Kermit Carow,Reformed Dutch,English-Dutch-Scottish-Huguenot,One (First wife) - Five (Second wife),42,Republican,1901-09,Charles Warren,Fairbanks,Ohio,1905-09,teeorlvso
DATA 27,William Howard,Taft,9/15/1857,Ohio,Helen (Nellie) Heron,Unitarian,English-Scottish-Irish,Three,51,Republican,1909-13,James Schoolcraft,Sherman,New York,1909-12 (Died),atft
DATA 28,Woodrow,Wilson,12/28/1856,Virginia,Ellen Louise Axson and Edith Bolling Galt,Presbyterian,Scottish-Irish,Three(1st Marriage),56,Democratic,1913-21,Thomas R.,Marshall,Indiana,1913-21,lsinwo
DATA 29,Warren G.,Harding,11/2/1865,Ohio,Florence Kling DeWolfe,Baptist,English-Scottish-Irish,None,55,Republican,1921-23 (Died),Calvin,Coolidge,Vermont,1921-23,nragidh
DATA 30,Calvin,Coolidge,7/4/1872,Vermont,Grace Anna Goodhue,Congregationalist,English,Two,51,Republican,1923-29,Charles G.,Dawes (1925-29),Ohio,1925-29,doclioge
DATA 31,Herbert,Hoover,8/10/1874,Iowa,Lou Henry,Quaker,German-Swiss-English,Two,54,Republican,1929-33,Charles,Curtis,Kansas,1929-33,eohrvo
DATA 32,Franklin D.,Roosevelt,1/30/1882,New York,Anna Eleanor,Episcopalian,Dutch-Huguenot-Engilsh,Six,51,Democratic,1933-45 (Died),John Nance,Garner,Texas,1933-41,teeorlvso
DATA 33,Harry S.,Truman,5/8/1884,Missouri,Elizabeth Virginia Wallace,Baptist,Engilsh-Scottish-Irish,One,60,Democratic,1945-53,Alben W.,Barkley (1949-53),Kentucky,1949-53,nmraut
DATA 34,Dwight D.,Eisenhower,10/14/1890,Texas,Mamie Geneva Doud,Presbyterian,Swiss-German,Two,62,Republican,1953-61,Richard M.,Nixon,California,1953-61,rwheiesnoe
DATA 35,John F.,Kennedy,5/29/1917,Massachusetts,Jacqueline Lee Bouvier,Roman Catholic,Irish,Three,46,Democratic,1961-63 (Assassinated),Lyndon B.,Johnson,Texas,1961-63,yenkdne
DATA 36,Lydon B.,Johnson,8/27/1908,Texas,Claudia Alta Taylor,Disciples of Christ,English,Two,55,Democratic,1963-69,Hubert H.,Humphrey (1965-69),South Dakota,1965-69,nshjono
DATA 37,Richard M.,Nixon,1/9/1913,California,Thelma Patricia Ryan,Quaker,English-Scottish-Irish,Two,56,Republican,1969-74 (Resigned),Spiro T.,Agnew,Maryland,1969-73 (Resigned),nxnoi
DATA 38,Gerald R.,Ford,7/14/1913,Nebraska,Elizabeth Bloomer,Episcopalian,Scottish-English,Four,61,Republican,1974-77,Nelson A.,Rockefeller,Maine,1974-77,dorf
DATA 39,Jimmy,Carter,10/1/1924,Georgia,Rosalynn Smith,Baptist,Irish,Four,52,Democratic,1977-81,Walter F.,Mondale,Minnisota,1977-81,rtaerc
DATA 40,Ronald W.,Reagan,2/6/1911,Illinois,Nancy Davis,Christian Church,Irish-Scottish-English,Four,69,Republican,1981-89,George,Bush,Massachusetts,1981-89,ngeaar
DATA 41,George,Bush,6/12/1924,Massachusetts,Barbara Pierce,Episcopalian,English,Six,64,Republican,1989-93,Dan,Quayle,Indiana,1989-93,husb
DATA 42,Bill,Clinton,8/19/1946,Arkansas,Hillary Rodman,Baptist, ,One,46,Democratic,1993-,Albert,Gore Jr.,Tennessee,1993-,nticonl
DATA 43,zzz,zzz,zzz,zzz,zzz,zzz,zzz,zzz,zzz,zzz,zzz,zzz,zzz,zzzz,zzzz,zzzz
DIM SHARED Num$(1 TO 43), FirstName$(1 TO 43), LastName$(1 TO 43), DOB$(1 TO 43), PState$(1 TO 43)
DIM SHARED Wife$(1 TO 43), Relig$(1 TO 43), Ances$(1 TO 43), Child$(1 TO 43), AgeNog$(1 TO 43)
DIM SHARED PARTY$(1 TO 43), PYears$(1 TO 43), VFName$(1 TO 43), VLName$(1 TO 43), VState$(1 TO 43)
DIM SHARED VYears$(1 TO 43), LtrPres$(1 TO 30), ScrambPres$(1 TO 43), AlphPres$(1 TO 43), FullName$(1 TO 43)
DIM SHARED LtrScramb$(1 TO 20)
' **************************** Program Mainline *******************************
COLOR 15, 1
CLS
GOSUB ReadData                          ' Fill arrays
GOSUB FullNamePres                      ' Fill an array with full name and sort alphabeticly
GOSUB AlphabeticLetters                 ' Fill array used for matching input
CALL Greeting                           ' Opening screen
DO                                      ' Loop for Main Menu
    CLS
    CALL MainMenu
    SELECT CASE D$
        CASE "1"
            CLS
            GOSUB GetGame               ' Menu for scrambled letters game
        CASE "2"
            CLS
            GOSUB Lists                 ' Menu for Information Center
        CASE "3"
            CLS
            CALL FinalScreen            ' Screen for ending program
    END SELECT
LOOP UNTIL D$ = "3"
END
'******************************* Read Data and Fill Arrays *******************
ReadData:
    FOR i = 1 TO 43
        READ Num$(i), FirstName$(i), LastName$(i), DOB$(i), PState$(i), Wife$(i), Relig$(i), Ances$(i)
        READ Child$(i), AgeNog$(i), PARTY$(i), PYears$(i), VFName$(i), VLName$(i), VState$(i), VYears$(i)
        READ ScrambPres$(i)
    NEXT i
RETURN
' ************ Put First and Last Names Together and Sort Alphabeticly **********
FullNamePres:
    FOR i = 1 TO 43
        FullName$(i) = LastName$(i) + ", " + FirstName$(i)
    NEXT i
    DO
        flag = 1
        FOR J = 1 TO 42
            IF FullName$(J) > FullName$(J + 1) THEN
                SWAP FullName$(J), FullName$(J + 1)
                SWAP LastName$(J), LastName$(J + 1)
                SWAP Num$(J), Num$(J + 1)
                SWAP FirstName$(J), FirstName$(J + 1)
                SWAP DOB$(J), DOB$(J + 1)
                SWAP PState$(J), PState$(J + 1)
                SWAP Wife$(J), Wife$(J + 1)
                SWAP Relig$(J), Relig$(J + 1)
                SWAP Ances$(J), Ances$(J + 1)
                SWAP Child$(J), Child$(J + 1)
                SWAP AgeNog$(J), AgeNog$(J + 1)
                SWAP PARTY$(J), PARTY$(J + 1)
                SWAP PYears$(J), PYears$(J + 1)
                SWAP VFName$(J), VFName$(J + 1)
                SWAP VLName$(J), VLName$(J + 1)
                SWAP VState$(J), VState$(J + 1)
                SWAP VYears$(J), VYears$(J + 1)
                SWAP AlphPres$(J), AlphPres$(J + 1)
                SWAP ScrambPres$(J), ScrambPres$(J + 1)
                flag = 0
            END IF
        NEXT J
        LOOP UNTIL flag = 1
RETURN
' *********** Arrange Last Name by Individual Letters Alphabeticly *************

' This routine takes the last name of each Presidents and puts each letter in an array.
' It then sorts the new array in alphabetic order. A,s first, B,s second and so forth.
' It then takes the letters and forms a string variable containing the letters in that order.
' For example, the variable LastName$(x) = "ADAMS" will have a parallel variable AlphPres$(x) = "AADMS"
' The newly created variable will be used to make the match in the game that the user inputs the
' Presidents name in scrambled form.

AlphabeticLetters:
    FOR i = 1 TO 43
        L = LEN(LastName$(i))
        P = 1
        FOR J = 1 TO L                  ' Seperate the letters
            LtrPres$(J) = UCASE$(MID$(LastName$(i), P, 1))
            P = P + 1
        NEXT J
        DO                              ' Arrange the letters alphabeticly
            flag = 1
            FOR K = 1 TO (L - 1)
                IF LtrPres$(K) > LtrPres$(K + 1) THEN
                    SWAP LtrPres$(K), LtrPres$(K + 1)
                    flag = 0
                END IF
            NEXT K
        LOOP UNTIL flag = 1
        FOR M = 1 TO L                  ' New string arranged alphabeticly
            AlphPres$(i) = AlphPres$(i) + LtrPres$(M)
        NEXT M
    NEXT i                              ' Should be all done
RETURN
' ********************* Get which game to play ********************************
GetGame:
    DO
        CALL GameMenu
        SELECT CASE F$
            CASE "1"
                CLS
                CALL GetScrambled
                IF s = 1 THEN CALL Unscramble
                IF s = 0 THEN CALL NoMatch
            CASE "2"
                CLS
                CALL CompUnscramb
                    IF Switch = 1 THEN
                        CALL Unscramble
                    END IF
        END SELECT
    LOOP UNTIL F$ = "3"
RETURN
'************************** Loop for Menu #2 ********************************
Lists:
    DO
        CALL MenuTwo
        SELECT CASE E$
            CASE "1"
                CLS
                GOSUB AlphabeticList
            CASE "2"
                CLS
                GOSUB WithVP
            CASE "3"
                CLS
                GOSUB OrderList
            CASE "4"
                CLS
                GOSUB PartyList
            CASE "5"
                CLS
                GOSUB WithPartyAlph
            CASE "6"
                CLS
                GOSUB StateList
        END SELECT
    LOOP UNTIL E$ = "7"
RETURN
' *********************** Print Alphabetic List *******************************
AlphabeticList:
    CLS
    H$ = "                 NAME                     YEARS SERVED"
    LOCATE 4: COLOR 14: PRINT H$: COLOR 15
    X = 6
    FOR i = 1 TO 42
        LOCATE X:  PRINT TAB(18); LastName$(i); ", "; FirstName$(i); TAB(43); PYears$(i)
        X = X + 1
        IF X = 20 AND i <> 42 THEN
            LOCATE 25: PRINT "Press any key for next page."
            D$ = INPUT$(1)
            X = 6
            CLS
            IF i < 41 THEN LOCATE 4: COLOR 14: PRINT H$: COLOR 15
        ELSEIF i = 42 THEN
            LOCATE 25: PRINT "END OF LIST - Press any key to continue."
            D$ = INPUT$(1)
        END IF
    NEXT i
RETURN
' ********************** Sort By Order Of Election ****************************
' This routine sorts the needed arrays by the order in which the Presidents were
' elected. It then outputs to the screen, and then puts the arrays back into the
' alphabetic order.
OrderList:
    gap = 20
    DO WHILE gap > 0
        flag = 0
        DO WHILE flag = 0
            flag = 1
            FOR i = 1 TO 42 - gap
                IF Num$(i) > Num$(i + 1) THEN
                    SWAP Num$(i), Num$(i + 1)
                    SWAP FirstName$(i), FirstName$(i + 1)
                    SWAP LastName$(i), LastName$(i + 1)
                    SWAP PYears$(i), PYears$(i + 1)
                    flag = 0
                END IF
            NEXT i
        LOOP
        gap = INT(gap / 2)
    LOOP
    CLS
    J$ = "           ORDER #     NAME                     YEARS"
    LOCATE 4: COLOR 14: PRINT J$: COLOR 15
    X = 6
    FOR i = 1 TO 42
        IF LEFT$(Num$(i), 1) = "0" THEN
            LOCATE X: PRINT TAB(12); RIGHT$(Num$(i), 1); TAB(24); FirstName$(i); " "; LastName$(i); TAB(49); PYears$(i)
            X = X + 1
            IF X = 20 AND i <> 42 THEN
                LOCATE 25: PRINT "Press any key for next page."
                HD$ = INPUT$(1)
                X = 6
                CLS
                LOCATE 4: COLOR 14: PRINT J$: COLOR 15
            END IF
        ELSE
            LOCATE X:  PRINT TAB(12); Num$(i); TAB(24); FirstName$(i); " "; LastName$(i); TAB(49); PYears$(i)
            X = X + 1
            IF X = 20 AND i <> 42 THEN
                LOCATE 25: PRINT "Press any key for next page."
                HD$ = INPUT$(1)
                X = 6
                CLS
                LOCATE 4: COLOR 14: PRINT J$: COLOR 15
            ELSEIF i = 42 THEN
                LOCATE 25: PRINT "END OF LIST - Press any key to continue."
                HD$ = INPUT$(1)
            END IF
        END IF
    NEXT i
    gap = 20
    DO WHILE gap > 0
        flag = 0
        DO WHILE flag = 0
            flag = 1
            FOR i = 1 TO 42 - gap
                IF LastName$(i) > LastName$(i + 1) THEN
                    SWAP LastName$(i), LastName$(i + 1)
                    SWAP FirstName$(i), FirstName$(i + 1)
                    SWAP Num$(i), Num$(i + 1)
                    SWAP PYears$(i), PYears$(i + 1)
                    flag = 0
                END IF
            NEXT i
        LOOP
        gap = INT(gap / 2)
    LOOP
RETURN
' ********************* List Presidents by Party ******************************
PartyList:
    DO
        CLS
        CALL PartyChoices
        SELECT CASE PC$
            CASE "1"
                CLS
                GOSUB FEDERALIST
            CASE "2"
                CLS
                GOSUB RepublicanJeffersonian
            CASE "3"
                CLS
                GOSUB NationalRepublican
            CASE "4"
                CLS
                GOSUB DEMOCRATIC
            CASE "5"
                CLS
                GOSUB WHIG
            CASE "6"
                CLS
                GOSUB REPUBLICAN
            CASE "7"
                CLS
                GOSUB DemocraticUnion
        END SELECT
    LOOP UNTIL PC$ = "8"
RETURN
' *************************** Federalist **************************************
FEDERALIST:
    LOCATE 3, 23: PRINT "THE FOLLOWING PRESIDENTS WERE MEMBERS"
    LOCATE 4, 23: PRINT "      OF THE FEDERALIST PARTY"
    X = 6
    COUNT = 0
    FOR i = 1 TO 42
        IF PARTY$(i) = "Federalist" THEN
            LOCATE X: PRINT TAB(25); FullName$(i); TAB(50); PYears$(i)
            X = X + 1
            COUNT = COUNT + 1
        END IF
    NEXT i
    LOCATE 23, 25: PRINT "TOTAL FEDERALISTS -"; COUNT
    LOCATE 25, 20: PRINT "Press any key to return to PARTY MENU."
    D$ = INPUT$(1)
RETURN
' ************************* Republican Jeffersonian ***************************
RepublicanJeffersonian:
    LOCATE 3, 23: PRINT "THE FOLLOWING PRESIDENTS WERE MEMBERS"
    LOCATE 4, 23: PRINT "OF THE REPUBLICAN(JEFFERSONIAN) PARTY"
    X = 6
    COUNT = 0
    FOR i = 1 TO 42
        IF PARTY$(i) = "Republican (Jeffersonian)" THEN
            LOCATE X: PRINT TAB(25); FullName$(i); TAB(50); PYears$(i)
            X = X + 1
            COUNT = COUNT + 1
        END IF
    NEXT i
    LOCATE 23, 25: PRINT "TOTAL REPUBLICAN (JEFFERSON) -"; COUNT
    LOCATE 25, 20: PRINT "Press any key to return to PARTY MENU."
    D$ = INPUT$(1)
RETURN
' ********************************* National Repulican ************************
NationalRepublican:
    LOCATE 3, 23: PRINT "THE FOLLOWING PRESIDENTS WERE MEMBERS"
    LOCATE 4, 23: PRINT "  OF THE NATIONAL REPUBLICAN PARTY"
    X = 6
    COUNT = 0
    FOR i = 1 TO 42
        IF PARTY$(i) = "National Republican" THEN
            LOCATE X: PRINT TAB(25); FullName$(i); TAB(50); PYears$(i)
            X = X + 1
            COUNT = COUNT + 1
        END IF
    NEXT i
    LOCATE 23, 25: PRINT "TOTAL NATIONAL REPUBLICANS -"; COUNT
    LOCATE 25, 20: PRINT "Press any key to return to PARTY MENU."
    D$ = INPUT$(1)
RETURN
' ******************************** Democrats **********************************
DEMOCRATIC:
    LOCATE 3, 23: PRINT "THE FOLLOWING PRESIDENTS WERE MEMBERS"
    LOCATE 4, 23: PRINT "      OF THE DEMOCRATIC PARTY"
    X = 6
    COUNT = 0
    FOR i = 1 TO 42
        IF PARTY$(i) = "Democratic" THEN
            LOCATE X: PRINT TAB(25); FullName$(i); TAB(50); PYears$(i)
            X = X + 1
            COUNT = COUNT + 1
        END IF
    NEXT i
    LOCATE 23, 25: PRINT "TOTAL DEMOCRATIC PARTY -"; COUNT
    LOCATE 25, 20: PRINT "Press any key to return to PARTY MENU."
    D$ = INPUT$(1)
RETURN
' ********************************* Whig Party ********************************
WHIG:
    LOCATE 3, 23: PRINT "THE FOLLOWING PRESIDENTS WERE MEMBERS"
    LOCATE 4, 23: PRINT "         OF THE WHIG PARTY"
    X = 6
    COUNT = 0
    FOR i = 1 TO 42
        IF PARTY$(i) = "Whig" THEN
            LOCATE X: PRINT TAB(25); FullName$(i); TAB(50); PYears$(i)
            X = X + 1
            COUNT = COUNT + 1
        END IF
    NEXT i
    LOCATE 23, 25: PRINT "TOTAL WHIG -"; COUNT
    LOCATE 25, 20: PRINT "Press any key to return to PARTY MENU."
    D$ = INPUT$(1)
RETURN
' ************************* Republican Party **********************************
REPUBLICAN:
    LOCATE 3, 23: PRINT "THE FOLLOWING PRESIDENTS WERE MEMBERS"
    LOCATE 4, 23: PRINT "       OF THE REPUBLICAN PARTY"
    X = 6
    COUNT = 0
    FOR i = 1 TO 42
        IF PARTY$(i) = "Republican" THEN
            LOCATE X: PRINT TAB(25); FullName$(i); TAB(50); PYears$(i)
            X = X + 1
            COUNT = COUNT + 1
        END IF
    NEXT i
    LOCATE 24, 25: PRINT "TOTAL REPUBLICAN -"; COUNT
    LOCATE 25, 20: PRINT "Press any key to return to PARTY MENU."
    D$ = INPUT$(1)
RETURN
' ************************* Democratic Union **********************************
DemocraticUnion:
    LOCATE 3, 23: PRINT "THE FOLLOWING PRESIDENTS WERE MEMBERS"
    LOCATE 4, 23: PRINT "    OF THE DEMOCRATIC (UNION) PARTY"
    X = 6
    COUNT = 0
    FOR i = 1 TO 42
        IF PARTY$(i) = "Democratic (Union)" THEN
            LOCATE X: PRINT TAB(25); FullName$(i); TAB(50); PYears$(i)
            X = X + 1
            COUNT = COUNT + 1
        END IF
    NEXT i
    LOCATE 23, 25: PRINT "TOTAL DEMOCRATIC (UNION) -"; COUNT
    LOCATE 25, 20: PRINT "Press any key to return to PARTY MENU."
    D$ = INPUT$(1)
RETURN
' *********************** List With Vice Presidents ***************************
WithVP:
    CLS
    LOCATE 4, 20: PRINT "ALPHABETIC LIST OF PRESIDENTS AND"
    LOCATE 5, 20: PRINT "     THEIR VICE PRESIDENTS"
    COLOR 14
    LOCATE 7, 14: PRINT "PRESIDENT"; TAB(41); "VICE PRESIDENT": COLOR 15
    X = 9
    FOR i = 1 TO 42
        IF FullName$(i) = "Jefferson, Thomas" THEN
            IF X > 19 THEN
                LOCATE 25: PRINT "Press any key for next page."
                Key$ = INPUT$(1)
                CLS
                LOCATE 7, 14: COLOR 14: PRINT "PRESIDENT"; TAB(41); "VICE PRESIDENT": COLOR 15
                X = 9
            END IF
            LOCATE X, 14: PRINT FullName$(i); TAB(41); "Arron Burr (1801-1805)"
            X = X + 1
            LOCATE X: PRINT TAB(41); "George Clinton (1805-09)"
            X = X + 1
        ELSEIF FullName$(i) = "Madison, James" THEN
            IF X > 19 THEN
                LOCATE 25: PRINT "Press any key for next page."
                Key$ = INPUT$(1)
                CLS
                LOCATE 7, 14: COLOR 14: PRINT "PRESIDENT"; TAB(41); "VICE PRESIDENT": COLOR 15
                X = 9
            END IF
            LOCATE X, 14: PRINT FullName$(i); TAB(41); "George Clinton (1809-12 Died)"
            X = X + 1
            LOCATE X: PRINT TAB(41); "Elbridge Gerry (1813-14 Died)"
            X = X + 1
        ELSEIF FullName$(i) = "Jackson, Andrew" THEN
            IF X > 19 THEN
                LOCATE 25: PRINT "Press any key for next page."
                Key$ = INPUT$(1)
                CLS
                LOCATE 7, 14: COLOR 14: PRINT "PRESIDENT"; TAB(41); "VICE PRESIDENT": COLOR 15
                X = 9
            END IF
            LOCATE X, 14: PRINT FullName$(i); TAB(41); "John C. Calhoun (1829-32 Resigned)"
            X = X + 1
            LOCATE X: PRINT TAB(41); "Martin Van Buren (1833-37)"
            X = X + 1
        ELSEIF FullName$(i) = "Lincoln, Abraham" THEN
            IF X > 19 THEN
                LOCATE 25: PRINT "Press any key for next page."
                Key$ = INPUT$(1)
                CLS
                LOCATE 7, 14: COLOR 14: PRINT "PRESIDENT"; TAB(41); "VICE PRESIDENT": COLOR 15
                X = 9
            END IF
            LOCATE X, 14: PRINT FullName$(i); TAB(41); "Hanibal Hamlin (1861-65)"
            X = X + 1
            LOCATE X: PRINT TAB(41); "Andrew Johnson (1865 Lincoln Died)"
            X = X + 1
        ELSEIF FullName$(i) = "Grant, Ulysses S." THEN
            IF X > 19 THEN
                LOCATE 25: PRINT "Press any key for next page."
                Key$ = INPUT$(1)
                CLS
                LOCATE 7, 14: COLOR 14: PRINT "PRESIDENT"; TAB(41); "VICE PRESIDENT": COLOR 15
                X = 9
            END IF
            LOCATE X, 14: PRINT FullName$(i); TAB(41); "Schuyler Colfax (1869-73)"
            X = X + 1
            LOCATE X: PRINT TAB(41); "Henry Wilson (1873-75 Died)"
            X = X + 1
        ELSEIF FullName$(i) = "McKinley, William" THEN
            IF X > 19 THEN
                LOCATE 25: PRINT "Press any key for next page."
                Key$ = INPUT$(1)
                CLS
                LOCATE 7, 14: COLOR 14: PRINT "PRESIDENT"; TAB(41); "VICE PRESIDENT": COLOR 15
                X = 9
            END IF
            LOCATE X, 14: PRINT FullName$(i); TAB(41); "Garret A. Hobart (1897-99 Died)"
            X = X + 1
            LOCATE X: PRINT TAB(41); "Theodore Roosevelt (1901 McKinley Died)"
            X = X + 1
        ELSEIF FullName$(i) = "Roosevelt, Franklin D." THEN
            IF X > 19 THEN
                LOCATE 25: PRINT "Press any key for next page."
                Key$ = INPUT$(1)
                CLS
                LOCATE 7, 14: COLOR 14: PRINT "PRESIDENT"; TAB(41); "VICE PRESIDENT": COLOR 15
                X = 9
            END IF
            LOCATE X, 14: PRINT FullName$(i); TAB(41); "John Nance Garner 1933-37)"
            X = X + 1
            LOCATE X: PRINT TAB(41); "Henry A. Wallace (1941-45)"
            X = X + 1
            LOCATE X: PRINT TAB(41); "Harry S. Truman (1945 Roosevelt Died)"
            X = X + 1
        ELSEIF FullName$(i) = "Nixon, Richard M." THEN
            IF X > 19 THEN
                LOCATE 25: PRINT "Press any key for next page."
                Key$ = INPUT$(1)
                CLS
                LOCATE 7, 14: COLOR 14: PRINT "PRESIDENT"; TAB(41); "VICE PRESIDENT": COLOR 15
                X = 9
            END IF
            LOCATE X, 14: PRINT FullName$(i); TAB(41); "Spiro T. Agnew"
            X = X + 1
            LOCATE X: PRINT TAB(41); "Gerald R. Ford"
            X = X + 1
        ELSE
            LOCATE X, 14: PRINT FullName$(i); TAB(41); VFName$(i); " "; VLName$(i)
            X = X + 1
            IF X > 19 THEN
                LOCATE 25: PRINT "Press any key for next page."
                Key$ = INPUT$(1)
                CLS
                LOCATE 7, 14: COLOR 14: PRINT "PRESIDENT"; TAB(41); "VICE PRESIDENT": COLOR 15
                X = 9
            END IF
        END IF
    NEXT i
    LOCATE 25: PRINT "END OF LIST - Press any key to continue"
    Key$ = INPUT$(1)
    CLS
RETURN
' ****************** Presidents alphabeticly with Party ************************
WithPartyAlph:
    CLS
    H$ = "         NAME                        PARTY"
    COLOR 14
    LOCATE 4: PRINT H$
    COLOR 15
    X = 6
    FOR i = 1 TO 42
        LOCATE X:  PRINT TAB(10); LastName$(i); ", "; FirstName$(i); TAB(38); PARTY$(i)
        X = X + 1
        IF X = 20 AND i <> 42 THEN
            LOCATE 25: PRINT "Press any key for next page."
            D$ = INPUT$(1)
            X = 6
            CLS
            IF i < 41 THEN COLOR 14: LOCATE 4: PRINT H$: COLOR 15
        ELSEIF i = 42 THEN
            LOCATE 25: PRINT "END OF LIST - Press any key to continue."
            D$ = INPUT$(1)
            COLOR 15, 1
        END IF
    NEXT i
RETURN
' ************************ Sort by state alphabeticly *************************
StateList:
    gap = 20
    DO WHILE gap > 0
        flag = 0
        DO WHILE flag = 0
            flag = 1
            FOR i = 1 TO 42 - gap
                IF PState$(i) > PState$(i + 1) THEN
                    SWAP PState$(i), PState$(i + 1)
                    SWAP FirstName$(i), FirstName$(i + 1)
                    SWAP LastName$(i), LastName$(i + 1)
                    flag = 0
                END IF
            NEXT i
        LOOP
        gap = INT(gap / 2)
    LOOP
    CLS
    J$ = "                       STATE              NAME"
    COLOR 14
    LOCATE 4: PRINT J$
    COLOR 15
    X = 6
    FOR i = 1 TO 42
        LOCATE X: PRINT TAB(24); PState$(i); TAB(43); FirstName$(i); " "; LastName$(i)
            X = X + 1
            IF X = 20 AND i <> 42 THEN
                LOCATE 25: PRINT "Press any key for next page."
                D$ = INPUT$(1)
                X = 6
                CLS
                COLOR 14
                LOCATE 4: PRINT J$
                COLOR 15
            ELSEIF i = 42 THEN
                LOCATE 25: PRINT "END OF LIST - Press any key to continue."
                D$ = INPUT$(1)
            END IF
    NEXT i
    gap = 20
    DO WHILE gap > 0
        flag = 0
        DO WHILE flag = 0
            flag = 1
            FOR i = 1 TO 42 - gap
                IF LastName$(i) > LastName$(i + 1) THEN
                    SWAP LastName$(i), LastName$(i + 1)
                    SWAP FirstName$(i), FirstName$(i + 1)
                    SWAP PState$(i), PState$(i + 1)
                    flag = 0
                END IF
            NEXT i
        LOOP
        gap = INT(gap / 2)
    LOOP
RETURN

SUB CompUnscramb STATIC
    RANDOMIZE TIMER
    N = INT(RND * 42 + 1)
    Nam$ = UCASE$(ScrambPres$(N))
    COLOR 14, 1
    CLS
    Uplft$ = CHR$(178)
    Uprgt$ = CHR$(178)
    Lorgt$ = CHR$(178)
    Lolft$ = CHR$(178)
    Vert$ = CHR$(178)
    Horiz$ = CHR$(178)
    Wide = 40
    Tall = 6
    Margin = (80 - Wide) / 2
    LOCATE 4: PRINT TAB(Margin); Uplft$ + STRING$(Wide - 2, Horiz$) + Uprgt$
    Tall = Tall - 2
    DO WHILE Tall > 0
        PRINT TAB(Margin); Vert$ + Vert$ + SPACE$(Wide - 4) + Vert$ + Vert$
        Tall = Tall - 1
    LOOP
    PRINT TAB(Margin); Lolft$ + STRING$(Wide - 2, Horiz$) + Lorgt$
    COLOR 14, 0: LOCATE 5, 22: PRINT SPACE$(36)
    LOCATE 6, 22: PRINT SPACE$(36)
    LOCATE 7, 22: PRINT SPACE$(36)
    LOCATE 8, 22: PRINT SPACE$(36)
    LOCATE 6, 26: PRINT "U N S C R A M B L E   T H E"
    LOCATE 7, 33: PRINT "L E T T E R S"
    COLOR 15, 1: LOCATE 12, 27: PRINT "Unscramble the letters below."
    LOCATE 13, 18: PRINT "They make up the LAST name of a U.S. President."
    LOCATE 15, 25: PRINT SPACE$(10); Nam$
    LOCATE 19, 26: PRINT "Type Name and Press <ENTER>"
    COLOR 14, 0: LOCATE 17, 22: PRINT SPACE$(35)
    LOCATE 17, 22: INPUT "ENTER NAME:  ", Nam1$
    Switch = 0
    IF UCASE$(Nam1$) = UCASE$(LastName$(N)) THEN
        Switch = 1
        LOCATE 21, 34: PRINT "CORRECT!!"
        LOCATE 23, 15: PRINT "Press any key for some interesting facts on "; LastName$(N);
        G$ = INPUT$(1)
        COLOR 15, 1
        CLS
        P$ = FullName$(N)
        LN$ = LastName$(N)
        NF$ = FirstName$(N)
        N$ = Num$(N)
        DB$ = DOB$(N)
        WF$ = Wife$(N)
        RL$ = Relig$(N)
        AC$ = Ances$(N)
        CH$ = Child$(N)
        AG$ = AgeNog$(N)
        PS$ = PState$(N)
        PA$ = PARTY$(N)
        PY$ = PYears$(N)
        VF$ = VFName$(N)
        VL$ = VLName$(N)
        VS$ = VState$(N)
        SC$ = ScrambPres$(N)
    ELSE
        LOCATE 21, 36: PRINT "WRONG!!"
        LOCATE 23, 26: PRINT "The President was "; LastName$(N)
        COLOR 15, 1: LOCATE 25: PRINT "Press any key to continue"
        G$ = INPUT$(1)
    END IF
END SUB

SUB FinalScreen STATIC
    COLOR 15, 1
    CLS
    Uplft$ = CHR$(201)
    Uprgt$ = CHR$(187)
    Lorgt$ = CHR$(188)
    Lolft$ = CHR$(200)
    Vert$ = CHR$(186)
    Horiz$ = CHR$(205)
    Wide = 50
    Tall = 12
    Margin = (80 - Wide) / 2
    LOCATE 8: PRINT TAB(Margin); Uplft$ + STRING$(Wide - 2, Horiz$) + Uprgt$
    Tall = Tall - 2
    DO WHILE Tall > 0
        PRINT TAB(Margin); Vert$ + SPACE$(Wide - 2) + Vert$
        Tall = Tall - 1
    LOOP
    PRINT TAB(Margin); Lolft$ + STRING$(Wide - 2, Horiz$) + Lorgt$
    COLOR 14
    LOCATE 9, 20: PRINT "    THANKS FOR USING THIS FREE PROGRAM"
    LOCATE 10, 20: PRINT "(double your money back if not satisfied)"
    LOCATE 12, 20: PRINT "Any comments or suggestions contact:"
    COLOR 2
    LOCATE 14, 23: PRINT "Harold Druss"
    LOCATE 15, 23: PRINT "408 Parker Street"
    LOCATE 16, 23: PRINT "Newton, MA 02159-2606"
    LOCATE 17, 23: PRINT "(617) 244-7880"
    LOCATE 18, 23: PRINT "Email: hdruss@world.std.com"
    COLOR 15: LOCATE 25: PRINT "Press any key for exit to DOS."
    Harry$ = INPUT$(1)
END SUB

SUB GameMenu STATIC
    LOCATE , , 0
    COLOR , 8
    CLS
    Uplft$ = CHR$(178)
    Uprgt$ = CHR$(178)
    Lorgt$ = CHR$(178)
    Lolft$ = CHR$(178)
    Vert$ = CHR$(178)
    Horiz$ = CHR$(178)
    Wide = 44
    Tall = 5
    Margin = (80 - Wide) / 2
    COLOR 11
    LOCATE 3: PRINT TAB(Margin); Uplft$ + STRING$(Wide - 2, Horiz$) + Uprgt$
    Tall = Tall - 2
    DO WHILE Tall > 0
        PRINT TAB(Margin); Vert$ + Vert$ + SPACE$(Wide - 4) + Vert$ + Vert$
        Tall = Tall - 1
    LOOP
    PRINT TAB(Margin); Lolft$ + STRING$(Wide - 2, Horiz$) + Lorgt$
    COLOR , 10
    LOCATE 4, 20: PRINT SPACE$(40)
    LOCATE 5, 20: PRINT SPACE$(40)
    LOCATE 6, 20: PRINT SPACE$(40)
    COLOR 0
    LOCATE 5, 31: PRINT "G A M E    M E N U"
    COLOR 15, 0
    LOCATE 11, 20: PRINT "1.  COMPUTER unscrambles the letters."
    LOCATE 13, 20: PRINT "2.  YOU unscramble the letters."
    LOCATE 15, 20: PRINT "3.  Return to MAIN MENU."
    COLOR 0, 7
    LOCATE 19, 27: PRINT "ENTER YOUR CHOICE (1-3)"
    F$ = INPUT$(1)
    DO UNTIL F$ = "1" OR F$ = "2" OR F$ = "3"
        COLOR 20
        LOCATE 22, 29: PRINT "PLEASE ENTER (1-3)"
        F$ = INPUT$(1)
    LOOP
    COLOR 15, 1
END SUB

SUB GetScrambled STATIC

' This routine gets the Presidents name from the user in scrambled form. It seperates the letters,
' arranges them alphabeticly (A,s first, etc.), and creates a string variable with the letters in that order
' The new variable is then matched against AlphPres$() to produce the correct name.
   
    s = 0
    Scramb1$ = ""
    S1$ = ""
    COLOR 14, 1
    CLS
    Uplft$ = CHR$(178)
    Uprgt$ = CHR$(178)
    Lorgt$ = CHR$(178)
    Lolft$ = CHR$(178)
    Vert$ = CHR$(178)
    Horiz$ = CHR$(178)
    Wide = 40
    Tall = 6
    Margin = (80 - Wide) / 2
    LOCATE 4: PRINT TAB(Margin); Uplft$ + STRING$(Wide - 2, Horiz$) + Uprgt$
    Tall = Tall - 2
    DO WHILE Tall > 0
        PRINT TAB(Margin); Vert$ + Vert$ + SPACE$(Wide - 4) + Vert$ + Vert$
        Tall = Tall - 1
    LOOP
    PRINT TAB(Margin); Lolft$ + STRING$(Wide - 2, Horiz$) + Lorgt$
    COLOR 14, 0
    LOCATE 5, 22: PRINT SPACE$(36)
    LOCATE 6, 22: PRINT SPACE$(36)
    LOCATE 7, 22: PRINT SPACE$(36)
    LOCATE 8, 22: PRINT SPACE$(36)
    LOCATE 6, 26: PRINT "U N S C R A M B L E   T H E"
    LOCATE 7, 33: PRINT "L E T T E R S"
    COLOR 15, 1
    LOCATE 12, 15: PRINT "      Enter the LAST name of a U.S. President."
    LOCATE 13, 15: PRINT "   You may put the letters in any order you want."
    LOCATE 14, 15: PRINT "I'll give you his name and some other interesting facts."
    LOCATE 18, 26: PRINT "Type Name and Press <ENTER>"
    COLOR 14, 0
    LOCATE 16, 22: PRINT SPACE$(35)
    LOCATE 16, 22: INPUT "ENTER NAME:  ", Scramb$                   ' Get input of scrambled name
    COLOR 15, 1
    CLS
    S1$ = UCASE$(Scramb$)                                           ' Put all letters in upper case
    L = LEN(S1$)                                                    ' How many letters in the name
    P = 1
    FOR i = 1 TO L                                                  ' Put each letter in it's array
        LtrScramb$(i) = UCASE$(MID$(S1$, P, 1))
        P = P + 1
    NEXT i
    DO                                                              ' Arrange the array alphabeticly
        flag = 1
        FOR i = 1 TO L - 1
            IF LtrScramb$(i) > LtrScramb$(i + 1) THEN
                SWAP LtrScramb$(i), LtrScramb$(i + 1)
                flag = 0
            END IF
        NEXT i
    LOOP UNTIL flag = 1
    FOR i = 1 TO L                                  ' New string for the scrambled name apphabeticly
        Scramb1$ = Scramb1$ + LtrScramb$(i)
    NEXT i
    S1$ = UCASE$(Scramb1$)                          ' Not neccessay, just a precaution
    s = 0
    FOR N = 1 TO 42
        IF UCASE$(AlphPres$(N)) = S1$ THEN
            s = 1
            P$ = FullName$(N)
            LN$ = LastName$(N)
            NF$ = FirstName$(N)
            N$ = Num$(N)
            DB$ = DOB$(N)
            WF$ = Wife$(N)
            RL$ = Relig$(N)
            AC$ = Ances$(N)
            CH$ = Child$(N)
            AG$ = AgeNog$(N)
            PS$ = PState$(N)
            PA$ = PARTY$(N)
            PY$ = PYears$(N)
            VF$ = VFName$(N)
            VL$ = VLName$(N)
            VS$ = VState$(N)
            SC$ = ScrambPres$(N)
        END IF
    NEXT N
END SUB

SUB Greeting STATIC
    LOCATE , , 0
    COLOR 12, 1
    CLS
    Uplft$ = CHR$(178)
    Uprgt$ = CHR$(178)
    Lorgt$ = CHR$(178)
    Lolft$ = CHR$(178)
    Vert$ = CHR$(178)
    Horiz$ = CHR$(178)
    Horiz1$ = CHR$(178)
    Wide = 40
    Tall = 13
    Margin = (80 - Wide) / 2
    LOCATE 6: PRINT TAB(Margin); Uplft$ + STRING$(Wide - 2, Horiz$) + Uprgt$
    Tall = Tall - 2
    DO WHILE Tall > 0
        PRINT TAB(Margin); Vert$ + Vert$ + SPACE$(Wide - 4) + Vert$ + Vert$
        Tall = Tall - 1
    LOOP
    PRINT TAB(Margin); Lolft$ + STRING$(Wide - 2, Horiz$) + Lorgt$
    COLOR 15, 7
    LOCATE 7, 22: PRINT SPACE$(36)
    LOCATE 8, 22: PRINT SPACE$(36)
    LOCATE 9, 22: PRINT SPACE$(36)
    LOCATE 10, 22: PRINT SPACE$(36)
    LOCATE 11, 22: PRINT SPACE$(36)
    LOCATE 12, 22: PRINT SPACE$(36)
    LOCATE 13, 22: PRINT SPACE$(36)
    LOCATE 14, 22: PRINT SPACE$(36)
    LOCATE 15, 22: PRINT SPACE$(36)
    LOCATE 16, 22: PRINT SPACE$(36)
    LOCATE 17, 22: PRINT SPACE$(36)
    COLOR 0
    LOCATE 8, 27: PRINT "W E L C O M E  T O  T H E"
    LOCATE 9, 25: PRINT "P R E S I D E N T S   G A M E"
    LOCATE 11, 37: PRINT "and"
    LOCATE 12, 30: PRINT "INFORMATION CENTER"
    COLOR 1
    s$ = STRING$(29, 223)
    LOCATE 10, 25: PRINT s$
    COLOR 1
    LOCATE 14, 26: PRINT "Programmed in QuickBasic 4.5"
    LOCATE 15, 39: PRINT "by Harold Druss"
    LOCATE 17, 26: PRINT "(Press any key to continue)"
    D$ = INPUT$(1)
END SUB

SUB MainMenu STATIC
    LOCATE , , 0
    COLOR 12, 1
    CLS
    Uplft$ = CHR$(178)
    Uprgt$ = CHR$(178)
    Lorgt$ = CHR$(178)
    Lolft$ = CHR$(178)
    Vert$ = CHR$(178)
    Horiz$ = CHR$(178)
    Horiz1$ = CHR$(178)
    Wide = 40
    Tall = 5
    Margin = (80 - Wide) / 2
    LOCATE 5: PRINT TAB(Margin); Uplft$ + STRING$(Wide - 2, Horiz$) + Uprgt$
    Tall = Tall - 2
    DO WHILE Tall > 0
        PRINT TAB(Margin); Vert$ + Vert$ + SPACE$(Wide - 4) + Vert$ + Vert$
        Tall = Tall - 1
    LOOP
    PRINT TAB(Margin); Lolft$ + STRING$(Wide - 2, Horiz$) + Lorgt$
    COLOR 15, 7
    LOCATE 6, 22: PRINT SPACE$(36)
    LOCATE 7, 22: PRINT SPACE$(36)
    LOCATE 8, 22: PRINT SPACE$(36)
    COLOR 0
    LOCATE 7, 32: PRINT "M A I N   M E N U"
    COLOR 15, 1
    LOCATE 13, 22: PRINT "1.  Play the Presidents Game."
    LOCATE 15, 22: PRINT "2.  Visit the Information Center."
    LOCATE 17, 22: PRINT "3.  Exit to DOS"
    COLOR 0, 7
    LOCATE 21, 27: PRINT "ENTER YOUR CHOICE (1-3)"
    D$ = INPUT$(1)
    DO UNTIL D$ = "1" OR D$ = "2" OR D$ = "3"
        BEEP
        COLOR 20, 7: LOCATE 23, 30: PRINT "PLEASE ENTER (1-3)"
        D$ = INPUT$(1)
    LOOP
    COLOR 15, 1
END SUB

SUB MenuTwo
    COLOR 14, 1
    CLS
    Uplft$ = CHR$(178)
    Uprgt$ = CHR$(178)
    Lorgt$ = CHR$(178)
    Lolft$ = CHR$(178)
    Vert$ = CHR$(178)
    Horiz$ = CHR$(178)
    Wide = 40
    Tall = 6
    Margin = (80 - Wide) / 2
    LOCATE 2: PRINT TAB(Margin); Uplft$ + STRING$(Wide - 2, Horiz$) + Uprgt$
    Tall = Tall - 2
    DO WHILE Tall > 0
        PRINT TAB(Margin); Vert$ + Vert$ + SPACE$(Wide - 4) + Vert$ + Vert$
        Tall = Tall - 1
    LOOP
    PRINT TAB(Margin); Lolft$ + STRING$(Wide - 2, Horiz$) + Lorgt$
    COLOR 14, 0
    LOCATE 3, 22: PRINT SPACE$(36)
    LOCATE 4, 22: PRINT SPACE$(36)
    LOCATE 5, 22: PRINT SPACE$(36)
    LOCATE 6, 22: PRINT SPACE$(36)
    LOCATE 4, 25: PRINT "     I N F O R M A T I O N"
    LOCATE 5, 25: PRINT "          C E N T E R"
    COLOR 15, 1
    LOCATE 10, 16: PRINT "1.  List Presidents Alphabeticly With Years Served"
    LOCATE 11, 16: PRINT "2.  List Presidents Alphabeticly With Vice Presidents"
    LOCATE 12, 16: PRINT "3.  List Presidents by Order of Election"
    LOCATE 13, 16: PRINT "4.  List Presidents by Party."
    LOCATE 14, 16: PRINT "5.  List Presidents Alphabeticly With Party"
    LOCATE 15, 16: PRINT "6.  List Presidents by Their Birth State"
    LOCATE 17, 16: PRINT "7.  Return to MAIN MENU."
    COLOR 14, 0
    LOCATE 21, 27: PRINT "ENTER YOUR CHOICE (1-7)"
    E$ = INPUT$(1)
    DO UNTIL E$ = "1" OR E$ = "2" OR E$ = "3" OR E$ = "4" OR E$ = "5" OR E$ = "6" OR E$ = "7"
        COLOR 30
        LOCATE 23, 29: PRINT "PLEASE ENTER (1-7)"
        E$ = INPUT$(1)
    LOOP
    COLOR 15, 1
END SUB

SUB NoMatch STATIC
        S2$ = "No President found with the letters below"
        S3$ = "Check your spelling (Information Center) and try again"
        S4$ = "Press any key to continue"
        LOCATE 9, (80 - LEN(S2$)) / 2: PRINT S2$
        LOCATE 11, (80 - (LEN(Scramb$)) - 2) / 2: PRINT CHR$(34); Scramb$; CHR$(34)
        LOCATE 13, (80 - LEN(S3$)) / 2: PRINT S3$
        LOCATE 15, (80 - LEN(S4$)) / 2: PRINT S4$
        DD$ = INPUT$(1)
END SUB

SUB PartyChoices STATIC
    COLOR 14, 1
    CLS
    Uplft$ = CHR$(178)
    Uprgt$ = CHR$(178)
    Lorgt$ = CHR$(178)
    Lolft$ = CHR$(178)
    Vert$ = CHR$(178)
    Horiz$ = CHR$(178)
    Wide = 46
    Tall = 6
    Margin = (80 - Wide) / 2
    LOCATE 2: PRINT TAB(Margin); Uplft$ + STRING$(Wide - 2, Horiz$) + Uprgt$
    Tall = Tall - 2
    DO WHILE Tall > 0
        PRINT TAB(Margin); Vert$ + Vert$ + SPACE$(Wide - 4) + Vert$ + Vert$
        Tall = Tall - 1
    LOOP
    PRINT TAB(Margin); Lolft$ + STRING$(Wide - 2, Horiz$) + Lorgt$
    COLOR 14, 0
    LOCATE 3, 19: PRINT SPACE$(42)
    LOCATE 4, 19: PRINT SPACE$(42)
    LOCATE 5, 19: PRINT SPACE$(42)
    LOCATE 6, 19: PRINT SPACE$(42)
    LOCATE 4, 20: PRINT "C H O O S E   T H E   P A R T Y   Y O U"
    LOCATE 5, 20: PRINT "     W A N T    D I S P L A Y E D"
    COLOR 15, 1
    LOCATE 10, 25: PRINT "1.  Federalist"
    LOCATE 11, 25: PRINT "2.  Republican (Jeffersonian)"
    LOCATE 12, 25: PRINT "3.  National Republican"
    LOCATE 13, 25: PRINT "4.  Democratic"
    LOCATE 14, 25: PRINT "5.  Whig"
    LOCATE 15, 25: PRINT "6.  Republican"
    LOCATE 16, 25: PRINT "7.  Democratic (Union)"
    LOCATE 18, 25: PRINT "8.  Return to the INFORMATION CENTER"
    COLOR 14, 0
    LOCATE 21, 29: PRINT "ENTER YOUR CHOICE (1-8)"
    PC$ = INPUT$(1)
    DO UNTIL PC$ = "1" OR PC$ = "2" OR PC$ = "3" OR PC$ = "4" OR PC$ = "5" OR PC$ = "6" OR PC$ = "7" OR PC$ = "8"
        COLOR 30
        LOCATE 23, 33: PRINT "PLEASE ENTER (1-8)"
        PC$ = INPUT$(1)
    LOOP
    COLOR 15, 1
END SUB

SUB Unscramble STATIC
    IF UCASE$(LN$) = "ADAMS" THEN
        CLS
        LOCATE 9, 22: PRINT "Two presidents were named "; LN$; "."
        LOCATE 11, 22: PRINT "Press:"
        LOCATE 13, 22: PRINT "1. For John Quincy Adams"
        LOCATE 14, 22: PRINT "2. For John Adams "
        Ans$ = INPUT$(1)
        DO UNTIL Ans$ = "1" OR Ans$ = "2"
            COLOR 28
            LOCATE 16, 22: PRINT "Please press 1 or  2"
            Ans$ = INPUT$(1)
        LOOP
        IF Ans$ = "1" THEN
            CLS
            COLOR 0, 7: LOCATE 3, 30: PRINT UCASE$(NF$); " "; UCASE$(LN$)
            COLOR 15, 1
            LOCATE 7, 15: PRINT "               BORN"; ":"; TAB(38); DB$
            LOCATE 8, 15: PRINT "     PLACE OF BIRTH"; ":"; TAB(38); PS$
            IF LEFT$(N$, 1) = "0" THEN
                LOCATE 9, 15: PRINT "  ORDER OF ELECTION"; ":"; TAB(38); RIGHT$(N$, 1)
            ELSE
                LOCATE 9, 15: PRINT "  ORDER OF ELECTION"; ":"; TAB(38); N$
            END IF
            LOCATE 10, 15: PRINT "     VICE PRESIDENT"; ":"; TAB(38); VF$; " "; VL$
            LOCATE 11, 15: PRINT "    POLITICAL PARTY"; ":"; TAB(38); PA$
            LOCATE 12, 15: PRINT "AGE AT INAUGURATION"; ":"; TAB(38); AG$
            LOCATE 13, 15: PRINT "       YEARS SERVED"; ":"; TAB(38); PY$
            LOCATE 14, 15: PRINT "               WIFE"; ":"; TAB(38); WF$
            LOCATE 15, 15: PRINT "           CHILDREN"; ":"; TAB(38); CH$
            LOCATE 16, 15: PRINT "           ANCESTRY"; ":"; TAB(38); AC$
            LOCATE 17, 15: PRINT "           RELIGION"; ":"; TAB(38); RL$
        ELSE
            CLS
            COLOR 0, 7: LOCATE 3, 30: PRINT UCASE$(FirstName$(1)); " "; UCASE$(LastName$(1))
            COLOR 15, 1
            LOCATE 7, 15: PRINT "               BORN"; ":"; TAB(38); DOB$(1)
            LOCATE 8, 15: PRINT "     PLACE OF BIRTH"; ":"; TAB(38); PState$(1)
            LOCATE 9, 15: PRINT "  ORDER OF ELECTION"; ":"; TAB(38); RIGHT$(Num$(1), 1)
            LOCATE 10, 15: PRINT "     VICE PRESIDENT"; ":"; TAB(38); VFName$(1); " "; VLName$(1)
            LOCATE 11, 15: PRINT "    POLITICAL PARTY"; ":"; TAB(38); PARTY$(1)
            LOCATE 12, 15: PRINT "AGE AT INAUGURATION"; ":"; TAB(38); AgeNog$(1)
            LOCATE 13, 15: PRINT "       YEARS SERVED"; ":"; TAB(38); PYears$(1)
            LOCATE 14, 15: PRINT "               WIFE"; ":"; TAB(38); Wife$(1)
            LOCATE 15, 15: PRINT "           CHILDREN"; ":"; TAB(38); Child$(1)
            LOCATE 16, 15: PRINT "           ANCESTRY"; ":"; TAB(38); Ances$(1)
            LOCATE 17, 15: PRINT "           RELIGION"; ":"; TAB(38); Relig$(1)
        END IF
    ELSEIF UCASE$(LN$) = "HARRISON" THEN
        CLS
        LOCATE 9, 22: PRINT "Two presidents were named "; LN$; "."
        LOCATE 11, 22: PRINT "Press:"
        LOCATE 13, 22: PRINT "1. For Benjamin Harrison"
        LOCATE 14, 22: PRINT "2. For William Henry Harrison"
        Ans$ = INPUT$(1)
        DO UNTIL Ans$ = "1" OR Ans$ = "2"
            COLOR 28
            LOCATE 16, 22: PRINT "Please press 1 or  2"
            Ans$ = INPUT$(1)
        LOOP
        IF Ans$ = "2" THEN
            CLS
            COLOR 0, 7: LOCATE 3, 30: PRINT UCASE$(NF$); " "; UCASE$(LN$)
            COLOR 15, 1
            LOCATE 7, 15: PRINT "               BORN"; ":"; TAB(38); DB$
            LOCATE 8, 15: PRINT "     PLACE OF BIRTH"; ":"; TAB(38); PS$
            IF LEFT$(N$, 1) = "0" THEN
                LOCATE 9, 15: PRINT "  ORDER OF ELECTION"; ":"; TAB(38); RIGHT$(N$, 1)
            ELSE
                LOCATE 9, 15: PRINT "  ORDER OF ELECTION"; ":"; TAB(38); N$
            END IF
            LOCATE 10, 15: PRINT "     VICE PRESIDENT"; ":"; TAB(38); VF$; " "; VL$
            LOCATE 11, 15: PRINT "    POLITICAL PARTY"; ":"; TAB(38); PA$
            LOCATE 12, 15: PRINT "AGE AT INAUGURATION"; ":"; TAB(38); AG$
            LOCATE 13, 15: PRINT "       YEARS SERVED"; ":"; TAB(38); PY$
            LOCATE 14, 15: PRINT "               WIFE"; ":"; TAB(38); WF$
            LOCATE 15, 15: PRINT "           CHILDREN"; ":"; TAB(38); CH$
            LOCATE 16, 15: PRINT "           ANCESTRY"; ":"; TAB(38); AC$
            LOCATE 17, 15: PRINT "           RELIGION"; ":"; TAB(38); RL$
        ELSE
            CLS
            COLOR 0, 7: LOCATE 3, 30: PRINT UCASE$(FirstName$(17)); " "; UCASE$(LastName$(17))
            COLOR 15, 1
            LOCATE 7, 15: PRINT "               BORN"; ":"; TAB(38); DOB$(17)
            LOCATE 8, 15: PRINT "     PLACE OF BIRTH"; ":"; TAB(38); PState$(17)
            LOCATE 9, 15: PRINT "  ORDER OF ELECTION"; ":"; TAB(38); Num$(17)
            LOCATE 10, 15: PRINT "     VICE PRESIDENT"; ":"; TAB(38); VFName$(17); " "; VLName$(17)
            LOCATE 11, 15: PRINT "    POLITICAL PARTY"; ":"; TAB(38); PARTY$(17)
            LOCATE 12, 15: PRINT "AGE AT INAUGURATION"; ":"; TAB(38); AgeNog$(17)
            LOCATE 13, 15: PRINT "       YEARS SERVED"; ":"; TAB(38); PYears$(17)
            LOCATE 14, 15: PRINT "               WIFE"; ":"; TAB(38); Wife$(17)
            LOCATE 15, 15: PRINT "           CHILDREN"; ":"; TAB(38); Child$(17)
            LOCATE 16, 15: PRINT "           ANCESTRY"; ":"; TAB(38); Ances$(17)
            LOCATE 17, 15: PRINT "           RELIGION"; ":"; TAB(38); Relig$(17)
        END IF
    ELSEIF UCASE$(LN$) = "JOHNSON" THEN
        CLS
        LOCATE 9, 22: PRINT "Two presidents were named "; LN$; "."
        LOCATE 11, 22: PRINT "Press:"
        LOCATE 13, 22: PRINT "1. For Andrew Johnson"
        LOCATE 14, 22: PRINT "2. For Lyndon B. Johnson"
        Ans$ = INPUT$(1)
        DO UNTIL Ans$ = "1" OR Ans$ = "2"
            COLOR 28
            LOCATE 16, 22: PRINT "Please press 1 or  2"
            Ans$ = INPUT$(1)
        LOOP
        IF Ans$ = "2" THEN
            CLS
            COLOR 0, 7: LOCATE 3, 30: PRINT UCASE$(NF$); " "; UCASE$(LN$)
            COLOR 15, 1
            LOCATE 7, 15: PRINT "               BORN"; ":"; TAB(38); DB$
            LOCATE 8, 15: PRINT "     PLACE OF BIRTH"; ":"; TAB(38); PS$
            IF LEFT$(N$, 1) = "0" THEN
                LOCATE 9, 15: PRINT "  ORDER OF ELECTION"; ":"; TAB(38); RIGHT$(N$, 1)
            ELSE
                LOCATE 9, 15: PRINT "  ORDER OF ELECTION"; ":"; TAB(38); N$
            END IF
            LOCATE 10, 15: PRINT "     VICE PRESIDENT"; ":"; TAB(38); VF$; " "; VL$
            LOCATE 11, 15: PRINT "    POLITICAL PARTY"; ":"; TAB(38); PA$
            LOCATE 12, 15: PRINT "AGE AT INAUGURATION"; ":"; TAB(38); AG$
            LOCATE 13, 15: PRINT "       YEARS SERVED"; ":"; TAB(38); PY$
            LOCATE 14, 15: PRINT "               WIFE"; ":"; TAB(38); WF$
            LOCATE 15, 15: PRINT "           CHILDREN"; ":"; TAB(38); CH$
            LOCATE 16, 15: PRINT "           ANCESTRY"; ":"; TAB(38); AC$
            LOCATE 17, 15: PRINT "           RELIGION"; ":"; TAB(38); RL$
        ELSE
            CLS
            COLOR 0, 7: LOCATE 3, 30: PRINT UCASE$(FirstName$(23)); " "; UCASE$(LastName$(23))
            COLOR 15, 1
            LOCATE 7, 15: PRINT "               BORN"; ":"; TAB(38); DOB$(23)
            LOCATE 8, 15: PRINT "     PLACE OF BIRTH"; ":"; TAB(38); PState$(23)
            LOCATE 9, 15: PRINT "  ORDER OF ELECTION"; ":"; TAB(38); Num$(23)
            LOCATE 10, 15: PRINT "     VICE PRESIDENT"; ":"; TAB(38); VFName$(23); " "; VLName$(23)
            LOCATE 11, 15: PRINT "    POLITICAL PARTY"; ":"; TAB(38); PARTY$(23)
            LOCATE 12, 15: PRINT "AGE AT INAUGURATION"; ":"; TAB(38); AgeNog$(23)
            LOCATE 13, 15: PRINT "       YEARS SERVED"; ":"; TAB(38); PYears$(23)
            LOCATE 14, 15: PRINT "               WIFE"; ":"; TAB(38); Wife$(23)
            LOCATE 15, 15: PRINT "           CHILDREN"; ":"; TAB(38); Child$(23)
            LOCATE 16, 15: PRINT "           ANCESTRY"; ":"; TAB(38); Ances$(23)
            LOCATE 17, 15: PRINT "           RELIGION"; ":"; TAB(38); Relig$(23)
        END IF
    ELSEIF UCASE$(LN$) = "JEFFERSON" THEN
        CLS
        COLOR 0, 7: LOCATE 3, 30: PRINT UCASE$(NF$); " "; UCASE$(LN$)
        COLOR 15, 1
        LOCATE 7, 15: PRINT "               BORN"; ":"; TAB(38); DB$
        LOCATE 8, 15: PRINT "     PLACE OF BIRTH"; ":"; TAB(38); PS$
        IF LEFT$(N$, 1) = "0" THEN
            LOCATE 9, 15: PRINT "  ORDER OF ELECTION"; ":"; TAB(38); RIGHT$(N$, 1)
        ELSE
            LOCATE 9, 15: PRINT "  ORDER OF ELECTION"; ":"; TAB(38); N$
        END IF
        LOCATE 10, 15: PRINT "     VICE PRESIDENT"; ":"; TAB(38); VF$; " "; VL$; " (1801-05)"
        LOCATE 11, 15: PRINT TAB(38); "George Clinton (1805-09)"
        LOCATE 12, 15: PRINT "    POLITICAL PARTY"; ":"; TAB(38); PA$
        LOCATE 13, 15: PRINT "AGE AT INAUGURATION"; ":"; TAB(38); AG$
        LOCATE 14, 15: PRINT "       YEARS SERVED"; ":"; TAB(38); PY$
        LOCATE 15, 15: PRINT "               WIFE"; ":"; TAB(38); WF$
        LOCATE 16, 15: PRINT "           CHILDREN"; ":"; TAB(38); CH$
        LOCATE 17, 15: PRINT "           ANCESTRY"; ":"; TAB(38); AC$
        LOCATE 18, 15: PRINT "           RELIGION"; ":"; TAB(38); RL$
    ELSEIF UCASE$(LN$) = "JACKSON" THEN
        CLS
        COLOR 0, 7: LOCATE 3, 30: PRINT UCASE$(NF$); " "; UCASE$(LN$)
        COLOR 15, 1
        LOCATE 7, 15: PRINT "               BORN"; ":"; TAB(38); DB$
        LOCATE 8, 15: PRINT "     PLACE OF BIRTH"; ":"; TAB(38); PS$
        IF LEFT$(N$, 1) = "0" THEN
            LOCATE 9, 15: PRINT "  ORDER OF ELECTION"; ":"; TAB(38); RIGHT$(N$, 1)
        ELSE
            LOCATE 9, 15: PRINT "  ORDER OF ELECTION"; ":"; TAB(38); N$
        END IF
        LOCATE 10, 15: PRINT "     VICE PRESIDENT"; ":"; TAB(38); VF$; " "; VL$; " (1829-32 resigned)"
        LOCATE 11, 15: PRINT TAB(38); "Martin Van Buren (1833-37)"
        LOCATE 12, 15: PRINT "    POLITICAL PARTY"; ":"; TAB(38); PA$
        LOCATE 13, 15: PRINT "AGE AT INAUGURATION"; ":"; TAB(38); AG$
        LOCATE 14, 15: PRINT "       YEARS SERVED"; ":"; TAB(38); PY$
        LOCATE 15, 15: PRINT "               WIFE"; ":"; TAB(38); WF$
        LOCATE 16, 15: PRINT "           CHILDREN"; ":"; TAB(38); CH$
        LOCATE 17, 15: PRINT "           ANCESTRY"; ":"; TAB(38); AC$
        LOCATE 18, 15: PRINT "           RELIGION"; ":"; TAB(38); RL$
    ELSEIF UCASE$(LN$) = "MADISON" THEN
        CLS
        COLOR 0, 7: LOCATE 3, 30: PRINT UCASE$(NF$); " "; UCASE$(LN$)
        COLOR 15, 1
        LOCATE 7, 15: PRINT "               BORN"; ":"; TAB(38); DB$
        LOCATE 8, 15: PRINT "     PLACE OF BIRTH"; ":"; TAB(38); PS$
        IF LEFT$(N$, 1) = "0" THEN
            LOCATE 9, 15: PRINT "  ORDER OF ELECTION"; ":"; TAB(38); RIGHT$(N$, 1)
        ELSE
            LOCATE 9, 15: PRINT "  ORDER OF ELECTION"; ":"; TAB(38); N$
        END IF
        LOCATE 10, 15: PRINT "     VICE PRESIDENT"; ":"; TAB(38); VF$; " "; VL$; " (1809-12 died)"
        LOCATE 11, 15: PRINT TAB(38); "Elbridge Gerry (1813-14 died)"
        LOCATE 12, 15: PRINT "    POLITICAL PARTY"; ":"; TAB(38); PA$
        LOCATE 13, 15: PRINT "AGE AT INAUGURATION"; ":"; TAB(38); AG$
        LOCATE 14, 15: PRINT "       YEARS SERVED"; ":"; TAB(38); PY$
        LOCATE 15, 15: PRINT "               WIFE"; ":"; TAB(38); WF$
        LOCATE 16, 15: PRINT "           CHILDREN"; ":"; TAB(38); CH$
        LOCATE 17, 15: PRINT "           ANCESTRY"; ":"; TAB(38); AC$
        LOCATE 18, 15: PRINT "           RELIGION"; ":"; TAB(38); RL$
    ELSEIF UCASE$(LN$) = "LINCOLN" THEN
        CLS
        COLOR 0, 7: LOCATE 3, 30: PRINT UCASE$(NF$); " "; UCASE$(LN$)
        COLOR 15, 1
        LOCATE 7, 15: PRINT "               BORN"; ":"; TAB(38); DB$
        LOCATE 8, 15: PRINT "     PLACE OF BIRTH"; ":"; TAB(38); PS$
        IF LEFT$(N$, 1) = "0" THEN
            LOCATE 9, 15: PRINT "  ORDER OF ELECTION"; ":"; TAB(38); RIGHT$(N$, 1)
        ELSE
            LOCATE 9, 15: PRINT "  ORDER OF ELECTION"; ":"; TAB(38); N$
        END IF
        LOCATE 10, 15: PRINT "     VICE PRESIDENT"; ":"; TAB(38); VF$; " "; VL$; " (1861-65)"
        LOCATE 11, 15: PRINT TAB(38); "Andrew Johnson (1865)"
        LOCATE 12, 15: PRINT "    POLITICAL PARTY"; ":"; TAB(38); PA$
        LOCATE 13, 15: PRINT "AGE AT INAUGURATION"; ":"; TAB(38); AG$
        LOCATE 14, 15: PRINT "       YEARS SERVED"; ":"; TAB(38); PY$
        LOCATE 15, 15: PRINT "               WIFE"; ":"; TAB(38); WF$
        LOCATE 16, 15: PRINT "           CHILDREN"; ":"; TAB(38); CH$
        LOCATE 17, 15: PRINT "           ANCESTRY"; ":"; TAB(38); AC$
        LOCATE 18, 15: PRINT "           RELIGION"; ":"; TAB(38); RL$
    ELSEIF UCASE$(LN$) = "GRANT" THEN
        CLS
        COLOR 0, 7: LOCATE 3, 30: PRINT UCASE$(NF$); " "; UCASE$(LN$)
        COLOR 15, 1
        LOCATE 7, 15: PRINT "               BORN"; ":"; TAB(38); DB$
        LOCATE 8, 15: PRINT "     PLACE OF BIRTH"; ":"; TAB(38); PS$
        IF LEFT$(N$, 1) = "0" THEN
            LOCATE 9, 15: PRINT "  ORDER OF ELECTION"; ":"; TAB(38); RIGHT$(N$, 1)
        ELSE
            LOCATE 9, 15: PRINT "  ORDER OF ELECTION"; ":"; TAB(38); N$
        END IF
        LOCATE 10, 15: PRINT "     VICE PRESIDENT"; ":"; TAB(38); VF$; " "; VL$; " (1869-73)"
        LOCATE 11, 15: PRINT TAB(38); "Henry Wilson (1873-75 died)"
        LOCATE 12, 15: PRINT "    POLITICAL PARTY"; ":"; TAB(38); PA$
        LOCATE 13, 15: PRINT "AGE AT INAUGURATION"; ":"; TAB(38); AG$
        LOCATE 14, 15: PRINT "       YEARS SERVED"; ":"; TAB(38); PY$
        LOCATE 15, 15: PRINT "               WIFE"; ":"; TAB(38); WF$
        LOCATE 16, 15: PRINT "           CHILDREN"; ":"; TAB(38); CH$
        LOCATE 17, 15: PRINT "           ANCESTRY"; ":"; TAB(38); AC$
        LOCATE 18, 15: PRINT "           RELIGION"; ":"; TAB(38); RL$
    ELSEIF UCASE$(LN$) = "MCKINLEY" THEN
        CLS
        COLOR 0, 7: LOCATE 3, 30: PRINT UCASE$(NF$); " "; UCASE$(LN$)
        COLOR 15, 1
        LOCATE 7, 15: PRINT "               BORN"; ":"; TAB(38); DB$
        LOCATE 8, 15: PRINT "     PLACE OF BIRTH"; ":"; TAB(38); PS$
        IF LEFT$(N$, 1) = "0" THEN
            LOCATE 9, 15: PRINT "  ORDER OF ELECTION"; ":"; TAB(38); RIGHT$(N$, 1)
        ELSE
            LOCATE 9, 15: PRINT "  ORDER OF ELECTION"; ":"; TAB(38); N$
        END IF
        LOCATE 10, 15: PRINT "     VICE PRESIDENT"; ":"; TAB(38); VF$; " "; VL$; " (1897-1899 died)"
        LOCATE 11, 15: PRINT TAB(38); "Theodore Roosevelt (1901)"
        LOCATE 12, 15: PRINT "    POLITICAL PARTY"; ":"; TAB(38); PA$
        LOCATE 13, 15: PRINT "AGE AT INAUGURATION"; ":"; TAB(38); AG$
        LOCATE 14, 15: PRINT "       YEARS SERVED"; ":"; TAB(38); PY$
        LOCATE 15, 15: PRINT "               WIFE"; ":"; TAB(38); WF$
        LOCATE 16, 15: PRINT "           CHILDREN"; ":"; TAB(38); CH$
        LOCATE 17, 15: PRINT "           ANCESTRY"; ":"; TAB(38); AC$
        LOCATE 18, 15: PRINT "           RELIGION"; ":"; TAB(38); RL$
    ELSEIF UCASE$(LN$) = "NIXON" THEN
        CLS
        COLOR 0, 7: LOCATE 3, 30: PRINT UCASE$(NF$); " "; UCASE$(LN$)
        COLOR 15, 1
        LOCATE 7, 15: PRINT "               BORN"; ":"; TAB(38); DB$
        LOCATE 8, 15: PRINT "     PLACE OF BIRTH"; ":"; TAB(38); PS$
        IF LEFT$(N$, 1) = "0" THEN
            LOCATE 9, 15: PRINT "  ORDER OF ELECTION"; ":"; TAB(38); RIGHT$(N$, 1)
        ELSE
            LOCATE 9, 15: PRINT "  ORDER OF ELECTION"; ":"; TAB(38); N$
        END IF
        LOCATE 10, 15: PRINT "     VICE PRESIDENT"; ":"; TAB(38); VF$; " "; VL$
        LOCATE 11, 15: PRINT TAB(38); "Gerald R. Ford"
        LOCATE 12, 15: PRINT "    POLITICAL PARTY"; ":"; TAB(38); PA$
        LOCATE 13, 15: PRINT "AGE AT INAUGURATION"; ":"; TAB(38); AG$
        LOCATE 14, 15: PRINT "       YEARS SERVED"; ":"; TAB(38); PY$
        LOCATE 15, 15: PRINT "               WIFE"; ":"; TAB(38); WF$
        LOCATE 16, 15: PRINT "           CHILDREN"; ":"; TAB(38); CH$
        LOCATE 17, 15: PRINT "           ANCESTRY"; ":"; TAB(38); AC$
        LOCATE 18, 15: PRINT "           RELIGION"; ":"; TAB(38); RL$
    ELSEIF UCASE$(LN$) = "CLEVELAND" THEN
        CLS
        COLOR 0, 7: LOCATE 3, 30: PRINT UCASE$(NF$); " "; UCASE$(LN$)
        COLOR 15, 1
        LOCATE 7, 15: PRINT "               BORN"; ":"; TAB(38); DB$
        LOCATE 8, 15: PRINT "     PLACE OF BIRTH"; ":"; TAB(38); PS$
        IF LEFT$(N$, 1) = "0" THEN
            LOCATE 9, 15: PRINT "  ORDER OF ELECTION"; ":"; TAB(38); RIGHT$(N$, 1)
        ELSE
            LOCATE 9, 15: PRINT "  ORDER OF ELECTION"; ":"; TAB(38); "22 and "; N$
        END IF
        LOCATE 10, 15: PRINT "     VICE PRESIDENT"; ":"; TAB(38); "Thomas A. Hendricks (1885 - Died )"
        LOCATE 11, 15: PRINT TAB(38); VF$; " "; VL$; " 1893-97"
        LOCATE 12, 15: PRINT "    POLITICAL PARTY"; ":"; TAB(38); PA$
        LOCATE 13, 15: PRINT "AGE AT INAUGURATION"; ":"; TAB(38); "47 and "; AG$
        LOCATE 14, 15: PRINT "       YEARS SERVED"; ":"; TAB(38); "1885-89 and "; PY$
        LOCATE 15, 15: PRINT "               WIFE"; ":"; TAB(38); WF$
        LOCATE 16, 15: PRINT "           CHILDREN"; ":"; TAB(38); CH$
        LOCATE 17, 15: PRINT "           ANCESTRY"; ":"; TAB(38); AC$
        LOCATE 18, 15: PRINT "           RELIGION"; ":"; TAB(38); RL$
    ELSEIF UCASE$(LN$) = "ROOSEVELT" THEN
        CLS
        LOCATE 9, 22: PRINT "Two presidents were named "; LN$; "."
        LOCATE 11, 22: PRINT "Press:"
        LOCATE 13, 22: PRINT "1. For Franklin D. Roosevelt"
        LOCATE 14, 22: PRINT "2. For Theodore Roosevelt"
        Ans$ = INPUT$(1)
        DO UNTIL Ans$ = "1" OR Ans$ = "2"
            COLOR 28
            LOCATE 16, 22: PRINT "Please press 1 or  2"
            Ans$ = INPUT$(1)
        LOOP
        IF Ans$ = "2" THEN
            CLS
            COLOR 0, 7: LOCATE 3, 30: PRINT UCASE$(NF$); " "; UCASE$(LN$)
            COLOR 15, 1
            LOCATE 7, 15: PRINT "               BORN"; ":"; TAB(38); DB$
            LOCATE 8, 15: PRINT "     PLACE OF BIRTH"; ":"; TAB(38); PS$
            IF LEFT$(N$, 1) = "0" THEN
                LOCATE 9, 15: PRINT "  ORDER OF ELECTION"; ":"; TAB(38); RIGHT$(N$, 1)
            ELSE
                LOCATE 9, 15: PRINT "  ORDER OF ELECTION"; ":"; TAB(38); N$
            END IF
            LOCATE 10, 15: PRINT "     VICE PRESIDENT"; ":"; TAB(38); "First term none."
            LOCATE 11, 15: PRINT TAB(38); VF$; " "; VL$; " (1905-09)"
            LOCATE 12, 15: PRINT "    POLITICAL PARTY"; ":"; TAB(38); PA$
            LOCATE 13, 15: PRINT "AGE AT INAUGURATION"; ":"; TAB(38); AG$
            LOCATE 14, 15: PRINT "       YEARS SERVED"; ":"; TAB(38); PY$
            LOCATE 15, 15: PRINT "               WIFE"; ":"; TAB(38); WF$
            LOCATE 16, 15: PRINT "           CHILDREN"; ":"; TAB(38); CH$
            LOCATE 17, 15: PRINT "           ANCESTRY"; ":"; TAB(38); AC$
            LOCATE 18, 15: PRINT "           RELIGION"; ":"; TAB(38); RL$
        ELSE
            CLS
            COLOR 0, 7: LOCATE 3, 30: PRINT UCASE$(FirstName$(34)); " "; UCASE$(LastName$(34))
            COLOR 15, 1
            LOCATE 7, 15: PRINT "               BORN"; ":"; TAB(38); DOB$(34)
            LOCATE 8, 15: PRINT "     PLACE OF BIRTH"; ":"; TAB(38); PState$(34)
            LOCATE 9, 15: PRINT "  ORDER OF ELECTION"; ":"; TAB(38); Num$(34)
            LOCATE 10, 15: PRINT "     VICE PRESIDENT"; ":"; TAB(38); VFName$(34); " "; VLName$(34); " (1933-37)"
            LOCATE 11, 15: PRINT TAB(38); "Henry Wallace (1941-45)"
            LOCATE 12, 15: PRINT TAB(38); "Harry S. Truman (1945 Roosevelt died)"
            LOCATE 13, 15: PRINT "    POLITICAL PARTY"; ":"; TAB(38); PARTY$(34)
            LOCATE 14, 15: PRINT "AGE AT INAUGURATION"; ":"; TAB(38); AgeNog$(34)
            LOCATE 15, 15: PRINT "       YEARS SERVED"; ":"; TAB(38); PYears$(34)
            LOCATE 16, 15: PRINT "               WIFE"; ":"; TAB(38); Wife$(34)
            LOCATE 17, 15: PRINT "           CHILDREN"; ":"; TAB(38); Child$(34)
            LOCATE 18, 15: PRINT "           ANCESTRY"; ":"; TAB(38); Ances$(34)
            LOCATE 19, 15: PRINT "           RELIGION"; ":"; TAB(38); Relig$(34)
        END IF
    ELSE
        CLS
        COLOR 0, 7: LOCATE 3, 30: PRINT UCASE$(NF$); " "; UCASE$(LN$)
        COLOR 15, 1
        LOCATE 7, 15: PRINT "               BORN"; ":"; TAB(38); DB$
        LOCATE 8, 15: PRINT "     PLACE OF BIRTH"; ":"; TAB(38); PS$
        IF LEFT$(N$, 1) = "0" THEN
            LOCATE 9, 15: PRINT "  ORDER OF ELECTION"; ":"; TAB(38); RIGHT$(N$, 1)
        ELSE
            LOCATE 9, 15: PRINT "  ORDER OF ELECTION"; ":"; TAB(38); N$
        END IF
        LOCATE 10, 15: PRINT "     VICE PRESIDENT"; ":"; TAB(38); VF$; " "; VL$
        LOCATE 11, 15: PRINT "    POLITICAL PARTY"; ":"; TAB(38); PA$
        LOCATE 12, 15: PRINT "AGE AT INAUGURATION"; ":"; TAB(38); AG$
        LOCATE 13, 15: PRINT "       YEARS SERVED"; ":"; TAB(38); PY$
        LOCATE 14, 15: PRINT "               WIFE"; ":"; TAB(38); WF$
        LOCATE 15, 15: PRINT "           CHILDREN"; ":"; TAB(38); CH$
        LOCATE 16, 15: PRINT "           ANCESTRY"; ":"; TAB(38); AC$
        LOCATE 17, 15: PRINT "           RELIGION"; ":"; TAB(38); RL$
    END IF
    LOCATE 25: PRINT "Press any key to continue."
    G$ = INPUT$(1)
END SUB

