/* client.c */
/*
 
 * Copyright 1994 A.Oliver De Guzman
 * All rights reserved

 *   Permission is granted to any individual to copy, use, and/or
 * distribute this software provided that the distribution retains this
 * entire copyright notice. No part of this software may be used and/or
 * sold for profit or used with any commercial product.

 * DISCLAIMER:
 *   This software comes with NO WARRANTIES of any kind. In no event
 * will the author be liable for any financial, physical, moral, and/or
 * mental damages incurred directly or indirectly by the use or intent
 * to use of this software.
 
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "dfcss.h"
#include "sock.h"
#include "sockio.h"
#include "config.h"
#include "fileio.h"
#ifndef __TURBOC__
# ifdef NCURSES
#include <ncurses.h>
# else
#include <curses.h>
# endif
#else
#include <conio.h>
#define LINES                   25
#define COLS                    80
#define printw                  printf
#define move(y,x)               gotoxy(x+1,y+1)
#define mvaddch(y,x,ch)         {gotoxy(x+1,y+1); putchar(ch);}
#define mvaddstr(y,x,s)         {gotoxy(x+1,y+1) printf("%s", s)}
#define addch(ch)               putchar(ch)
#define refresh()               /**/
#define scroll(s)               {gotoxy(1, 25); putchar('\n');}
#define ERR                     (-1)
#endif

#define EXITKEY             ('x'-'a'+1)
#define CONFIGFILE			"client.cfg"
#define RESPONSEFILE		"client.res"
#define COMMANDFILE			"playtcp.bat"
#define NOCONFIG			"# client.cfg not found."
#define MAXARGS             128

#ifdef LOGGING
#define LOGFILE             "client.log"
FILE *fp = NULL;
char logfile[1024] = LOGFILE;
#endif

#define MAXLINE				128
char buff[MAXLINE+1];
int bufflen = 0;

char COMMAND[1024] = "tcpsetup";
char SERVER[1024] = "165.220.16.6";
int SERVERPORT = PORT_NUMBER;
char EXTRA[1024] = "";

Config configs[] = {
	{ "command", CFG_STR, COMMAND },
	{ "server", CFG_STR, SERVER },
	{ "serverport", CFG_INT, &SERVERPORT },
	{ "extra", CFG_STR, EXTRA },
};
#define NUMCONFIGS		(sizeof(configs)/sizeof(Config))


int k=0;
int getkey()
{
#ifdef __TURBOC__
    int ch;
    if (kbhit())
      if (ch=getch()) return(ch);
      else return(getch());
/*
      if (ch=getch()) {move(++k%3, 0); printf("[%d]", ch); move(5,0); printf("[%s]        ", buff);return(ch); }
      else {move(++k%3, 0); printf("[%d]", ch); move(5,0); printf("[%s]          ", buff);return(getch());}
*/
    else return(ERR);
#else
    return(getch());
#endif
}

#define ClearBuffLine() { int i;   \
    buff[bufflen] = '\0';          \
    for (i=0; i<strlen(buff); i++) \
       mvaddch(LINES-1, i, ' ');   \
    move(LINES-1, 0);}

void displayline(s)
char *s;
{
	int i, j, k;

	ClearBuffLine();
	scroll(stdscr);
	for(i=0, j=0; s[i]; i++){
		if (s[i] == '\n'/* || !(i%(COLS-2))*/){
			j = 0;
/* For long lines!
			if (!(i%(COLS-2)) && (i/(COLS-2)))
				mvaddch(LINES-3, COLS-1, '\\');
*/
			scroll(stdscr);
		}
		else mvaddch(LINES-3, j++, s[i]);
	}
	move(LINES-1, 0);
	printw(buff);
    refresh();
}

int updatebuff(ch)
int ch;
{
    if (bufflen < MAXLINE && (bufflen < COLS-2)){
        buff[bufflen++] = ch;
        move(LINES-1, bufflen-1);
		addch(ch);
	}
	refresh();
}


int DisConnect(sd)
#ifdef __TURBOC__
    tcp_Socket *sd;
#else
	int sd;
#endif
{
	ASockWrite(sd, "/quit");
#ifdef __TURBOC__
	sock_close(sd);
#else
	close(sd);
#endif
}


int Quit(n, sd)
int n;
{
#ifndef __TURBOC__
	resetty();
	endwin();
#endif
#ifdef LOGGING
	if (fp) closelog(fp);
#endif
	exit(n);
}


main(argc, argv)
int argc;
char *argv[];
{
#ifdef __TURBOC__
	tcp_Socket mysock;
	tcp_Socket *sd = &mysock;
#else
	int sd;
#endif
	char hostname[1024], serverID[IDLEN+1];
    char msg[MAXMSG+1], commandline[MAXMSG+1], response[MAXMSG+1];
    char *myargs[MAXARGS+1], *p;
	int port = PORT_NUMBER, status = 0;
    int i, j, msglen;
    char configfile[1024];
	char stype[80];
	int nread;
	int ch;

	strcpy(configfile, CONFIGFILE);
	strcpy(stype, "player");

	if ((i = CheckParm("-config", argc, argv)) && (i < argc-1))
		strcpy(configfile, argv[i+1]);

	if (CheckParm("-status", argc, argv)){
		strcpy(stype, "status");
		status = 1;
	}

	if (CheckParm("-guest", argc, argv))
		strcpy(stype, "guest");

	if (CheckParm("-god", argc, argv))
		strcpy(stype, "god");

	if (readconfig(configfile, configs, NUMCONFIGS) == -1){
		if (!status){
			printf("Cannot open config file [%s]. Using defaults.\n",
				configfile);
			fflush(stdout);
		}
	}

	port = SERVERPORT;

	/* commandline overrides the cfg file */
	if ((i = CheckParm("-server", argc, argv)) && (i < argc-1))
		strcpy(SERVER, argv[i+1]);

	if ((i = CheckParm("-port", argc, argv)) && (i < argc-1))
		port = atoi(argv[i+1]);

	StripWhite(SERVER);
	StripWhite(EXTRA);

	strcpy(hostname, SERVER);
    if (!status){
		printf("Connecting to [%s] in port[%d]...", hostname, port);
		fflush(stdout);
	}

#ifdef __TURBOC__
    sock_init();
    if (SockOpen(sd, hostname, port) == -1) exit(1);
#else
    if ((sd = SockOpen(hostname, port)) == -1) exit(1);
#endif
	
	if (!status) printf("Reading_ServerVersion...");
	if (SockRead(sd, serverID, IDLEN) < 0){
		printf("Cannot read serverID.\n");
		exit(0);
	}

    serverID[IDLEN] = '\0';
	if (strncmp(SERVERID, serverID, IDLEN)){
		printf("Incorrect Version.\n");
		exit(0);
	}

	/* Write out the connection type */
	if (ASockWrite(sd, stype) <0) exit(1);

	if (status){
		printf("[%s] port %d\n", hostname, port);
        ASockRead(sd, msg);
        printf("%s\n", msg);
        DisConnect(sd);
		exit(0);
	}

    if ((msglen = readfile(configfile, msg, MAXMSG)) == -1){
		strcpy(msg, NOCONFIG);
		msglen = strlen(NOCONFIG);
		printf("Cannot open config file [%s].\n", configfile);
	}

	msg[msglen] = '\0';
	printf("Send_Configuration...");
    if (ASockWrite(sd, msg) < 0) exit(1);
	printf("ok.");

#ifdef LOGGING
	fp = openlog(logfile);
	sprintf(msg, "connect %s:%d [%s]", hostname, port, serverID);
	logger(fp, msg);
#endif
	
#ifndef __TURBOC__
	initscr();
	savetty();
	cbreak();
	noecho();
	nodelay(stdscr, TRUE);
	nonl();
	raw();
	scrollok(stdscr, TRUE);
# ifdef KEY_UP
	keypad(stdscr, TRUE);
# endif
#else
   	clrscr();
#endif

	displayline("= The Internet DOOM Client");
    displayline("= by A.Oliver de Guzman\n");

    sprintf(msg, "Connected to [%s].", hostname);
    displayline(msg);

    bufflen = 0;
	msg[0] = '\0';
    while(strcmp(msg, CONNECT) && strcmp(msg, ABORT) && strcmp(msg, SHUTDOWN)
#ifdef __TURBOC__
    && tcp_tick(sd)
#endif
	){
        switch(ch=getkey()){
			case ERR:
				break;
			case EXITKEY :
				DisConnect(sd);
				Quit(1);
				break;
#ifdef __TURBOC__
			case '\b':
#else
# ifdef KEY_BACKSPACE
            case KEY_BACKSPACE:
# else
            case '\b':
# endif
#endif
                if (bufflen > 0){
                    bufflen--;
                    mvaddch(LINES-1, bufflen, ' ');
                    move(LINES-1, bufflen);
                }
				break;
            case '\r':
                buff[bufflen] = '\0';
				ClearBuffLine();
				ASockWrite(sd, buff);
                bufflen = 0;
				break;
			default:
                if (isprint(ch)) updatebuff(ch);
				break;
		}

        if ((nread = NSockRead(sd, msg)) < 0) Quit(0);
        if (nread) displayline(msg);
    }

    if (!strcmp(msg, ABORT)) Quit(0);

	/* read something for the log file */
	if (ASockRead(sd, msg) < 0) Quit(0);
#ifdef LOGGING
    logger(fp, msg);
#endif

	/* read the parameters for the response file */
	if (ASockRead(sd, response) < 0) Quit(0);
	writefile(RESPONSEFILE, response, strlen(response));

	/* read the commandline parameters */
	if (ASockRead(sd, commandline) < 0) Quit(0);

	/* read parting message */
	if (ASockRead(sd, msg) < 0) Quit(0);
	displayline(msg);

	sprintf(msg, "%s @%s %s %s", COMMAND, RESPONSEFILE, EXTRA, commandline);
	StripWhite(msg);
	displayline(msg);
	writefile(COMMANDFILE, msg, strlen(msg));

    sprintf(msg, "%s @%s %s %s", COMMAND, RESPONSEFILE, EXTRA, commandline);
	StripWhite(msg);
    for (i=0, j=0; msg[i] && j < MAXARGS; j++){
       	/* skip spaces, look for a parameter */
       	while (isspace(msg[i]) && msg[i]) i++;
       	p = msg+i;

       	/* goto the end of the parameter */
       	while (!isspace(msg[i]) && msg[i]) i++;
       	msg[i] = '\0';

       	if (*p){
            	myargs[j] = (char *) malloc(sizeof(char)*(strlen(p)+1));
            	strcpy(myargs[j], p);
            	i++;
       	}
	}
    myargs[j] = NULL;

    if (execvp(COMMAND, myargs) == -1){
		displayline("Cannot execute command");
		Quit(0);
	}

	Quit(0);
}

