#ifndef _CONFIG_H
#define _CONFIG_H
/* WB2PSI.H 386 - switch */

#define whofor "WB2PSI (switch)"

/* Software options */
  
#define CONVERS     1   /* Conference bridge (babble-box :-) */
#define XCONVERS    1
/* Use only ONE of the 2 news options below !!! */
#undef NNTP        1   /* Netnews client */
#undef NNTPS       1   /* Netnews client and server */
#undef STKTRACE   1   /* Include stack tracing code */
#define TRACE       1   /* Include packet tracing code */
#undef DIALER      1   /* SLIP redial code */
#undef POP2CLIENT  1   /* POP2 client -- IAB not recommended */
#undef POP3CLIENT  1   /* POP3 client -- IAB draft standard */
#define POPLZW     1
#undef ESCAPE      1   /* Allow Unix style escape on PC */
#define ATCMD       1   /* Include timed 'at' execution */
#define NR4TDISC    1   /* Include Netrom L4 timeout-disconnect */
#undef XMODEM      1   /* xmodem file xfer for tipmail  */
#undef IPACCESS    1   /* Include IP access control code */
#undef TCPACCESS   1   /* Include TCP access control code */
#undef ENCAP       1   /* Include IP encapsulation code */
#undef AUTOROUTE   1   /* Include AX.25 IP auto-route code(causes problems when VC mode is used for ip) */
#undef HOPPER      1   /* Include SMTP hopper code by G8FSL */
#undef LOCK        1   /* Include keyboard locking */
#undef TTYCALL     1   /* Include AX.25 ttylink call */
#define MONITOR     1   /* Include user-port monitor trace mode */
#undef MULTITASK   1   /* Include Dos shell multi-tasker */
#define SHELL       1   /* Include shell command */
#undef SWATCH      1   /* stopWATCH code */
#define ALLCMD     1    /* include dump,finger,fkey,info,mail,motd,more,status,
                         * record,watch,upload commands */
#define DOSCMD      1   /* Include del,ren,cd,dir,mkdir,pwd,rmdir commands */
  
#define SPLITSCREEN     1
#define STATUSWIN       1   /* Up to 3 line status window */
  
/* Protocol options */
  
#define AX25        1   /* Ax.25 support */
#define NETROM      1   /* NET/ROM network support */
#define NRS         1   /* NET/ROM async interface */
#undef RIP         1   /* Include RIP routing */
#define LZW         1   /* LZW-compressed sockets */
#define SLIP        1   /* Serial line IP on built-in ports */
#undef PPP         1   /* Point-to-Point Protocol code */
#define VJCOMPRESS  1   /* Van Jacobson TCP compression for SLIP */
#undef RDATE       1   /* Include the Time Protocol */
#undef RSPF        1   /* Include Radio Shortest Path First Protocol */
#undef AXIP        1   /* digipeater via ip port 93 interface */
#undef RARP        1   /* Include Reverse Address Resolution Protocol */
#undef BOOTP       1   /* Include BootP protocol */
  
  
/* Network services */
  
#define SERVERS         1   /* Include TCP servers */
#define AX25SERVER       1   /* Ax.25 server */
#define NETROMSERVER     1   /* Net/rom server */
#define TELNETSERVER     1   /* Tcp telnet server */
#define RLOGINSERVER     1   /* Tcp rlogin server */
#undef TTYLINKSERVER    1   /* Tcp ttylink server */
#define SMTPSERVER       1   /* Tcp smtp server */
#define FTPSERVER        1   /* Tcp ftp server */
#define FINGERSERVER     1   /* Tcp finger server */
#undef POP2SERVER       1   /* POP2 server -- IAB not recommended */
#define POP3SERVER      1   /* POP3 server -- IAB draft standard */
#define REMOTESERVER     1   /* Udp remote server */
#undef ECHOSERVER       1   /* Tcp echo server */
#undef DISCARDSERVER    1   /* Tcp discard server */
#define TIPSERVER        1   /* Serial port tip server */
#define DOMAINSERVER    1   /* Udp Domain Name Server */
#define CALLSERVER       1   /* Include BuckMaster CDROM server support */
#undef ICALL            1   /* Buckmaster's international callsign database April '92 */
#undef SAMCALLB         1   /* SAM callbook server. Note that you can NOT have */
                            /* BOTH Buckmaster and SAM defined.If so, SAM is used */
#undef QRZCALLB         1   /* QRZ callbook server. Note that you can NOT have */
                             /* BOTH Buckmaster and QRZ defined.If so, QRZ is used */

/* Outgoing Sessions */
  
#define SESSIONS        1
#undef CALLCLI          1   /* Include BuckMaster or SAM client code only  */
#undef AX25SESSION      1
#undef NETROMSESSION    1
#define TELNETSESSION    1
#define TTYLINKSESSION   1
#define BBSSESSION      1
#define FTPSESSION       1
#define FINGERSESSION    1
#define PINGSESSION      1
#define HOPCHECKSESSION  1   /* IP path tracing command */
#undef RLOGINSESSION    1   /* Rlogin client code */
#define TIPSESSION       1
#define DIRSESSION       1
#define MORESESSION      1
#define REPEATSESSION   1
#define LOOKSESSION     1   /* follow user activity on the bbs */
  
/* Mailbox options */
  
#define MAILBOX     1   /* Include SM0RGV mailbox server */
#define MAILCMDS    1   /* Include mail commands, S, R, V etc */
#define FILECMDS    1   /* Include D,U,W,Z commands */
#define GATECMDS    1   /* Include gateway releated commands C,E,N,NR,P,PI,T */
#undef GWTRACE     1   /* Log all gateway connects to the logfile */
#define FOQ_CMDS    1   /* Include Finger, Operator, Query
                         * If GATECMDS and FOQ_CMDS are both undefined,
                         * extra code is saved! */
#define EXPIRY      1   /* Include message and bid expiry */
#undef MAILFOR     1   /* Include Mailbox 'Mail for' beacon */
#define RLINE       1   /* Include BBS R:-line interpretation code */
#undef MBFWD       1   /* Include Mailbox AX.25 forwarding */
#undef FWDCTLZ     1    /* Use a CTRL-Z instead of /EX to end message forwarding */
#define USERLOG     1   /* Include last-msg-read,prompt-type user tracking */
#define REGISTER    1   /* Include User Registration option */
#undef MAILERROR   1   /* Include Mail-on-error option */
  
  
/* Memory options */
  
#define EMS         1   /* Include Expanded Memory Usage */
 /* DO NOT define the following, it doesn't work yet !!! */
#undef XMS         1   /* Include Extended Memory Usage */
  
  
/* Software tuning parameters */
  
#define MTHRESH     16384    /* Default memory threshold */
#define NROWS       25      /* Number of rows on screen */
#define NIBUFS      5       /* Number of interrupt buffers */
#define IBUFSIZE    2048    /* Size of interrupt buffers */
#define NSESSIONS   10      /* Number of interactive clients */
  
  
/* Hardware driver options */
  
#define ASY         1   /* Asynch driver code */
#define KISS        1   /* Multidrop KISS TNC code for Multiport tnc */
#undef POLLEDKISS  1   /* G8BPQ Polled Multidrop KISS TNC code */
#define PACKET      1   /* FTP Software's Packet Driver interface */
#undef SCC         1   /* PE1CHL generic scc driver */
#undef BPQ         1   /* include Bpqhost interface */
#undef PACKETWIN   1   /* Gracilis PackeTwin driver */
#undef PI          1   /* VE3IFB pi dma card scc driver */
#undef ARCNET      1   /* ARCnet via PACKET driver */
#undef PC_EC       1   /* 3-Com 3C501 Ethernet controller */
#undef HS          1   /* High speed (56kbps) modem driver */
#undef HAPN        1   /* Hamilton Area Packet Network driver code */
#undef EAGLE       1   /* Eagle card driver */
#undef PC100       1   /* PAC-COM PC-100 driver code */
#undef APPLETALK   1   /* Appletalk interface (Macintosh) */
#undef DRSI        1   /* DRSI PCPA slow-speed driver */
#undef SLFP         1   /* SLFP packet driver class supported */
  
#define N2RJT_FINGERS    /* Enable for more fingers available from the finger daemon */
#define N2RJT_ASYNC_NRS  /* Async driver does NRS handshaking for hexipus */
#define N2RJT_PRINT_COMMAND /* Print command */
#define N2RJT_USERLOGIN  /* User login with less universal perms */
/*#define XCONVERS         /* LZW-compressed convers */
#define CHANNELNAMES     /* Named convers channels */
#define CALLCHECK        /* Checks for valid callsign in convers */
#define LOCAL_CHANNELS   /* Local channels don't convect to other nodes */
#define ENHANCED_VIA     /* If convers user is local, "via" gives more info */
#define CHANGE_PERSONAL  /* Allow users to change their personal data */
#define LINK_CHANGE_MSG  /* Send link change messages in convers */
#define MBOXRESET        /* Allow disconnect of mbox users by sysop */
#define CHAINED_IRQ
#define DECIMAL_IRQ
#define RECORD_TO_PORT   /* Allows session recording to LPT, COM, etc */
#define SESSION_SPLIT    /* Session split on/off command */
#define LZW_TELNET_3601  /* Automatically compress telnet to 3601 */

#ifdef CHAINED_IRQ
#define DECIMAL_IRQ
#endif
  
/***************************************************************************/
/* This section corrects some defines that include/exclude others          */
  
#ifdef STATUSWIN
#define SPLITSCREEN 1
#endif
  
#ifdef DIRSESSION
#undef MORESESSION
#define MORESESSION 1
#endif
  
#if defined(NRS)
#undef  NETROM
#define NETROM      1   /* NRS implies NETROM */
#endif
  
#if defined(ARCNET) || defined(SLFP)
#undef  PACKET
#define PACKET      1   /* FTP Software's Packet Driver interface */
#endif
  
#if defined(PC_EC) || defined(PACKET)
#define ETHER   1       /* Generic Ethernet code */
#endif
  
#if defined(SAMCALLB)
#define CALLCLI 1
#undef CALLSERVER 1
#undef QRZCALLB 1
#endif
  
#if defined(QRZCALLB)
#define CALLCLI 1
#undef CALLSERVER 1
#undef SAMCALLB   1
#endif

#if defined(CALLSERVER)
#define CALLCLI     1
#endif
  
#if defined(POP2CLIENT) || defined(POP3CLIENT)
#define MAILCLIENT  1
#endif
  
#ifdef POLLEDKISS
#define KISS 1
#endif
  
#ifndef MAILBOX
#undef MAILCMDS 1
#undef FILECMDS 1
#undef GATECMDS 1
#undef FOQ_CMDS 1
#undef CALLBOOK 1
#undef CALLCLI 1
#undef EXPIRY 1
#undef MBXTDISC 1
#undef TIPSERVER 1
#undef MAILFOR 1
#undef RLINE 1
#undef MBFWD 1
#undef USERLOG 1
#endif
  
#ifndef MAILCMDS
#undef MAILFOR 1
#undef RLINE 1
#undef MBFWD 1
#endif
  
#ifndef TIPSERVER
#undef XMODEM 1
#endif
  
#ifndef AX25
#undef AX25SESSION 1
#undef AX25SERVER 1
#undef MAILFOR 1
#undef RLINE 1
#undef MBFWD 1
#undef NRS 1
#undef NETROM 1
#undef NETROMSESSION 1
#undef NETROMSERVER 1
#undef AXIP 1
#undef NR4TDISC 1
#undef TTYCALL 1
#undef BPQ 1
#undef EAGLE 1
#undef SCC 1
#undef KISS 1
#undef POLLEDKISS 1
#undef HAPN 1
#undef PI 1
#undef PC100 1
#undef HS 1
#undef AXIP 1
#endif
  
#ifndef NETROM
#undef NETROMSESSION 1
#undef NETROMSERVER 1
#endif
  
#ifndef SMTPSERVER
#undef MAILCMDS 1
#undef MBFWD 1
#undef MAILFOR 1
#undef RLINE 1
  
#endif
  
  
#endif  /* _CONFIG_H */
