/* Various I/O definitions specific to asynch I/O on Linux */
#ifndef _LXASY_H
#define _LXASY_H
  
#ifndef _MBUF_H
#include "mbuf.h"
#endif
  
#ifndef _PROC_H
#include "proc.h"
#endif
  
#ifndef _IFACE_H
#include "iface.h"
#endif
  
/* Asynch controller control block */
struct asy {
    struct iface *iface;
    struct mbuf *sndq;  /* Transmit queue */
    struct mbuf *rcvq;  /* Receive queue */
    struct proc *rxproc;    /* Low-level receive process */
    int fd;         /* Fildes for tty device */
    char uulock[60];    /* UUCP lock file name */
    long speed;
    long rxints;        /* simulated rx interrupts */
    long txints;        /* simulated tx interrupts */
    long rxchar;        /* Received characters */
    long txchar;        /* Transmitted characters */
};
  
extern int Nasy;        /* Actual number of asynch lines */
extern struct asy Asy[];
  
extern int carrier_detect __ARGS((int));
  
#endif  /* _LXASY_H */
