/* MAIL2IND creates index files for all *.TXT mail files
 * found in the present directory and all directories below it.
 * (C) 1993 Johan. K. Reinalda, WG7J
 * Freely usable for non-commercial use only !
 *
 * Syntax:
 * ' mail2ind -d<dirname>' sets mail directory to create index files.
 * Eg: mail2ind -d/nos
 *
 * if called with an argument not starting with - ,
 * this is taken to be a file to be indexed. If this file has
 * no extension, the '.txt' is assumed.
 * Eg: mail2ind wg7j
 *     mail2ind wg7j.txt
 *
 * v1.06 - fixed -d again :-(
 * v1.05 - redone for new format of index file. Now call MAIL2IND.EXE
 *         released with jnos 1.10x10 . Added -v option to show index file.
 *         and -v for verbose mode.
 * v1.04 - /spool/areas file is read for message type. (-d option also
 *         works with this)
 * v1.03 - added -? option for help, smtp 'Apparently-to:' handled,
 * v1.02 - bug fix in -d option. (930706)
 * v1.01 - bug fix, no more corrupt index file if message file is empty
 *         or contains no valid messages.  (930629)
 * v1.0  - Initial release, with JNOS 1.10X3 (930622)
 *
 */
  
#include <io.h>
#include <fcntl.h>
#include <dir.h>
#include <ctype.h>
#ifdef MSDOS
#include <dos.h>
#endif
#include "global.h"
#include "mailutil.h"
#include "smtp.h"
#include "files.h"
#include "index.h"
  
#define VERSION "JNOS index files creator v1.06\n" \
"(C) 1993 Johan. K. Reinalda, WG7J\n"
  
#undef fopen
  
char *Mailspool = "/spool/mail";
char *Arealist = "/spool/areas";
  
int found,verbose;
  
void index(char *file) {
    int val;
    char *cp;
  
    found = 1;
    printf("File: %s/%s\n",Mailspool,file);
  
    if((cp = strchr(file,'.')) != NULL)
        *cp = '\0';
  
    if((val=IndexFile(file,verbose)) != 0)
        printf("Error %d occured!\n",val);
  
    return;
}
  
void show_index(char *name) {
    int i,idx;
    char *cp;
    struct indexhdr hdr;
    struct mailindex ind;
    char buf[129];
  
    if((cp=strchr(name,'.')) != NULL)
        *cp = '\0';
    sprintf(buf,"%s/%s.ind",Mailspool,name);
    if((idx = open(buf,READBINARY)) == -1) {
        printf("Index file '%s' not found!\n",buf);
        return;
    }
  
    if(read_header(idx,&hdr) == -1){
        printf("Can not read header from index file '%s'\n",buf);
        return;
    }
  
    printf("%s has %d message%s:\n\n",buf,hdr.msgs,(hdr.msgs == 1 ? "" : ""));
  
    memset(&ind,0,sizeof(ind));
  
    for(i=1;i<=hdr.msgs;i++) {
        printf("Message %d\n",i);
        default_index("",&ind);
        if(read_index(idx,&ind) == -1) {
            puts("Can not read index!");
            break;
        }
        print_index(&ind);
    }
  
}
  
int checkdir(char *path) {
    char *wildcard,*newpath,*fullname;
    struct ffblk ff;
    int done;
  
    if((wildcard = malloc(129)) == NULL) {
        puts("can't allocate 'wildcard'");
        return -1;
    }
    if((newpath = malloc(129)) == NULL) {
        puts("Can't allocate 'newpath'");
        free(wildcard);
        return -1;
    }
    if((fullname = malloc(129)) == NULL) {
        puts("Can't allocate 'fullname'");
        free(wildcard);
        free(newpath);
        return -1;
    }
  
    /* First check all the files */
    if(!path)
        sprintf(wildcard,"%s/*.txt",Mailspool);
    else
        sprintf(wildcard,"%s/%s/*.txt",Mailspool,path);
    done = findfirst(wildcard,&ff,0);
    while(!done){
        if(!path)
            strcpy(fullname,ff.ff_name);
        else
            sprintf(fullname,"%s/%s",path,ff.ff_name);
        index(fullname);
        done = findnext(&ff);
    }
    /* Now check for sub-directories */
    if(!path)
        sprintf(wildcard,"%s/*.*",Mailspool);
    else
        sprintf(wildcard,"%s/%s/*.*",Mailspool,path);
    done = findfirst(wildcard,&ff,FA_DIREC);
    while(!done){
        if(strcmp(ff.ff_name,".") && strcmp(ff.ff_name,"..")) {
            /* Not the present or 'mother' directory, so create new path,
             * and recurs into it.
             */
            if(!path)
                strcpy(newpath,ff.ff_name);
            else
                sprintf(newpath,"%s/%s",path,ff.ff_name);
            checkdir(newpath);
        }
        done = findnext(&ff);
    }
    free(wildcard);
    free(newpath);
    free(fullname);
    return 0;
}
  
char HelpTxt[] = "Options:\n"
"<filename>   mailfile to index\n"
"-d<rootdir>  set new root, same as 'NOS -d<dir>\n"
"-s<filename> view index file for <filename>\n"
"-v           verbose (show index before writing it)\n"
"-?,-h,-H     produce this help.";
  
char NewMailspool[129];
char NewArealist[129];
  
void main(int argc,char *argv[]) {
    char *cp;
    int i,len,onefile = 0;
    char fn[129];
  
    puts(VERSION);
  
    if(argc > 1) {
        for(i=1;i<argc;i++) {
            dirformat(argv[1]);
            if(argv[i][0] == '-') {
                /* Command line options */
                switch(tolower(argv[i][1])) {
                    case '?':
                    case 'h':
                        puts(HelpTxt);
                        return;
                    case 'd':
                    /* Set the directory to search and index */
                        cp = &argv[i][2];
                        len=strlen(cp);
                        if(len) {
                            if(cp[len-1] == '/' || cp[len] == '\\')
                                cp[len-1] = '\0';
                        /* Add path in front */
                            strcpy(NewMailspool,cp);
                            strcat(NewMailspool,Mailspool);
                            Mailspool = NewMailspool;
                            strcpy(NewArealist,cp);
                            strcat(NewArealist,Arealist);
                            Arealist = NewArealist;
                        }
                        break;
                    case 'v':
                        verbose = 1;
                        break;
                    case 's':
                        show_index(&argv[i][2]);
                        return;
                        break;
                    default:
                        printf("Invalid option %s\n\n",argv[1]);
                        puts(HelpTxt);
                        return;
                }
            } else {
                /* Just one file to do */
                if((cp=strchr(argv[i],'.')) != NULL)
                    *cp = '\0'; /* Cut off extension */
                strcpy(fn,argv[i]);
                strcat(fn,".txt");
                onefile = 1;
            }
        }
    }
  
    if(onefile) {
        index(fn);
        if(!found)
            printf("Not found: %s\n", fn);
        return;
    }
  
    if(checkdir(NULL))
        puts("ERROR detected, not all index files created!\n");
    if(!found)
        puts("NO files found to index !\n");
}
  
int pwait(void *event) {
    return 0;
}
  
void *
mallocw(nb)
unsigned nb;
{
    return malloc((size_t)nb);
}
  
  
