/*
mkinfo.c	wa2zkd   6 Sep 1994

Derived from JNOS110g's version.c to create config.inf files to
use with a revised version.c scheme that reads external files.
This scheme saves nos.exe from having to carry the baggage of all
this info.

*/

#include <stdio.h>
#include "config.h"

int
main()
{
    int Nibufs = NIBUFS;
    int Ibufsize = IBUFSIZE;
    FILE *fp;
    if((fp = fopen("config.inf","w")) != NULL) {

    fprintf(fp,"\n");

#ifndef SERVERS
    fprintf(fp,"TCP Servers:  None !\n");
#else

    fprintf(fp,"TCP Servers:"
#ifdef SMTPSERVER
    " SMTP"
#endif
#ifdef FINGERSERVER
    " FINGER"
#endif
#ifdef FTPSERVER
    " FTP"
#endif
#ifdef TELNETSERVER
    " TELNET"
#endif
#ifdef RLOGINSERVER
    " RLOGIN"
#endif
#ifdef TTYLINKSERVER
    " TTYLINK"
#endif
#ifdef DISCARDSERVER
    " DISCARD"
#endif
#ifdef ECHOSERVER
    " ECHO"
#endif
    "\n");

#if (defined(CALLSERVER) || defined(SAMCALLB) || defined(QRZCALLB) || defined(CONVERS) || defined(NNTPS) || defined(POP2SERVER) || defined(POP3SERVER) || defined(RDATE))
    fprintf(fp,"            "

#ifdef CALLSERVER
    " Callbook (CD-ROM)"
#endif

#ifdef SAMCALLB
    " Callbook (SAM)"
#endif /* SAMCALLB */

#ifdef QRZCALLB
    " Callbook (QRZ)"
#endif /* QRZCALLB */

#ifdef CONVERS
    " CONVERS"
#endif

#ifdef NNTPS
    " NNTP"
#endif

#ifdef POP2SERVER
    " POP2"
#endif

#ifdef POP3SERVER
    " POP3"
#endif


#ifdef RDATE
    " TIME"
#endif

    "\n");
#endif /* CALLSERVER || CONVERS || NNTPS || POP2SERVER || POP3SERVER || RDATE */

#endif /* SERVERS */

    fprintf(fp,"TCP Clients: SMTP"

#ifdef FINGERSESSION
    " FINGER"
#endif

#ifdef FTPSESSION
    " FTP"
#endif

#ifdef TELNETSESSION
    " TELNET"
#endif

#ifdef TTYLINKSESSION
    " TTYLINK"
#endif

    "\n");

#if (defined(CALLCLI) || defined(CONVERS) || defined(NNTP) || defined(NNTPS) || defined(POP2CLIENT) || defined(POP3CLIENT) || defined(RLOGINCLI) || defined(RDATE))
    fprintf(fp,"             "

#ifdef CALLCLI
    "Callbook Client"
#endif

#ifdef CONVERS
    " CONVERS"
#endif

#if (defined(NNTP) || defined(NNTPS))
    " NNTP"
#endif

#ifdef POP2CLIENT
    " POP2"
#endif

#ifdef POP3CLIENT
    " POP3"
#endif

#ifdef RLOGINCLI
    " RLOGIN"
#endif

#ifdef RDATE
    " TIME"
#endif

#ifdef LOOKSESSION
    " LOOK"
#endif

    "\n");
#endif /* CALLCLI || CONVERS || NNTP || NNTPS || POP2CLIENT || POP3CLIENT || RLOGINCLI || RDATE */

    fprintf(fp,"With:\n");

#ifdef LZW
    fprintf(fp,"LZW compression for TCP sockets\n");
#endif /* LZW */

#if (defined(TCPACCESS) || defined(IPACCESS))

#ifdef TCPACCESS
    "TCP"
#endif

#if (defined(TCPACCESS) && defined(IPACCESS))
    "/"
#endif

#ifdef IPACCESS
    "IP"
#endif

    " access controls\n");
#endif /* TCPACCESS || IPACCESS */


#if (defined(DOMAINSERVER) || defined(REMOTESERVER))
    fprintf(fp,"UDP Servers:"
#endif /* DOMAINSERVER || REMOTESERVER */

#ifdef DOMAINSERVER
    "  DOMAIN NAMESERVER"
#endif /* DOMAINSERVER */

#ifdef REMOTESERVER
    "  REMOTE"
#endif /* SERVERS */

#if (defined(DOMAINSERVER) || defined(REMOTESERVER))
    "\n");
#endif /* DOMAINSERVER || REMOTESERVER */

#ifdef MAILBOX

#ifdef TIPSERVER
	fprintf(fp,"TIP ");
#endif

    fprintf(fp,"Mailbox Server"

#ifdef XMODEM
    " with Xmodem file transfer"
#endif /* XMODEM */

    "\n");

#ifdef MAILCMDS
    fprintf(fp,"Full Service BBS"

#if (defined(EXPIRY) || defined(MAILFOR) || defined(MBFWD) || defined(RLINE))
    " with:"
#endif

#ifdef EXPIRY
    "\n     Message and BID expiry"
#endif

#ifdef MAILFOR
    "\n     'Mail For' beaconing"
#endif

#ifdef MBFWD
    "\n     AX.25 mail forwarding"
#endif /* MBFWD */

#ifdef RLINE
    "\n     BBS 'R:-line' compatibility"
#endif /* RLINE */

    "\n");
#endif /* MAILCMDS */

#endif /* MAILBOX */

#if (defined(AXIP) || defined(ENCAP))
    fprintf(fp,"Internet Services:"

#ifdef AXIP
    "  AX.25 Digipeating"
#endif /* AXIP */

#ifdef ENCAP
    "  IP Encapsulation"
#endif /* ENCAP */

    "\n");
#endif /* AXIP || ENCAP */

#ifdef HOPCHECKSESSION
	fprintf(fp,"Hopcheck IP path tracing\n");
#endif /* HOPCHECKSESSION */

#ifdef HOPPER
    fprintf(fp,"G8FSL SMTP Hopper\n");
#endif

#ifdef RIP
    fprintf(fp,"RIP-2 Routing Protocol\n");
#endif /* RIP */

#ifdef RSPF
	fprintf(fp,"Radio Shortest Path First Protocol (RSPF)\n");
#endif /* RSPF */

#ifdef RARP
	fprintf(fp,"Reverse Address Resolution Protocol (RARP)\n");
#endif /* RARP */

    fprintf(fp,"%d interrupt buffers of %d bytes\n",Nibufs,Ibufsize);

#ifdef ASY
#ifdef LINUX
    fprintf(fp,"Generic async (cua*) interface driver\n");
#else
    fprintf(fp,"Generic async (8250/16450/16550) interface driver\n");
#endif

#if (defined(KISS) || defined(AX25) || defined(NRS))
    fprintf(fp,"Async interface drivers:"

#ifdef KISS
    "  KISS-TNC"
#endif /* KISS */

#ifdef POLLEDKISS
    "  POLLED-KISS"
#endif /* POLLEDKISS */

#ifdef AX25
    "  AX.25"
#endif /* AX25 */

#ifdef NRS
    "  NET/ROM-TNC"
#endif /* NRS */

    "\n");
#endif /* KISS || AX25 || NRS */

#endif /* ASY */

#ifdef BPQ
    fprintf(fp,"Bpq Host driver\n");
#endif

#ifdef NETROM
	fprintf(fp,"NET/ROM network interface\n");
#endif /* NETROM */

#if (defined(PPP) || defined(SLIP))
    fprintf(fp,"Async IP drivers:"

#ifdef PPP
    "  Point-to-Point (PPP)"
#endif /* PPP */

#ifdef SLIP
    "  Serial Line (SLIP)"
#endif /* SLIP */

    "\n");

#ifdef DIALER
    fprintf(fp,"      with dialer code for SLIP\n");
#endif /* DIALER */

#ifdef VJCOMPRESS
    fprintf(fp,"      with V-J compression for PPP/SLIP\n");
#endif /* VJCOMPRESS */

#endif /* PPP || SLIP */

#ifdef PACKET
	fprintf(fp,"FTP Software's PACKET driver interface\n");
#endif /* PACKET */

#ifdef APPLETALK
	fprintf(fp,"Appletalk interface for MacIntosh\n");
#endif /* APPLETALK */

#ifdef ARCNET
	fprintf(fp,"ARCnet via PACKET driver\n");
#endif /* ARCNET */

#ifdef DRSI
	fprintf(fp,"DRSI PCPA low-speed driver\n");
#endif /* DRSI */

#ifdef EAGLE
    fprintf(fp,"Eagle card 8530 driver\n");
#endif /* EAGLE */

#ifdef ETHER
    fprintf(fp,"Generic ethernet driver\n");
#endif /* ETHER */

#ifdef HAPN
	fprintf(fp,"Hamilton Area Packet Network driver\n");
#endif /* HAPN */

#ifdef HS
	fprintf(fp,"High speed (56 kbps) modem driver\n");
#endif /* HS */

#ifdef PACKETWIN
	fprintf(fp,"Gracilis PackeTwin driver\n");
#endif /* PACKETWIN */

#ifdef PC_EC
	fprintf(fp,"3-Com 3C501 Ethernet controller driver\n");
#endif /* PC_EC */

#ifdef PC100
	fprintf(fp,"PAC-COM PC-100 driver\n");
#endif /* PC100 */

#ifdef PI
	fprintf(fp,"PI SCC card with DMA driver (VE3IFB)\n");
#endif /* PI */

#ifdef SCC
    fprintf(fp,"Generic SCC (8530) driver (PE1CHL)\n");
#endif /* SCC */

#ifdef SLFP
	fprintf(fp,"SLFP via PACKET driver\n");
#endif /* SLFP */
    
#ifdef TRACE
	fprintf(fp,"Hardware interface packet tracing code\n");
#endif /* TRACE */

#ifdef STKTRACE
	fprintf(fp,"Stack tracing code\n");
#endif /* STKTRACE */

#ifdef MULTITASK
/*      fprintf(fp,"The Russell Nelson modsets\n"); */
	fprintf(fp,"Multitasking capability when shelling out to MS-DOS\n");
#endif /* MULTITASK */

#ifdef LINUX
    fprintf(fp,"Linux modifications by Brandon S. Allbery\n");
#endif

#ifdef MONITOR
    fprintf(fp,"User port monitor trace mode\n");
#endif

    fclose(fp);
    }

    if((fp = fopen("longmenu.eng","w")) != NULL) {

#ifdef MAILCMDS
    fprintf(fp,"Mail   : Area Kill List Read Send Verbose\n");
#endif
  
#ifdef GATECMDS
    fprintf(fp,"Gateway:");

#if defined AX25 || defined NETROM
    fprintf(fp," Connect");
#endif

    fprintf(fp," Escape");

#ifdef NETROM
    fprintf(fp," Nodes NRroute");
#endif

#ifdef AX25
    fprintf(fp," Ports");
#endif

    fprintf(fp," PIng Telnet\n");
  
#endif /* GATECMDS */
  
#ifdef FILECMDS
    fprintf(fp,"File   : Download Upload What Zap\n");
#endif
  
    fprintf(fp,"General: ?-Help Alias Bye");

#ifdef CONVERS
    fprintf(fp," CONVers");
#endif

#ifdef FOQ_CMDS
    fprintf(fp," Finger");
#endif

    fprintf(fp," Help Info IHeard\n");
    fprintf(fp,"         IProute");

#ifdef AX25
    fprintf(fp," Jheard");
#endif

    fprintf(fp," Mbox");

#if defined FOQ_CMDS && defined TTYLINKSERVER
    fprintf(fp," Operator");
#endif

#if defined FOQ_CMDS && defined CALLCLI
    fprintf(fp," Query");
#endif

    fprintf(fp," Xpert\n\n");

    fclose(fp);
    }
	
    return;
}

