#ifndef _PC_H
#define _PC_H
#define _HARDWARE_H
  
#ifndef _GLOBAL_H
#include "global.h"
#endif
  
#ifndef _CONFIG_H
#include "config.h"
#endif
  
#ifndef _SESSION_H
#include "session.h"
#endif
  
#define NSW 10  /* Number of stopwatch "memories" */
  
struct stopwatch {
    long calls;
    int16 maxval;
    int16 minval;
};
  
struct screen {
#define UNKNOWN_SWAP 0  /* Default */
#define EMS_SWAP 1
#define XMS_SWAP 2  /* not yet working */
#define MEM_SWAP 4
#define FILE_SWAP 8
  
    int stype;       /* Where is the screen saved ? */
    union {
        char *save;     /* Conventional memory screen save buffer */
#ifdef EMS
        struct {
            unsigned int token;
            char *save;
        } ems;
#endif
#ifdef XMS
        int handle;     /* XMS handle */
#endif
        FILE *fp;       /* File pointer to disk image */
    } sv;
    int row;        /* Saved cursor location */
    int col;
};
#define NULLSCREEN  (struct screen *)0
  
extern char *Screen;    /* Pointer to video memory */
extern int Numrows,Numcols;
extern int ScreenSize;
extern int SwapMode;
#ifdef XMS
extern unsigned int ScreenSizeK;   /* Screen size in Kbytes */
#endif
extern struct stopwatch Sw[];
extern int16 Intstk[];  /* Interrupt stack defined in pcgen.asm */
extern void (*Shutdown[])();    /* List of functions to call at shutdown */
extern int Mtasker; /* Type of multitasker, if any */
  
/* In 8250.c: */
void asytimer __ARGS((void));
  
/* In scc.c: */
void scctimer __ARGS((void));
void sccstop __ARGS((void));
  
/* In pc.c: */
void clrbit __ARGS((unsigned port,char bits));
void ctick __ARGS((void));
INTERRUPT  (*getirq __ARGS((unsigned int)) ) __ARGS((void));
void freescreen __ARGS((struct session *sp));
int getmask __ARGS((unsigned irq));
void ioinit __ARGS((void));
void iostop __ARGS((void));
void kbint __ARGS((void));
int kbread __ARGS((void));
int maskoff __ARGS((unsigned irq));
int maskon __ARGS((unsigned irq));
void newscreen __ARGS((struct session *sp));
void pctick __ARGS((void));
void setbit __ARGS((unsigned port,char bits));
int setirq __ARGS((unsigned irq,INTERRUPT (*handler) __ARGS((void))));
void sysreset __ARGS((void));
void systick __ARGS((void));
void writebit __ARGS((unsigned port,char mask,int val));
long bioscnt __ARGS((void));
void UpdateStatus __ARGS((void));
  
/* In pcgen.asm: */
INTERRUPT btick __ARGS((void));
void chktasker __ARGS((void));
void chtimer __ARGS((INTERRUPT (*)()));
unsigned long divrem __ARGS((int32 dividend,int16 divisor));
int16 getss __ARGS((void));
void giveup __ARGS((void));
int kbraw __ARGS((void));
int16 longdiv __ARGS((int16 divisor,int n,int16 *dividend));
int16 longmul __ARGS((int16 multiplier,int n,int16 *multiplicand));
INTERRUPT nullvec __ARGS((void));
void uchtimer __ARGS((void));
int16 clockbits __ARGS((void));
  
/* In stopwatch.asm: */
void swstart __ARGS((void));
int16 stopval __ARGS((void));
  
/* In sw.c: */
void swstop __ARGS((int n));
  
/* In command.asm: */
int start_back __ARGS((void));
int stop_back __ARGS((void));
  
/* in bpq.c */
void bpqtimer __ARGS((void));
  
#endif  /* _PC_H */
