/* Mods by PA0GRI */
#ifndef _SOCKET_H
#define _SOCKET_H
  
#ifndef _GLOBAL_H
#include "global.h"
#endif
  
#ifdef  ANSIPROTO
#include <stdarg.h>
#endif
  
#ifndef _MBUF_H
#include "mbuf.h"
#endif
  
#ifndef _PROC_H
#include "proc.h"
#endif
  
#ifndef _SOCKADDR_H
#include "sockaddr.h"
#endif
  
/* Local IP wildcard address */
#define INADDR_ANY  0x0L
  
/* IP protocol numbers */
/* now in internet.h */
  
/* TCP port numbers */
#define IPPORT_ECHO 7   /* Echo data port */
#define IPPORT_DISCARD  9   /* Discard data port */
#define IPPORT_FTPD 20  /* FTP Data port */
#define IPPORT_FTP  21  /* FTP Control port */
#define IPPORT_TELNET   23  /* Telnet port */
#define IPPORT_SMTP 25  /* Mail port */
#define IPPORT_TIME 37  /* Time port */
#define IPPORT_MTP  57  /* Secondary telnet protocol */
#define IPPORT_FINGER   79  /* Finger port */
#define IPPORT_TTYLINK  87  /* Chat port */
#define IPPORT_POP  109 /* Pop port */
#define IPPORT_POP2 109 /* Pop port */
#define IPPORT_POP3 110 /* Pop port */
#define IPPORT_NNTP 119 /* Netnews port */
#define IPPORT_RLOGIN 513       /* Remote login */
#define IPPORT_CONVERS 3600     /* Converse */
#define IPPORT_XCONVERS 3601    /* LZW Convers */
#define IPPORT_CALLDB 1235      /* Pulled out of the air GRACILIS */
#define IPPORT_TERM 5000        /* Serial interface server port */
  
/* UDP port numbers */
#define IPPORT_DOMAIN   53
#define IPPORT_BOOTPS   67  /* bootp server */
#define IPPORT_BOOTPC   68  /* bootp client */
#define IPPORT_RWHO 513
#define IPPORT_RIP  520
#define IPPORT_TIMED    525 /* Time daemon */
#define IPPORT_REMOTE   1234    /* Pulled out of the air */
#define IPPORT_BSR  5000    /* BSR X10 interface server port (UDP) */
  
#define AF_INET     0
#define AF_AX25     1
#define AF_NETROM   2
#define AF_LOCAL    3
  
#define SOCK_STREAM 0
#define SOCK_DGRAM  1
#define SOCK_RAW    2
#define SOCK_SEQPACKET  3
  
/* Socket flag values - controls newline mapping */
#define SOCK_BINARY 0   /* socket in raw (binary) mode */
#define SOCK_ASCII  1   /* socket in cooked (newline mapping) mode */
#define SOCK_QUERY  2   /* Return setting without change */
  
/* Socket noblock values, set with sockblock() */
#define SOCK_BLOCK      0
#define SOCK_NOTXBLOCK  1
#define SOCK_NORXBLOCK  2   /* currently not implemented - WG7J */
  
#ifdef LINUX
  
/*
 * Avoid collisions with the C library's socket interface.  We may want to use
 * that in the future, anyway.  (Something like WAMPES tcpgate, but with some
 * protections.)
 */
  
#define accept j_accept
#define bind j_bind
#define connect j_connect
#define getpeername j_getpeername
#define getsockname j_getsockname
#define listen j_listen
#define setflush j_setflush
#define shutdown j_shutdown
#define socket j_socket
#define socketpair j_socketpair
#define recv j_recv
#define recvfrom j_recvfrom
#define send j_send
#define sendto j_sendto
  
#define EABORT ECONNRESET
#define EALARM ETIME
  
#else /* LINUX */
  
#define EMFILE  1
#define EBADF   2
#define EINVAL  3
#define ESOCKTNOSUPPORT 4
#define EAFNOSUPPORT    5
#define EOPNOTSUPP  6
#define EFAULT      7
#define ENOTCONN    8
#define ECONNREFUSED    9
#define EAFNOSUPP   10
#define EISCONN     11
#define EWOULDBLOCK 12
#define EINTR       13
#define EADDRINUSE  14
#define ENOMEM      15
#define EMSGSIZE    16
#define EALARM      17
#define EABORT      18
#define ECONNNOROUTE 19
  
#endif /* LINUX */
  
/* In socket.c: */
extern int Axi_sock;    /* Socket listening to AX25 (there can be only one) */
  
int accept __ARGS((int s,char *peername,int *peernamelen));
int bind __ARGS((int s,char *name,int namelen));
int close_s __ARGS((int s));
int connect __ARGS((int s,char *peername,int peernamelen));
void freesock __ARGS((struct proc *pp));
int getpeername __ARGS((int s,char *peername,int *peernamelen));
int getsockname __ARGS((int s,char *name,int *namelen));
int listen __ARGS((int s,int backlog));
int recv_mbuf __ARGS((int s,struct mbuf **bpp,int flags,char *from,int *fromlen));
int send_mbuf __ARGS((int s,struct mbuf *bp,int flags,char *to,int tolen));
int setflush __ARGS((int s,int c));
int shutdown __ARGS((int s,int how));
int socket __ARGS((int af,int type,int protocol));
int sockkick __ARGS((int s));
int socklen __ARGS((int s,int rtx));
struct proc *sockowner __ARGS((int s,struct proc *newowner));
int usesock __ARGS((int s));
int socketpair __ARGS((int af,int type,int protocol,int sv[]));
int getnextsocket __ARGS((int s));
  
/* In sockuser.c: */
void flushsocks __ARGS((void));
int keywait __ARGS((char *prompt,int flush));
int recv __ARGS((int s,char *buf,int len,int flags));
int recvchar __ARGS((int s));
int recvfrom __ARGS((int s,char *buf,int len,int flags,char *from,int *fromlen));
int recvline __ARGS((int s,char *buf,unsigned len));
int rrecvchar __ARGS((int s));
int send __ARGS((int s,char *buf,int len,int flags));
int sendto __ARGS((int s,char *buf,int len,int flags,char *to,int tolen));
int seteol __ARGS((int s,char *seq));
int sockmode __ARGS((int s,int mode));
int sockblock __ARGS((int s,int value));
void tflush __ARGS((void));
int tprintf __ARGS((char *fmt,...));
int tputc __ARGS((char c));
#ifdef LINUX
#define tputs j_tputs
#endif
int tputs __ARGS((char *s));
#ifdef LINUX
int tcmdprintf __ARGS((FILE *fp, char *fmt, ...));
int tfprintf __ARGS((FILE *fp, char *fmt, ...));
#endif
int usflush __ARGS((int s));
int usprintf __ARGS((int s,char *fmt,...));
int usputc __ARGS((int s,char c));
int usputs __ARGS((int s,char *x));
int usvprintf __ARGS((int s,char *fmt, va_list args));
  
/* In file sockutil.c: */
char *psocket __ARGS((void *p));
char *sockerr __ARGS((int s));
char *sockstate __ARGS((int s));
  
/* In tcpuser.c */
int start_tcp __ARGS((int16 port,char *name,void (*task)(),int stack));
int stop_tcp __ARGS((int16 port));
  
/* In mailbox.c: */
extern char Nosock[];
  
#endif  /* _SOCKET_H */
