#ifndef _CONFIG_H
#define _CONFIG_H
/* This is the configuration for a ip switch */
  
/* Software options */
#undef MAILBOX     1   /* Include SM0RGV mailbox server */
#define CONVERS     1   /* Conference bridge (babble-box :-) */
/* Use only ONE of the 2 news options below !!! */
#undef NNTP        1   /* Netnews client */
#undef NNTPS       1   /* Netnews client and server */
#define SERVERS    1   /* Include TCP servers */
#define DSERVER    1   /* Include Domain Name Server */
#define STKTRACE   1   /* Include stack tracing code */
#define TRACE       1   /* Include packet tracing code */
#undef RIP         1   /* Include RIP routing */
#undef HOPCHECK    1   /* IP path tracing command */
#undef DIALER      1   /* SLIP redial code */
#undef NRS         1   /* NET/ROM async interface */
#define NETROM      1   /* NET/ROM network support */
#undef LZW         1   /* LZW-compressed sockets */
#undef RLOGINCLI   1   /* Rlogin client code */
#define SLIP        1   /* Serial line IP on built-in ports */
#undef PPP         1   /* Point-to-Point Protocol code */
#undef VJCOMPRESS  1   /* Van Jacobson TCP compression for SLIP */
#undef POP         1   /* Include POP2 Post Office Protocol */
#undef POP2CLIENT  1   /* POP2 client -- IAB not recommended */
#undef POP2SERVER  1   /* POP2 server -- IAB not recommended */
#define POP3CLIENT  1   /* POP3 client -- IAB draft standard */
#define POP3SERVER  1   /* POP3 server -- IAB draft standard */
#undef ESCAPE      1   /* Allow Unix style escape on PC */
#undef RDATE       1   /* Include the Time Protocol */
#undef RSPF        1   /* Include Radio Shortest Path First Protocol */
#define AXIP        1   /* digipeater via ip port 93 interface */
#undef RARP        1   /* Include Reverse Address Resolution Protocol */
#define CALLBOOK    1   /* Simple callbook server over Internet */
#undef CALLSERVER   1   /* Include BuckMaster CDROM server support */
#undef CALLCLI      1   /* Include BuckMaster CDROM client code only  */
#define ATCMD       1   /* Include timed 'at' execution */
#define EXPIRY      1   /* Include message and bid expiry */
#define MBXTDISC    1   /* Include mailbox timeout-disconnect */
#define NR4TDISC    1   /* Include Netrom L4 timeout-disconnect */
#define FTPTDISC    1   /* Include ftp-server timeout disconnect */
#undef TIPMAIL     1   /* Include TIP mailbox server */
#define IPACCESS    1   /* Include IP access control code */
#define TCPACCESS   1   /* Include TCP access control code */
#define ENCAP       1   /* Include IP encapsulation code */
#undef AUTOROUTE   1   /* Include AX.25 IP auto-route code(causes problems when VC mode is used for ip) */
#define LOCK        1   /* Include keyboard locking */
#define MAILFOR     1   /* Include Mailbox 'Mail for' beacon */
#define RLINE       1   /* Include BBS R:-line interpretation code */
#define MBFWD       1   /* Include Mailbox AX.25 forwarding */
#define USERLOG     1   /* Include last-message-read tracking for users */
#define MULTITASK   1   /* Include Dos shell multi-tasker */
#define SHELL       1   /* Include shell command */
#define XSPAWN      1   /* Include swapping to ems or disk on spawning shell */
#define ALLSESSIONS 1   /* Include all session types */
/*if undefined, deletes outgoing telnet,ftp,ax25,netrom sessions */
#define ALLCMD     1    /* if undefined, exclude a bunch of commands */
/*excluded are:
 *   delete,rename,more,tail,dump,status,motd,cd,dir,finger,fkey,info,mail,mkdir
 *   pwd,record,rmdir,watch,test,upload
 */
#define ALLSERV      1   /* if undefined, exclude a bunch of servers */
/*excluded are:
 *echo,discard,tip and ttylink servers
 *and the ttylink command (with no split screen code anymore)
 */
  
/* Software tuning parameters */
#define MTHRESH     16384    /* Default memory threshold */
#define NROWS       25      /* Number of rows on screen */
#define NIBUFS      5       /* Number of interrupt buffers */
#define IBUFSIZE    2048    /* Size of interrupt buffers */
#define NSESSIONS   10      /* Number of interactive clients */
#define DEFNSOCK    40      /* Default number of sockets */
  
/* Hardware driver options */
#undef ARCNET      1   /* ARCnet via PACKET driver */
#undef PC_EC       1   /* 3-Com 3C501 Ethernet controller */
#define KISS        1   /* KISS TNC code */
#undef HS          1   /* High speed (56kbps) modem driver */
#undef HAPN        1   /* Hamilton Area Packet Network driver code */
#undef EAGLE       1   /* Eagle card driver */
#define PACKET      1   /* FTP Software's Packet Driver interface */
#undef PACKETWIN   1   /* Gracilis PackeTwin driver */
#undef PC100       1   /* PAC-COM PC-100 driver code */
#undef APPLETALK   1   /* Appletalk interface (Macintosh) */
#undef DRSI        1   /* DRSI PCPA slow-speed driver */
#define SCC         1   /* PE1CHL generic scc driver */
#undef PI          1   /* VE3IFB pi dma card scc driver */
#define ASY         1   /* Asynch driver code */
#undef SLFP         1   /* SLFP packet driver class supported */
  
#if defined(NRS)
#undef  NETROM
#define NETROM      1   /* NRS implies NETROM */
#endif
  
#if (defined(AXIP)||defined(HS)||defined(NETROM)||defined(KISS)||defined(HAPN)||defined(EAGLE)||defined(PC100)||defined(PI))
#define AX25        1   /* AX.25 subnet code */
#endif
  
#if (defined(ARCNET) || defined(SLFP))
#undef  PACKET
#define PACKET      1   /* FTP Software's Packet Driver interface */
#endif
  
#if (defined(PC_EC) || defined(PACKET))
#define ETHER   1       /* Generic Ethernet code */
#endif
  
#if defined(CALLSERVER)
#define CALLCLI     1
#endif
  
#if (defined(POP2CLIENT) || defined(POP2SERVER))
#undef POP 1
#endif
  
#if (defined(POP2CLIENT) || defined(POP3CLIENT))
#define MAILCLIENT  1
#undef POP 1
#endif
  
#ifdef XSPAWN
#define SHELL 1
#undef MULTITASK 1
#endif
  
#ifndef MAILBOX
#undef CALLBOOK 1
#undef CALLCLI 1
#undef EXPIRY 1
#undef MBXTDISC 1
#undef TIPMAIL 1
#undef MAILFOR 1
#undef RLINE 1
#undef MBFWD 1
#undef USERLOG 1
#endif
  
#endif  /* _CONFIG_H */
