VERSION 2.00
Begin Form frmPreView 
   AutoRedraw      =   -1  'True
   BorderStyle     =   0  'None
   ClientHeight    =   2895
   ClientLeft      =   1095
   ClientTop       =   2610
   ClientWidth     =   5850
   ClipControls    =   0   'False
   ControlBox      =   0   'False
   FontBold        =   -1  'True
   FontItalic      =   0   'False
   FontName        =   "MS Sans Serif"
   FontSize        =   9.75
   FontStrikethru  =   0   'False
   FontUnderline   =   0   'False
   Height          =   3300
   HelpContextID   =   5
   Left            =   1035
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   2895
   ScaleWidth      =   5850
   Top             =   2265
   Width           =   5970
   WindowState     =   2  'Maximized
End
Option Explicit
DefInt A-Z

' Used to rescale the font sizes.
Dim mfSizeHeading0 As Single
Dim mfSizeHeading1 As Single
Dim mfSizeHeading2 As Single
Dim mfSizeNumber As Single
Dim mfSizeSymbol As Single
Dim mfSizeName As Single
Dim mfSizeMass As Single

Dim mnColumnWidth(0 To 18)

' Draws one of the elements on the preview form.
' Input: giElementToShow
'        nBoxWidthCC       The "CC" is for center-to-center
'        lBoxHeight
'
'  Note:  Set fontsize=10, fontname, then fontsize desired.
'         This is needed when working with small fonts.
'
Sub Draw_All (ByVal nBoxWidthCC, ByVal lBoxHeight As Long, ByVal nLineWidthPixels, ByVal nDiagonalWidthPixels, ByVal nExtraSpacePixels As Single, ByVal fScaleFactor As Single)
Dim msg As String
Dim msgWidth
Dim N
Dim Position As Single
Dim nLinePoint1, nLinePoint2
Dim nLineWidthHeadingX, nLineWidthHeadingY
Dim nLineTop, nLineBottom
Dim nDiagTop, nDiagBottom
Dim fTemp As Single

nLineTop = nLineWidthPixels * Screen.TwipsPerPixelY \ 2
nLineBottom = nLineWidthPixels * Screen.TwipsPerPixelY - nLineTop

' If element has a heading, draw it.
If Element(giElementToShow).iHeading <> 0 Then
   
   ' Group Number, IUPAC style.
   If gbColumnHeading(0) Then
      FontSize = 10
      FontName = HeadingProperties(0).sName
      FontSize = mfSizeHeading0
      FontBold = HeadingProperties(0).bBold
      FontItalic = HeadingProperties(0).bItalic
      ForeColor = HeadingProperties(0).lColor
      msg = LTrim$(Str$(Element(giElementToShow).iHeading))
      msgWidth = TextWidth(msg)
      CurrentX = (nBoxWidthCC - msgWidth) / 2
      Print msg
   End If
   
   'Group Number, old style (e.g., 1A - 8B).
   If gbColumnHeading(1) Then
      FontSize = 10
      FontName = HeadingProperties(1).sName
      FontSize = mfSizeHeading1
      FontBold = HeadingProperties(1).bBold
      FontItalic = HeadingProperties(1).bItalic
      ForeColor = HeadingProperties(1).lColor   ' Lines will be the same color as the text.
        
      ' A point is about 1/72 of an inch; a twip is 1/20 of a point.
      ' A fontsize of 10 would have about 7 characters/inch.
      ' The width of lines would be about 1/8 of that, or 1/56 of an inch.
      'DrawWidth = TheGroup(0).TheField(1).nSize / 72 / 8 * 1440 / Screen.TwipsPerPixelY
      ' 1440/72/8 = 2.5
      fTemp = mfSizeHeading1 * 2.5 / Screen.TwipsPerPixelY
      ' Make the line 2/3 as thick if a bold font isn't used.
      If Not HeadingProperties(1).bBold Then fTemp = fTemp * 2 / 3
      If fTemp < 1 Then
         DrawWidth = 1
      Else
         DrawWidth = fTemp
      End If
      nLineWidthHeadingX = DrawWidth * Screen.TwipsPerPixelX
      nLineWidthHeadingY = DrawWidth * Screen.TwipsPerPixelY

'********************* Logic of Line Drawings ******************************
'                                          ___
'                ___    letter "A"          |
'               |   |                       |
'   z2_____z3__ |___|                       |
'   /           |   |                       |
'  /            |   |       ___             | text height
' z1                         |   descent    |
'                           _|_            _|_
' line 1 = z1 - z2      line 2 = z2' - z3
' z1 = linewidth/2, currentY + textheight - descent
' z2 = (nBoxWidthCC-linewidth)/4-Hlinewidth/2, position + (text height-descent)/2
'           (nBoxWidthCC-linewidth) is linecenter-to-linecenter width of box.
'           z2 starts Hlinewidth/2 early; z2' adds Hlinewidth/2
' z2'= (nBoxWidthCC-linewidth)/4+linewidth/2, position + (text height-descent)/2
' z3 = nBoxWidthCC - linewidth/2,                   "  +        "
' Visual Basic adds a half linewidth to each end of a line it draws.
'***************************************************************************
      If Element(giElementToShow).iHeading = 8 Then
         ' Draw "/-----"
         Position = CurrentY
         nLinePoint1 = nBoxWidthCC \ 4 + nLineWidthHeadingX \ 2
         nLinePoint2 = HeadingProperties(1).nHeight * fScaleFactor
         ' straight line 2         z2'                              z3
         Line (nLinePoint1, Position + nLinePoint2 \ 2)-(nBoxWidthCC, Position + nLinePoint2 / 2)
         ' slanted line, line 1    z2                            z1
         Line (nLinePoint1, Position + nLinePoint2 \ 2)-(0, Position + nLinePoint2 - gnDescentHeadingOld * fScaleFactor - nLineWidthHeadingY \ 2)

      ElseIf Element(giElementToShow).iHeading = 9 Then
      ' Draw --VIIIA--
         Position = CurrentY
         ' Print the heading text.
         msg = gsColumnHeadingStyle(giColumnHeadingStyleChoice, Element(giElementToShow).iHeading)
         msgWidth = TextWidth(msg)
         CurrentX = (nBoxWidthCC - msgWidth) \ 2
         Print msg
         ' Draw the lines on each side of text.
         nLinePoint1 = (nBoxWidthCC - msgWidth) \ 2 - nLineWidthHeadingX
         nLinePoint2 = Position + (HeadingProperties(1).nHeight * fScaleFactor) \ 2
         Line (0, nLinePoint2)-(nLinePoint1, nLinePoint2)
         Line (nBoxWidthCC - nLinePoint1, nLinePoint2)-(nBoxWidthCC, nLinePoint2)
      ElseIf Element(giElementToShow).iHeading = 10 Then
      ' Draw "-----\"
         Position = CurrentY
         nLinePoint1 = nLineWidthHeadingX \ 2 + 3 * (nBoxWidthCC - nLineWidthHeadingX) \ 4
         nLinePoint2 = HeadingProperties(1).nHeight * fScaleFactor
         ' straight line 2         z2'                  z3
         Line (0, Position + nLinePoint2 \ 2)-(nLinePoint1, Position + nLinePoint2 \ 2)
         ' slanted line, line 1    z2                              z1
         Line (nLinePoint1, Position + nLinePoint2 \ 2)-(nBoxWidthCC, Position + nLinePoint2 - gnDescentHeadingOld * fScaleFactor - nLineWidthHeadingY \ 2)
      Else
         'A normal heading without lines.
         msg = gsColumnHeadingStyle(giColumnHeadingStyleChoice, Element(giElementToShow).iHeading)
         msgWidth = TextWidth(msg)
         CurrentX = (nBoxWidthCC - msgWidth) \ 2
         Print msg
      End If
   End If
End If

' Add the background color to the box.
DrawWidth = nLineWidthPixels
Line (0, 0)-(nBoxWidthCC, lBoxHeight), lGet_Color_Box_Fill(), BF

' Draw the box.
Line (0, 0)-(nBoxWidthCC, lBoxHeight), glLineColor, B

' Draw the heavy diagonal line that separates metals from nonmetals.
'        The vertical line on boron sticks up too far if thick, so
'        a correction is added.
If frmPeriodic.mnuOptionsDiagonal.Checked Then
   nDiagTop = nDiagonalWidthPixels * Screen.TwipsPerPixelY \ 2
   nDiagBottom = nDiagonalWidthPixels * Screen.TwipsPerPixelY - nDiagTop
   DrawWidth = nDiagonalWidthPixels
   Select Case giElementToShow
      Case 5
         ' Draw a vertical line on left.
         Line (0, nDiagTop - nLineBottom)-(0, lBoxHeight), glDiagonalColor
      Case 13, 32, 51
         ' Draw a line on right.            and top
         Line (0, 0)-(nBoxWidthCC, 0), glDiagonalColor
         'Line (nBoxWidthCC, 0)-(nBoxWidthCC, lBoxHeight), glDiagonalColor
      Case 14, 33, 52
         ' Draw a line on left.        and bottom.
         Line (0, 0)-(0, lBoxHeight), glDiagonalColor
        ' Line (0, lBoxHeight)-(nBoxWidthCC, lBoxHeight), glDiagonalColor
      Case 84
         ' Draw a line on top'       and right.
         Line (0, 0)-(nBoxWidthCC, 0), glDiagonalColor 'Top
         'Line (nBoxWidthCC, 0)-(nBoxWidthCC, lBoxHeight - nDiagBottom + nLineBottom), glDiagonalColor
      Case 85
         ' Draw a line on left.
         Line (0, 0)-(0, lBoxHeight - nDiagBottom + nLineBottom), glDiagonalColor
   End Select
End If
'           Regular line width   +     Extra space
CurrentY = nLineTop + nExtraSpacePixels * Screen.TwipsPerPixelY

' Atomic Number.
Draw_All_Fields (0), (Element(giElementToShow).sNumber), (nBoxWidthCC), (mfSizeNumber), (fScaleFactor)
CurrentY = CurrentY - basic(0).nDescent * (mfSizeNumber / basic(0).fSize)  'A little more accurate than multiplying by fScaleFactor.
    ' Reduce blank space before next field.
    ' Space is present because no tail to numbers.

' Atomic Symbol.
Draw_All_Fields (1), (Element(giElementToShow).sSymbol), (nBoxWidthCC), (mfSizeSymbol), (fScaleFactor)

' Name of Element.
If Not gbOmitName Then
   Draw_All_Fields (2), (Element(giElementToShow).sName), (nBoxWidthCC), (mfSizeName), (fScaleFactor)
End If

' Mass of Element.
Draw_All_Fields (3), (Element(giElementToShow).sMass), (nBoxWidthCC), (mfSizeMass), (fScaleFactor)

End Sub

' Print each field in the box drawn by Draw_All.  Called by Draw_All.
' Correctly centers italic text.
' Input: iField         Which field to print.
'        msg            String to print
'        nBoxWidth      Width of box to center string in
Sub Draw_All_Fields (ByVal iField, ByVal msg As String, ByVal nBoxWidth, ByVal fFontSize As Single, ByVal fScaleFactor As Single)

Dim sWorkName As String, bWorkBold, bWorkItalic, lWorkColor As Long
Dim N, M, msgWidth
Dim nLetterNumber

Get_Property_Work (iField), sWorkName, bWorkBold, bWorkItalic, lWorkColor
FontSize = 10
FontName = sWorkName
FontSize = fFontSize
FontItalic = bWorkItalic
' Bug:  With bold italic Small Fonts, if you change fontitalic
' to false, that also removes the bold property.  (Removing
' bold from a bold italic Small Fonts does not remove italics,
' though.)
FontBold = bWorkBold
ForeColor = lWorkColor

msgWidth = TextWidth(msg)
If bWorkItalic Then
   nLetterNumber = Asc(Left$(msg, 1))
   N = GetCharABCWidths(hDC, nLetterNumber, nLetterNumber, ABCsize)
   If N <> 0 Then
      ' Function was successful (non-TrueType fonts are allowed, which would return 0).
      If ABCsize.abcA < 0 Then
         ' First character in string has an underhang.  Add to string length.
         msgWidth = msgWidth - 2 * ABCsize.abcA * Screen.TwipsPerPixelX
         ' Why multiply by 2:  TextWidth of a character is abcA + abcB + abcC.
         ' If abcA, say, is negative, TextWidth does worse than not count
         ' it: it subtracts it.
      End If
      nLetterNumber = Asc(Right$(msg, 1))
      N = GetCharABCWidths(hDC, nLetterNumber, nLetterNumber, ABCsize)
      If ABCsize.abcC < 0 Then
         ' Last character in string has an overhang.  Add to string length.
         msgWidth = msgWidth - 2 * ABCsize.abcC * Screen.TwipsPerPixelX
      End If
   End If
End If
CurrentX = (nBoxWidth - msgWidth) \ 2
N = CurrentY
M = GetTextMetrics(frmPreview.hDC, FontInfo)
CurrentY = CurrentY + (basic(iField).nHeight - basic(iField).nDescent) * fScaleFactor - FontInfo.tmAscent * Screen.TwipsPerPixelY
Print msg
CurrentY = N + basic(iField).nHeight * fScaleFactor
                                                ' Distance to baseline, desired               Distance to baseline, presently
End Sub

' Controls the drawing of the entire periodic chart on a form.
Sub Draw_Control ()

Dim lWidest As Long
Dim N
Dim Row, Col
Dim saveElement As Integer
Dim nLineWidthPixels, nLineWidthTwipsY, nLineWidthTwipsX
Dim nDiagonalWidthPixels
Dim nExtraSpacePixels
Dim msg As String
Dim lTableWidthTwips As Long, lTableHeightTwips As Long
Dim fScaleFactor As Single
Dim fScaleWide As Single, fScaleHigh As Single
Dim iFirstColumn
Dim iLeftMargin, iTopMargin
Dim lRowHeight As Long
Dim nHeadingRowHeight As Integer
Dim fMinPointSize As Single
Dim nLineTop, nLineLeft, nLineBottom
Dim nPageHeight, nPageWidth
Dim lTableHeight As Long, lTableWidth As Long
Dim lTableSizeHeight As Long, lTableSizeWidth As Long
Dim nPagesHigh, nPagesWide
Dim nScaledWidth, fFontSizeIncrement As Single
Dim fTemp As Single

saveElement = giElementToShow
Print " Working"
Print
Print
Print
Print Tab(8); "Tip for laser printer users:  Printing with this program requires that"
Print Tab(8); "the " & Chr$(34) & "Print Truetype as Graphics" & Chr$(34) & " option in Printer Setup be activated."
frmPreview.MousePointer = 11 ' Busy.
Refresh
nLineTop = gnLineWidthTwipsY \ 2
nLineBottom = gnLineWidthTwipsY - nLineTop
nLineLeft = gnLineWidthTwipsX \ 2

'********************** Get column widths **********************************
' The period number width.
If frmPeriodic.mnuOptionsPeriod.Checked Then
   iFirstColumn = 0
   FontSize = 10
   FontName = HeadingProperties(0).sName
   FontSize = HeadingProperties(0).nSize
   FontBold = HeadingProperties(0).bBold
   FontItalic = HeadingProperties(0).bItalic
   ' Column width is one character + one character blank.
   mnColumnWidth(0) = TextWidth("7 ")   ' At this point, have ignored a half line width.
   lTableWidthTwips = mnColumnWidth(0)
Else
   iFirstColumn = 1
End If

' Column widths.
Printer.ScaleMode = 3
GetmBasicPrint
For Col = 1 To 18
   lWidest = lWidest_Box_Printer(Col) * Printer.TwipsPerPixelX'lWidest string in column (or table).
   ' Width is lWidest string + box line width + 2 more line widths for inside margins.
   lWidest = lWidest + 3 * gnLineWidthTwipsX  ' Line-center to line-center width of box.
   ' Add more extra space that may have been requested.
   lWidest = lWidest + 2 * frmPeriodic.hsbExtraSpace * Screen.TwipsPerPixelX
   If lWidest > 32767 Then
      frmPreview.MousePointer = 0  ' Default
      msg = "Column " & Col & " is TOO WIDE to be printed.  Reduce the WIDTH and try again.  "
      msg = msg & "(Evidently that column is wider than the column containing the last displayed element."
      MsgBox msg, MB_ICONEXCLAMATION Or MB_OK, "Table Preview"
      Cls
      FontSize = 10
      FontName = "MS Sans Serif"
      FontSize = 10
      FontBold = True
      FontItalic = False
      ForeColor = 0
      Print " Press any key to continue."
      Exit Sub
   End If
   
   mnColumnWidth(Col) = lWidest
   lTableWidthTwips = lTableWidthTwips + lWidest
   If Not frmPeriodic.mnuOptionsWidthMethod(0).Checked Then
      'Using the longest string in table, so set all
      'column widths the same and exit the for/next loop.
      For N = 2 To 18
         mnColumnWidth(N) = lWidest
      Next N
      lTableWidthTwips = lTableWidthTwips + 17 * lWidest
      Exit For
   End If
Next Col
lTableWidthTwips = lTableWidthTwips + gnLineWidthTwipsX
lTableSizeWidth = lTableWidthTwips  ' Used at end for table size.

'******************** Get row and heading height **************************
' Determine height of heading row.
If gbColumnHeading(0) Then
   ' Group Number, IUPAC style.
   nHeadingRowHeight = HeadingProperties(0).nHeight
End If
If gbColumnHeading(1) Then
   'Group Number, old style (e.g., 1A - 8B).
   nHeadingRowHeight = nHeadingRowHeight + HeadingProperties(1).nHeight
End If
nHeadingRowHeight = nHeadingRowHeight + nLineTop

' Determine height of a row.
lRowHeight = gnLineWidthTwipsY ' 1 line width
lRowHeight = lRowHeight + basic(0).nHeight + basic(1).nHeight + basic(3).nHeight
lRowHeight = lRowHeight - basic(0).nDescent
If Not gbOmitName Then lRowHeight = lRowHeight + basic(2).nHeight
lRowHeight = lRowHeight + 2 * frmPeriodic.hsbExtraSpace * Screen.TwipsPerPixelY
                                                       ' Lan/Actinide space.
lTableHeightTwips = nHeadingRowHeight + 9 * lRowHeight + lRowHeight \ 3
                                       ' For Lan/Act elements.
lTableHeightTwips = lTableHeightTwips + gnLineWidthTwipsY + nLineBottom
lTableSizeHeight = lTableHeightTwips   ' Used for table size at end.

'************************ Find and apply scale factor **********************
' A 5 pixel wide border is assumed on each side of the table.
fScaleWide = (Width - 10 * Screen.TwipsPerPixelX) / lTableWidthTwips
fScaleHigh = (Height - 10 * Screen.TwipsPerPixelY) / lTableHeightTwips
If fScaleWide < fScaleHigh Then
   fScaleFactor = fScaleWide
Else
   fScaleFactor = fScaleHigh
End If
If fScaleFactor > 1 Then
   ' Don't expand a small table; only scale down a large one.
   fScaleFactor = 1
End If
   
' Scale line widths.
nLineWidthPixels = frmPeriodic.hsbLineWidth(0) * fScaleFactor
If nLineWidthPixels < 1 Then nLineWidthPixels = 1
nLineWidthTwipsY = nLineWidthPixels * Screen.TwipsPerPixelY
nLineWidthTwipsX = nLineWidthPixels * Screen.TwipsPerPixelX
nDiagonalWidthPixels = frmPeriodic.hsbLineWidth(1) * fScaleFactor
If nDiagonalWidthPixels < 1 Then nDiagonalWidthPixels = 1
nExtraSpacePixels = frmPeriodic.hsbExtraSpace * fScaleFactor
' Allows requested Extra Space to be zero.
If nExtraSpacePixels < 1 And frmPeriodic.hsbExtraSpace > 0 Then nExtraSpacePixels = 1

nLineTop = nLineWidthTwipsY \ 2
nLineBottom = nLineWidthTwipsY - nLineTop
nLineLeft = nLineWidthTwipsX \ 2

' Scale font sizes.
FontSize = 10
FontName = "Arial" ' Doesn't matter which font is used, so long as its TrueType.
FontSize = HeadingProperties(0).nSize * fScaleFactor
mfSizeHeading0 = FontSize

FontSize = 10  ' Must be large enough to get out of "small fonts" or "MS Serif".
FontName = "Arial"   ' Must be reset in case switched to "small fonts" or "MS Serif".
FontSize = HeadingProperties(1).nSize * fScaleFactor
mfSizeHeading1 = FontSize

FontSize = 10
FontName = "Arial"
FontSize = basic(0).fSize * fScaleFactor
mfSizeNumber = FontSize

FontSize = 10
FontName = "Arial"
FontSize = basic(1).fSize * fScaleFactor
mfSizeSymbol = FontSize

' Get the increment between font sizes (.75 if possible fonts are 2.25,3.0,3.75,etc.)
fFontSizeIncrement = Screen.TwipsPerPixelY * .05   ' .05 = (72 pts per inch) / (1440 twips per inch)
If Not gbOmitName Then
   FontSize = 10
   FontName = "Arial"
   FontSize = basic(2).fSize * fScaleFactor
   mfSizeName = FontSize
   If TheGroup(0).TheField(2).nBold Then
      ' The width of text is longer than expected with bold "small fonts".
      FontSize = 10
      FontName = "Arial"
      FontSize = basic(2).fSize
      FontBold = True
      ' Get expected textwidth.
      nScaledWidth = TextWidth("unnilennium") * fScaleFactor
      FontSize = mfSizeName
      FontBold = True
      Do While TextWidth("unnilennium") > nScaledWidth And FontSize > 3 * fFontSizeIncrement
         ' 2.25 is as small a Small Font as my computer gets, which is 3 pixels high.
         fTemp = FontSize
         FontSize = FontSize - fFontSizeIncrement
         If FontSize = fTemp Then FontName = "Small Fonts"
      Loop
      mfSizeName = FontSize
   End If
End If

FontSize = 10
FontName = "Arial"
FontSize = basic(3).fSize * fScaleFactor
mfSizeMass = FontSize
If TheGroup(0).TheField(3).nBold Then
   ' The width of text is longer than expected with bold "small fonts".
   FontSize = 10
   FontName = "Arial"
   FontSize = basic(3).fSize
   FontBold = True
   ' Get expected textwidth.
   nScaledWidth = TextWidth("18.9984032") * fScaleFactor
   FontSize = mfSizeMass
   FontBold = True
   Do While TextWidth("18.9984032") > nScaledWidth And FontSize > 3 * fFontSizeIncrement
      fTemp = FontSize
      FontSize = FontSize - fFontSizeIncrement
      ' The original font name was Arial.  The scaled fontsize may cause the
      ' name to change to MS Serif with a font size of 6.  Bug:  If the font
      ' size is made smaller, say 5.25, the font name will not change to
      ' small fonts.  Instead, the font size changes back to 6.  The next
      ' line detects that behavior and changes the font name.
      If FontSize = fTemp Then FontName = "Small Fonts"
   Loop
   mfSizeMass = FontSize
End If

If frmPeriodic.chkTitleSameSize = 0 Then
   FontSize = 10
   FontName = "Arial"
   FontSize = HeadingProperties(2).nSize * fScaleFactor
   mfSizeHeading2 = FontSize
Else
   mfSizeHeading2 = mfSizeSymbol
End If

' Scale column widths & row heights.
lTableWidthTwips = nLineWidthTwipsX
For Col = iFirstColumn To 18
   mnColumnWidth(Col) = mnColumnWidth(Col) * fScaleFactor
   Debug.Print fScaleFactor
   lTableWidthTwips = lTableWidthTwips + mnColumnWidth(Col) 'Accurate width.
Next Col

' Use integer division to make row heights an integer number of pixels.
nHeadingRowHeight = ((nHeadingRowHeight * fScaleFactor) \ Screen.TwipsPerPixelY) * Screen.TwipsPerPixelY
lRowHeight = ((lRowHeight * fScaleFactor) \ Screen.TwipsPerPixelY) * Screen.TwipsPerPixelY
lTableHeightTwips = nHeadingRowHeight + 9 * lRowHeight + lRowHeight \ 3 + nLineWidthTwipsY + nLineBottom

'****************** Draw the elements in the table *************************
Cls   ' Gets rid of "Working", which is displayed on form.
' Center the table.  Move 2 pixels to left (seems to always be needed).
iLeftMargin = -(Width - lTableWidthTwips) \ 2
iTopMargin = -(Height - lTableHeightTwips) \ 2 - nHeadingRowHeight
For Row = 1 To 9
   ' Scale adjusted so that boxes are drawn with
   ' borders at (0,0) and (ColHeight,RowHeight)
   ' Leave room for line.
   ScaleLeft = iLeftMargin
      ' Setting scaleleft = 0 apparently changes the scalemode to pixels
      ' instead of twips.  Don't.
   If Row = 1 Then
      ScaleTop = iTopMargin
   ElseIf Row = 8 Then
      ' Move the f-block elements down 1/3 of a row, + 1 linewidth.
      ScaleTop = ScaleTop - lRowHeight - lRowHeight \ 3 - nLineWidthTwipsY
   Else
      ' Go to the bottom of the last row.
      ScaleTop = ScaleTop - lRowHeight
   End If
   For Col = iFirstColumn To 18  'iFirstColumn=0, if print period, or 1.
      If Col = 0 Then
         ' Print the period number.
         If Row < 8 Then
            FontSize = 10
            FontName = HeadingProperties(0).sName
            FontSize = mfSizeHeading0
            FontBold = HeadingProperties(0).bBold
            FontItalic = HeadingProperties(0).bItalic
            ForeColor = HeadingProperties(0).lColor
            CurrentX = -nLineLeft 'Leaves room for line width.
            CurrentY = (lRowHeight - TextHeight("1")) \ 2
            Print Format$(Row)
         End If
      Else
         ' Get the element to draw.
         giElementToShow = AtomicNumberAtThisSpot(Col, Row)
         If giElementToShow > 0 Then
            ' Outside width of box, used for centering text, is column width + line width.
            If Element(giElementToShow).iHeading <> 0 Then
               CurrentY = -nHeadingRowHeight
            Else
               CurrentY = 0
            End If
            Draw_All mnColumnWidth(Col), lRowHeight, nLineWidthPixels, nDiagonalWidthPixels, nExtraSpacePixels, fScaleFactor
         ElseIf giElementToShow = -1 Then
            ' Print Table caption.
            FontSize = 10
            FontName = HeadingProperties(2).sName
            FontSize = mfSizeHeading2
            FontBold = HeadingProperties(2).bBold
            FontItalic = HeadingProperties(2).bItalic
            ForeColor = HeadingProperties(2).lColor
            msg = frmPeriodic.txtTableTitle
            CurrentY = -nHeadingRowHeight
            CurrentX = ScaleLeft - iLeftMargin + (lTableWidthTwips - TextWidth(msg)) \ 2
            Print msg
         End If
      End If
      ScaleLeft = ScaleLeft - mnColumnWidth(Col)
   Next Col
Next Row
giElementToShow = saveElement 'Exit with element to show same as before drawing table.

'*************************** Page Lines ************************************
' Draw dashed lines representing printed page boundaries.
' Also, print the table size.

Printer.ScaleMode = 3
FontSize = 10
FontName = "MS Sans Serif"
FontSize = 10
FontBold = True
FontItalic = False
ForeColor = 0
ScaleLeft = iLeftMargin
ScaleTop = iTopMargin + nHeadingRowHeight

If frmPeriodic!mnuPreviewBoundaries.Checked = True Then
   Refresh
   DrawWidth = 1
   DrawStyle = 2 ' Dashed line
   DrawMode = 2 ' NotMergePen--So that a line appears on letters that are the same color as the pen.
   ' Get dimensions of paper in twips.
   nPageHeight = fScaleFactor * Printer.ScaleHeight * Printer.TwipsPerPixelY
   nPageWidth = fScaleFactor * Printer.ScaleWidth * Printer.TwipsPerPixelX ' Useable width of paper (Printer.Width gives actual width).
   
   nPagesHigh = lTableHeightTwips \ nPageHeight
   If lTableHeightTwips Mod nPageHeight > 0 Then
      ' Don't add extra page if picture is exactly same size as paper.  (Picky, picky, picky.)
      nPagesHigh = nPagesHigh + 1
   End If
   
   nPagesWide = lTableWidthTwips \ nPageWidth
   If lTableWidthTwips Mod nPageWidth > 0 Then nPagesWide = nPagesWide + 1
   
   For N = 0 To nPagesHigh ' Usually, the last line drawn will be off the screen, but not always.
      Line (0, N * nPageHeight)-Step(nPagesWide * nPageWidth, 0), QBColor(0)
   Next N
   
   For N = 0 To nPagesWide
      Line (N * nPageWidth, 0)-Step(0, nPagesHigh * nPageHeight), QBColor(0)
   Next N

   CurrentY = ScaleTop + ScaleHeight - 2.5 * TextHeight("W")
   CurrentX = 0
   Print Format$(nPagesHigh * Printer.ScaleHeight * Printer.TwipsPerPixelY * gfUnits, "####.00") & " X " & Format$(nPagesWide * Printer.ScaleWidth * Printer.TwipsPerPixelX * gfUnits, "####.00")
   Print " " & gsUnits
Else
   CurrentY = ScaleTop + ScaleHeight - 2.5 * TextHeight("W")
   CurrentX = 0
   Print Format$(lTableSizeHeight * gfUnits, "####.00") & " X " & Format$(lTableSizeWidth * gfUnits, "####.00")
   Print " " & gsUnits
End If
frmPreview.MousePointer = 0  ' Default

End Sub

Sub Form_KeyPress (KeyAscii As Integer)
Unload Me
End Sub

Sub Form_Load ()
Show
Draw_Control
End Sub

Sub Form_MouseDown (Button As Integer, Shift As Integer, x As Single, Y As Single)
Unload Me
End Sub

