VERSION 2.00
Begin Form frmStateOfTheArt 
   AutoRedraw      =   -1  'True
   Caption         =   "State of the Art"
   ClientHeight    =   2865
   ClientLeft      =   2715
   ClientTop       =   4110
   ClientWidth     =   6555
   Height          =   3270
   Icon            =   STATEART.FRX:0000
   KeyPreview      =   -1  'True
   Left            =   2655
   LinkTopic       =   "Form1"
   ScaleHeight     =   2865
   ScaleWidth      =   6555
   Top             =   3765
   Width           =   6675
   WindowState     =   2  'Maximized
   Begin VScrollBar vsbScroll 
      Height          =   5055
      HelpContextID   =   53
      Left            =   9360
      TabIndex        =   0
      TabStop         =   0   'False
      Top             =   1800
      Width           =   255
   End
   Begin PictureBox Picture1 
      Height          =   5055
      HelpContextID   =   53
      Left            =   0
      ScaleHeight     =   5025
      ScaleWidth      =   9345
      TabIndex        =   1
      TabStop         =   0   'False
      Top             =   1800
      Width           =   9375
      Begin PictureBox picScroll 
         AutoRedraw      =   -1  'True
         BorderStyle     =   0  'None
         Height          =   5055
         HelpContextID   =   53
         Left            =   0
         ScaleHeight     =   5055
         ScaleWidth      =   9135
         TabIndex        =   2
         TabStop         =   0   'False
         Top             =   0
         Width           =   9135
      End
   End
   Begin CommandButton Command1 
      Caption         =   "&Done"
      Height          =   375
      HelpContextID   =   53
      Left            =   8520
      TabIndex        =   3
      Top             =   120
      Width           =   975
   End
End
Option Explicit
DefInt A-Z

Dim msAttributes(4) As String
Dim msMsg(4) As String
Dim miTopOfPicture1

Sub Command1_Click ()
Unload Me
End Sub

Sub Form_GotFocus ()
' Only goes here when form is first loaded.
ShowBasicProperties
End Sub

' Cause Page Up and Page Down keys to scroll the vertical scrollbar.
Sub Form_KeyDown (KeyCode As Integer, Shift As Integer)
Dim nTemp
' Shift = 0 if neither shift, alt, nor control are pressed;
' Shift = 2 if just control is pressed.
If vsbScroll.Visible = True And Shift = 0 Then  ' Do nothing if not visible.
   If KeyCode = KEY_PRIOR Then      ' Page Up
      nTemp = vsbScroll.Value - vsbScroll.LargeChange
      If nTemp < vsbScroll.Min Then nTemp = vsbScroll.Min
      vsbScroll.Value = nTemp
   ElseIf KeyCode = KEY_NEXT Then  ' Page Down
      nTemp = vsbScroll.Value + vsbScroll.LargeChange
      If nTemp > vsbScroll.Max Then nTemp = vsbScroll.Max
      vsbScroll.Value = nTemp
   End If
End If

End Sub

Sub Form_Load ()
Dim N
Dim Flags
Remove_Items_From_Sysmenu frmStateOfTheArt
Flags = SWP_NOMOVE Or SWP_NOSIZE
N = SetWindowPos(frmStateOfTheArt.hWnd, HWND_TOPMOST, 0, 0, 0, 0, Flags)
End Sub

Sub Form_Resize ()
Dim nTemp

Picture1.Top = miTopOfPicture1
Picture1.Width = ScaleWidth - vsbScroll.Width
nTemp = ScaleHeight - miTopOfPicture1
If nTemp < 40 Then nTemp = 40
Picture1.Height = nTemp
vsbScroll.Top = miTopOfPicture1
vsbScroll.Left = ScaleWidth - vsbScroll.Width
vsbScroll.Height = nTemp
picScroll.Width = Picture1.ScaleWidth
If miTopOfPicture1 + picScroll.Height < ScaleHeight Then
   vsbScroll.Visible = False
Else
   If picScroll.Height < 40 Then
      vsbScroll.SmallChange = 1
   Else
      vsbScroll.SmallChange = picScroll.Height \ 40
   End If
   ' Since picScroll has no border, ScaleHeight = Height.
   vsbScroll.Visible = True
   vsbScroll.Max = picScroll.Height - Picture1.ScaleHeight
   vsbScroll.LargeChange = Picture1.ScaleHeight
   ' Next lines reposition in same place as before.
   vsbScroll.Value = vsbScroll
   vsbScroll_Change
End If
If gsWhoGotDuhFokus = "Me" Then
   ' Just updating this form; return focus to frmPeriodic.
   gsWhoGotDuhFokus = "You"
   frmPeriodic.SetFocus
Else
   ' Give the cancel button the focus.
   Command1.SetFocus
End If
End Sub

Sub Picture1_GotFocus ()
ShowBasicProperties

End Sub

Sub ShowBasicProperties ()
' Everything is printed on the form from this procedure.
Dim N
Dim TextBlockHeight

Cls
Print "Show period numbers:  ";        ' Period numbers
If frmPeriodic.mnuOptionsPeriod.Checked Then
   Print "Yes",
Else
   Print "No",
End If
FontUnderline = True
Print Tab(45); "Font name"; Tab(65); "size"; Tab(74); "color"; Tab(80); "attributes"
FontUnderline = False

Print "Title:  ";                      ' Title
FontName = HeadingProperties(2).sName
ForeColor = HeadingProperties(2).lColor
FontBold = HeadingProperties(2).bBold
FontItalic = HeadingProperties(2).bItalic
Print frmPeriodic.txtTableTitle;
FontName = "MS Sans Serif"
ForeColor = &H80000008
FontBold = True
FontItalic = False
Print Tab(45); HeadingProperties(2).sName;
Print Tab(65); HeadingProperties(2).nSize;
Print Tab(74); HeadingProperties(2).lColor; Tab(80);
If HeadingProperties(2).bBold And HeadingProperties(2).bItalic Then
   Print "Bold/Italic"
ElseIf HeadingProperties(2).bBold And Not HeadingProperties(2).bItalic Then
   Print "Bold"
ElseIf Not HeadingProperties(2).bBold And HeadingProperties(2).bItalic Then
   Print "Italic"
Else
   Print "Normal"
End If

If frmPeriodic!chkColHead(0).Value = 1 Then   ' Heading 1 - 18
   Print "Heading (1 - 18):  ";
   FontName = HeadingProperties(0).sName
   ForeColor = HeadingProperties(0).lColor
   FontBold = HeadingProperties(0).bBold
   FontItalic = HeadingProperties(0).bItalic
   Print "1 2 3 4 5 6 ... 15 16 17 18";
   FontName = "MS Sans Serif"
   ForeColor = &H80000008
   FontBold = True
   FontItalic = False
   Print Tab(45); HeadingProperties(0).sName;
   Print Tab(65); HeadingProperties(0).nSize;
   Print Tab(74); HeadingProperties(0).lColor; Tab(80);
   If HeadingProperties(0).bBold And HeadingProperties(0).bItalic Then
      Print "Bold/Italic"
   ElseIf HeadingProperties(0).bBold And Not HeadingProperties(0).bItalic Then
      Print "Bold"
   ElseIf Not HeadingProperties(0).bBold And HeadingProperties(0).bItalic Then
      Print "Italic"
   Else
      Print "Normal"
   End If
End If

If frmPeriodic!chkColHead(1).Value = 1 Then  ' Heading old style
   Print "Heading (Traditional):  ";
   FontName = HeadingProperties(1).sName
   ForeColor = HeadingProperties(1).lColor
   FontBold = HeadingProperties(1).bBold
   FontItalic = HeadingProperties(1).bItalic
   For N = 1 To 3
      Print gsColumnHeadingStyle(giColumnHeadingStyleChoice, N);
   Next N
   Print gsColumnHeadingStyle(giColumnHeadingStyleChoice, 9);
   Print gsColumnHeadingStyle(giColumnHeadingStyleChoice, 11);
   Print gsColumnHeadingStyle(giColumnHeadingStyleChoice, 12);
   Print gsColumnHeadingStyle(giColumnHeadingStyleChoice, 17);
   Print gsColumnHeadingStyle(giColumnHeadingStyleChoice, 18);
   FontName = "MS Sans Serif"
   ForeColor = &H80000008
   FontBold = True
   FontItalic = False
   Print Tab(45); HeadingProperties(1).sName;
   Print Tab(65); HeadingProperties(1).nSize;
   Print Tab(74); HeadingProperties(1).lColor; Tab(80);
   If HeadingProperties(1).bBold And HeadingProperties(1).bItalic Then
      Print "Bold/Italic"
   ElseIf HeadingProperties(1).bBold And Not HeadingProperties(1).bItalic Then
      Print "Bold"
   ElseIf Not HeadingProperties(1).bBold And HeadingProperties(1).bItalic Then
      Print "Italic"
   Else
      Print "Normal"
   End If
End If

' **************************** Basic properties *****************************
FontUnderline = True
Print Tab(18); "Atomic Number"; Tab(40); "Symbol"; Tab(62);
If frmPeriodic.chkOmitName = 1 Then ForeColor = QBColor(8)
Print "Name";
ForeColor = QBColor(0)
Print Tab(84); "Atomic Mass"
Print "Basic"
FontUnderline = False
Print Tab(5); "Box Fill Color:"; Tab(25); glBoxFillColor(0)
Print Tab(5); "Font Size:";
Print Tab(18); -Int(-Basic(0).fSize);
Print Tab(40); -Int(-Basic(1).fSize);
Print Tab(62); -Int(-Basic(2).fSize);
Print Tab(84); -Int(-Basic(3).fSize);

Print Tab(5); "Font Name:";
Print Tab(18); TheGroup(0).TheField(0).sName;
Print Tab(40); TheGroup(0).TheField(1).sName;
Print Tab(62); TheGroup(0).TheField(2).sName;
Print Tab(84); TheGroup(0).TheField(3).sName

Print Tab(5); "Font Color:";
Print Tab(18); TheGroup(0).TheField(0).lColor;
Print Tab(40); TheGroup(0).TheField(1).lColor;
Print Tab(62); TheGroup(0).TheField(2).lColor;
Print Tab(84); TheGroup(0).TheField(3).lColor

Print Tab(5); "Attributes:"; Tab(18);
For N = 0 To 3
   If TheGroup(0).TheField(N).nBold And TheGroup(0).TheField(N).nItalic Then
      msAttributes(N) = "Bold/Italic"
   ElseIf TheGroup(0).TheField(N).nBold And Not TheGroup(0).TheField(N).nItalic Then
      msAttributes(N) = "Bold"
   ElseIf Not TheGroup(0).TheField(N).nBold And TheGroup(0).TheField(N).nItalic Then
      msAttributes(N) = "Italic"
   Else
      msAttributes(N) = "Normal"
   End If
Next N
Print msAttributes(0); Tab(40); msAttributes(1); Tab(62); msAttributes(2); Tab(84); msAttributes(3)

miTopOfPicture1 = CurrentY
TextBlockHeight = 5 * picScroll.TextHeight("F")
N = 3 * TextBlockHeight * frmPeriodic!mnuGroupActiveChoice(0).Checked
N = N + TextBlockHeight * frmPeriodic!mnuGroupActiveChoice(1).Checked
N = N + 2 * TextBlockHeight * frmPeriodic!mnuGroupActiveChoice(2).Checked
N = N + 2 * TextBlockHeight * frmPeriodic!mnuGroupActiveChoice(3).Checked
picScroll.Height = -N
picScroll.Cls
' ************************ s-, p-, & f-Block element ************************
'CurrentX of 1530, 3510, 5490, 7470 = tabs of 18, 40, 62, 84
' Don't display unless it is an active group.
If frmPeriodic!mnuGroupActiveChoice(0).Checked Then
   picScroll.FontUnderline = True
   picScroll.Print "s-Block"
   ShowGroupProperties 6
   picScroll.FontUnderline = True
   picScroll.Print "p-Block"
   ShowGroupProperties 7
   picScroll.FontUnderline = True
   picScroll.Print "f-Block"
   ShowGroupProperties 8
End If

' ************************ Non-Terrestrial properties ***********************
If frmPeriodic!mnuGroupActiveChoice(1).Checked Then
   picScroll.FontUnderline = True
   picScroll.Print "Non-Terrestrial"
   ShowGroupProperties 1
End If
   
' ************************ Metalloid & Non-metal properties ***********************
If frmPeriodic!mnuGroupActiveChoice(2).Checked Then
   picScroll.FontUnderline = True
   picScroll.Print "Metalloid"
   ShowGroupProperties 2
   picScroll.FontUnderline = True
   picScroll.Print "Non-metal"
   ShowGroupProperties 3
End If
   
' ************************ Gase & Liquid properties ***********************
If frmPeriodic!mnuGroupActiveChoice(3).Checked Then
   picScroll.FontUnderline = True
   picScroll.Print "Gas"
   ShowGroupProperties 4
   picScroll.FontUnderline = True
   picScroll.Print "Liquid"
   ShowGroupProperties 5
End If

Form_Resize

End Sub

' Show the font properties of one group.
Sub ShowGroupProperties (ByVal Group)
Dim N
Dim sWorkName As String
Dim bWorkBold, bWorkItalic, lWorkColor As Long
Dim sBold As String, sItalic As String
         ' Box Fill Color
   picScroll.FontUnderline = False
   picScroll.Print Tab(5); "Box Fill Color:";
   If Not glBoxFillColor(Group) = COLORWILDCARD Then
      picScroll.Print Tab(25); glBoxFillColor(Group)
   End If
         ' Font Name
   picScroll.Print Tab(5); "Font Name:"; Tab(18);
   For N = 0 To 3
      If Not TheGroup(Group).TheField(N).sName = "" Then
         msMsg(N) = TheGroup(Group).TheField(N).sName
      Else
         msMsg(N) = ""
      End If
   Next N
   picScroll.Print msMsg(0); Tab(40); msMsg(1); Tab(62); msMsg(2); Tab(84); msMsg(3)
         ' Font Color
   picScroll.Print Tab(5); "Font Color:"; Tab(18);
   For N = 0 To 3
      If Not TheGroup(Group).TheField(N).lColor = COLORWILDCARD Then
         msMsg(N) = Str$(TheGroup(Group).TheField(N).lColor)
      Else
         msMsg(N) = ""
      End If
   Next N
   picScroll.Print msMsg(0); Tab(40); msMsg(1); Tab(62); msMsg(2); Tab(84); msMsg(3)
         ' Font Attributes
   picScroll.Print Tab(5); "Attributes:"; Tab(18);
   For N = 0 To 3
      If TheGroup(Group).TheField(N).nBold = 1 Then
         sBold = ""
      ElseIf TheGroup(Group).TheField(N).nBold Then
         sBold = "Bold"
      Else
         sBold = "Non-Bold"
      End If
      If TheGroup(Group).TheField(N).nItalic = 1 Then
         sItalic = ""
      ElseIf TheGroup(Group).TheField(N).nItalic Then
         sItalic = "Italic"
      Else
         sItalic = "Non-Italic"
      End If
      If sBold = "" And sItalic = "" Then
         msMsg(N) = ""
      ElseIf sBold = "" And Not sItalic = "" Then
         msMsg(N) = sItalic
      ElseIf Not sBold = "" And sItalic = "" Then
         msMsg(N) = sBold
      Else
         If sBold = "Non-Bold" And sItalic = "Non-Italic" Then
            msMsg(N) = "Normal"
         Else
            msMsg(N) = sBold & "/" & sItalic
         End If
      End If
   Next N
   picScroll.Print msMsg(0); Tab(40); msMsg(1); Tab(62); msMsg(2); Tab(84); msMsg(3)

End Sub

Sub vsbScroll_Change ()
   picScroll.Top = -vsbScroll.Value

End Sub

