#define INCL_DOSPROCESS
#define INCL_DOSSEMAPHORES

#include <os2.h>

#ifdef INCLUDE_PRAGMA
   #include "pragma.h"
#endif

/* 			ͻ
 * 				 Ŀ 													  
 * 				  	 ĿĿĿ 								  
 * 				  	 	 ٳ   								  
 * 				    Ŀ							  
 * 						  				  	ĿĿ 	  
 * 											  	   	 	 Ŀ   
 * 											 ٳ	     
 * 																  
 * 					 Door Programming Toolkit - Version 4.10		  
 * 			ͼ
 * 		(C) Copyright 1991-1993 by Brian Pirie. All Rights Reserved.
 *
 *
 * 						  UNREGISTERED EVALUATION VERSION
 * 										  
 *  This version of OpenDoors may be used for a reasonable evaluation
 *  period, and doors written with it may NOT be distributed. Your low $28
 *  registration fee will entitle you to continue using OpenDoors,
 *  distribute or even sell programs written with it, and you will be entitled
 *  to free upgrades to newer versions of OpenDoors. Unlike other libraries
 *  of this sort, OpenDoors requires no additional licencing fees - once you
 *  have paid your $28, you will be entitled to unlimited use of the
 *  package. For more information, see the accompanying OPENDOOR.DOC file.
 */


#ifndef OPENDOOR_H										/* Only parse OPENDOOR.H once */
#define OPENDOOR_H



															 /* OPENDOORS GLOBAL DEFINITIONS */
															 /* ---------------------------- */

#ifdef __cplusplus					  /* Compiler-dependant function definitions */
#define FUNCDEF extern "C"
#else
#define FUNCDEF
#endif

// Added by Joel Downer

typedef char boolean;

/* Format for internode message. */

typedef struct {
   short    length;
   short    source_node;
   short    event;
   boolean  from_player;
   char     name[36];
   char     text[256];
   } tInternodeMsg;


/* Semaphore formats used by the tInternodeMsg event field. */

enum NODE_EVENT { EVT_NONE, EVT_INIT, EVT_ACK, EVT_CHAT_INIT,
   EVT_CHAT_ACK, EVT_CHAT_BYE, EVT_CHAT_MSG, EVT_BYE };

   
extern char od_registered_to[36];            /* Program information variables */
extern unsigned long od_registration_key;
extern char od_program_name[40];



#ifndef __OS2__
#define FALSE 0										 /* Boolean constant definitions */
#define TRUE !FALSE
#else
#define XS 32									// Size of extended keypress buffer
#define BS 128 								// Size of the incoming keypress buffer
#define DEST_ALL_NODES -1
#define DEST_TEST_NODES -2
#endif
#define MAYBE 2
#define OD_MAX_STRING 1024

#define ERROR -32767
#define OK 0

										  /* OPENDOORS DOORDRIVER FUNCTIONS DEFINITIONS */
										  /* ------------------------------------------ */

/* Low-Level serial I/O interface routines.	Use FOSSIL or MCOMM. */

FUNCDEF void			 od_send_char(char c, boolean local_echo);
FUNCDEF int 			 od_receive_char(void);
FUNCDEF void			 hang_up(void);
FUNCDEF void			 clear_rx_buffer(void);
FUNCDEF void			 clear_tx_buffer(void);
FUNCDEF boolean		 bytes_received(void);
FUNCDEF void			 comm_close(void);
FUNCDEF boolean		 od_carrier(void);

/* OpenDoors door driver functions */

FUNCDEF void			 od_clear_keybuffer(void);
FUNCDEF void			 od_clr_line(void);
FUNCDEF void			 od_clr_scr(void);
FUNCDEF unsigned char od_colour_config(char *config_line);
FUNCDEF void			 od_disp(char *buffer, int size, char local_echo);
FUNCDEF void			 od_disp_str(char *string);
FUNCDEF void			 od_send_block(char *buf, int num_chars, boolean
								local_echo);
FUNCDEF int 			 od_draw_box(char left, char top, char right, char bottom);
FUNCDEF unsigned int  od_edit_str(char *input_string, char *format_string,
											 int row, int col, unsigned char normal_colour,
											 unsigned char highlight_colour,
											 char character, unsigned int flags);
FUNCDEF void			 od_emulate(register char in_char);
FUNCDEF void			 od_exit(int errorlevel, char term_call);
FUNCDEF char			 od_get_answer(char *string);
FUNCDEF int 			 od_get_key(int wait);
FUNCDEF char			 od_hotkey_menu(char *filename, char *hotkeys, char wait);
FUNCDEF void			 od_init(void);
FUNCDEF void			 od_init_with_config(char *filename,
														void (*custom_line_function)
															  (char *keyword,char *options));
FUNCDEF void			 od_input_str(char *string, int max_len,
											 unsigned char minchar, unsigned char maxchar);
FUNCDEF void			 od_kernal(void);
FUNCDEF int 			 od_list_files(char *directory);
FUNCDEF int 			 od_log_open(void);
FUNCDEF int 			 od_log_write(char *message);
FUNCDEF void			 od_page(void);
FUNCDEF void			 od_printf(char *format, ...);
FUNCDEF void			 od_putch(int character);
FUNCDEF void			 od_repeat(char value, unsigned char times);
FUNCDEF int 			 od_send_file(char *filename);
FUNCDEF void			 od_set_attrib(int colour);
#define					 od_set_colour(x, y) od_set_attrib(x|(y<<4))
FUNCDEF void			 od_set_cursor(int row, int col);
FUNCDEF void			 od_set_statusline(char setting);
FUNCDEF int 			 od_spawn(char *command_line);
FUNCDEF int 			 od_spawnvpe(int modeflag, char *path, char *argv[],
											 char *envp[]);
FUNCDEF char          od_keys_in_buffer(void);
/* Substitute for bioskey(0)... */
FUNCDEF int 			 getxkey(void);
FUNCDEF void			 od_flush(void);
FUNCDEF void          od_blank_display(char *pchBlankStr); /* Turns on secure mode. */
FUNCDEF void          od_restore_display(void);            /* Turns off secure mode. */
FUNCDEF void          od_gettext(int lcol, int lrow, int rcol, int rrow,
                         void *buf);
FUNCDEF int           SendMessage(short dest_node, char *player, short event,
                         boolean from_player, char *format, ...);
FUNCDEF int           od_wherex(void);
FUNCDEF int           od_wherey(void);
FUNCDEF int           od_get_attrib(void);
FUNCDEF int           od_random(int max);
FUNCDEF void          dv_sleep(short seconds);


#define P_WAIT 	0												 /* od_spawnvpe() flags */
#define CURRENT	0
#define IRET		1


#define EDIT_FLAG_NORMAL			 0x0000					 /* od_edit_str() flags */
#define EDIT_FLAG_NO_REDRAW		 0x0001
#define EDIT_FLAG_FIELD_MODE		 0x0002
#define EDIT_FLAG_EDIT_STRING 	 0x0004
#define EDIT_FLAG_STRICT_INPUT	 0x0008
#define EDIT_FLAG_PASSWORD_MODE	 0x0010
#define EDIT_FLAG_ALLOW_CANCEL	 0x0020
#define EDIT_FLAG_FILL_STRING 	 0x0040
#define EDIT_FLAG_AUTO_ENTER		 0x0080
#define EDIT_FLAG_AUTO_DELETE 	 0x0100
#define EDIT_FLAG_KEEP_BLANK		 0x0200
#define EDIT_FLAG_PERMALITERAL	 0x0400
#define EDIT_FLAG_LEAVE_BLANK 	 0x0800



#define EDIT_RETURN_ERROR			 0 			  /* od_edit_str() return values */
#define EDIT_RETURN_CANCEL 		 1
#define EDIT_RETURN_ACCEPT 		 2
#define EDIT_RETURN_PREVIOUS		 3
#define EDIT_RETURN_NEXT			 4



#define STATUS_NORMAL		1					  /* OpenDoors status line settings */
#define STATUS_NONE			10
#define STATUS_HELP			9
#define STATUS_USER1 		2
#define STATUS_USER2 		3
#define STATUS_USER3 		5
#define STATUS_USER4 		6
#define STATUS_SYSTEM		4



#define D_BLACK	 0 								 /* OpenDoors colour definitions */
#define D_BLUE 	 1
#define D_GREEN	 2
#define D_CYAN 	 3
#define D_RED		 4
#define D_MAGENTA  5
#define D_BROWN	 6
#define D_GREY 	 7
#define L_BLACK	 8
#define L_BLUE 	 9
#define L_GREEN	 10
#define L_CYAN 	 11
#define L_RED		 12
#define L_MAGENTA  13
#define L_YELLOW	 14
#define L_WHITE	 15
#define B_BLACK	 L_BLACK
#define B_BLUE 	 L_BLUE
#define B_GREEN	 L_GREEN
#define B_CYAN 	 L_CYAN
#define B_RED		 L_RED
#define B_MAGENTA  L_MAGENTA
#define B_BROWN	 L_YELLOW
#define B_GREY 	 L_WHITE

#define TIMING_NICE -1
#define TIMING_NORMAL 0
#define TIMING_NASTY 1



												/* OPENDOORS DOORDRIVER CONTROL STRUCTURE */
												/* -------------------------------------- */

/* Note:  in order to incorporate v. 5.0 ODoors changes, I am updating the
	*USER SETTING* section of _od_control to square with 5.0.  I am *NOT*
	updating any other section. */

struct _od_control					  /* OpenDoors door driver control structure */
	{
	char			  info_path[60];			  /* Location of door information file */
	char			  od_infofile[25];		  /* Allow user to specify dropfile */
													  // J. Downer, 3/94


#ifdef __OS2__
	unsigned long handle;
   TID           comm_tid;
	TID			  kbd_tid;
   TID           kernal_tid;
   TID           commout_tid;
   HMTX          InBufSem;      /* controls access to bhead, btail,
                                   input_buffer, and input_remote */
   HMTX          TimeOutSem;    /* Controls access to timeout data. */
   HMTX          NodeSem;       /* Control access to the list of active nodes. */
   HEV           ReqExitSem;    /* Posted by input threads to request exit. */
   HEV           AllowComSem;   /* Used to block the comm threads. */
   HEV           AllowKbdSem;   /* Used to block the keyboard input thread. */
   HEV           AllowMsgSem;   /* Used to block the inbound msg. thread. */
   HEV           AllowMainSem;  /* To block main thread when other terminates. */
   HEV           RXSem;         /* Indicates that keystrokes are in buffer. */
   HEV           MsgSem;        /* Indicates a message has been received. */
   HEV           InactWarn;     /* Need an inactivity warning. */
   HEV           TimeWarn;      /* Need to warn about remaining time. */
   HMUX          KeyOrTimeOrInact; /* Generic event muxwait. */
   char          use_port;
   boolean       od_no_messages;       // Disable the message thread?
   int           od_max_nodes;         // What's the highest node number?
   int           od_timing;     /* How "kind and gentle" is the door? */
#endif
	char			  port;						// Modem information.
	unsigned int  baud;
   /* Configuration to control internal async under DOS.  Irrelevant
      under OS/2. */
   boolean       fossil;
	boolean		  od_no_fossil;			// Set true to force internal async.
	boolean		  od_accept_baud; 		// Open port at current bps rate.
	boolean		  od_fifo_disable;
	int			  force_address;
	int			  force_irq;
	unsigned int  lockbps;

	char			  system_name[40];					  /* Caller & BBS information */
	char			  sysop_name[40];
	long			  system_calls;
	char			  system_last_caller[36];
	char			  timelog_start_date[9];
	int			  timelog_busyperhour[24];
	int			  timelog_busyperday[7];

	char			  user_name[36];
	char			  user_location[26];
	char			  user_password[16];
	char			  user_dataphone[16];
	char			  user_homephone[16];
	char			  user_lasttime[6];
	char			  user_lastdate[9];
	char			  user_attribute;
	char			  user_flags[4];
	unsigned long user_net_credit;
	unsigned long user_pending;
	unsigned int  user_messages;
	unsigned long user_lastread;
	unsigned int  user_security;
	unsigned long user_numcalls;
	unsigned long user_uploads;
	unsigned long user_downloads;
	unsigned long user_upk;
	unsigned long user_downk;
	unsigned long user_todayk;
	unsigned int  user_time_used;
	unsigned int  user_screen_length;
	char			  user_last_pwdchange;
	char			  user_attrib2;
	unsigned int  user_group;
	// unsigned int  user_xi_record;

	char			  event_status;
	char			  event_starttime[6];
	unsigned char event_errorlevel;
	char			  event_days;
	char			  event_force;
	char			  event_last_run[9];

	char			  user_netmailentered;
	char			  user_echomailentered;
	char			  user_logintime[6];
	char			  user_logindate[9];
	int			  user_timelimit;
	long			  user_loginsec;
	long			  user_credit;
	unsigned int  user_num;
	int			  user_readthru;
	int			  user_numpages;
	int			  user_downlimit;
	char			  user_timeofcreation[6];
	char			  user_logonpassword[16];
	char			  user_wantchat;
	char			  user_ansi;

	int			  user_deducted_time;
	// Spitfire keeps track of seconds awarded beyond normal limit.
	int			  user_bonus_time;
	char			  user_menustack[50][9];
	char			  user_menustackpointer;
	char			  user_handle[36];
	char			  user_comment[81];
	char			  user_firstcall[9];
	char			  user_combinedrecord[200];
	char			  user_birthday[9];
	char			  user_subdate[9];
	unsigned char user_screenwidth;
	// unsigned char user_msg_area;
	// unsigned char user_file_area;
	unsigned char user_language;
	unsigned char user_date_format;
	char			  user_forward_to[36];
	char			  user_error_free;
	char			  sysop_next;
	char			  user_emsi_session;
	char			  user_emsi_crtdef[41];
	char			  user_emsi_protocols[41];
	char			  user_emsi_capabilities[41];
	char			  user_emsi_requests[41];
	char			  user_emsi_software[41];
	unsigned char user_hold_attr1;
	unsigned char user_hold_attr2;
	unsigned char user_hold_len;

	char			  user_reasonforchat[78];
	char			  user_callsign[12];
	unsigned int  user_msg_area;
	unsigned int  user_file_area;
	char			  user_protocol;
	unsigned int  user_file_group;
	unsigned char user_last_birthday_check;
	char			  user_sex;
	unsigned long user_xi_record;
	unsigned int  user_msg_group;
	char			  user_avatar;
	char			  user_org[51];
	char			  user_address[3][51];
	long			  user_pwd_crc;
	long			  user_logon_pwd_crc;
	char			  user_last_cost_menu[9];
	unsigned int  user_menu_cost;
	char			  user_rip;


	char			  od_info_type;				/* Door information file statistics */
	char			  od_extended_info;
	unsigned int  od_node;
	char			  od_ra_info;


	char			  od_okaytopage;										 /* Door settings */
	int			  od_pagestartmin;
	int			  od_pageendmin;
	char			  od_user_keyboard_on;
	char			  od_page_pausing;
	char			  od_last_input;
	char			  od_logfile_name[80];
	char			  od_logfile_disable;
	unsigned int  od_maxtime;
	int			  od_maxtime_deduction;


	char			  od_box_chars[6];		  /* OpenDoors customization variables */
	char			  od_colour_char;
	char			  od_colour_delimiter;
	char			  od_clear_on_exit;
	unsigned char od_disable;
	int			  od_inactivity;
	int			  od_last_hot;
	/* 04/27/93 - D. Roseen - The following line creates a control variable for
	*								 erasing/keeping status bar during spawn.  Default
	*								 for this variable is set to erase for consistency
	*								 with existing programs.  This method permits
	*								 all existing code for other programs to work as
	*								 intended, and without any further modification. */
	int			  od_spawn_big_window;
	char			  od_list_pause;
	char			  od_list_stop;
	char			  od_nocopyright;
	char			  od_noexit;
	char			  od_page_len;
	char			  od_status_on;
	char			  od_spawn_freeze_time;
	char			  od_swapping_disable;
	char			  od_swapping_noems;
	char			  od_swapping_path[80];

	char			  od_chat_disable;
	char			  od_shell_disable;

	void			  (*od_before_exit)(void); 			  /* Custom function hooks */
	void			  (*od_cbefore_chat)(void);
	void			  (*od_cafter_chat)(void);
	void			  (*od_cbefore_shell)(void);
	void			  (*od_cafter_shell)(void);
	void			  (*od_warnfunc)(char *str);
	void			  (*od_cbefore_status)(void);
	void			  (*od_cafter_status)(void);
   void          (*od_node_message)(tInternodeMsg *);


	unsigned int  key_chat; 			 /* OpenDoors function key customizations */   unsigned int 		 key_dosshell;
	unsigned int  key_drop2bbs;
	unsigned int  key_hangup;
	unsigned int  key_keyboardoff;
	unsigned int  key_lesstime;
	unsigned int  key_lockout;
	unsigned int  key_moretime;
	unsigned int  key_status[8];
	unsigned int  key_sysopnext;

	char			  od_num_keys; 						  /* Additional function keys */
	int			  od_hot_key[16];


	char *			od_after_chat; 			 /* OpenDoors prompt customizations */
	char *			od_after_shell;
	char *			od_before_chat;
	char *			od_before_shell;
	char *			od_chat_reason;
	char *			od_day[7];
	char *			od_help_text;
	char *			od_help_text2;
	char *			od_inactivity_timeout;
	char *			od_inactivity_warning;
	char *			od_month[12];
	char *			od_no_keyboard;
	char *			od_no_sysop;
	char *			od_no_response;
	char *			od_no_time;
	char *			od_offline;
	char *			od_paging;
	char *			od_press_key;
	char *			od_status_line[15];
	char *			od_sysop_next;
	char *			od_time_left;
	char *			od_time_warning;
	char *			od_want_chat;

	char *			od_continue;
   #ifdef __OS2__
   char *         od_pipe_name;
   #endif
	char				od_continue_yes;
	char				od_continue_no;
	char				od_continue_nonstop;


	char			  od_chat_colour1;			 /* OpenDoors colour customizations */
	char			  od_chat_colour2;
	char			  od_list_comment_col;
	char			  od_list_name_col;
	char			  od_list_offline_col;
	char			  od_list_size_col;
	char			  od_list_title_col;
	};

extern struct _od_control od_control;			 /* od_control external variable */

#define DORINFO1			 0 						  /* Door information file types */
#define EXITINFO			 1
#define RA1EXITINFO		 2
#define CHAINTXT			 3
#define SFDOORSDAT		 4
#define CALLINFO			 5
#define DOORSYS_GAP		 6
#define DOORSYS_DRWY 	 7
#define QBBS275EXITINFO  8
#define CUSTOM 			 9
#define DOORSYS_WILDCAT  10
#define RA2EXITINFO		 11
#define PCBOARD			 12


#define DIS_INFOFILE 		 0x01 						 /* Function disable flags */
#define DIS_CARRIERDETECT	 0x02
#define DIS_TIMEOUT			 0x04
#define DIS_LOCAL_OVERRIDE  0x08

#define ES_DELETED 0 										  /* Event status settings */
#define ES_ENABLED 1
#define ES_DISABLED 2

extern char *od_log_messages[12];							/* External text arrays */
extern char od_config_text[31][33];
extern char od_config_lines[24][33];
extern char od_config_colours[12][33];


																 /* OLD VERSION COMPATIBILITY */
																 /*  */

#define key_help								key_status[6]
#define key_nohelp							key_status[0]
#define od_chat_color1						od_chat_colour1
#define od_chat_color2						od_chat_colour2
#define od_set_color(x, y) 				od_set_attrib(x|(y<<4))
#define user_credit							user_net_credit
#define caller_netmailentered 			user_netmailentered
#define caller_echomailentered			user_echomailentered
#define caller_logintime					user_logintime
#define caller_logindate					user_logindate
#define caller_timelimit					user_timelimit
#define caller_loginsec 					user_loginsec
#define caller_credit						user_credit
#define caller_userrecord					user_num
#define caller_readthru 					user_readthru
#define caller_numpages 					user_numpages
#define caller_downlimit					user_downlimit
#define caller_timeofcreation 			user_timeofcreation
#define caller_logonpassword				user_logonpassword
#define caller_wantchat 					user_wantchat
#define caller_ansi							user_ansi
#define ra_deducted_time					user_deducted_time
#define ra_menustack 						user_menustack
#define ra_menustackpointer				user_menustackpointer
#define ra_userhandle						user_handle
#define ra_comment							user_comment
#define ra_firstcall 						user_firstcall
#define ra_combinedrecord					user_combinedrecord
#define ra_birthday							user_birthday
#define ra_subdate							user_subdate
#define ra_screenwidth						user_screenwidth
#define ra_msg_area							user_msg_area
#define ra_file_area 						user_file_area
#define ra_language							user_language
#define ra_date_format						user_date_format
#define ra_forward_to						user_forward_to
#define ra_error_free						user_error_free
#define ra_sysop_next						sysop_next
#define ra_emsi_session 					user_emsi_session
#define ra_emsi_crtdef						user_emsi_crtdef
#define ra_emsi_protocols					user_emsi_protocols
#define ra_emsi_capabilities				user_emsi_capabilities
#define ra_emsi_requests					user_emsi_requests
#define ra_emsi_software					user_emsi_software
#define ra_hold_attr1						user_hold_attr1
#define ra_hold_attr2						user_hold_attr2
#define ra_hold_len							user_hold_len
#define caller_usernum						user_num
#define caller_callsign 					user_callsign
#define caller_sex							user_sex
#define od_avatar 							user_avatar
#define B_YELLOW								L_YELLOW
#define B_WHITE								L_WHITE
#define od_rbbs_node 						od_node
#endif
