/*********************************************************************
*     SMESSAGE.C -- Sample Doors/2 source code.  This is the default *
*                   function used to display an internode message to *
*                   the user.  It does the following:                *
*                                                                    *
*                   (a) Saves a rectangular region of the screen,    *
*                   (b) Draws a rectangular text box on the screen,  *
*                   (c) Displays the message in the text box,        *
*                   (d) Waits for the user to hit {Enter}, and       *
*                   (e) Redraws the screen region overwritten.       *
*                                                                    *
*                   This source is provided in the unregistered      *
*                   version in case you wish to try writing your     *
*                   own message-handling function.                   *
*                                                                    *
*  Author:     Joel Downer                Date:     5/94             *
**********************************************************************/

/* Determines the space required to display message. */

void CalcSize(tInternodeMsg *Message, int *top, int *left,
   int *bottom, int *right);

void od_show_message(tInternodeMsg *Message)
   {
   char *savescreen;
   int savex, savey;
   int top;
   int left;
   int bottom;
   int right;
   int between_size;
   int screensize;
   char ans;
   char save_delimiter = od_control.od_colour_delimiter;

   int row;

   /* Zero-length messages -- like door status messages -- shouldn't be
      displayed. */

   if (strlen(Message->text) == 0)
      return;

   /* Because a different function is used to handle messages in chat, this
      function shouldn't display chat messages. */

   if (Message->event == EVT_CHAT_MSG)
      return;

   /* How big a box do we need to display this message? */
   CalcSize(Message, &top, &left, &bottom, &right);

   between_size = (right - left) - 1;
   screensize = 2 * (bottom - top + 1) * (right - left + 1);

   if ((savescreen = malloc(screensize)) == NULL)
      return;

   od_save_screen(savescreen, &savex, &savey, left, top, right, bottom);

   od_set_colour(L_WHITE, D_BLUE);

   od_set_cursor(top, left);
   od_putch(od_control.od_box_chars[0]);
   od_repeat(od_control.od_box_chars[1], between_size);
   od_putch(od_control.od_box_chars[2]);

   for (row = top + 1; row < bottom; ++row)
      {
      od_set_cursor(row, left);
      od_putch(od_control.od_box_chars[3]);
      od_repeat(' ', between_size);
      od_putch(od_control.od_box_chars[3]);
      }

   od_set_cursor(bottom, left);
   od_putch(od_control.od_box_chars[4]);
   od_repeat(od_control.od_box_chars[1], between_size);
   od_putch(od_control.od_box_chars[5]);

   /* If you have changed the color delimiter from '`' (e.g., to prevent
      users from entering color strings on an

      od_input_str(str, len, 32, 127);

      call and corrupting the display), this code insures that "`bright
      cyan on blue`" won't be displayed to the user in lieu of a color
      change. */

   od_control.od_colour_delimiter = '';

   if (Message->from_player)
      {
      od_set_cursor(top + 1, left + 2);
      od_printf("bright cyan on blueReceived from bright white on blue%s"
         "bright cyan on blue on node bright white on blue%d"
         "bright cyan on blue:", Message->name,
         Message->source_node);

      od_set_cursor(top + 3, left + 2);
      }
   else
      od_set_cursor(top + 2, left + 2);

   od_printf("bright white on blue%s", Message->text);

   od_set_cursor(top + 4, left + 2);
   od_printf("bright cyan on blueHit \'bright white on blueEnter"
      "bright cyan on blue\' to continue.");

   do {
      ans = od_get_key(TRUE);
      } while (ans != '\r');

   /* Restoring old color delimiter now... */
   od_control.od_colour_delimiter = save_delimiter;

   od_restore_screen(savescreen, &savex, &savey, left, top, right, bottom);
   free(savescreen);
   }
