/* printf.c (emx+gcc) */

/* As this program tests a lot of borderline cases and cases of
   `undefined behavior' of printf(), GCC displays many warning
   messages.  Ignore them. */

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <ctype.h>

#if defined (__IBMCPP__)
#define alloca _alloca
#endif

static void test_printf (char type, const char *fmt, ...)
{

  va_list arg_ptr;
  char *p, *q;

  p = alloca (strlen (fmt) + 1);
  strcpy (p, fmt);
  for (q = p; *q != 0; ++q)
    if (*q == '?')
      *q = type;
  va_start (arg_ptr, fmt);
  vprintf (p, arg_ptr);
  va_end (arg_ptr);
}


static void test_float (char type)
{
  printf ("------ %c\n", type);
  test_printf (type, "%?|%#?|%15?|%15.3?|\n", 0.0, 0.0, 0.0, 0.0);
  test_printf (type, "%+15.3?|%015.3?|%#?|%-15?|\n", 0.0, 0.0, 0.0, 0.0);
  test_printf (type, "%.0?|%15.0?|%#15.0?|\n", 0.0, 0.0, 0.0);
  if (type == 'e' || type == 'g')
    type = toupper (type);
  test_printf (type, "%?|%?|%?|%?|%?|\n", 0.01, 0.1, 1.0, 10.0, 100.0);
  test_printf (type, "%.0?|%.1?|%.2?|%.3?|%.4?|%.5?|\n",
               0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999);
  test_printf (type, "%.3?|%.3?|%.3?|%.3?|\n",
               1.23449, 1.234500001, 2.3449, 2.34500001);
}


int main (void)
{
  printf ("");
  printf ("x%");
  printf ("x%%y");
  printf ("a%999bc\n");

  printf ("%s|\n", NULL);
  printf ("%2s|\n", NULL);
  printf ("%10s|\n", NULL);
  printf ("%.0s|\n", NULL);
  printf ("%.2s|\n", NULL);
  printf ("%.10s|\n", NULL);
  printf ("%10.0s|\n", NULL);
  printf ("%10.2s|\n", NULL);
  printf ("%10.10s|\n", NULL);

  printf ("%s|%s|%10s|%2s|%.2s|%10.2s|%-10s|%+5s|%#5s|% 5s|\n",
          "", "abc", "abc", "abc", "abc", "abc", "abc", "abc", "abc", "abc");
  printf ("%05s|%-05s|%*.*s|%*.*s|\n",
          "abc", "abc", 5, 2, "abc", -5, 2, "abc");

  printf ("%c|%3c|%3.1c|%3.0c|%-3c|%03c|%-03c|%#3c|% 3c|%+3c|\n",
          'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j');

  printf ("%d|%5d|%-5d|%5.3d|%-5.3d|%05d|%-05d|%05.3d|%3.0d|%3.0d|\n",
          12, 12, 12, 12, 12, 12, 12, 12, 12, 0);
  printf ("%+d|%+d|%+5d|%+05d|%#5d|% 05d|% 08.3d|\n",
          12, -12, 12, -12, 12, 12, 12);

  test_float ('e');
  test_float ('f');
  test_float ('g');

  return (0);
}
