/* strtol.c (emx+gcc) */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>

static const char *errno_str (void)
{
  static char buf[40];

  switch (errno)
    {
    case 0:
      return ("NOERROR");
    case ERANGE:
      return ("ERANGE");
    case EDOM:
      return ("EDOM");
    case EINVAL:
      return ("EINVAL");
    default:
      sprintf (buf, "#%d", errno);
      return (buf);
    }
}


int main (int argc, char *argv[])
{
  char buf[100], *p;
  const char *e;
  long ln;
  unsigned long uln;
  int radix;
  int unsigned_flag;

  if (argc != 3 || (strcmp (argv[1], "s") != 0 && strcmp (argv[1], "u") != 0))
    {
      fputs ("Usage: strtol s|u <radix>\n", stderr);
      return (1);
    }
  unsigned_flag = (argv[1][0] == 'u');
  radix = atoi (argv[2]);
  while (fgets (buf, sizeof (buf), stdin) != NULL)
    {
      p = strchr (buf, '\n');
      if (p != NULL)
        *p = 0;
      errno = 0;
      if (unsigned_flag)
        {
          uln = strtoul (buf, &p, radix);
          e = errno_str ();
          printf ("%lu %d %s\n", uln, (int)(p - buf), e);
        }
      else
        {
          ln = strtol (buf, &p, radix);
          e = errno_str ();
          printf ("%ld %d %s\n", ln, (int)(p - buf), e);
        }
    }
  return (0);
}
