#ifndef SESSION_DEFINED
#define SESSION_DEFINED
//**************************************************************************
// Class:   Session                                                        *
//                                                                         *
// Purpose: Provide a session for communication.                           *
//                                                                         *
//**************************************************************************

#include <os2def.h>
#include <ithread.hpp>

class ASession
{
public:                               //Define the public Information
  virtual write (char *data) = 0;     // output to the session
  virtual write (char *data, int len) = 0;     // output to the session
  virtual ~ASession() {}
  virtual Boolean active() = 0;
private:                              //Define the private Information
};


class ADosSession : public ASession
{
public:                               //Define the public Information
  ADosSession();		      // Constructor
  ~ADosSession();
  write (char *data);		      // output to the session
  write (char *data, int len) {return write(data);}
  Boolean active() { return isActive; }
  
private:                              //Define the private Information
  ULONG writePipe;		      // pipe for writing to session
  PID   childPID;
  IThread *pthr;
  Boolean isActive;
};


class AComSession : public ASession
{
public:                               //Define the public Information
  AComSession();		      // Constructor
  ~AComSession();
  write (char *data);		      // output to the session
  write (char *data, int len) { return write(data); }
  Boolean active() { return isActive; }
  
private:                              //Define the private Information
  Boolean    isActive;
  IThread    *listenThread;
  int        comPort;
  int        comBaud;
};


class ATcpSession : public ASession
{
public:                               //Define the public Information
  ATcpSession();		      // Constructor
  ~ATcpSession();
  write (char *data);		      // output to the session
  write (char *data, int len);		      // output to the session
  Boolean active() { return sock > 0; }
  void EtherInit();
  void TTYInit();
  
private:                              //Define the private Information
  IThread    *listenThread;
  int        sock;
};

#endif
