-- Copyright (c) 1994 ARINC Research Corporation
-- From material copyright (c) 1991, 1992 Premia Corporation
--
-- This material may be reproduced by or for the US Government pursuant 
-- to the copyright license under DFAR Clause 252.227-7013 (1988)
--
-- Developed for US Air Force under contract no. F41608-90-D-0544-0005
--
-- MODIFICATIONS
--   94/06 - J. Neuse, SD/OSE/EA  - Initial code
--   94/10 - O. Sluder, SD/OSE/EA - Cleanup

with CW_ATTR;
with CW_BFEX;
with CW_COMP;
with CW_EDSY;
with CW_LANG;
with CW_SMAN;
with CW_TYPES;
with SYSTEM;

-- *******************
-- *            	   *
-- *  ADA_SUPPORT_1  *  BODY
-- *            	   *
-- *******************

package body ADA_SUPPORT_1 is

  -- The following pragmas are required by the Meridian OpenAda for
  -- Windows 2.0 compiler in the package spec and body of code to be 
  -- used in a DLL, otherwise the application will general protection 
  -- fault when the DLL is loaded
  pragma SUPPRESS (elaboration_check);
  pragma SUPPRESS (storage_check);

  ADA_KEYWORD_COUNT : constant := 69;
  EOF_CHAR          : constant := 16#100#;

  Ada_Hash_Names : System.Address;
  Ada_Keywords   : array (1 .. ADA_KEYWORD_COUNT) of CW_Types.LPStr;

  type LPStr_Access_Type is access CW_Types.LPStr;

  -- ..........
  -- .        .
  -- .  Init  .  BODY
  -- .        .
  -- ..........

  procedure Init is

    i             : integer;
    Hash_Location : SYSTEM.ADDRESS;
    Hash_Access   : LPSTR_ACCESS_TYPE;
    New_Ext       : BOOLEAN;

  begin

    CW_EDSY.LibExport ("_ada_language_colors_update long long");
    CW_EDSY.LibExport ("_ada_language_colors long");

    Ada_Keywords := (new STRING'("ABORT"),
                     new STRING'("ABS"),
                     new STRING'("ABSTRACT"),
                     new STRING'("ACCEPT"),
                     new STRING'("ACCESS"),
                     new STRING'("ALIASED"),
                     new STRING'("ALL"),
                     new STRING'("AND"),
                     new STRING'("ARRAY"),
                     new STRING'("AT"),
                     new STRING'("BEGIN"),
                     new STRING'("BODY"),
                     new STRING'("CASE"),
                     new STRING'("CONSTANT"),
                     new STRING'("DECLARE"),
                     new STRING'("DELAY"),
                     new STRING'("DELTA"),
                     new STRING'("DIGITS"),
                     new STRING'("DO"),
                     new STRING'("ELSE"),
                     new STRING'("ELSIF"),
                     new STRING'("END"),
                     new STRING'("ENTRY"),
                     new STRING'("EXCEPTION"),
                     new STRING'("EXIT"),
                     new STRING'("FOR"),
                     new STRING'("FUNCTION"),
                     new STRING'("GENERIC"),
                     new STRING'("GOTO"),
                     new STRING'("IF"),
                     new STRING'("IN"),
                     new STRING'("IS"),
                     new STRING'("LIMITED"),
                     new STRING'("LOOP"),
                     new STRING'("MOD"),
                     new STRING'("NEW"),
                     new STRING'("NOT"),
                     new STRING'("NULL"),
                     new STRING'("OF"),
                     new STRING'("OR"),
                     new STRING'("OTHERS"),
                     new STRING'("OUT"),
                     new STRING'("PACKAGE"),
                     new STRING'("PRAGMA"),
                     new STRING'("PRIVATE"),
                     new STRING'("PROCEDURE"),
                     new STRING'("PROTECTED"),
                     new STRING'("RAISE"),
                     new STRING'("RANGE"),
                     new STRING'("RECORD"),
                     new STRING'("REM"),
                     new STRING'("RENAMES"),
                     new STRING'("REQUEUE"),
                     new STRING'("RETURN"),
                     new STRING'("REVERSE"),
                     new STRING'("SELECT"),
                     new STRING'("SEPARATE"),
                     new STRING'("SUBTYPE"),
                     new STRING'("TAGGED"),
                     new STRING'("TASK"),
                     new STRING'("TERMINATE"),
                     new STRING'("THEN"),
                     new STRING'("TYPE"),
                     new STRING'("UNTIL"),
                     new STRING'("USE"),
                     new STRING'("WHEN"),
                     new STRING'("WHILE"),
                     new STRING'("WITH"),
                     new STRING'("XOR"));

    Ada_Hash_Names := CW_EDSY.HashCreateTable (Ada_Keyword_Count,
                                               (SYSTEM.ADDRESS'SIZE / 8), 0);

    i := 1;
    while i <= ADA_KEYWORD_COUNT loop

      Hash_Location := CW_EDSY.HashGetEntry (Ada_Hash_Names,
                                             Ada_Keywords (i).all,
                                             Ada_Keywords (i).all'LAST);

      if (SYSTEM."/=" (Hash_Location, CW_TYPES.NUL)) then
      FILL_HASH:
        declare
          Hash_Address : SYSTEM.ADDRESS;
          for Hash_Address use at Hash_Location;
        begin
          Hash_Address := CW_SMAN.StrNew (Ada_Keywords (i).all);
        end FILL_HASH;
        i := i + 1;
      end if;

    end loop;

    New_Ext := CW_COMP.CompilerNewExt (".ada");

  end Init;

  -- .............
  -- .           .
  -- .  LibMain  .  BODY
  -- .           .
  -- .............

  function LibMain (hModule     : in WINTYPES.HANDLE;
                    wDataSeg    : in WINTYPES.WORD;
                    cbHeapSize  : in WINTYPES.WORD;
                    lpszCmdLine : in WINTYPES.LPSTR) return INTEGER is

  begin
    return 1;
  end LibMain;

  -- .........
  -- .       .
  -- .  WEP  .  BODY
  -- .       .
  -- .........

  function WEP (bSystemExit : in INTEGER) return INTEGER is

  begin
    return 1;
  end WEP;

  -- ..............
  -- .            .
  -- .  LINT2STR  .  BODY
  -- .            .
  -- ..............

  procedure lint2str (str  : in out string;
                      lint : in long_integer) is


    temp_int : long_integer := lint;

  begin

    for i in str'FIRST .. str'LAST loop
      str (str'LAST - (i - 1)) := character'VAL (48 + (temp_int rem 10));
      temp_int                 := temp_int / 10;
    end loop;

    if lint < 0 then
      str (str'FIRST) := '-';
    end if;

  end lint2str;

  -- ................................
  -- .       	    	       	       	.
  -- .  Ada_Language_Colors_Update  .  BODY
  -- .       	    	       	       	.
  -- ................................

  procedure Ada_Language_Colors_Update (Firstline : in Long_Integer;
                                        Lastline  : in Long_Integer) is

    Startoff     : Long_Integer := 0;
    Init_Success : BOOLEAN      := TRUE;
    Lines_Moved  : Long_Integer := 0;
    Pass_Lines   : LONG_INTEGER := 0;

  begin

    if (Firstline /= 0) and (Lastline /= 0) then

      --  Begin coloring at the previous comment if currently located
      --  in the middle of one.

      Init_Success := CW_BFEX.PosInit (0);
      if (Firstline = 1) then
        Lines_Moved := CW_BFEX.PosPrevLine (LONG_INTEGER (0));
      else
        Lines_Moved := CW_BFEX.PosNextLine (LONG_INTEGER (Firstline - 1));
      end if;
      Startoff := CW_BFEX.PosQOffset;

      CW_ATTR.AttrSetColor (Firstline, Lastline, LONG_INTEGER (1),
                            LONG_INTEGER (16#7FFFFFFF#), INTEGER (0));

      Init_Success := CW_BFEX.PosInit (Startoff);

      Pass_Lines := (Lastline - Firstline + 1);
      ADA_SUPPORT1.Ada_Language_Colors (Pass_Lines);

    end if;

  end Ada_Language_Colors_Update;

  -- ....................
  -- .       	     	    .
  -- .  Color_Comments  .  BODY
  -- .       	     	    .
  -- ....................

  procedure Color_Comments (Ch            : in out CHARACTER;
                            Numlines      : in out LONG_INTEGER;
                            Comment_Color : in INTEGER) is

    Startoff     : LONG_INTEGER := 0;
    Endoff       : LONG_INTEGER := 0;
    inc          : LONG_INTEGER := 0;
    Init_Success : BOOLEAN      := TRUE;

  begin

    Startoff := CW_BFEX.PosQOffset;
    Ch       := CW_BFEX.PosNextChar;

    if (Ch = '-') then
      Inc          := CW_BFEX.PosNextLine (LONG_INTEGER (1));
      Numlines     := Numlines - 1;
      Endoff       := CW_BFEX.PosQOffset;
      Init_Success := CW_BFEX.PosInit (Startoff);
      CW_BFEX.PosSetColor (Comment_Color, (Endoff - Startoff - Inc));
      Init_Success := CW_BFEX.PosInit (Endoff);
      Ch           := CW_BFEX.PosPrevChar;
    else
      Ch := CW_BFEX.PosPrevChar;
    end if;

  end Color_Comments;

  -- ...................
  -- .       	     	   .
  -- .  Color_Keyword  .  BODY
  -- .       	     	   .
    -- .................

  procedure Color_Keyword (Ch            : in out CHARACTER;
                           Keyword_Color : in INTEGER) is

    LastCh       : CHARACTER;
    Next_Char    : CHARACTER;
    Startoff     : LONG_INTEGER := 0;
    Endoff       : LONG_INTEGER := 0;
    Init_Success : BOOLEAN      := TRUE;

    Temp_Void : CW_TYPES.LPVOID := 0;

    key : string (1 .. 100);
    i   : integer;

  begin

    LastCh := CW_BFEX.PosPrevChar;

    if LastCh /= ASCII.SUB then
      Next_Char := CW_BFEX.PosNextChar;
    end if;

    StartOff := CW_BFEX.PosQOffset;

    i := 0;
    while (Ch in 'A' .. 'Z') or (Ch in 'a' .. 'z') loop

      i       := i + 1;
      key (i) := Ch;
      Ch      := CW_BFEX.PosNextChar;

    end loop;

    for j in 1 .. i loop
      if CHARACTER'POS (Key (j)) in 16#61# .. 16#7A# then
        Key (j) := CHARACTER'VAL (CHARACTER'POS (Key (j)) - 16#20#);
      end if;
    end loop;

    if ((Ch /= '_') and (Ch not in '0' .. '9')) and
      ((LastCh /= '_') and (LastCh not in '0' .. '9')) then
      Temp_Void := CW_EDSY.HashFindEntry (Ada_Hash_Names, Key, (i));
    else
      Temp_Void := CW_TYPES.NUL;
    end if;

    if SYSTEM."/=" (Temp_Void, CW_TYPES.NUL) then
      EndOff       := CW_BFEX.PosQOffset;
      Init_Success := CW_BFEX.PosInit (StartOff);
      CW_BFEX.PosSetColor (Keyword_Color, (EndOff - Startoff));
      Init_Success := CW_BFEX.PosInit (Endoff);
    end if;

    Ch := CW_BFEX.PosPrevChar;

  end Color_Keyword;

  -- .................
  -- .       	     	 .
  -- .  Color_Digit  .  BODY
  -- .       	     	 .
  -- .................

  procedure Color_Digit (Ch           : in out CHARACTER;
                         Buffer       : in out STRING;
                         Number_Color : in INTEGER) is

    LastCh       : CHARACTER;
    Next_Char    : CHARACTER;
    Startoff     : LONG_INTEGER := 0;
    Endoff       : LONG_INTEGER := 0;
    Init_Success : BOOLEAN      := TRUE;
    Periods      : INTEGER      := 0;
    Do_Color     : BOOLEAN      := TRUE;

  begin

    LastCh := CW_BFEX.PosPrevChar;

    if LastCh /= ASCII.SUB then
      Next_Char := CW_BFEX.PosNextChar;
    end if;

    StartOff := CW_BFEX.PosQOffset;
    Periods  := 0;
    while ((Ch in '0' .. '9') or (Ch in 'A' .. 'F') or (Ch in 'a' .. 'f')) or
      (Ch = '.') or (Ch = '#') or (Ch = '_') loop

      if Ch = '.' then
        Periods := Periods + 1;
      else
        Periods := 0;
      end if;

      exit when Periods = 2;

      Ch := CW_BFEX.PosNextChar;

    end loop;

    if Periods = 2 then
      Ch := CW_BFEX.PosPrevChar;
    end if;

    Do_Color := (LastCh /= '_') and (LastCh not in 'A' .. 'Z') and
                (LastCh not in 'a' .. 'z');
    Do_Color := (Ch /= '_') and (Ch not in 'A' .. 'Z') and
                (Ch not in 'a' .. 'z') and Do_Color;

    if Do_Color then

      EndOff       := CW_BFEX.PosQOffset;
      Init_Success := CW_BFEX.PosInit (Startoff);
      CW_BFEX.PosSetColor (Number_Color, (EndOff - StartOff));
      Init_Success := CW_BFEX.PosInit (EndOff);

    end if;

    Ch := CW_BFEX.PosPrevChar;

  end Color_Digit;

  -- .................
  -- .       	     	 .
  -- .  Color_Quote  . BODY
  -- .       	     	 .
  -- .................

  procedure Color_Quote (Ch          : in out CHARACTER;
                         Buffer      : in out STRING;
                         Quote_Color : in INTEGER) is

    StartOff     : LONG_INTEGER := 0;
    EndOff       : LONG_INTEGER := 0;
    Quote        : CHARACTER;
    Init_Success : BOOLEAN;
    Open_Char    : CHARACTER := Ch;
    Char_Count   : INTEGER   := 0;
    Do_Color     : BOOLEAN   := TRUE;

  begin

    Do_Color := TRUE;

    -- The character passed opens the quotation or character literal.
    Quote    := Ch;
    StartOff := CW_BFEX.PosQOffset;

    --  Reset Ch to begin the loop.
    Ch := 'A';

    Char_Count := 1;
    while Ch /= Open_Char loop

      Ch         := CW_BFEX.PosNextChar;
      Char_Count := Char_Count + 1;

      if (Ch = Open_Char) and (Char_Count = 2) and (Ch = ''') then
        Ch := CW_BFEX.PosNextChar;
      end if;

      if (Open_Char = ''') and (Char_Count = 3) and (Ch /= Open_Char) then
        Ch       := CW_BFEX.PosPrevChar;
        Do_Color := FALSE;
      end if;

      exit when (not Do_Color);
      exit when ((Ch = ASCII.SUB) or (Ch = ASCII.LF));

    end loop;

    --  Advance the _Pos pointer to the character after the last quote
    --  so the PosSetColor call will work properly.
    if Do_Color and (Ch = '"' or Ch = ''') then
      Ch := CW_BFEX.PosNextChar;
    end if;

    if Do_Color and (Quote_Color > 0) then
      EndOff       := CW_BFEX.PosQOffset;
      Init_Success := CW_BFEX.PosInit (StartOff);
      CW_BFEX.PosSetColor (Quote_Color, (EndOff - StartOff));
      Init_Success := CW_BFEX.PosInit (EndOff);
    end if;

    --  Back up the _Pos pointer so that the posnextchar at the end
    --  of the loop in ada_language_colors gets the right character.
    Ch := CW_BFEX.PosPrevChar;

  end Color_Quote;

  -- ....................
  -- .       	     	    .
  -- .  Ada_In_Comment  .  BODY
  -- .       	     	    .
  -- ....................

  function Ada_In_Comment (Offset : in LONG_INTEGER) return LONG_INTEGER is

    Ch           : CHARACTER;
    Init_Success : BOOLEAN      := TRUE;
    First_Time   : BOOLEAN      := TRUE;
    Return_Long  : LONG_INTEGER := - 1;

  begin

    Init_Success := CW_BFEX.PosInit (Offset);
    Ch           := CW_BFEX.PosCurrentChar;

    while (((Ch) /= ASCII.SUB) or First_Time) loop

      First_Time := FALSE;

      exit when Ch = ASCII.LF;

      if Ch = '-' then

        Ch := CW_BFEX.PosPrevChar;
        exit when Ch = ASCII.LF;

        if Ch = '-' then
          Return_Long := CW_BFEX.PosQOffset;
          exit;
        end if;

      end if;

      Ch := CW_BFEX.PosPrevChar;

    end loop;

    return Return_Long;

  end Ada_In_Comment;

  -- .........................
  -- .       	    	       	 .
  -- .  Ada_Language_Colors  .  BODY
  -- .       	    	       	 .
  -- .........................


  procedure Ada_Language_Colors (Numlines : in out Long_Integer) is


    Startoff      : LONG_INTEGER := 0;
    MaxLines      : LONG_INTEGER := 0;
    Startline     : LONG_INTEGER := 0;
    Endoff        : LONG_INTEGER := 0;
    inc           : LONG_INTEGER := 0;
    Ch            : CHARACTER;
    Buff          : STRING (1 .. 100);
    i             : INTEGER := 0;
    Comment_Color : INTEGER;
    Keyword_Color : INTEGER;
    Quote_Color   : INTEGER;
    Number_Color  : INTEGER;
    Brace_Color   : INTEGER;
    Preproc_Color : INTEGER;
    Init_Success  : BOOLEAN := TRUE;
    Continue_If   : BOOLEAN := TRUE;

    TEMP_STR : string (1 .. 20) := "                    ";

    temp_numlines : long_integer;

  begin

    Comment_Color := CW_EDSY.ColorComments (- 1);
    Keyword_Color := CW_EDSY.ColorKeywords (- 1);
    Quote_Color   := CW_EDSY.ColorAlternate1 (- 1);
    Number_Color  := CW_EDSY.ColorAlternate2 (- 1);
    Brace_Color   := CW_EDSY.ColorAlternate3 (- 1);
    Preproc_Color := CW_EDSY.ColorAlternate4 (- 1);
    MaxLines      := CW_LANG.ExtCommentSearchLimit (- 1);

    if Numlines = - 1 then
      Init_Success := CW_BFEX.PosInit (0);
      NumLines     := 16#7FFFFFFF#;
    else
      Startoff  := CW_BFEX.PosQOffset;
      StartLine := CW_BFEX.PosQLine;
      Endoff    := ADA_SUPPORT1.Ada_In_Comment (Startoff);
      if Endoff = - 1 then
        Init_Success := CW_BFEX.PosInit (Startoff);
      else
        Init_Success := CW_BFEX.PosInit (Endoff);
        Numlines     := Numlines + (Startline - CW_BFEX.PosQLine);
      end if;
    end if;

    Ch       := CW_BFEX.PosCurrentChar;
    StartOff := CW_BFEX.PosQOffset;
    if numlines > Maxlines then
      Maxlines := numlines;
    end if;

    while ((Ch /= ASCII.SUB) and (Numlines > 0)) loop

      if Ch = ASCII.LF then
        Numlines := Numlines - 1;
      end if;

      if Ch = '"' or Ch = ''' then
        Color_Quote (Ch, Buff, Quote_Color);
        Continue_If := FALSE;
      elsif (Number_Color > 0) and (Ch in '0' .. '9') then
        Color_Digit (Ch, Buff, Number_Color);
        Continue_If := FALSE;
      elsif (Ch in 'A' .. 'Z') or (Ch in 'a' .. 'z') then
        Color_Keyword (Ch, Keyword_Color);
        continue_if := false;
      elsif (Ch = '-') then
        Color_Comments (Ch, Numlines, Comment_Color);
        Continue_If := FALSE;
      end if;

      Ch := CW_BFEX.PosNextChar;

    end loop;

  end Ada_Language_Colors;

end ADA_SUPPORT_1;
