-- Copyright (c) 1994 ARINC Research Corporation
-- From material copyright (c) 1991, 1992 Premia Corporation
--
-- This material may be reproduced by or for the US Government pursuant 
-- to the copyright license under DFAR Clause 252.227-7013 (1988)
--
-- Developed for US Air Force under contract no. F41608-90-D-0544-0005
--
-- MODIFICATIONS
--   94/06 - J. Neuse, SD/OSE/EA  - Initial code
--   94/10 - O. Sluder, SD/OSE/EA - Cleanup

with CW_ATTR;
with CW_BFEX;
with CW_BFOP;
with CW_COMP;
with CW_CURS;
with CW_EDIT;
with CW_EDSY;
with CW_FLAG;
with CW_LANG;
with CW_SLCT;
with CW_SMAN;
with CW_SRCH;
with CW_TYPES;
with SYSTEM;
with WINDOWS;

-- *******************
-- *       	    	   *
-- *  ADA_SUPPORT_2  *  BODY
-- *       	    	   *
-- *******************

package body ADA_SUPPORT_2 is

  -- The following pragmas are required by the Meridian OpenAda for
  -- Windows 2.0 compiler in the package spec and body of code to be 
  -- used in a DLL, otherwise the application will general protection 
  -- fault when the DLL is loaded
  pragma SUPPRESS (elaboration_check);
  pragma SUPPRESS (storage_check);

  type LANGUAGE_TEMPLATE_TYPE is
    record
      Abbrev   : CW_TYPES.LPSTR;
      Template : CW_TYPES.LPSTR;
    end record;

  ADA_TEMPLATE_COUNT : constant := 7;
  Ada_Templates : array (1 .. ADA_TEMPLATE_COUNT) of LANGUAGE_TEMPLATE_TYPE;
  Ada_Hash_Templates : SYSTEM.ADDRESS;

  capt : constant := 16#54#;

  ADA_INDENT_STR : string (1 .. 35);

  -- ..........
  -- .        .
  -- .  Init  .  BODY
  -- .        .
  -- ..........

  procedure Init is

    New_Ext : BOOLEAN;

  begin

    --  Initialize here because Meridian has a bug initializing before
    --  procedures.
    ADA_INDENT_STR := "-if-elsif-else-while-for-loop-case-";

    CW_EDSY.LibExport ("BOOL _ada_routines");

    Ada_Templates :=
      ((new STRING'("if"),
        new STRING'("if & then\nend if ;")),
       (new STRING'("for"), new STRING'("for & in  loop\nend loop ;")),
       (new STRING'("while"), new STRING'("while & loop\nend loop ;")),
       (new STRING'("loop"), new STRING'("loop&\nexit when\nend loop ;")),
       (new STRING'("record"), new STRING'("record&\nend record ;")),
       (new STRING'("declare"),
        new STRING'("&\n" & ASCII.HT & "declare\n\nbegin\n\nend  ;")),
       (new STRING'("case"),
        new STRING'("case & is\n" & ASCII.HT & "when  =>\nend case ;")));

    Ada_Hash_Templates :=
      CW_EDSY.HashCreateTable
         (ADA_TEMPLATE_COUNT, (SYSTEM.ADDRESS'SIZE / 8), 0);

    for i in 1 .. ADA_TEMPLATE_COUNT loop
      CW_LANG.Ext_Assign_Template (Ada_Hash_Templates,
                                   Ada_Templates (i).Abbrev.all,
                                   Ada_Templates (i).Template.all);
    end loop;

    New_Ext := CW_COMP.CompilerNewExt (".ada");

  end Init;

  -- .............
  -- .           .
  -- .  LibMain  .  BODY
  -- .           .
  -- .............

  function LibMain (hModule     : in WINTYPES.HANDLE;
                    wDataSeg    : in WINTYPES.WORD;
                    cbHeapSize  : in WINTYPES.WORD;
                    lpszCmdLine : in WINTYPES.LPSTR) return INTEGER is

  begin
    return 1;
  end LibMain;

  -- .........
  -- .       .
  -- .  WEP  .  BODY
  -- .       .
  -- .........

  function WEP (bSystemExit : in INTEGER) return INTEGER is

  begin
    return 1;
  end WEP;

  -- ..................
  -- .	 	       	    .
  -- .  Ada_Routines  .  BODY
  -- .       	  	    .
  -- ..................

  procedure Ada_Routines is

    MovBool    : BOOLEAN;
    SrchBool   : BOOLEAN;
    sFlags     : CW_TYPES.DWORD;
    SetFlags   : CW_TYPES.DWORD;
    matchLen   : LONG_INTEGER;
    First_Line : LONG_INTEGER;
    Last_Line  : LONG_INTEGER;
    ErrCode    : INTEGER;

  begin --  procedure Ada_Routines

    sFlags   := CW_TYPES."+" (CW_TYPES.SEARCH_IGCASE, CW_TYPES.SEARCH_REGEX);
    sFlags   := CW_TYPES."+" (sFlags, CW_TYPES.SEARCH_FORWARD);
    SetFlags := CW_FLAG.SrchSetFlags (sFlags);

    CW_BFOP.BufSetAscii;
    CW_SLCT.MarkSavePos;

    MovBool    := CW_CURS.MovTopBuf;
    First_Line := CW_BFOP.BufQCurrentLine;

    loop

      SrchBool := cw_srch.srchfind ("^[ \t]*(procedure|function)", sFlags,
                                    matchLen'ADDRESS);

      -- If SrchBool is FALSE, then no more procedures or functions were
      -- found, so we need to exit.	  	       
      exit when (not SrchBool);

      Last_Line := CW_BFOP.BufQCurrentLine;
      CW_ATTR.AttrSetVisible (CW_TYPES.DWORD (First_Line),
                              CW_TYPES.DWORD (Last_Line - 1), INTEGER (0));
      First_Line := Last_Line;

      --  Find the end of the procedure declaration or the opening of the
      --  parameter declaration ( "is", or ";", or "(" ).
      SrchBool := CW_SRCH.SrchFind ("((is|;)|\()", sFlags, matchLen'ADDRESS);

      --  If found open parameter declaration, find end of parameter
      --  declaration, and then the end of the procedure declaration.
      if (CW_BFEX.BufReadChar = '(') then
        SrchBool := CW_SRCH.SrchFind ("\)", sFlags, matchLen'ADDRESS);
        SrchBool := CW_SRCH.SrchFind ("(is|;)", sFlags, matchLen'ADDRESS);
      end if;

      Last_Line := CW_BFOP.BufQCurrentLine;
      CW_ATTR.AttrSetVisible (CW_TYPES.DWORD (First_Line),
                              CW_TYPES.DWORD (Last_Line), INTEGER (1));
      First_Line := Last_Line + 1;
      MovBool    := CW_CURS.MovDown (LONG_INTEGER (1));

    end loop;

    MovBool   := CW_CURS.MovEOF;
    Last_Line := CW_BFOP.BufQCurrentLine;
    CW_ATTR.AttrSetVisible (CW_TYPES.DWORD (First_Line),
                            CW_TYPES.DWORD (Last_Line), INTEGER (0));

    SetFlags := CW_FLAG.SrchSetFlags (SetFlags);
    ErrCode  := CW_SLCT.MarkRestorePos;
    CW_BFOP.BufSetCompact;

  end Ada_Routines;

  -- ....................
  -- .       	     	    .
  -- .  Ada_In_Comment  .  BODY
  -- .       	     	    .
  -- ....................
  --
  -- NOTES
  -- Ada_In_Comment returns a -1 if the cursor is not currently positioned
  -- in a comment.  If the cursor is in a comment, the function returns
  -- the position in the buffer where the comment begins.

  function Ada_In_Comment (Offset : in LONG_INTEGER) return LONG_INTEGER is

    Ch           : CHARACTER;
    Init_Success : BOOLEAN      := TRUE;
    First_Time   : BOOLEAN      := TRUE;
    Return_Long  : LONG_INTEGER := - 1;

  begin

    Init_Success := CW_BFEX.PosInit (Offset);
    Ch           := CW_BFEX.PosCurrentChar;

    while (((Ch) /= ASCII.SUB) or First_Time) loop

      First_Time := FALSE;

      exit when Ch = ASCII.LF;

      if Ch = '-' then

        Ch := CW_BFEX.PosPrevChar;
        exit when Ch = ASCII.LF;

        if Ch = '-' then
          Return_Long := CW_BFEX.PosQOffset;
          exit;
        end if;

      end if;

      Ch := CW_BFEX.PosPrevChar;

    end loop;

    return Return_Long;

  end Ada_In_Comment;

  -- .................
  -- .       	     	 .
  -- .  Get_Address  .  SPEC & BODY
  -- .       	     	 .
  -- .................
  --
  -- Get_Address "dereferences" a system address.  In this case the 
  -- system address passed to the function "points" to a memory location
  -- containing another system address "pointing" to something else.
  -- The second system address is returned by the function.

  function Get_Address (addr : in SYSTEM.ADDRESS) return SYSTEM.ADDRESS is

    Return_Addr : SYSTEM.ADDRESS;
    for Return_Addr use at addr;

  begin --  function Get_Address 

    return Return_Addr;

  end Get_Address;

  -- ................
  -- .	 	       	  .
  -- .  Ada_Expand  .  BODY
  -- .       	  	  .
  -- ................
  --

  function Ada_Expand return INTEGER is

    Bas_String    : CW_TYPES.LPSTR;
    HashStr       : CW_TYPES.LPSTR;
    Str           : STRING (1 .. 256);
    ErrCode       : INTEGER;
    i             : INTEGER;
    Length        : INTEGER;
    htEntry       : SYSTEM.ADDRESS := CW_TYPES.NUL;
    Comment_Found : LONG_INTEGER;

  begin --  function Ada_Expand

    CW_SLCT.MarkSavePos;

    Comment_Found := Ada_In_Comment (LONG_INTEGER (- 1));
    if (Comment_Found /= - 1) then
      ErrCode := CW_SLCT.MarkRestorePos;
      return INTEGER (0);
    end if;

    CW_BFEX.BufReadStr (Str);
    i          := CW_SMAN.FindChar (1, ASCII.CR, Str) - 1;
    Bas_String := new STRING'(CW_SMAN.StrTrim (Str (1 .. i), " " & ASCII.HT));

    for j in 1 .. Bas_String.all'LAST loop
      if CHARACTER'POS (Bas_String (j)) in 16#41# .. 16#5A# then
        Bas_String (j) := CHARACTER'VAL (CHARACTER'POS (Bas_String (j)) +
                                         16#20#);
      end if;
    end loop;

    htEntry := CW_EDSY.HashFindEntry (Ada_Hash_Templates, Bas_String.all,
                                      Bas_String.all'LAST);

    if SYSTEM."/=" (htEntry, CW_TYPES.NUL) then

      ErrCode := CW_SLCT.MarkDropPos (INTEGER (- 1));
      --  HashFindEntry returns a system address that contains the
      --  system address of the expansion string.  Use Get_Address
      --  to retrieve the system address at the htEntry.
      htEntry := Get_Address (htEntry);
      Length  := CW_SMAN.Addr_Str_Len (htEntry);
      HashStr := new STRING'(CW_SMAN.ADDR_To_String (htEntry, Length));
      ErrCode := CW_EDIT.BufDelToEOL;
      CW_LANG.Ext_Expand_Template (HashStr.all);
      return INTEGER (1);
    end if;

    ErrCode := CW_SLCT.MarkRestorePos;
    return INTEGER (0);

  end Ada_Expand;

  -- ................
  -- .	 	       	  .
  -- .  Ada_Indent  .  BODY
  -- .       	  	  .
  -- ................
  --

  function Ada_Indent return INTEGER is

    MatchLength : LONG_INTEGER := 0;
    CurLine     : LONG_INTEGER;
    Col         : LONG_INTEGER;
    ErrCode     : INTEGER;
    Str_Found   : BOOLEAN := TRUE;
    Match_Str   : CW_TYPES.LPSTR;
    Temp_Str    : string (1 .. 256);

  begin --  function Ada_Indent

    CW_SLCT.MarkSavePos;
    CurLine := CW_BFOP.BufQCurrentLine;

    -- Ada_In_Comment returns -1 if the cursor is not currently positioned
    -- in a comment.  Otherwise, it returns the buffer position where the
    -- comment begins.
    if (Ada_In_Comment (LONG_INTEGER (- 1)) /= - 1) then
      ErrCode := CW_SLCT.MarkRestorePos;
      return INTEGER (0);
    end if;

    Str_Found := CW_SRCH.SrchFind ("^[ \t]*[a-zA-Z]+\c([ \t]|$)",
                                   CW_TYPES.SEARCH_REGEX, MatchLength'ADDRESS);

    if (not Str_Found) or (CW_BFOP.BufQCurrentLine /= CurLine) then
      ErrCode := CW_SLCT.MarkRestorePos;
      return INTEGER (0);
    end if;

    Col       := CW_BFOP.BufQCurrentCol;
    Str_Found := CW_SRCH.SrchFind ("(^|[^a-zA-Z])\c[a-zA-Z]",
                                   CW_TYPES.SEARCH_REGEX, MatchLength'ADDRESS);
    Col := Col - CW_BFOP.BufQCurrentCol;

    CW_BFEX.BufReadStr (Temp_Str);
    Match_Str := new STRING'('-' & Temp_Str (1 .. INTEGER (Col)) & '-');

    MatchLength :=
      CW_SMAN.StrMatch (Match_Str.all, Ada_Support2.ADA_INDENT_STR,
                        (CW_TYPES.SEARCH_FORWARD + CW_TYPES.SEARCH_IGCASE),
                        MatchLength);

    -- StrMatch returns the position in the string where the match was
    -- found if there was a match.  It returns zero for no match.
    if MatchLength = 0 then
      ErrCode := CW_SLCT.MarkRestorePos;
      return INTEGER (0);
    end if;

    ErrCode := CW_SLCT.MarkRestorePos;
    CW_LANG.Ext_Insert_Indented_EOL;
    CW_EDIT.BufInsertChar (ASCII.HT);
    return INTEGER (1);

  end Ada_Indent;

end ADA_SUPPORT_2;

