-- Copyright (c) 1994 ARINC Research Corporation
-- From material copyright (c) 1991, 1992 Premia Corporation
--
-- This material may be reproduced by or for the US Government pursuant 
-- to the copyright license under DFAR Clause 252.227-7013 (1988)
--
-- Developed for US Air Force under contract no. F41608-90-D-0544-0005
--
-- MODIFICATIONS
--   94/06 - J. Neuse, SD/OSE/EA  - Initial code
--   94/10 - O. Sluder, SD/OSE/EA - Cleanup

with WINTYPES;

-- *******************
-- *                 *
-- *  Error_Parsers  *  SPEC
-- *                 *
-- *******************

package Error_Parsers is

  -- The following pragmas are required by the Meridian OpenAda for
  -- Windows 2.0 compiler in the package spec and body of code to be
  -- included in a DLL, or an application calling the DLL will 
  -- general protection fault
  pragma SUPPRESS (elaboration_check);
  pragma SUPPRESS (storage_check);

  -- The following pragma is required by the Meridian OpenAda for 
  -- Windows 2.0 compiler in the package spec of code to used in a DLL
  -- to properly export function names; its scope continues to the next 
  -- use of the pragma
  pragma runtime_names (windows);

  -- ..........
  -- .        .
  -- .  Init  .  SPEC
  -- .        .
  -- ..........

  procedure Init;

  -- .............
  -- .           .
  -- .  LibMain  .  SPEC
  -- .           .
  -- .............

  function LibMain (hModule     : in WINTYPES.HANDLE;
                    wDataSeg    : in WINTYPES.WORD;
                    cbHeapSize  : in WINTYPES.WORD;
                    lpszCmdLine : in WINTYPES.LPSTR) return INTEGER;

  -- .........
  -- .       .
  -- .  WEP  .  SPEC
  -- .       .
  -- .........

  function WEP (bSystemExit : in INTEGER) return INTEGER;

  -- ......................
  -- .	 	       	       	.
  -- .  MeridianErrorInfo .  SPEC
  -- .       	  	       	.
  -- ......................

  function MeridianErrorInfo return INTEGER;

  -- ....................
  -- .	 	       	      .
  -- .  JanusErrorInfo  .  SPEC
  -- .       	  	      .
  -- ....................

  function JanusErrorInfo return INTEGER;

end Error_Parsers;
