-- Copyright (c) 1994 ARINC Research Corporation
-- From material copyright (c) 1991, 1992 Premia Corporation
--
-- This material may be reproduced by or for the US Government pursuant 
-- to the copyright license under DFAR Clause 252.227-7013 (1988)
--
-- Developed for US Air Force under contract no. F41608-90-D-0544-0005
--
-- MODIFICATIONS
--   94/06 - J. Neuse, SD/OSE/EA  - Initial code
--   94/10 - O. Sluder, SD/OSE/EA - Cleanup

with CW_BFEX;
with CW_CURS;
with CW_EDSY;
with CW_PARS;
with CW_SRCH;
with CW_TYPES;
with SYSTEM;

-- *******************
-- *                 *
-- *  Error_Parsers  *  BODY
-- *                 *
-- *******************

package body Error_Parsers is

  -- The following pragmas are required by the Meridian OpenAda for
  -- Windows 2.0 compiler in the package spec and body of code to be
  -- included in a DLL, or an application calling the DLL will 
  -- general protection fault
  pragma SUPPRESS (elaboration_check);
  pragma SUPPRESS (storage_check);

  PARSER_COUNT   : constant := 2;
	
  Parser_Names   : array (1 .. Parser_Count) of CW_TYPES.LPSTR;
  Janus_Filename : STRING (1 .. 40);

  -- ..........
  -- .        .
  -- .  Init  .  BODY
  -- .        .
  -- ..........

  procedure Init is

  begin

    for i in Janus_Filename'FIRST .. Janus_Filename'LAST loop
      Janus_Filename (i) := ' ';
    end loop;

    Parser_Names := ((new STRING'("Meridian")), (new STRING'("Janus")));

    for i in 1 .. PARSER_COUNT loop
      CW_EDSY.LibExport ("int _" & Parser_Names (i).all & "ErrorInfo");
      CW_PARS.AddErrorInfoName ("_" & Parser_Names (i).all & "ErrorInfo");
    end loop;

  end Init;

  -- .............
  -- .           .
  -- .  LibMain  .  BODY
  -- .           .
  -- .............

  function LibMain (hModule     : in WINTYPES.HANDLE;
                    wDataSeg    : in WINTYPES.WORD;
                    cbHeapSize  : in WINTYPES.WORD;
                    lpszCmdLine : in WINTYPES.LPSTR) return INTEGER is

    -- .........................
    -- .                       .
    -- .  Setup_Init_Callback  .  SPEC
    -- .                       .
    -- .........................

    procedure Setup_Init_Callback (pfnInit_Callback : in SYSTEM.ADDRESS);

    pragma INTERFACE (microsoft_c, Setup_Init_Callback);

    -- ......................................
    -- .                       	    	      .
    -- .  Setup_MeridianErrorInfo_Callback  .  SPEC
    -- .                                    .
    -- ......................................

    procedure Setup_MeridianErrorInfo_Callback
       (pfnMeridianErrorInfo_Callback : in SYSTEM.ADDRESS);

    pragma INTERFACE (microsoft_c, Setup_MeridianErrorInfo_Callback);

    -- ...................................
    -- .                       	    	   .
    -- .  Setup_JanusErrorInfo_Callback  .  SPEC
    -- .                                 .
    -- ...................................

    procedure Setup_JanusErrorInfo_Callback
       (pfnJanusErrorInfo_Callback : in SYSTEM.ADDRESS);

    pragma INTERFACE (microsoft_c, Setup_JanusErrorInfo_Callback);

  begin
    Setup_Init_Callback (Init'ADDRESS);
    Setup_MeridianErrorInfo_Callback (Error_Parsers.MeridianErrorInfo'ADDRESS);
    Setup_JanusErrorInfo_Callback (Error_Parsers.JanusErrorInfo'ADDRESS);
    return 1;
  end LibMain;

  -- .........
  -- .       .
  -- .  WEP  .  BODY
  -- .       .
  -- .........

  function WEP (bSystemExit : in INTEGER) return INTEGER is

  begin
    return 1;
  end WEP;

  -- ..............
  -- .	 	       	.
  -- .  FindChar  .  BODY
  -- .       	  	.
  -- ..............

  function FindChar (Start : in INTEGER;
                     Char  : in CHARACTER;
                     Str   : in STRING) return INTEGER is

    i : integer := Start;

  begin --  function FindChar

    while Str (i) /= Char loop
      i := i + 1;
    end loop;

    return i;

  end FindChar;

  -- .......................
  -- .	 	       	       	 .
  -- .  MeridianErrorInfo  .  BODY
  -- .       	  	       	 .
  -- .......................
  --
  -- NOTES:
  -- 1.	Meridian error lines take the following format:
  --	   filename(nn)error message
  -- 2. Meridian warning lines take the following format:
  --	   filename(nn)warning warning message
  -- 3. Meridian compiler errors take the following format:
  --	   *** Compiler Error

  function MeridianErrorInfo return INTEGER is

    Error_Str   : CW_TYPES.LPSTR;
    Str_Found   : BOOLEAN;
    MatchLength : LONG_INTEGER   := 0;
    Flags       : CW_TYPES.DWORD := 0;
    MsgStr      : STRING (1 .. 256);
    j           : INTEGER := 0;
    i           : INTEGER := 0;
    Err_File    : SYSTEM.ADDRESS;
    Err_Line    : LONG_INTEGER;
    Err_Col     : LONG_INTEGER;
    Err_Msg     : SYSTEM.ADDRESS;
    Mov_Bool    : BOOLEAN;

  begin --  function MeridianErrorInfo

    --  Set up the search control flags.
    Flags := CW_TYPES."+" (CW_TYPES.SEARCH_FORWARD, CW_TYPES.SEARCH_IGCASE);

    Str_Found := CW_SRCH.SrchFind ("No errors detected.", Flags,
                                   MatchLength'ADDRESS);

    if Str_Found then
      return INTEGER (0);
    end if;

    Str_Found := CW_SRCH.SrchFind ("*** Compiler Error", Flags,
                                   MatchLength'ADDRESS);
    if Str_Found then
      Mov_Bool := CW_CURS.MovHome;
      CW_BFEX.BufReadStr (MsgStr);
      Mov_Bool := CW_CURS.MovEOL;
      j        := FindChar (1, ASCII.CR, MsgStr) - 1;
      Err_File := CW_PARS.ErrorSrcFile ("");
      Err_Line := CW_PARS.ErrorLine (LONG_INTEGER (0));
      Err_Col  := CW_PARS.ErrorColumn (LONG_INTEGER (0));
      Err_Msg  := CW_PARS.ErrorMsgLine (MsgStr (1 .. j));
      return INTEGER (2);
    end if;

    Flags := CW_TYPES."+" (CW_TYPES.SEARCH_FORWARD, CW_TYPES.SEARCH_REGEX);
    Flags := CW_TYPES."+" (Flags, CW_TYPES.SEARCH_IGCASE);

    Error_Str := new STRING'("\([0-9]+\)");

    Str_Found := CW_SRCH.SrchFind (error_str.all, Flags, MatchLength'ADDRESS);

    if Str_Found then
      Mov_Bool := CW_CURS.MovHome;
      CW_BFEX.BufReadStr (MsgStr);
      Mov_Bool := CW_CURS.MovEOL;
      --  Locate the slice containing the filename.
      j := 1;
      j := FindChar (j, '(', MsgStr) - 1;
      --  Pass the name of the file containing the error back to CW.
      Err_File := CW_PARS.ErrorSrcFile (MsgStr (1 .. j));
      --  Locate the slice containing the error line number.
      i := j + 2;
      j := FindChar (i, ')', MsgStr) - 1;
      --  Pass the line containing the error back to CW.
      Err_Line := CW_PARS.ErrorLine (LONG_INTEGER'VALUE (MsgStr (i .. j)));
      --  Pass the column of the error back to CW.
      Err_Col := CW_PARS.ErrorColumn (LONG_INTEGER (0));
      --  Locate the slice containing the error message.
      i       := j + 2;
      j       := FindChar (i, ASCII.CR, MsgStr) - 1;
      Err_Msg := CW_PARS.ErrorMsgLine (MsgStr (i .. j));

      if MsgStr (i .. (i + 6)) = "warning" then
        return INTEGER (1);
      else
        return INTEGER (2);
      end if;

    end if;

    return INTEGER (0);

  end MeridianErrorInfo;

  -- ....................
  -- .	 	       	      .
  -- .  JanusErrorInfo  .  BODY
  -- .       	  	      .
  -- ....................
  --
  -- NOTES:
  -- This parser parses the BRIEF and VERBOSE output of the Janus compiler.

  function JanusErrorInfo return INTEGER is

    Error_Str   : CW_TYPES.LPSTR;
    Str_Found   : BOOLEAN;
    MatchLength : LONG_INTEGER   := 0;
    Flags       : CW_TYPES.DWORD := 0;
    MsgStr      : STRING (1 .. 256);
    j           : INTEGER := 0;
    i           : INTEGER := 0;
    Err_File    : SYSTEM.ADDRESS;
    Err_Line    : LONG_INTEGER;
    Err_Col     : LONG_INTEGER;
    Err_Msg     : SYSTEM.ADDRESS;
    Mov_Bool    : BOOLEAN;
    Fatal_Error : BOOLEAN := FALSE;

  begin --  function JanusErrorInfo

    --  Set up the search control flags.
    Flags := CW_TYPES."+" (CW_TYPES.SEARCH_FORWARD, CW_TYPES.SEARCH_IGCASE);

    Str_Found := CW_SRCH.SrchFind ("Input File Is", Flags, MatchLength'ADDRESS);

    if Str_Found then

      Mov_Bool := CW_CURS.MovHome;
      CW_BFEX.BufReadStr (MsgStr);
      Mov_Bool := CW_CURS.MovEOL;
      --  Locate the slice containing the filename.
      i := 1;
      i := FindChar (i, 's', MsgStr) + 2;
      j := FindChar (i, ASCII.CR, MsgStr) - 1;
      Janus_Filename (1 .. (j - i + 1)) := MsgStr (i .. j);
      Janus_Filename (j - 1 + 2)        := ASCII.CR;
    end if;

    Flags := CW_TYPES."+" (CW_TYPES.SEARCH_FORWARD, CW_TYPES.SEARCH_REGEX);
    Flags := CW_TYPES."+" (Flags, CW_TYPES.SEARCH_IGCASE);

    Error_Str := new STRING'("((\*WARNING\*|\*SYNTAX ERROR\*)|" &
                       "(\*ERROR\*|\*FATAL ERROR\*))");

    Str_Found := CW_SRCH.SrchFind (error_str.all, Flags, MatchLength'ADDRESS);

    if Str_Found then

      --  Locate the filename in Janus_Filename.
      j := FindChar (1, ASCII.CR, Janus_Filename) - 1;
      --  Pass the name of the file containing the error back to CW.
      Err_File := CW_PARS.ErrorSrcFile (Janus_Filename (1 .. j));

      Mov_Bool := CW_CURS.MovUp (LONG_INTEGER (1));
      Mov_Bool := CW_CURS.MovHome;
      CW_BFEX.BufReadStr (MsgStr);


      if (MsgStr (1) /= '-') then

        --  Process *FATAL ERROR* message.
        --  Set Error Column
        Err_Col := CW_PARS.ErrorColumn (LONG_INTEGER (1));
        --  Position cursor to retrieve line number.
        Mov_Bool := CW_CURS.MovDown (LONG_INTEGER (1));
        Mov_Bool := CW_CURS.MovHome;
        CW_BFEX.BufReadStr (MsgStr);
        --  Extract line number from error.
        i := 1;
        while MsgStr (i) not in '0' .. '9' loop
          i := i + 1;
        end loop;
        j := FindChar (i, ASCII.CR, MsgStr) - 1;
        --  Pass the line containing the error back to CW.
        Err_Line    := CW_PARS.ErrorLine (LONG_INTEGER'VALUE (MsgStr (i .. j)));
        Mov_Bool    := CW_CURS.MovDown (LONG_INTEGER (1));
        Fatal_Error := TRUE;

      elsif MsgStr (7 .. 10) = "Line" then

        --  Process Brief output.
        --  Locate the slice containing the error line number.
        i := 14; --  The Line Number starts here for the Brief output,
        --  Pass I.
        --  Locate line number for other passes.
        while MsgStr (i) not in '0' .. '9' loop
          i := i + 1;
        end loop;
        j := FindChar (i, ' ', MsgStr) - 1;
        --  Pass the line containing the error back to CW.
        Err_Line := CW_PARS.ErrorLine (LONG_INTEGER'VALUE (MsgStr (i .. j)));

        --  Locate the slice containing the error column.
        i := FindChar (j, '-', MsgStr) + 2;
        j := FindChar (i, ASCII.CR, MsgStr) - 1;
        --  Pass the column of the error back to CW.
        Err_Col := CW_PARS.ErrorColumn (LONG_INTEGER'VALUE (MsgStr (i .. j)));

        Mov_Bool := CW_CURS.MovDown (LONG_INTEGER (1));

      else

        --  Process Verbose compiler output.
        --  Find the caret indicating the position.
        j := FindChar (1, '^', MsgStr) - 8;
        --  Pass the column of the error back to CW.
        Err_Col := CW_PARS.ErrorColumn (LONG_INTEGER (j));

        Mov_Bool := CW_CURS.MovUp (LONG_INTEGER (4));
        Mov_Bool := CW_CURS.MovHome;
        CW_BFEX.BufReadStr (MsgStr);

        --  Find the line number.
        i := FindChar (1, '.', MsgStr);
        i := FindChar (i, 'e', MsgStr) + 2;
        j := FindChar (i, ASCII.CR, MsgStr) - 1;
        --  Pass the line containing the error back to CW.
        Err_Line := CW_PARS.ErrorLine (LONG_INTEGER'VALUE (MsgStr (i .. j)));

        Mov_Bool := CW_CURS.MovDown (LONG_INTEGER (5));

      end if;

      Mov_Bool := CW_CURS.MovHome;
      CW_BFEX.BufReadStr (MsgStr);

      --  Locate the slice containing the error message.
      j := FindChar (1, ASCII.CR, MsgStr) - 1;
      if Fatal_Error then
        Err_Msg := CW_PARS.ErrorMsgLine ("*FATAL ERROR* " & MsgStr (1 .. j));
      else
        Err_Msg := CW_PARS.ErrorMsgLine (MsgStr (1 .. j));
      end if;

      Mov_Bool := CW_CURS.MovEOL;

      if MsgStr (2 .. 8) = "WARNING" then
        return INTEGER (1);
      else
        return INTEGER (2);
      end if;

    end if;

    return INTEGER (0);

  end JanusErrorInfo;

end Error_Parsers;
