-- Copyright (c) 1994 ARINC Research Corporation
-- From material copyright (c) 1991, 1992 Premia Corporation
--
-- This material may be reproduced by or for the US Government pursuant 
-- to the copyright license under DFAR Clause 252.227-7013 (1988)
--
-- Developed for US Air Force under contract no. F41608-90-D-0544-0005
--
-- MODIFICATIONS
--   94/06 - J. Neuse, SD/OSE/EA  - Initial code
--   94/10 - O. Sluder, SD/OSE/EA - Cleanup

with CW_TYPES;

-- *************
-- *           *
-- *  CW_ATTR  *  SPEC
-- *           *
-- *************

package CW_ATTR is

  -- The following pragmas are required by the Meridian OpenAda for
  -- Windows 2.0 compiler in the package spec and body of code to be
  -- included in a DLL, or an application calling the DLL will 
  -- general protection fault
  pragma SUPPRESS (elaboration_check);
  pragma SUPPRESS (storage_check);

  -- .....................
  -- .                   .
  -- .  AttrFindVisible  .  SPEC
  -- .                   .
  -- .....................

  function AttrFindVisible (visAttr  : in INTEGER;
                            forward  : in BOOLEAN;
                            matching : in BOOLEAN) return BOOLEAN;

  -- ..................
  -- .                .
  -- .  AttrSetColor  .  SPEC
  -- .                .
  -- ..................

  procedure AttrSetColor (fline : in long_integer;
                          lline : in long_integer;
                          fcol  : in long_integer;
                          lcol  : in long_integer;
                          color : in integer);

  -- ....................
  -- .                  .
  -- .  AttrSetVisible  .  SPEC
  -- .                  .
  -- ....................

  procedure AttrSetVisible (first   : in CW_TYPES.DWORD;
                            last    : in W_TYPES.DWORD;
                            visAttr : in INTEGER);

  -- ..........
  -- .        .
  -- .  Grep  .  SPEC
  -- .        .
  -- ..........

  function Grep (str : in string) return LONG_INTEGER;

end CW_ATTR;
