-- Copyright (c) 1994 ARINC Research Corporation
-- From material copyright (c) 1991, 1992 Premia Corporation
--
-- This material may be reproduced by or for the US Government pursuant 
-- to the copyright license under DFAR Clause 252.227-7013 (1988)
--
-- Developed for US Air Force under contract no. F41608-90-D-0544-0005
--
-- MODIFICATIONS
--   94/06 - J. Neuse, SD/OSE/EA  - Initial code
--   94/10 - O. Sluder, SD/OSE/EA - Cleanup

with SYSTEM;

-- *************
-- *           *
-- *  CW_ATTR  *  BODY
-- *           *
-- *************

package body CW_ATTR is

  -- The following pragmas are required by the Meridian OpenAda for
  -- Windows 2.0 compiler in the package spec and body of code to be
  -- included in a DLL, or an application calling the DLL will 
  -- general protection fault
  pragma SUPPRESS (elaboration_check);
  pragma SUPPRESS (storage_check);

  -- .....................
  -- .                   .
  -- .  AttrFindVisible  .  BODY
  -- .                   .
  -- .....................

  function AttrFindVisible (visAttr  : in INTEGER;
                            forward  : in BOOLEAN;
                            matching : in BOOLEAN) return BOOLEAN is

    Pass_forward  : INTEGER;
    Pass_Matching : INTEGER;
    Return_Int    : INTEGER;

    -- ........................
    -- .                      .
    -- .  CW_AttrFindVisible  .  SPEC
    -- .                      .
    -- ........................

    function CW_AttrFindVisible (visAttr  : in INTEGER;
                                 forward  : in INTEGER;
                                 matching : in INTEGER) return INTEGER;
    pragma INTERFACE (windows, CW_AttrFindVisible, "AttrFindVisible");

  begin --  function AttrFindVisible

    if forward then
      Pass_Forward := 1;
    else
      Pass_Forward := 0;
    end if;

    if matching then
      Pass_matching := 1;
    else
      Pass_matching := 0;
    end if;

    Return_Int := CW_AttrFindVisible (visAttr, Pass_forward, Pass_matching);
    return (Return_Int /= 0);

  end AttrFindVisible;

  -- ..................
  -- .                .
  -- .  AttrSetColor  .  BODY
  -- .                .
  -- ..................
  --
  -- NOTES
	--   Codewright's documentation on AttrSetColor (Programmer's
	--   Reference, page 85) implies that the largest value to be used 
	--   with this procedure is 16#7FFF_FFFF#. Therefore, we can use 
	--   Meridian's Long_Integer type in the Ada interface

  procedure AttrSetColor (fline : in long_integer;
                          lline : in long_integer;
                          fcol  : in long_integer;
                          lcol  : in long_integer;
                          color : in integer) is

    -- .....................
    -- .                   .
    -- .  CW_AttrSetColor  .  SPEC
    -- .                   .
    -- .....................

    procedure CW_AttrSetColor (fline : in CW_TYPES.DWORD;
                               lline : in CW_TYPES.DWORD;
                               fcol  : in CW_TYPES.DWORD;
                               lcol  : in CW_TYPES.DWORD;
                               color : in integer);
    pragma INTERFACE (windows, CW_AttrSetColor, "AttrSetColor");

  begin

    CW_AttrSetColor (CW_TYPES.DWORD (fline), CW_TYPES.DWORD (lline),
                     CW_TYPES.DWORD (fcol), CW_TYPES.DWORD (lcol), color);

  end AttrSetColor;

  -- ....................
  -- .                  .
  -- .  AttrSetVisible  .  BODY
  -- .                  .
  -- ....................

  procedure AttrSetVisible (first   : in CW_TYPES.DWORD;
                            last    : in CW_TYPES.DWORD;
                            visAttr : in INTEGER) is

    Pass_forward  : INTEGER;
    Pass_Matching : INTEGER;
    Return_Int    : INTEGER;

    -- .......................
    -- .                     .
    -- .  CW_AttrSetVisible  .  SPEC
    -- .                     .
    -- .......................

    procedure CW_AttrSetVisible (first   : in CW_TYPES.DWORD;
                                 last    : in CW_TYPES.DWORD;
                                 visAttr : in INTEGER);
    pragma INTERFACE (windows, CW_AttrSetVisible, "AttrSetVisible");

  begin --  function AttrSetVisible

    CW_AttrSetVisible (first, last, visAttr);

  end AttrSetVisible;

  -- ..........
  -- .        .
  -- .  Grep  .  BODY
  -- .        .
  -- ..........

  function Grep (str : in string) return LONG_INTEGER is

    Pass_LPSTR  : CW_TYPES.LPSTR;
    Return_Long : LONG_INTEGER;

    -- .............
    -- .           .
    -- .  CW_Grep  .  SPEC
    -- .           .
    -- .............

    function CW_Grep (str : in SYSTEM.ADDRESS) return LONG_INTEGER;
    pragma INTERFACE (windows, CW_Grep, "Grep");

  begin --  function Grep

    Pass_LPSTR  := new STRING'(str & ascii.nul);
    Return_Long := CW_Grep (Pass_LPSTR.all (Pass_LPSTR.all'FIRST)'ADDRESS);
    return Return_Long;

  end Grep;

end CW_ATTR;
