-- Copyright (c) 1994 ARINC Research Corporation
-- From material copyright (c) 1991, 1992 Premia Corporation
--
-- This material may be reproduced by or for the US Government pursuant 
-- to the copyright license under DFAR Clause 252.227-7013 (1988)
--
-- Developed for US Air Force under contract no. F41608-90-D-0544-0005
--
-- MODIFICATIONS
--   94/06 - J. Neuse, SD/OSE/EA  - Initial code
--   94/10 - O. Sluder, SD/OSE/EA - Cleanup

with CW_TYPES;
with SYSTEM;

-- *************
-- *           *
-- *  CW_COMP  *  BODY
-- *           *
-- *************

package body CW_COMP is

  -- The following pragmas are required by the Meridian OpenAda for
  -- Windows 2.0 compiler in the package spec and body of code to be
  -- included in a DLL, or an application calling the DLL will 
  -- general protection fault
  pragma SUPPRESS (elaboration_check);
  pragma SUPPRESS (storage_check);

  -- ....................
  -- .                  .
  -- .  CompilerNewExt  .  BODY
  -- .                  .
  -- ....................

  function CompilerNewExt (ext : in STRING) return BOOLEAN is

    Pass_LPSTR  : CW_TYPES.LPSTR;
    Return_Code : CW_TYPES.BOOL;

    -- .......................
    -- .                     .
    -- .  CW_CompilerNewExt  .  SPEC
    -- .                     .
    -- .......................

    function CW_CompilerNewExt (ext : in SYSTEM.ADDRESS) return CW_TYPES.BOOL;
    pragma INTERFACE (windows, CW_CompilerNewExt, "CompilerNewExt");

  begin

    Pass_LPSTR  := new STRING'(ext & ascii.nul);
    Return_Code :=
      CW_CompilerNewExt (Pass_LPSTR.all (Pass_LPSTR.all'FIRST)'ADDRESS);
    return TRUE;

  end CompilerNewExt;

end CW_COMP;
