-- Copyright (c) 1994 ARINC Research Corporation
-- From material copyright (c) 1991, 1992 Premia Corporation
--
-- This material may be reproduced by or for the US Government pursuant 
-- to the copyright license under DFAR Clause 252.227-7013 (1988)
--
-- Developed for US Air Force under contract no. F41608-90-D-0544-0005
--
-- MODIFICATIONS
--   94/06 - J. Neuse, SD/OSE/EA  - Initial code
--   94/10 - O. Sluder, SD/OSE/EA - Cleanup

-- *************
-- *           *
-- *  CW_CURS  *  BODY
-- *           *
-- *************

package body CW_CURS is

  -- The following pragmas are required by the Meridian OpenAda for
  -- Windows 2.0 compiler in the package spec and body of code to be
  -- included in a DLL, or an application calling the DLL will 
  -- general protection fault
  pragma SUPPRESS (elaboration_check);
  pragma SUPPRESS (storage_check);

  -- .............
  -- .           .
  -- .  MovDown  .  BODY
  -- .           .
  -- .............

  function MovDown (lines : in LONG_INTEGER) return BOOLEAN is

    Return_Int : INTEGER;

    -- ................
    -- .              .
    -- .  CW_MovDown  .  SPEC
    -- .              .
    -- ................

    function CW_MovDown (lines : in LONG_INTEGER) return INTEGER;
    pragma INTERFACE (windows, CW_MovDown, "MovDown");

  begin -- function MovDown

    Return_Int := CW_MovDown (lines);
    return (Return_Int /= 0);

  end MovDown;

  -- ............
  -- .          .
  -- .  MovEOF  .  BODY
  -- .          .
  -- ............

  function MovEOF return BOOLEAN is

    Return_Int : INTEGER;

    -- ...............
    -- .             .
    -- .  CW_MovEOF  .  SPEC
    -- .             .
    -- ...............

    function CW_MovEOF return INTEGER;
    pragma INTERFACE (windows, CW_MovEOF, "MovEOF");

  begin -- function MovEOF

    Return_Int := CW_MovEOF;
    return (Return_Int /= 0);

  end MovEOF;

  -- ............
  -- .          .
  -- .  MovEOL  .  BODY
  -- .          .
  -- ............

  function MovEOL return BOOLEAN is

    Return_Int : INTEGER;

    -- ...............
    -- .             .
    -- .  CW_MovEOL  .  SPEC
    -- .             .
    -- ...............

    function CW_MovEOL return INTEGER;
    pragma INTERFACE (windows, CW_MovEOL, "MovEOL");

  begin -- function MovEOL

    Return_Int := CW_MovEOL;
    return (Return_Int /= 0);

  end MovEOL;

  -- .............
  -- .           .
  -- .  MovHome  .  BODY
  -- .           .
  -- .............

  function MovHome return BOOLEAN is

    Return_Int : INTEGER;

    -- ................
    -- .              .
    -- .  CW_MovHome  .  SPEC
    -- .              .
    -- ................

    function CW_MovHome return INTEGER;
    pragma INTERFACE (windows, CW_MovHome, "MovHome");

  begin -- function MovHome

    Return_Int := CW_MovHome;
    return (Return_Int /= 0);

  end MovHome;

  -- .................
  -- .               .
  -- .  MovPrevChar  .  BODY
  -- .               .
  -- .................

  function MovPrevChar (chars : in LONG_INTEGER) return BOOLEAN is

    Return_Int : INTEGER;

    -- ....................
    -- .                  .
    -- .  CW_MovPrevChar  .  SPEC
    -- .                  .
    -- ....................

    function CW_MovPrevChar (chars : in LONG_INTEGER) return INTEGER;
    pragma INTERFACE (windows, CW_MovPrevChar, "MovPrevChar");

  begin -- function MovPrevChar

    Return_Int := CW_MovPrevChar (chars);
    return (Return_Int /= 0);

  end MovPrevChar;

  -- ...............
  -- .             .
  -- .  MovTopBuf  .  BODY
  -- .             .
  -- ...............

  function MovTopBuf return BOOLEAN is

    Return_Int : INTEGER;

    -- ..................
    -- .                .
    -- .  CW_MovTopBuf  .  SPEC
    -- .                .
    -- ..................

    function CW_MovTopBuf return INTEGER;
    pragma INTERFACE (windows, CW_MovTopBuf, "MovTopBuf");

  begin -- function MovTopBuf

    Return_Int := CW_MovTopBuf;
    return (Return_Int /= 0);

  end MovTopBuf;

  -- ...........
  -- .         .
  -- .  MovUp  .  BODY
  -- .         .
  -- ...........

  function MovUp (lines : in LONG_INTEGER) return BOOLEAN is

    Return_Int : INTEGER;

    -- ..............
    -- .            .
    -- .  CW_MovUp  .  SPEC
    -- .            .
    -- ..............

    function CW_MovUp (lines : in LONG_INTEGER) return INTEGER;
    pragma INTERFACE (windows, CW_MovUp, "MovUp");

  begin -- function MovUp

    Return_Int := CW_MovUp (lines);
    return (Return_Int /= 0);

  end MovUp;

end CW_CURS;
