-- Copyright (c) 1994 ARINC Research Corporation
-- From material copyright (c) 1991, 1992 Premia Corporation
--
-- This material may be reproduced by or for the US Government pursuant 
-- to the copyright license under DFAR Clause 252.227-7013 (1988)
--
-- Developed for US Air Force under contract no. F41608-90-D-0544-0005
--
-- MODIFICATIONS
--   94/06 - J. Neuse, SD/OSE/EA  - Initial code
--   94/10 - O. Sluder, SD/OSE/EA - Cleanup

with SYSTEM;

-- *************
-- *           *
-- *  CW_EDSY  *  SPEC
-- *           *
-- *************

package CW_EDSY is

  -- The following pragmas are required by the Meridian OpenAda for
  -- Windows 2.0 compiler in the package spec and body of code to be
  -- included in a DLL, or an application calling the DLL will 
  -- general protection fault
  pragma SUPPRESS (elaboration_check);
  pragma SUPPRESS (storage_check);

  -- .....................
  -- .                   .
  -- .  ColorAlternate1  .  SPEC
  -- .                   .
  -- .....................

  function ColorAlternate1 (color : in integer) return integer;

  -- .....................
  -- .                   .
  -- .  ColorAlternate2  .  SPEC
  -- .                   .
  -- .....................

  function ColorAlternate2 (color : in integer) return integer;

  -- .....................
  -- .                   .
  -- .  ColorAlternate3  .  SPEC
  -- .                   .
  -- .....................

  function ColorAlternate3 (color : in integer) return integer;

  -- .....................
  -- .                   .
  -- .  ColorAlternate4  .  SPEC
  -- .                   .
  -- .....................

  function ColorAlternate4 (color : in integer) return integer;

  -- ...................
  -- .                 .
  -- .  ColorComments  .  SPEC
  -- .                 .
  -- ...................

  function ColorComments (color : in integer) return integer;

  -- ...................
  -- .                 .
  -- .  ColorKeywords  .  SPEC
  -- .                 .
  -- ...................

  function ColorKeywords (color : in integer) return integer;

  -- .....................
  -- .                   .
  -- .  HashCreateTable  .  SPEC
  -- .                   .
  -- .....................

  function HashCreateTable (entries  : in integer;
                            datasize : in integer;
                            mode     : in integer) return SYSTEM.ADDRESS;

  -- ...................
  -- .                 .
  -- .  HashFindEntry  .  SPEC
  -- .                 .
  -- ...................

  function HashFindEntry (hashTab : in SYSTEM.ADDRESS;
                          key     : in STRING;
                          keyLen  : in integer) return SYSTEM.ADDRESS;

  -- ..................
  -- .                .
  -- .  HashGetEntry  .  SPEC
  -- .                .
  -- ..................

  function HashGetEntry (hashTab : in SYSTEM.ADDRESS;
                         key     : in STRING;
                         keyLen  : in integer) return SYSTEM.ADDRESS;

  -- ...............
  -- .             .
  -- .  LibExport  .  SPEC
  -- .             .
  -- ...............

  procedure LibExport (execStr : in STRING);

end CW_EDSY;
