-- Copyright (c) 1994 ARINC Research Corporation
-- From material copyright (c) 1991, 1992 Premia Corporation
--
-- This material may be reproduced by or for the US Government pursuant 
-- to the copyright license under DFAR Clause 252.227-7013 (1988)
--
-- Developed for US Air Force under contract no. F41608-90-D-0544-0005
--
-- MODIFICATIONS
--   94/06 - J. Neuse, SD/OSE/EA  - Initial code
--   94/10 - O. Sluder, SD/OSE/EA - Cleanup

with CW_TYPES;

-- *************
-- *           *
-- *  CW_LANG  *  BODY
-- *           *
-- *************

package body CW_LANG is

  -- The following pragmas are required by the Meridian OpenAda for
  -- Windows 2.0 compiler in the package spec and body of code to be
  -- included in a DLL, or an application calling the DLL will 
  -- general protection fault
  pragma SUPPRESS (elaboration_check);
  pragma SUPPRESS (storage_check);

  -- .........................
  -- .                       .
  -- .  Ext_Assign_Template  .  BODY
  -- .                       .
  -- .........................

  procedure Ext_Assign_Template (Hash_Templates : in SYSTEM.ADDRESS;
                                 abbrev         : in STRING;
                                 template       : in STRING) is

    Pass_Abbrev   : CW_TYPES.LPSTR;
    Pass_Template : CW_TYPES.LPSTR;

    -- ............................
    -- .                          .
    -- .  CW_Ext_Assign_Template  .  SPEC
    -- .                          .
    -- ............................

    procedure CW_Ext_Assign_Template (Hash_Templates : in SYSTEM.ADDRESS;
                                      abbrev         : in SYSTEM.ADDRESS;
                                      template       : in SYSTEM.ADDRESS);
    pragma INTERFACE (windows, CW_Ext_Assign_Template, "_Ext_Assign_Template");

  begin

    Pass_Abbrev   := new STRING'(abbrev & ASCII.NUL);
    Pass_Template := new STRING'(template & ASCII.NUL);

    CW_Ext_Assign_Template
       (Hash_Templates, Pass_abbrev.all (Pass_abbrev.all'FIRST)'ADDRESS,
        Pass_template.all (Pass_template.all'FIRST)'ADDRESS);

  end Ext_Assign_Template;

  -- .........................
  -- .                       .
  -- .  Ext_Expand_Template  .  BODY
  -- .                       .
  -- .........................

  procedure Ext_Expand_Template (str : in STRING) is

    Pass_Str : CW_TYPES.LPSTR;

    -- ............................
    -- .                          .
    -- .  CW_Ext_Expand_Template  .  SPEC
    -- .                          .
    -- ............................

    procedure CW_Ext_Expand_Template (str : in SYSTEM.ADDRESS);
    pragma INTERFACE (windows, CW_Ext_Expand_Template, "_Ext_Expand_Template");

  begin

    Pass_Str := new STRING'(str & ASCII.NUL);

    CW_Ext_Expand_Template (Pass_Str.all (Pass_Str.all'FIRST)'ADDRESS);

  end Ext_Expand_Template;

  -- .............................
  -- .                         	 .
  -- .  Ext_Insert_Indented_EOL  .  BODY
  -- .                         	 .
  -- .............................

  procedure Ext_Insert_Indented_EOL is

    -- ................................
    -- .                            	.
    -- .  CW_Ext_Insert_Indented_EOL  .  SPEC
    -- .                              .
    -- ................................

    procedure CW_Ext_Insert_Indented_EOL;
    pragma INTERFACE (windows, CW_Ext_Insert_Indented_EOL,
                      "_Ext_Insert_Indented_EOL");

  begin

    CW_Ext_Insert_Indented_EOL;

  end Ext_Insert_Indented_EOL;

  -- ...........................
  -- .                         .
  -- .  ExtCommentSearchLimit  .  BODY
  -- .                         .
  -- ...........................

  function ExtCommentSearchLimit (limit : in LONG_INTEGER) return LONG_INTEGER
                                 is

    Return_Long : CW_TYPES.LONG;

    -- ..............................
    -- .                            .
    -- .  CW_ExtCommentSearchLimit  .  SPEC
    -- .                            .
    -- ..............................

    function CW_ExtCommentSearchLimit
       (limit : in CW_TYPES.LONG) return CW_TYPES.LONG;
    pragma INTERFACE (windows, CW_ExtCommentSearchLimit,
                      "ExtCommentSearchLimit");

  begin
    Return_Long := CW_ExtCommentSearchLimit (CW_TYPES.LONG (limit));

    return Long_Integer (Return_Long);
  end ExtCommentSearchLimit;

end CW_LANG;
