-- Copyright (c) 1994 ARINC Research Corporation
-- From material copyright (c) 1991, 1992 Premia Corporation
--
-- This material may be reproduced by or for the US Government pursuant 
-- to the copyright license under DFAR Clause 252.227-7013 (1988)
--
-- Developed for US Air Force under contract no. F41608-90-D-0544-0005
--
-- MODIFICATIONS
--   94/06 - J. Neuse, SD/OSE/EA  - Initial code
--   94/10 - O. Sluder, SD/OSE/EA - Cleanup

with SYSTEM;

-- *************
-- *           *
-- *  CW_PARS  *  SPEC
-- *           *
-- *************

package CW_PARS is

  -- The following pragmas are required by the Meridian OpenAda for
  -- Windows 2.0 compiler in the package spec and body of code to be
  -- included in a DLL, or an application calling the DLL will 
  -- general protection fault
  pragma SUPPRESS (elaboration_check);
  pragma SUPPRESS (storage_check);

  -- ......................
  -- .                    .
  -- .  AddErrorInfoName  .  SPEC
  -- .                    .
  -- ......................

  procedure AddErrorInfoName (errInfoName : in string);

  -- .................
  -- .               .
  -- .  ErrorColumn  .  SPEC
  -- .               .
  -- .................

  function ErrorColumn (column : in LONG_INTEGER) return LONG_INTEGER;

  -- ...............
  -- .             .
  -- .  ErrorLine  .  SPEC
  -- .             .
  -- ...............

  function ErrorLine (line : in LONG_INTEGER) return LONG_INTEGER;

  -- ..................
  -- .                .
  -- .  ErrorMsgLine  .  SPEC
  -- .                .
  -- ..................

  function ErrorMsgLine (errmsg : in STRING) return SYSTEM.ADDRESS;

  -- ..................
  -- .                .
  -- .  ErrorSrcFile  .  SPEC
  -- .                .
  -- ..................

  function ErrorSrcFile (fname : in STRING) return SYSTEM.ADDRESS;

end CW_PARS;
