-- Copyright (c) 1994 ARINC Research Corporation
-- From material copyright (c) 1991, 1992 Premia Corporation
--
-- This material may be reproduced by or for the US Government pursuant 
-- to the copyright license under DFAR Clause 252.227-7013 (1988)
--
-- Developed for US Air Force under contract no. F41608-90-D-0544-0005
--
-- MODIFICATIONS
--   94/06 - J. Neuse, SD/OSE/EA  - Initial code
--   94/10 - O. Sluder, SD/OSE/EA - Cleanup

with CW_TYPES;

-- *************
-- *           *
-- *  CW_PARS  *  BODY
-- *           *
-- *************

package body CW_PARS is

  -- The following pragmas are required by the Meridian OpenAda for
  -- Windows 2.0 compiler in the package spec and body of code to be
  -- included in a DLL, or an application calling the DLL will 
  -- general protection fault
  pragma SUPPRESS (elaboration_check);
  pragma SUPPRESS (storage_check);

  -- ......................
  -- .                    .
  -- .  AddErrorInfoName  .  SPEC
  -- .                    .
  -- ......................

  procedure AddErrorInfoName (errInfoName : in string) is

    Pass_LPSTR : CW_TYPES.LPSTR;

    -- .........................
    -- .                       .
    -- .  CW_AddErrorInfoName  .  SPEC
    -- .                       .
    -- .........................

    procedure CW_AddErrorInfoName (errInfoName : in SYSTEM.ADDRESS);
    pragma INTERFACE (windows, CW_AddErrorInfoName, "_AddErrorInfoName");

  begin --  procedure AddErrorInfoName

    Pass_LPSTR := new STRING'(errInfoName & ascii.nul);
    CW_AddErrorInfoName (Pass_LPSTR.all (Pass_LPSTR.all'FIRST)'ADDRESS);

  end AddErrorInfoName;

  -- .................
  -- .               .
  -- .  ErrorColumn  .  BODY
  -- .               .
  -- .................

  function ErrorColumn (column : in LONG_INTEGER) return LONG_INTEGER is

    Return_Long : LONG_INTEGER;

    -- ....................
    -- .                  .
    -- .  CW_ErrorColumn  .  SPEC
    -- .                  .
    -- ....................

    function CW_ErrorColumn (column : in LONG_INTEGER) return LONG_INTEGER;
    pragma INTERFACE (windows, CW_ErrorColumn, "ErrorColumn");

  begin -- function ErrorColumn

    Return_Long := CW_ErrorColumn (column);

    return Return_Long;

  end ErrorColumn;

  -- ...............
  -- .             .
  -- .  ErrorLine  .  BODY
  -- .             .
  -- ...............

  function ErrorLine (line : in LONG_INTEGER) return LONG_INTEGER is

    Return_Long : LONG_INTEGER;

    -- ..................
    -- .                .
    -- .  CW_ErrorLine  .  SPEC
    -- .                .
    -- ..................

    function CW_ErrorLine (line : in LONG_INTEGER) return LONG_INTEGER;
    pragma INTERFACE (windows, CW_ErrorLine, "ErrorLine");

  begin -- function ErrorLine

    Return_Long := CW_ErrorLine (line);

    return Return_Long;

  end ErrorLine;

  -- ..................
  -- .                .
  -- .  ErrorMsgLine  .  BODY
  -- .                .
  -- ..................

  function ErrorMsgLine (errmsg : in STRING) return SYSTEM.ADDRESS is

    Return_Addr : SYSTEM.ADDRESS;
    Pass_LPSTR  : CW_TYPES.LPSTR;

    -- .....................
    -- .                   .
    -- .  CW_ErrorMsgLine  .  SPEC
    -- .                   .
    -- .....................

    function CW_ErrorMsgLine (errmsg : in SYSTEM.ADDRESS) return SYSTEM.ADDRESS;
    pragma INTERFACE (windows, CW_ErrorMsgLine, "ErrorMsgLine");

  begin -- function ErrorMsgLine

    Pass_LPSTR  := new STRING'(errmsg & ascii.nul);
    Return_Addr :=
      CW_ErrorMsgLine (Pass_LPSTR.all (Pass_LPSTR.all'FIRST)'ADDRESS);
    return Return_Addr;

  end ErrorMsgLine;

  -- ..................
  -- .                .
  -- .  ErrorSrcFile  .  BODY
  -- .                .
  -- ..................

  function ErrorSrcFile (fname : in STRING) return SYSTEM.ADDRESS is

    Return_Addr : SYSTEM.ADDRESS;
    Pass_LPSTR  : CW_TYPES.LPSTR;

    -- .....................
    -- .                   .
    -- .  CW_ErrorSrcFile  .  SPEC
    -- .                   .
    -- .....................

    function CW_ErrorSrcFile (fname : in SYSTEM.ADDRESS) return SYSTEM.ADDRESS;
    pragma INTERFACE (windows, CW_ErrorSrcFile, "ErrorSrcFile");

  begin -- function ErrorSrcFile

    Pass_LPSTR  := new STRING'(fname & ascii.nul);
    Return_Addr :=
      CW_ErrorSrcFile (Pass_LPSTR.all (Pass_LPSTR.all'FIRST)'ADDRESS);
    return Return_Addr;

  end ErrorSrcFile;

end CW_PARS;
