-- Copyright (c) 1994 ARINC Research Corporation
-- From material copyright (c) 1991, 1992 Premia Corporation
--
-- This material may be reproduced by or for the US Government pursuant 
-- to the copyright license under DFAR Clause 252.227-7013 (1988)
--
-- Developed for US Air Force under contract no. F41608-90-D-0544-0005
--
-- MODIFICATIONS
--   94/06 - J. Neuse, SD/OSE/EA  - Initial code
--   94/10 - O. Sluder, SD/OSE/EA - Cleanup

-- *************
-- *           *
-- *  CW_SLCT  *  BODY
-- *           *
-- *************

package body CW_SLCT is

  -- The following pragmas are required by the Meridian OpenAda for
  -- Windows 2.0 compiler in the package spec and body of code to be
  -- included in a DLL, or an application calling the DLL will 
  -- general protection fault
  pragma SUPPRESS (elaboration_check);
  pragma SUPPRESS (storage_check);

  -- .................
  -- .               .
  -- .  MarkDropPos  .  BODY
  -- .               .
  -- .................

  function MarkDropPos (count : in INTEGER) return INTEGER is

    Return_Int : INTEGER;

    -- ....................
    -- .                  .
    -- .  CW_MarkDropPos  .  SPEC
    -- .                  .
    -- ....................

    function CW_MarkDropPos (count : in INTEGER) return INTEGER;
    pragma INTERFACE (windows, CW_MarkDropPos, "MarkDropPos");

  begin -- function MarkDropPos

    Return_Int := CW_MarkDropPos (count);
    return Return_Int;

  end MarkDropPos;

  -- ....................
  -- .                  .
  -- .  MarkRestorePos  .  BODY
  -- .                  .
  -- ....................

  function MarkRestorePos return INTEGER is

    Return_Int : INTEGER;

    -- .......................
    -- .                     .
    -- .  CW_MarkRestorePos  .  SPEC
    -- .                     .
    -- .......................

    function CW_MarkRestorePos return INTEGER;
    pragma INTERFACE (windows, CW_MarkRestorePos, "MarkRestorePos");

  begin -- function MarkRestorePos

    Return_Int := CW_MarkRestorePos;
    return Return_Int;

  end MarkRestorePos;

  -- .................
  -- .               .
  -- .  MarkSavePos  .  BODY
  -- .               .
  -- .................

  procedure MarkSavePos is

    -- ....................
    -- .                  .
    -- .  CW_MarkSavePos  .  SPEC
    -- .                  .
    -- ....................

    procedure CW_MarkSavePos;
    pragma INTERFACE (windows, CW_MarkSavePos, "MarkSavePos");

  begin -- function MarkSavPos

    CW_MarkSavePos;

  end MarkSavePos;

end CW_SLCT;
