-- Copyright (c) 1994 ARINC Research Corporation
-- From material copyright (c) 1991, 1992 Premia Corporation
--
-- This material may be reproduced by or for the US Government pursuant 
-- to the copyright license under DFAR Clause 252.227-7013 (1988)
--
-- Developed for US Air Force under contract no. F41608-90-D-0544-0005
--
-- MODIFICATIONS
--   94/06 - J. Neuse, SD/OSE/EA  - Initial code
--   94/10 - O. Sluder, SD/OSE/EA - Cleanup

with SYSTEM;

-- *************
-- *           *
-- *  CW_SMAN  *  SPEC
-- *           *
-- *************

package CW_SMAN is

  -- The following pragmas are required by the Meridian OpenAda for
  -- Windows 2.0 compiler in the package spec and body of code to be
  -- included in a DLL, or an application calling the DLL will 
  -- general protection fault
  pragma SUPPRESS (elaboration_check);
  pragma SUPPRESS (storage_check);

  -- ..................
  -- .	 	       	    .
  -- .  Addr_Str_Len  .  SPEC
  -- .       	  	    .
  -- ..................

  function Addr_Str_Len (Address : in SYSTEM.ADDRESS) return INTEGER;

  -- ....................
  -- .	 	       	      .
  -- .  Addr_To_String  .  BODY
  -- .       	  	      .
  -- ....................

  function Addr_To_String (Address : in SYSTEM.ADDRESS;
                           Length  : in INTEGER) return STRING;

  -- ..............
  -- .	 	       	.
  -- .  FindChar  .  SPEC
  -- .       	  	.
  -- ..............

  function FindChar (Start : in INTEGER;
                     Char  : in CHARACTER;
                     Str   : in STRING) return INTEGER;

  -- .............
  -- .           .
  -- .  StrFree  .  SPEC
  -- .           .
  -- .............

  procedure StrFree (Str_Address : in SYSTEM.ADDRESS);

  -- ..............
  -- .            .
  -- .  StrMatch  .  SPEC
  -- .            .
  -- ..............

  function StrMatch (pattern : in STRING;
                     str     : in STRING;
                     flags   : in INTEGER;
                     len     : in LONG_INTEGER) return LONG_INTEGER;

  -- ............
  -- .          .
  -- .  StrNew  .  SPEC
  -- .          .
  -- ............

  function StrNew (str : in STRING) return SYSTEM.ADDRESS;

  -- .............
  -- .           .
  -- .  StrTrim  .  SPEC
  -- .           .
  -- .............

  function StrTrim (Str  : in STRING;
                    cset : in STRING) return STRING;

end CW_SMAN;
