-- Copyright (c) 1994 ARINC Research Corporation
-- From material copyright (c) 1991, 1992 Premia Corporation
--
-- This material may be reproduced by or for the US Government pursuant 
-- to the copyright license under DFAR Clause 252.227-7013 (1988)
--
-- Developed for US Air Force under contract no. F41608-90-D-0544-0005
--
-- MODIFICATIONS
--   94/06 - J. Neuse, SD/OSE/EA  - Initial code
--   94/10 - O. Sluder, SD/OSE/EA - Cleanup

-- *************
-- *           *
-- *  CW_SRCH  *  BODY
-- *           *
-- *************

package body CW_SRCH is

  -- The following pragmas are required by the Meridian OpenAda for
  -- Windows 2.0 compiler in the package spec and body of code to be
  -- included in a DLL, or an application calling the DLL will 
  -- general protection fault
  pragma SUPPRESS (elaboration_check);
  pragma SUPPRESS (storage_check);

  -- ..............
  -- .            .
  -- .  SrchFind  .  BODY
  -- .            .
  -- ..............

  function SrchFind (sPattern      : in STRING;
                     sFlag         : in CW_TYPES.DWORD;
                     matchLen_Addr : in SYSTEM.ADDRESS) return BOOLEAN is

    Return_Bool : BOOLEAN;
    Pass_LPSTR  : CW_TYPES.LPSTR;
    Temp_Bool   : INTEGER;

    -- .................
    -- .               .
    -- .  CW_SrchFind  .  SPEC
    -- .               .
    -- .................

    function CW_SrchFind (sPattern : in SYSTEM.ADDRESS;
                          sFlag    : in CW_TYPES.DWORD;
                          matchLen : in SYSTEM.ADDRESS) return INTEGER;
    pragma INTERFACE (windows, CW_SrchFind, "SrchFind");

  begin -- function SrchFind

    Pass_LPSTR := new STRING'(sPattern & ascii.nul);
    Temp_Bool  := CW_SrchFind (Pass_LPSTR.all (Pass_LPSTR.all'FIRST)'ADDRESS,
                              sFlag, matchLen_Addr);
    Return_Bool := (Temp_Bool /= 0);
    return Return_Bool;

  end SrchFind;

end CW_SRCH;
