-- Copyright (c) 1994 ARINC Research Corporation
-- From material copyright (c) 1991, 1992 Premia Corporation
--
-- This material may be reproduced by or for the US Government pursuant 
-- to the copyright license under DFAR Clause 252.227-7013 (1988)
--
-- Developed for US Air Force under contract no. F41608-90-D-0544-0005
--
-- MODIFICATIONS
--   94/06 - J. Neuse, SD/OSE/EA  - Initial code
--   94/10 - O. Sluder, SD/OSE/EA - Cleanup

with CW_TYPES;

-- ************
-- *          *
-- *  CW_SYS  *  BODY
-- *          *
-- ************

package body CW_SYS is

  -- The following pragmas are required by the Meridian OpenAda for
  -- Windows 2.0 compiler in the package spec and body of code to be
  -- included in a DLL, or an application calling the DLL will 
  -- general protection fault
  pragma SUPPRESS (elaboration_check);
  pragma SUPPRESS (storage_check);

  -- ..............
  -- .            .
  -- .  MemAlloc  .  BODY
  -- .            .
  -- ..............

  function MemAlloc (size : in integer) return SYSTEM.ADDRESS is

    Return_LPVOID : CW_TYPES.LPVOID;

    -- .................
    -- .               .
    -- .  CW_MemAlloc  .  SPEC
    -- .               .
    -- .................

    function CW_MemAlloc (size : in integer) return CW_TYPES.LPVOID;
    pragma INTERFACE (windows, CW_MemAlloc, "MemAlloc");

  begin

    Return_LPVOID := CW_MemAlloc (size);
    return SYSTEM.ADDRESS (Return_LPVOID);

  end MemAlloc;

  -- .............
  -- .           .
  -- .  MemFree  .  BODY
  -- .           .
  -- .............

  procedure MemFree (blockptr : in SYSTEM.ADDRESS) is

    Pass_LPVOID : CW_TYPES.LPVOID;

    -- ................
    -- .              .
    -- .  CW_MemFree  .  SPEC
    -- .              .
    -- ................

    procedure CW_MemFree (blockptr : in CW_TYPES.LPVOID);
    pragma INTERFACE (windows, CW_MemFree, "MemFree");

  begin

    Pass_LPVOID := CW_TYPES.LPVOID (blockptr);
    CW_MemFree (Pass_LPVOID);

  end MemFree;

end CW_SYS;
