-- Copyright (c) 1994 ARINC Research Corporation
-- From material copyright (c) 1991, 1992 Premia Corporation
--
-- This material may be reproduced by or for the US Government pursuant 
-- to the copyright license under DFAR Clause 252.227-7013 (1988)
--
-- Developed for US Air Force under contract no. F41608-90-D-0544-0005
--
-- MODIFICATIONS
--   94/06 - J. Neuse, SD/OSE/EA  - Initial code
--   94/10 - O. Sluder, SD/OSE/EA - Cleanup

with SYSTEM;

-- **************
-- *            *
-- *  CW_Types  *  SPEC
-- *            *
-- **************

package CW_Types is

  -- The following pragmas are required by the Meridian OpenAda for
  -- Windows 2.0 compiler in the package spec and body of code to be
  -- included in a DLL, or an application calling the DLL will 
  -- general protection fault
  pragma SUPPRESS (elaboration_check);
  pragma SUPPRESS (storage_check);

  -- The following constants indicate the following functions in search
  -- operations:
	--
	--   SEARCH_IGCASE             : ignore character case
  --   SEARCH_FORWARD            : forward searches
	--   SEARCH_GLOBAL             : perform global replacement
	--   SEARCH_PROMPT             : prompt user
	--   SEARCH_REGEX              : perform a regex search
	--   SEARCH_SELECTION          : restrict search to selection
	--   SEARCH_WRAP               : search wraps to top of buffer
	--   SEARCH_MAXIMAL            : Maximal match flag
	--   SEARCH_ONCE               : do one replacement and return
	--   SEARCH_LOW_ALT_PRECEDENCE : alternation has a lower precedence
	--     lower than term
	--   SEARCH_SELECTION_AGAIN    : searching again in a selection
	--   SEARCH_PROMPT_SELECTION   : use selection as default prompt
	--   SEARCH_PROMPT_WORD        : use current word as default prompt
	--   SEARCH_HIGHLIGHT          : highlight the matching text
	--   SEARCH_RETAIN_HIGHLIGHT   : retain the highlight

  SEARCH_IGCASE             : constant := 16#0001#;
  SEARCH_FORWARD            : constant := 16#0002#;
  SEARCH_GLOBAL             : constant := 16#0004#;
  SEARCH_PROMPT             : constant := 16#0008#;
  SEARCH_REGEX              : constant := 16#0010#;
  SEARCH_SELECTION          : constant := 16#0020#;
  SEARCH_WRAP               : constant := 16#0040#;
  SEARCH_MAXIMAL            : constant := 16#0080#;
  SEARCH_ONCE               : constant := 16#0100#;
  SEARCH_LOW_ALT_PRECEDENCE : constant := 16#0200#;
  SEARCH_SELECTION_AGAIN    : constant := 16#0400#;
  SEARCH_PROMPT_SELECTION   : constant := 16#0800#;
  SEARCH_PROMPT_WORD        : constant := 16#1000#;
  SEARCH_HIGHLIGHT          : constant := 16#2000#;
  SEARCH_RETAIN_HIGHLIGHT   : constant := 16#4000#;

  EOF_CHAR : constant := 16#100#;

  ----------------------------------------------------------------------------
  --  Common C-like Type Definitions
  ----------------------------------------------------------------------------

  type short_unsigned_integer is  range 0 .. 65535;
  subtype unsigned_integer is short_unsigned_integer;
  type long_unsigned_integer is new long_integer;
  --	     old declaration, using access to string should be more versatile
  --  type    cstring                is access character;
  type cstring is access STRING;

  ----------------------------------------------------------------------------
  --  General Purpose Defines
  ----------------------------------------------------------------------------

  -- <<warning>> "NULL" renamed to "NUL"
  NUL : constant := 0;

  FALSE : constant := 0;
  TRUE  : constant := 1;

  subtype BOOL is integer;
  type BYTE is  range 0 .. 255;
  subtype WORD is unsigned_integer;
  subtype UINT is WORD;
  subtype LONG is long_integer;
  subtype DWORD is long_unsigned_integer; -- should be unsigned

  subtype LPSTR is cstring; -- modifyable string

  subtype LPVOID is system.address;

  subtype HANDLE is UINT;
  subtype HWND is HANDLE;

end CW_Types;
