-- Copyright (c) 1994 ARINC Research Corporation
-- From material copyright (c) 1991, 1992 Premia Corporation
--
-- This material may be reproduced by or for the US Government pursuant 
-- to the copyright license under DFAR Clause 252.227-7013 (1988)
--
-- Developed for US Air Force under contract no. F41608-90-D-0544-0005
--
-- MODIFICATIONS
--   94/06 - J. Neuse, SD/OSE/EA  - Initial code
--   94/10 - O. Sluder, SD/OSE/EA - Cleanup

with CW_TYPES;
with SYSTEM;

-- *************
-- *           *
-- *  CW_USER  *  BODY
-- *           *
-- *************

package body CW_USER is

  -- The following pragmas are required by the Meridian OpenAda for
  -- Windows 2.0 compiler in the package spec and body of code to be
  -- included in a DLL, or an application calling the DLL will 
  -- general protection fault
  pragma SUPPRESS (elaboration_check);
  pragma SUPPRESS (storage_check);

  -- ...............
  -- .             .
  -- .  MsgNotify  .  BODY
  -- .             .
  -- ...............

  procedure MsgNotify (str : in STRING) is

    Pass_LPSTR : CW_TYPES.LPSTR;

    -- ..................
    -- .                .
    -- .  CW_MsgNotify  .  SPEC
    -- .                .
    -- ..................

    procedure CW_MsgNotify (strptr : in SYSTEM.ADDRESS);
    pragma INTERFACE (windows, CW_MsgNotify, "MsgNotify");

  begin

    Pass_LPSTR := new STRING'(str & ascii.nul);
    CW_MsgNotify (Pass_LPSTR.all (Pass_LPSTR.all'FIRST)'ADDRESS);

  end MsgNotify;

end CW_USER;
