
STRSEP(3)                  UNIX Programmer's Manual                  STRSEP(3)

NNAAMMEE
     ssttrrsseepp - separate strings

SSYYNNOOPPSSIISS
     ##iinncclluuddee <<ssttrriinngg..hh>>

     _c_h_a_r _*
     ssttrrsseepp(_c_h_a_r _*_*_s_t_r_i_n_g_p, _c_h_a_r _*_d_e_l_i_m)

DDEESSCCRRIIPPTTIIOONN
     The ssttrrsseepp() locates in the null-terminated string at _*_s_t_r_i_n_g_p the first
     occurence of any character in _d_e_l_i_m and replaces this with a `\0',
     records the location of the immediate following character in _*_s_t_r_i_n_g_p,
     then returns the original value of _*_s_t_r_i_n_g_p. If no delimiter characters
     are found, ssttrrsseepp() sets _*_s_t_r_i_n_g_p to NULL; if _*_s_t_r_i_n_g_p is initially NULL,
     ssttrrsseepp() returns NULL.

EEXXAAMMPPLLEESS
     The following uses ssttrrsseepp() to parse strings containing runs of white
     space, making up an argument vector:

           char inputstring[100];
           char **argv[51], **ap = argv, *p, *val;
           /* set up inputstring */
           for (p = inputstring; p != NULL; ) {
                   while ((val = strsep(&p, " \t")) != NULL && *val == '\0');
                   *ap++ = val;
           }
           *ap = 0;

HHIISSTTOORRYY
     The ssttrrsseepp() function is currently under development.

BSD Experimental                April 19, 1991                               1





























