// Developer Helper Object Set, (C) 1994 Thomas E. Bednarz, Jr.
//  All rights reserved

/*

   This code fragment shows how to set up a simple demo program
   which will use a non-modal dialog box as the applications 
   main window.   Notice the use of the window class member
   getClassName, which is used in the automation of regisration
   with Presentation Manager.

    In all, about 50 lines of additional code on top of
    the Developer Helper Object set which will pop up
    a modal dialog box, which has a slider in it.
*/

#include "applicat.h"
#include "nmdlog.h"
#include"moddlog.h"
#include"slider.h"

#define APP_RESOURCE 201

//-------------------------------------------------------------------
//   This is the main application
class TDHOApp : public TApplication
{

   public:
      TDHOApp(ULONG)    
                  {;    };
      virtual void CreateMainWindow()    
                  {MainWin = new TTestNMDialog(fResource);};
      virtual const char *getClassName() 
                  {return "TDHOApp";};		 // used in registration with Pres. Man.
};

//-------------------------------------------------------------------
//   In this example, the Main Window is a non-modal dialog, derived
//    from the class TNonModalDialog.
class TTestNMDialog: public TNonModalDialog
{
   public:
     TTestNMDialog(ULONG resource):TNonModalDialog(resource) {;};
     virtual void doCommand(SHORT command)
               {
                   if (command == 202)
                   {
                      TTestModalDialog dlog(204,this);
                      dlog.Init();
                      dlog.Execute();
                   }
                  else if (command = 203)
                     WinPostMsg(hwndFrame, WM_QUIT, 0,0);
               }
      virtual const char *getClassName() 
                  {return "TTestNMDialog";};		 // used in registration with Pres. Man.
               
};


//-------------------------------------------------------------------
//    This is a modal dialog which is showing how to use a 
//       control class.
class TTestModalDialog: public TModalDialog
{
   protected:
      TSlider *fSlider;
   public:
      TTestModalDialog(ULONG resource, TWinBase *owner):
         TModalDialog(resource, owner, NULL) {;};
      virtual ~TTestModalDialog() {delete fSlider;};
      virtual void Init() { fSlider = new TSlider(this, 202);
                          fSlider->tickSize(7);
                          fSlider->placeAtTick(5);
                          fSlider->setTickText(0,"Slow");
                          fSlider->setTickText(5, "Default");
                          fSlider->setTickText(10, "Fast");
                          fSlider->DetentShaftCenter();
                         };

      virtual const char *getClassName() 
                  {return "TTestNModalDialog";};		 
                     // used in registration with Pres. Man.
 
};




//-------------------------------------------------------------------
//    the main function
INT main(void)
{
   TDHOApp app(APP_RESOURCE);     
   app.init();
   app.run();
}
