// Developer Helper Object Set, (C) 1994 Thomas E. Bednarz, Jr.
//  All rights reserved
#include"moddlog.h"

TModalDialog *tempTHIS;


//-------------------------------------------------------------------
//  TModalDialog
TModalDialog::TModalDialog(ULONG resource, TWinBase *owner, void *buffer):TWinBase(resource)
{
   fBuffer = buffer;
   fOwner = owner;
   tempTHIS = this;
   MakeFrame();
}


//-------------------------------------------------------------------
//  ~TModalDialog
TModalDialog::~TModalDialog()
{
   WinDestroyWindow(hwndFrame);
}
 

//-------------------------------------------------------------------
//  MakeFrame
BOOL TModalDialog::MakeFrame(void)
{
   hwndFrame = WinLoadDlg( HWND_DESKTOP,
			                fOwner->hwndFrame,
 			                (PFNWP)ClientDlogProc,
			                0,fResource,NULL);

   return (hwndFrame != (HWND)NULL);

}


//-------------------------------------------------------------------
//  Init
BOOL TModalDialog::Init(HAB hab)
{
   Init();
}


//-------------------------------------------------------------------
//  Init
void  TModalDialog::Init()
{

}


//-------------------------------------------------------------------
//  Execute
void TModalDialog::Execute()
{
   WinProcessDlg(hwndFrame);
}


//-------------------------------------------------------------------
//  getClassName
const char *TModalDialog::getClassName()
{
   return "TModalDialog";
}


//-------------------------------------------------------------------
//  DlogProc
MRESULT TModalDialog::DlogProc(HWND hWnd, ULONG Message, MPARAM mParam1, MPARAM mParam2 )
{
   switch (Message)
   {
   case WM_COMMAND:
       return doCommand(hWnd, Message, mParam1, mParam2);
      break;
   case WM_INITDLG:
         Init();
      break;
   default:
      return WinDefDlgProc(hWnd, Message, mParam1, mParam2);
   }
   return (MRESULT)FALSE;
}


//-------------------------------------------------------------------
//  doCommand
MRESULT TModalDialog::doCommand(HWND hWnd, ULONG Message, MPARAM mParam1, MPARAM mParam2)
{
   SHORT command = SHORT1FROMMP(mParam1);
   if (command = DID_OK)
   {
    if (doOK())
      WinDismissDlg(hwndFrame,1);
      return TRUE;
    }
   else if (command = DID_CANCEL)
   {
       doCancel();
      WinDismissDlg(hwndFrame,1);
      return TRUE;
   }
   else 
      return FALSE;
}


//-------------------------------------------------------------------
//  doOk
SHORT TModalDialog::doOK(void)
{
   SetData();
   return 1;
}


//-------------------------------------------------------------------
//  SetData
void TModalDialog::SetData()
{

}


//-------------------------------------------------------------------
//  doCancel
void TModalDialog::doCancel(void)
{

}


//-------------------------------------------------------------------
//  ClientDlogProc
MRESULT EXPENTRY TModalDialog::ClientDlogProc(HWND hWnd,ULONG iMessage,
    MPARAM mParam1, MPARAM mParam2)
{
 
    TModalDialog *pDialog = (TModalDialog *)WinQueryWindowULong(hWnd,0);

    if (pDialog == 0) 
    {
        if (iMessage == WM_INITDLG)
        {
            pDialog = tempTHIS;
            WinSetWindowULong(hWnd,0,(ULONG)pDialog);
            return pDialog->DlogProc(hWnd,iMessage,mParam1,mParam2);
        }
        else
            return WinDefDlgProc(hWnd,iMessage,mParam1,mParam2);
    } 
    else
        return pDialog->DlogProc(hWnd,iMessage,mParam1,mParam2);
}


