// Developer Helper Object Set, (C) 1994 Thomas E. Bednarz, Jr.
//  All rights reserved

#include"slider.h"
#include"winbase.h"
#include"object.h"
#define INCL_WIN
#define INCL_WINSTDSLIDER
#include<os2.h>


//-------------------------------------------------------------------
//   TSlider
TSlider::TSlider(TWinBase *parent, ULONG resource):
    TControl(parent, resource)
{

}


//-------------------------------------------------------------------
//   ~TSlider
TSlider::~TSlider()
{

}


//-------------------------------------------------------------------
//   placeAtTick
void TSlider::placeAtTick(SHORT no)
{
   SendMessage(SLM_SETSLIDERINFO,
                 MPFROM2SHORT(SMA_SLIDERARMPOSITION,
                                    SMA_INCREMENTVALUE),
                 (MPARAM)no);
}


//-------------------------------------------------------------------
//   tickSize
void TSlider::tickSize(SHORT pix)
{
   SendMessage(SLM_SETTICKSIZE,
                 MPFROM2SHORT(SMA_SETALLTICKS,
                                    pix),
                 (MPARAM)NULL);

}


//-------------------------------------------------------------------
//   setTickText
void TSlider::setTickText(SHORT tick, CHAR *text)
{
   SendMessage(SLM_SETSCALETEXT,
                 MPFROMSHORT(tick),
                 MPFROMP(text));

}


//-------------------------------------------------------------------
//   DetentShaftCenter
void TSlider::DetentShaftCenter(void)
{
   SHORT armpos = SendMessage(SLM_QUERYSLIDERINFO, MPFROM2SHORT(SMA_SLIDERARMPOSITION,
                 SMA_RANGEVALUE), NULL);

    SendMessage(SLM_ADDDETENT, MPFROMSHORT(armpos), NULL);
}



//-------------------------------------------------------------------
//   getSliderPos
USHORT TSlider::getSliderPos()
{
   return (USHORT) SendMessage(SLM_QUERYSLIDERINFO,
                                MPFROM2SHORT(SMA_SLIDERARMPOSITION,SMA_INCREMENTVALUE),
                                (MPARAM)NULL);

}


//-------------------------------------------------------------------
//   getClassName
const char *TSlider::getClassName()
{
   return "TSlider";
}
