/* 
 * this sample source will give you an idea on how to
 * call up the various library functions. -SW
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <time.h>
#include "des3.h"

#define BUFSIZE 4096

static char Usage[] = "des [-]{d|e}[2|3] infile outfile key";

int main(int argc, char **argv)
{
  register uchar *b, *buf, c, key[8], key2[16], key3[24];
  register int i,j,len,what,mode;
  register time_t t, t1;
  FILE *ih, *oh;
  if(argc == 5) {
    switch (c = *argv[1] == '-' ? *++argv[1] : *argv[1]) {
      case 'e': case 'E': what = 0; break;
      case 'd': case 'D': what = 1; break;
      default : fprintf(stderr,"des : illegal option %c \n",c);
   	   	fprintf(stderr,"Usage : %s \n",Usage);
   	   	return 1;
    }
    switch(*++argv[1]) {
      case '2': mode = 2; break;
      case '3': mode = 3; break;
      default : mode = 1;
    }
  } else {
    fprintf(stderr,"Usage : %s \n",Usage);
    return 1;
  }
  if ((buf = (uchar *) malloc(BUFSIZE)) == NULL) {
    fprintf(stderr,"Error: Cannot alloc memory !\n");
    return 1;
  }                                          
  ih =  fopen(argv[2],"rb"); 
  oh = fopen(argv[3],"wb");
  if (ih == NULL || oh == NULL) {
    perror(ih ? argv[3]:argv[2]);
    return 1;
  }
  if (mode == 1) {
    memset(key,0,8);
    len = strlen(argv[4]);
    memcpy(key,argv[4],len > 7 ? 8:len);
    des1init(key);
  } else if (mode == 2) {
    memset(key2,0,16);
    len = strlen(argv[4]);
    memcpy(key2,argv[4],len > 15 ? 16:len);
    des2init(key2);
  } else if (mode == 3) {
    memset(key3,0,24);
    len = strlen(argv[4]);
    memcpy(key3,argv[4],len > 23 ? 24:len);
    des3init(key3);
  }
  t = time(NULL);
  while ((i = fread(buf,1,BUFSIZE,ih)) != 0) {
    for (b=buf; i > 0; i -=8 , b += 8) {
      if (!what) {
        if (i < 8) b[7] = i;
        if (mode == 1) des1encode(b,b);
        else if (mode == 2) des2encode(b,b);
        else if (mode == 3) des3encode(b,b);
        fwrite(b,1,8,oh);
        if (i < 8) fputc(i,oh);
      } else {
        if (mode == 1) des1decode(b,b);
        else if (mode == 2) des2decode(b,b);
        else if (mode == 3) des3decode(b,b);
        if (i == 9) {
          fwrite (b,1,b[7],oh);
          i = 0;
        }
        else fwrite(b,1,8,oh);
      }
    }
  }
  t1 = time(NULL) - t;
  printf("%scrypted bytes per second using %s DES: %ld\n", what ? "De":"En", 
          mode == 1 ? "single" : mode == 2 ? "double" : mode == 3 ? "triple"
          : "unknown", ftell(ih)/(t1 ? t1 : 1));
  fclose(ih);
  fclose(oh);
  return 0;
}
