/*
**
**   --- please read this ! ---
**
**  This source code is in "shrouded" form. It is distributed in this form
**  rather than as a library (.LIB) file because of the inconsistancies
**  between object files generated by different compilers. To support several
**  compilers would require a .LIB file for each compiler manufacturer, and
**  sometimes several versions of the .LIB file are needed for the different
**  versions of the same manufacturers compiler!
**
**  You can compile this code, but you will have to register with us in order
**  to get the normal (commented) C source code with normal variable names.
*/


#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <fcntl.h>
#include <string.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <malloc.h>
#include <dos.h>
#include <conio.h>
#include <io.h>

#include "zmodem.h"
#include "datetime.h"
#include "term_io.h"
#include "dir_io.h"
#include "dos_io.h"
#include "zdate.h"
#include "crc16.h"
#include "crc32.h"
#include "pcl4c.h"
#include "ascii.h"
#include "zconst.h"
#include "modem_io.h"
#include "win_io.h"

#define ABORT_CHAR    CAN

#define MAX_ERRORS   5
#define ZDELAY       1
#define CARRIER_TEST 0

#define LOW(x)  (0x00ff&(x))
#define HIGH(x) (0x00ff&((x)>>8))

#define BYTE unsigned char
#define WORD unsigned int
#define BOOL int

#define STRING_SIZE 50
#define FALSE 0
#define TRUE !FALSE

#define ZATTNLEN    32
#define ZBUFSIZE  1024

#define V59     18
#define V99    36
#define V37     9
#define V90    2


static int  V15 = 0;
static int  V63;
static long V71;
static BYTE V70[4];
static int  V72;
static int  V73;
static int  V69;
static BYTE V3[ZATTNLEN];
static char V28[15];
static WORD V31;
static WORD V27;
static long V26;
static BOOL V13 = FALSE;
static long V102;
static BYTE V101[4];
static WORD V23;
static int  V84;
static char V41[16] = {"0123456789abcdef"};
static char *AbortedMsg = "Aborted by USER";

static char *V53[21] =
       {"ZRQINIT", "ZRINIT",  "ZSINIT",    "ZACK",
        "ZFILE",   "ZSKIP",   "ZNAK",      "ZABORT",
        "ZFIN",    "ZRPOS",   "ZDATA",     "ZEOF",
        "ZFERR",   "ZCRC",    "ZCHALLENGE","ZCOMPL",
        "ZCAN",    "ZFREECNT","ZCOMMAND",  "ZSTDERR",
        "ZUNKNOWN"};

static char *V52[4] = {"ZBIN ", "ZHEX ", "ZBIN32 ", " "};



static int  V61;
static BYTE V98;
static int  V68;
static long V30;
static BOOL V45;
static BOOL V21;
static BYTE Zconv;
static BYTE V65[ZBUFSIZE];



static int  V44;
static long V82;
static int  V66;
static BYTE V100[ZBUFSIZE];



void V107(char V9, int V103, int V43, BYTE *V39)
{int i;
 char V87[STRING_SIZE];
 char V88[12];
 if(V103 > 20) V103 = 20;
 *V87 = V9;
 *(V87+1) = ':';
 *(V87+2) = '\0';
 if(V103<0) switch(V103)
   {case -42:
      strcat(V87, "MESSED_UP");
      break;
    case -41:
      strcat(V87, "ZNOCARRIER");
      break;
    case -40:
      strcat(V87, "ZERROR");
      break;
    case -1:
      strcat(V87, "ZTIMEOUT");
      break;
   }
 else
   {if(V15)
      {if( (V43>=ZBIN) && (V43<=ZBIN32)) strcat(V87,V52[V43-65]);
       strcat(V87,V53[V103]);
       strcat(V87," [");
       for(i=0;i<=3;i++)
         {sprintf(V88,"%x",V39[i]);
          strcat(V87,V88);
          if(i<3) strcat(V87,",");
          else strcat(V87,"]");
         }
      }
   }
 if( *(V87+2) != '\0') WriteMsg(V87);
}



void V122(BYTE V92)
{static BYTE V47;
 switch(0x7f & V92)
   {case CR:
      if((BYTE)(0x7f&V47)!=0x40)
         {V47 = V92;
          break;
         }
    case ZDLE:
    case DLE:
    case XON:
    case XOFF:
      CharPut(V63,(char)ZDLE);
      V47 = 0x40 ^ V92;
      break;
    default:
      V47 = V92;
      break;
   }
 CharPut(V63,(char)V47);
}



long V106(int V38)
{int  n;
 BYTE V25[ZBUFSIZE];
 long V12;
 int  V6;
 V12 = 0xFFFFFFFF;
 lseek(V38,0,SEEK_SET);
 do
    {V6 = read(V38,V25,ZBUFSIZE);
     for(n=0;n<V6;n++) V12 = UpdateCrc32(V25[n],V12);
    } while (V6 == ZBUFSIZE);
 lseek(V38,0,SEEK_SET);
 return V12;
}



BOOL V105(void)
{
#if CARRIER_TEST
 return SioDCD(V63);
#else
 return TRUE;
#endif
}



int V110(int V96)
{int r;
 while(1)
    {if(!V105()) return RCDO;
     r = CharGet(V63,1);
     if(r<-1)
       {WriteIntMsg("ERROR",r);
        return r;
       }
     if(r >= 0) return r;
     if(--V96<=0) return ZTIMEOUT;
    }
}



int V115(void)
{int c;
 while(1)
   {if((c = V110(V72)) < 0) return c;
    c &= 0x7f;
    if((c!=XON)&&(c!=XOFF)) return c;
   }
}



void V133(void)
{int n;
 SioTxFlush(V63);
 for(n=1;n<=8;n++)
   {CharPut(V63,(char)(CAN));
    SioDelay(V90);
   }
 for(n=1;n<=10;n++) CharPut(V63,(char)(BS));
}



void V121(BYTE *p)
{int i = 0;
 while ((i < ZBUFSIZE) && (p[i] != 0))
   {switch( p[i] )
      {case 221:
         SioBrkSig(V63,'A');
         break;
       case 222:
         SioDelay(V99);
         break;
       default:
         CharPut(V63,(char)(p[i]));
         break;
      }
    i++;
   }
}



void V119(BYTE Byte)
{
 CharPut(V63,V41[0x000f & (Byte >> 4)]);
 CharPut(V63,V41[0x000f & Byte]);
}



void V139(int V42, BYTE *V40)
{int   i;
 WORD  V12;
 V107('S',V42,ZHEX,V40);
 CharPut(V63,(char)(ZPAD));
 CharPut(V63,(char)(ZPAD));
 CharPut(V63,(char)(ZDLE));
 CharPut(V63,(char)(ZHEX));
 V119((BYTE)V42);
 V12 = UpdateCrc16((BYTE)V42,0);
 for(i=0;i<4;i++)
    {V119(V40[i]);
     V12 = UpdateCrc16(V40[i],V12);
    }
 V12 = UpdateCrc16(0,V12);
 V12 = UpdateCrc16(0,V12);
 V119((BYTE)HIGH(V12));
 V119((BYTE)LOW(V12));
 CharPut(V63,(char)(CR));
 CharPut(V63,(char)(LF));
 if((V42 != ZFIN) && (V42 != ZACK))
      CharPut(V63,(char)XON);
 if(!V105())
      SioTxFlush(V63);
}



long V114(BYTE *V40)
{long  V49;
 V49 = V40[ZP3];
 V49 = (V49 << 8) | V40[ZP2];
 V49 = (V49 << 8) | V40[ZP1];
 V49 = (V49 << 8) | V40[ZP0];
 return V49;
}



void V120(long V49)
{
 V101[ZP0] = (BYTE)(V49);
 V101[ZP1] = (BYTE)(V49 >> 8);
 V101[ZP2] = (BYTE)(V49 >> 16);
 V101[ZP3] = (BYTE)(V49 >> 24);
}



int V117(void)
{int  c;
 
getzdl100:
 if(!V105()) return RCDO;
 if((c = V110(V72)) < 0) return c;
 switch(c)
   {case ZDLE:
      break;
    case XON:
    case XOFF:
      goto getzdl100;
    default:
      return c;
   }
 
getzdl200:
 if(!V105()) return RCDO;
 
 if((c = V110(V72)) < 0) return c;
 if(c == CAN)
    {
     if((c = V110(V72)) < 0) return c;
     if(c == CAN)
        {
         if((c = V110(V72)) < 0) return c;
         if(c == CAN)
            {
             if((c = V110(V72)) < 0) return c;
            }
        }
    }
 
 switch( c )
    {case CAN:
        
        return GOTCAN;
     case ZCRCE:
     case ZCRCG:
     case ZCRCQ:
     case ZCRCW:
        
        return (c | GOTOR);
     case ZRUB0:
        
        return 0x007f;
     case ZRUB1:
        
        return 0x00ff;
     case XON:
     case XOFF:
        goto getzdl200;
     default:
        if((0x60 & c) == 0x40) return (0x40 ^ c);
        break;
    }
 WriteHexMsg("Bad escape sequence ",c);
 return ZERROR;
}



int V112(void)
{int c, n;
 n = V115();
 if(n < 0) return n;
 n = n - 0x30;
 if(n > 9)  n = n - 39;
 if((0xfff0 & n) != 0) return ZERROR;
 c = V115();
 if(c < 0) return c;
 c = c - 0x30;
 if (c > 9)  c = c - 39;
 if((0xfff0 & c) != 0) return ZERROR;
 return ( (n << 4) | c );
}



int V113(BYTE *V40)
{WORD V12;
 int c, n;
 c = V112();
 if(c < 0) return c;
 V73 = c;
 V12 = UpdateCrc16((BYTE)V73,0);
 for(n=0;n<4;n++)
    {c = V112();
     if(c < 0) return c;
     V40[n] = LOW(c);
     V12 = UpdateCrc16((BYTE)LOW(c),V12);
    }
 c = V112();
 if (c < 0) return c;
 V12 = UpdateCrc16((BYTE)LOW(c), V12);
 c = V112();
 if(c < 0) return c;
 V12 = UpdateCrc16((BYTE)LOW(c), V12);
 if(V12 != 0)
    {V23++;
     WriteIntMsg("Error(1)=",V23);
     return ZERROR;
    }
 if(V110(1) == CR)  c = V110(1);
 return V73;
}



int V108(BYTE *V40)
{WORD V12;
 int  c, n;
 c = V117();
 if(c < 0) return c;
 V73 = c;
 V12 = UpdateCrc16((BYTE)V73,0);
 for(n=0;n<4;n++)
    {c = V117();
     if(HIGH(c) != 0) return c;
     V40[n] = LOW(c);
     V12 = UpdateCrc16((BYTE)LOW(c),V12);
    }
 c = V117();
 if ((BYTE)HIGH(c) != 0) return c;
 V12 = UpdateCrc16((BYTE)LOW(c),V12);
 c = V117();
 if((BYTE)HIGH(c) != 0) return c;
 V12 = UpdateCrc16((BYTE)LOW(c),V12);
 if(V12 != 0)
    {V23++;
     WriteIntMsg("Error(2)=",V23);
     return 0;
    }
 return V73;
}



int V109(BYTE *V40)
{long V12;
 int  c, n;
 c = V117();
 if (c < 0) return c;
 V73 = c;
 V12 = UpdateCrc32((BYTE)V73,0xffffffffL);
 for(n=0;n<4;n++)
    {c = V117();
     if((BYTE)HIGH(c) != 0) return c;
     V40[n] = (BYTE)LOW(c);
     V12 = UpdateCrc32((BYTE)LOW(c),V12);
    }
 for(n=0;n<4;n++)
    {c = V117();
     if((BYTE)HIGH(c) != 0) return c;
     V12 = UpdateCrc32((BYTE)LOW(c),V12);
    }
 if (V12 != 0xdebb20e3)
    {V23++;
     WriteIntMsg("Error(3)=",V23);
     return ZERROR;
    }
 return V73;
}



int V111(BYTE *V40)
{int i;
 int c, n;
 int CANcount;
 n = 32;
 CANcount = 5;
V1:
 if(SioKeyPress()) if(SioKeyRead() == ABORT_CHAR)
      {V133();
       WriteMsg("Cancelled by USER");
       return ZCAN;
      }
 V69 = 0;
 V73 = 0;
 
 c = V115();
 switch( c )
    {case ZPAD:
        break;
     case RCDO:
     case ZTIMEOUT:
        goto V18;
     case CAN:
V36:
        if(--CANcount < 0)
           {c = ZCAN;
            goto V18;
           }
        c = V110(1);
        switch( c )
           {case ZTIMEOUT:
               goto V1;
            case ZCRCW:
               c = ZERROR;
               goto V18;
            case RCDO:
               goto V18;
            case CAN:
               CANcount--;
               if(CANcount < 0)
                  {c = ZCAN;
                   goto V18;
                  }
               goto V1;
            default:
               
               break;
           } 
        break;
     default: 
        
again2:
        if(--n < 0)
            {V23++;
             WriteIntMsg("Header is unrecognizable. Errors=",V23);
             return ZERROR;
            }
        if(c != CAN)  CANcount = 5;
        
        goto V1;
    } 
    
    CANcount = 5;
V81:
   c = V115();
   switch( c )
     {case ZDLE:
         break;
      case ZPAD:
         
         goto V81;
      case RCDO:
      case ZTIMEOUT:
         goto V18;
      default:
         goto again2;
     } 
   
   c = V115();
   switch( c )
      {case ZBIN32:
          V69 = ZBIN32;
          c = V109(V40);
          break;
       case ZBIN:
          V69 = ZBIN;
          c = V108(V40);
          break;
       case ZHEX:
          V69 = ZHEX;
          c = V113(V40);
          break;
       case CAN:
          goto V36;
       case RCDO:
       case ZTIMEOUT:
          goto V18;
       default:
          goto again2;
   } 
   V71 = V114(V40);
V18:
   V107('R',c,V69,V40);
   return c;
}



int V124(BYTE *V7,int V4)
{
 int  c, d;
 int  n, i;
 long V12;
 BOOL V18;
 int  RetValue = ZERROR;
 V12 = 0xffffffffL;
 V68 = 0;
 V18 = FALSE;
 do
    {c = V117();
     if((BYTE)HIGH(c) != 0)
        {
V14:
          switch( c )
              {case GOTCRCE:
               case GOTCRCG:
               case GOTCRCQ:
               case GOTCRCW:
                  d = c;
                  V12 = UpdateCrc32((BYTE)LOW(c),V12);
                  for(n=0;n<4;n++)
                     {c = V117();
                      if((BYTE)HIGH(c) != 0)  goto V14;
                      V12 = UpdateCrc32((BYTE)LOW(c),V12);
                     }
                  if(V12 != 0xdebb20e3)
                     {V23++;
                      WriteIntMsg("Error(4)=",V23);
                      RetValue = ZERROR;
                     }
                  else RetValue = d;
                  V18 = TRUE;
                  break;
               case GOTCAN:
                  RetValue = ZCAN;
                  V18 = TRUE;
                  break;
               case ZTIMEOUT:
                  RetValue = c;
                  V18 = TRUE;
                  break;
               case RCDO:
                  RetValue = c;
                  V18 = TRUE;
                  break;
               default:
                  WriteIntMsg("Garbage(1) = ",c);
                  SioDelay(V37);
                  SioRxFlush(V63);
                  RetValue = c;
                  V18 = TRUE;
              } 
        }
      if(!V18)
         {if(--V4 < 0)
             {WriteMsg("Long packet");
              RetValue = ZERROR;
              V18 = TRUE;
             }
          V7[(int)V68] = (BYTE)LOW(c);
          V68++;
          V12 = UpdateCrc32((BYTE)LOW(c),V12);
         }
    } while (!V18);
  return RetValue;
}



int V127(BYTE *V7, int V4)
{int  i;
 int  c, d;
 WORD V12;
 BOOL V18;
 int RetValue = ZERROR;
 if(V69 == ZBIN32)
     {
      return V124(V7,V4);
     }
 V12 = 0;
 V68 = 0;
 V18 = FALSE;
 do
    {c = V117();
     if((BYTE)HIGH(c) != 0)
        {
V14:
         switch( c )
            {case GOTCRCE:
             case GOTCRCG:
             case GOTCRCQ:
             case GOTCRCW:
                d = c;
                V12 = UpdateCrc16((BYTE)LOW(c),V12);
                c = V117();
                if((BYTE)HIGH(c) != 0)  goto V14;
                V12 = UpdateCrc16((BYTE)LOW(c),V12);
                c = V117();
                if ((BYTE)HIGH(c) != 0)  goto V14;
                V12 = UpdateCrc16((BYTE)LOW(c),V12);
                if(V12 != 0)
                    {V23++;
                     WriteIntMsg("Error(5)=",V23);
                     RetValue = ZERROR;
                     V18 = TRUE;
                    }
                RetValue = d;
                V18 = TRUE;
                break;
             case GOTCAN:
                WriteMsg("Received CAN");
                RetValue = ZCAN;
                V18 = TRUE;
                break;
             case ZTIMEOUT:
                RetValue = c;
                V18 = TRUE;
                break;
             case RCDO:
                WriteMsg("Lost carrier");
                RetValue = c;
                V18 = TRUE;
                break;
             default:
                WriteHexMsg("Garbage(2) = ",c);
                SioDelay(V37);
                SioRxFlush(V63);
                RetValue = c;
                V18 = TRUE;
                break;
            } 
        } 
     if(!V18)
        {if(--V4 < 0)
            {WriteMsg("Long packet");
             RetValue = ZERROR;
             V18 = TRUE;
            }
         V7[(int)V68] = (BYTE)LOW(c);
         V68++;
         V12 = UpdateCrc16((BYTE)LOW(c),V12);
        }
    } while (!V18);
 return RetValue;
}



void V74(void)
{int  n, i;
 V120(V71);
 n = 4;
 SioDelay(ZDELAY);
 SioRxFlush(V63);
 do
    {V139(ZFIN,V101);
     switch( V110(V99) )
        {case ZTIMEOUT:
         case RCDO:
            return;
         case 79:
            if(V110(V59) == 79) ; 
            SioDelay(V37);
            SioRxFlush(V63);
            return;
         default:
            SioDelay(V37);
            SioRxFlush(V63);
            n--;
        } 
    } while (n > 0);
}


int V76(void)
{int  c, n, V24;
 for(n=0;n<ZATTNLEN;n++) V3[n] = 0;
 V23 = 0;
 V24 = 0;
 for(n=10;n>=0;n--)
    {if(!V105())
        {WriteMsg("Lost carrier");
         return ZERROR;
        }
      V120(0L);
      V101[ZF0] = CANFDX || CANOVIO || CANFC32 || CANBRK;
      V13 = CANFC32;
      if(V13) WriteMsg("Using CRC 32");
      V139(V98,V101);
      if(V98 == ZSKIP)  V98 = ZRINIT;
V1:
      c = V111(V70);
      switch( c )
         {case ZFILE:
             Zconv = V70[ZF0];
             V98 = ZRINIT;
             c = V127(V65,ZBUFSIZE);
             if(c == GOTCRCW) return ZFILE;
             V139(ZNAK,V101);
             goto V1;
          case ZSINIT:
             c = V127(V3,ZATTNLEN);
             if(c == GOTCRCW) V139(ZACK,V101);
             else V139(ZNAK,V101);
             goto V1;
          case ZFREECNT:
             
             V120(FreeDiskSpace());
             V139(ZACK,V101);
             goto V1;
          case ZCOMMAND:
             c = V127(V65,ZBUFSIZE);
             if(c == GOTCRCW)
                {V120(0);
                 do
                    {V139(ZCOMPL,V101);
                     V24++;
                    } while ((V24 <= MAX_ERRORS) && (V111(V70) != ZFIN));
                 V74();
                 return ZCOMPL;
                }
             V139(ZNAK,V101);
             goto V1;
          case ZCOMPL:
          case ZFIN:
             return ZCOMPL;
          case ZCAN:
          case RCDO:
             return c;
         } 
    } 
 WriteMsg("Timed out");
 return ZERROR;
}



int V75(void)
{int  i, p;
 char c;
 char V94[STRING_SIZE];
 long V93;
 char V87[STRING_SIZE];
 V45 = TRUE;
 V26 = 0L;
 V94[0] = '\0';
 
 p = 0;
 while(1)
   {if(p==ZBUFSIZE) break;
    c = toupper((char)V65[p]);
    if(c=='\0') break;
    else V94[p++] = c;
   }
 V94[p++] = '\0';

 
 strcpy(V28,V94);

 
 V26 = 0L;
 while(1)
   {if(p==ZBUFSIZE) break;
    c = (char)V65[p];
    if((c==' ')||(c=='\0')) break;
    V26 = (10 * V26) + (c - 0x30);
    p++;
   }
 p++;
 
 i = 0;
 while(1)
   {if(p==ZBUFSIZE) break;
    c = V65[p++];
    if((c<'0')||(c>'7')) break;
    V94[i++] = c;
   }
 V94[i] = '\0';
 p++;
 Z2DosDate(V94,&V27,&V31);
 
 if(FindFirst(V28,NULL,&V93))
    {
     if(V93 > 0)
       {if((Zconv == ZCRESUM) && (V26 > V93))
           {V30 = V93;
            V61 = open(V28,O_WRONLY|O_APPEND|O_BINARY,S_IWRITE);
            if(V61<0)
               {sprintf(V87,"Unable to open(1) %s",V28);
                WriteMsg(V87);
                return ZERROR;
               }
            WriteLongMsg("Recovering to",V30);
           }
        else
           {sprintf(V87,"%s is already complete",V28);
            WriteMsg(V87);
            return ZSKIP;
           }
       }
    }
 else
    {
     V30 = 0;
     V61 = open(V28,O_CREAT|O_TRUNC|O_WRONLY|O_BINARY,S_IWRITE);
     if(V61<0)
        {strcpy(V87,"Unable to create ");
         strcat(V87,V28);
         WriteMsg(V87);
         return ZERROR;
        }
    }
 WriteLongMsg("Size=",V26);
 return ZOK;
}



int V77(long *V67)
{int RetValue;
 if(SioKeyPress()) if(SioKeyRead() == ABORT_CHAR)
     {WriteMsg(AbortedMsg);
      V133();
      return ZERROR;
     }
 if(write(V61,V65,V68)!=V68)
     {WriteIntMsg("Disk write error",errno);
      RetValue = ZERROR;
     }
  else RetValue = ZOK;
  *V67 = *V67 + V68;
  return RetValue;
}



int V128(void)
{int  c, n;
 long V67;
 BOOL V18;
 V23 = 0;
 V18 = FALSE;
 V21 = FALSE;
 c = V75();
 if(c != ZOK)
    {if(c == ZSKIP)  V98 = ZSKIP;
     return c;
    }
 c = ZOK;
 n = MAX_ERRORS;
 V67 = V30;
 V71 = V30;
 do
    {V120(V67);
     V139(ZRPOS,V101);
V58:
     c = V111(V70);
     switch( c )
        {case ZDATA:
            if(V71 != V67)
                {n--;
                 V23++;
                 WriteIntMsg("Error(6)=",V23);
                 if(n < 0)  goto V22;
                 WriteMsg("Bad position");
                 V121(V3);
                }
            else
                {
V51:
                 c = V127(V65,ZBUFSIZE);
                 switch( c )
                     {case ZCAN:
                      case RCDO:
                          goto V22;
                      case ZERROR:
                          n--;
                          V23++;
                          WriteIntMsg("Error",V23);
                          if(n < 0)  goto V22;
                          V121(V3);
                          break;
                      case ZTIMEOUT:
                          n--;
                          if(n < 0)  goto V22;
                          break;
                      case GOTCRCW:
                          n = MAX_ERRORS;
                          c = V77(&V67);
                          if(c != ZOK) return c;
                          WriteLongMsg("ZCRCW: Pos=",V67);
                          V120(V67);
                          V139(ZACK,V101);
                          goto V58;
                      case GOTCRCQ:
                          n = MAX_ERRORS;
                          c = V77(&V67);
                          if(c != ZOK) return c;
                          WriteLongMsg("ZCRCQ: Pos=",V67);
                          V120(V67);
                          V139(ZACK,V101);
                          goto V51;
                      case GOTCRCG:
                          n = MAX_ERRORS;
                          c = V77(&V67);
                          if (c != ZOK) return c;
                          WriteLongMsg("ZCRCG: Pos=",V67);
                          goto V51;
                      case GOTCRCE:
                          n = MAX_ERRORS;
                          c = V77(&V67);
                          if(c != ZOK) return c;
                          WriteLongMsg("ZCRCE: Pos=",V67);
                          goto V58;
                     } 
                } 
            break;
         case ZNAK:
         case ZTIMEOUT:
            if (--n < 0)  goto V22;
            WriteLongMsg("ZNAK: Pos=",V67);
            break;
         case ZFILE:
            c = V127(V65,ZBUFSIZE);
            break;
         case ZEOF:
            if(V71 == V67) return c;
            else goto V58;
         case ZERROR:
            if(--n < 0)  goto V22;
            WriteLongMsg("ZERROR: Pos=",V67);
            V121(V3);
            break;
         default:
            return ZERROR;
      } 
   } while (V18);
V22:
   return ZERROR;
}



int V126(void)
{int  c;
 long V96;
 char V87[50];
 while(TRUE)
     {if(!V105()) return ZERROR;
      V96 = SioTimer();
      c = V128();
      SetFileDT(V61,V27,V31);
      WriteCPS(V96,V26,V28,(c==ZSKIP));
      close(V61);
      switch( c )
         {case ZEOF:
          case ZSKIP:
             c = V76();
             switch( c )
                {case ZFILE:
                    break;
                 case ZCOMPL:
                    V74();
                    return ZOK;
                 default:
                    return ZERROR;
                } 
             break;
          default: 
             return c;
         } 
     } 
}



BOOL V125(int V62)
{int i;
 V63 = V62;
 WriteIntMsg("zmReceive: V63 = COM",1+V63);
 V72 = 10 * V59;
 V98 = ZRINIT;
 i = V76();
 if((i==ZCOMPL) || ((i==ZFILE) && (V126() == ZOK)))
    {WriteMsg("Done.");
     return TRUE;
    }
 else
    {SioTxFlush(V63);
     WriteMsg("Sending CAN");
     V133();
     WriteMsg("Done.");
     return FALSE;
    }
}



void V130(BYTE V42,BYTE *V40)
{long  V12;
 int   i, n;
 V107('S',V42,ZBIN32,V40);
 CharPut(V63,(char)(ZPAD));
 CharPut(V63,(char)(ZDLE));
 CharPut(V63,(char)(ZBIN32));
 V122(V42);
 V12 = UpdateCrc32(V42,0xffffffffL);
 for(n=0;n<4;n++)
    {V122(V40[n]);
     V12 = UpdateCrc32(V40[n],V12);
    }
 V12 = ~V12;
 for(n=0;n<4;n++)
    {V122((BYTE)V12);
     V12 = (V12 >> 8);
    }
 if(V42 != ZDATA)  SioDelay(V90+ZDELAY);
}



void V131(BYTE V42,BYTE *V40)
{WORD V12;
 int  i, n;
 if(V13)
    {V130(V42,V40);
     return;
    }
 V107('S',V42,ZBIN,V40);
 CharPut(V63,(char)(ZPAD));
 CharPut(V63,(char)(ZDLE));
 CharPut(V63,(char)(ZBIN));
 V122(V42);
 V12 = UpdateCrc16(V42,0);
 for(n=0;n<4;n++)
    {V122(V40[n]);
     V12 = UpdateCrc16(V40[n],V12);
    }
 V12 = UpdateCrc16(0,V12);
 V12 = UpdateCrc16(0,V12);
 V122((BYTE)HIGH(V12));
 V122((BYTE)LOW(V12));
 if (V42 != ZDATA)  SioDelay(V90+ZDELAY);
}



void V134(BYTE *V7,int  V4,BYTE V33)
{long V12;
 int  i;
 V12 = 0xffffffffL;
 for(i=0;i<V4;i++)
    {V122(V7[i]);
     V12 = UpdateCrc32(V7[i],V12);
    }
 V12 = UpdateCrc32(V33,V12);
 V12 = (~V12);
 CharPut(V63,(char)(ZDLE));
 CharPut(V63,(char)(V33));
 for(i=0;i<4;i++)
    {V122((BYTE)V12);
     V12 = (V12 >> 8);
    }
 CharPut(V63,(char)(XON));
 SioDelay(ZDELAY);
}



void V135(BYTE *V7,int V4,BYTE V33)
{WORD V12;
 int  i;
 if(V13)
    {V134(V7,V4,V33);
     return;
    }
 V12 = 0;
 for(i=0;i<V4;i++)
    {V122(V7[i]);
     V12 = UpdateCrc16(V7[i],V12);
    }
 
 V12 = UpdateCrc16(V33,V12);
 CharPut(V63,(char)(ZDLE));
 CharPut(V63,(char)(V33));
 V12 = UpdateCrc16(0,V12);
 V12 = UpdateCrc16(0,V12);
 V122((BYTE)HIGH(V12));
 V122((BYTE)LOW(V12));
 if(V33 == ZCRCW)
    {CharPut(V63,(char)(17));
     SioDelay(ZDELAY);
    }
}



void V136(void)
{int  i;
 do
    {V120(V102);
     V131(ZFIN,V101);
     switch( V111(V70) )
        {case ZFIN:
            CharPut(V63,'O');
            CharPut(V63,'O');
            SioDelay(V90);
            SioTxFlush(V63);
            return;
         case ZCAN:
         case RCDO:
         case ZFERR:
         case ZTIMEOUT:
            return;
        }
    } while (TRUE);
}



int V85(void)
{int  n, c;
 WriteMsg("Getting receiver info.");
 for(n=1;n<MAX_ERRORS;n++)
    {c = V111(V70);
     switch( c )
        {case ZCHALLENGE:
            V120(V71);
            V139(ZACK,V101);
            break;
         case ZCOMMAND:
            V120(0L);
            V139(ZRQINIT,V101);
            break;
         case ZRINIT:
            V66 = ((WORD)(V70[ZP1]) << 8) | V70[ZP0];
            V13 = (V70[ZF0] & CANFC32);
            if(V13) WriteMsg("Using CRC 32");
            return ZOK;
         case ZCAN:
         case RCDO:
         case ZTIMEOUT:
            return ZERROR;
         default:
            if((c != ZRQINIT)||(V70[ZF0] != ZCOMMAND))
              V139(ZNAK,V101);
            break;
        } 
    } 
 return ZERROR;
}



int V86(void)
{int  i, c;
 int  V55 = MAX_ERRORS;
 do
    {c = V111(V70);
     
     SioRxFlush(V63);
     switch( c )
        {case ZTIMEOUT:
            if(--V55 < 0) return ZERROR;
         case ZCAN:
         case ZABORT:
         case ZFIN:
         case RCDO:
            return ZERROR;
         case ZRPOS:
            if(lseek(V44,V71,SEEK_SET)<0)
               {WriteMsg("File seek error");
                return ZERROR;
               }
            WriteLongMsg("New Pos=",V71);
            V102 = V71;
            return c;
         case ZSKIP:
         case ZRINIT:
         case ZACK:
            return c;
         default:
            WriteMsg("Unspecified error!");
            V131(ZNAK,V101);
            break;
        } 
    } while (TRUE);
}



int V138(void)
{int i, c;
 int V33;
 int V56;
 int V5;
 int V8;
 int V50;
 int V34;
 int V35;
 V35 = 1;
 V50 = ZBUFSIZE;
 V5 = V50;
V80:
 SioDelay(ZDELAY);
 if(SioRxQue(V63) == 0)
    {
V104:
     c = V86();
     switch( c )
        {case ZSKIP:
            return ZSKIP;
         case ZACK:
            break;
         case ZRPOS:
            V23++;
            WriteIntMsg("Error(7)=",V23);
            if ((V5 >> 2) > 32) V5 = (V5 >> 2);
            else V5 = 32;
            V34 = 0;
            V35 = (V35 << 1) | 1;
            break;
         case ZRINIT:
            return ZOK;
         default:
            return ZERROR;
      } 
     while(1)
         {i = V110(ZDELAY);
          if(i<0) break;
          switch( i )
              {case CAN:
               case ZPAD:
                  goto V104;
               case RCDO:
                  return ZERROR;
              } 
         }
    }
   V56 = V66;
   V120(V102);
   V131(ZDATA,V101);
   do
      {if(SioKeyPress()) if(SioKeyRead() == ABORT_CHAR)
          {WriteMsg(AbortedMsg);
           V133();
           goto V60;
          }
       if(!V105())  goto V60;
       V8 = read(V44,V100,V5);
       if(V8<0)
          {WriteMsg("Error reading disk");
           V133();
           goto V60;
          }
       if(V8 < V5) V33 = ZCRCE;
       else
          {if((V66 != 0) && ((V56 - V8) <= 0))
             {V56 = (V56 - V8);
              V33 = ZCRCW;
             }
           else
             {if(V84) V33 = ZCRCG;
              else V33 = ZCRCW;
             }
          }
       
       switch(V33)
         {case ZCRCE:
             WriteLongMsg("ZCRCE: Pos=",V102);
             break;
          case ZCRCW:
             WriteLongMsg("ZCRCW: Pos=",V102);
             break;
          case ZCRCG:
             WriteLongMsg("ZCRCG: Pos=",V102);
             break;
          default:
             WriteLongMsg("ZCRC?: Pos=",V102);
         }
       
       V135(V100,V8,(BYTE)V33);
       V102 = V102 + V8;
       V34++;
       if((V5 < V50) && (V34 > V35))
          {if((V5 << 1) < V50)
                V5 = (V5 << 1);
           else
                V5 = V50;
           V34 = 0;
          }
       if(V33 == ZCRCW)  goto V104;
       while(1)
          {i = V110(ZDELAY);
           if(i < 0) break;
           switch( i )
              {case CAN:
                   WriteMsg("CAN !");
               case ZPAD:
                   WriteMsg("Trouble?");
                   SioTxFlush(V63);
                   V135(V100,0,ZCRCE);
                   goto V104;
                case RCDO:
                   return ZERROR;
            } 
         } 
      } while (V33 == ZCRCG);
   do
     {V120(V102);
      WriteMsg("Sending EOF");
      V131(ZEOF,V101);
      c = V86();
      switch( c )
         {case ZACK:
             break;
          case ZRPOS:
             goto V80;
          case ZRINIT:
             return ZOK;
          case ZSKIP:
             return c;
          default:
V60:        return ZERROR;
         } 
   } while (c == ZACK);
 return c;
}



int V137(void)
{int  i, c;
 V23 = 0;
 do
   {if(SioKeyPress()) if(SioKeyRead() == ABORT_CHAR)
       {V133();
        WriteMsg(AbortedMsg);
        return ZERROR;
       }
    if(!V105())
       {WriteMsg("Lost carrier");
        return ZERROR;
       }
    for(i=0;i<4;i++) V101[i] = 0;
    V101[ZF0] = ZCRESUM; 
    V131(ZFILE,V101);
    V135(V100,ZBUFSIZE,ZCRCW);
    do
       {c = V111(V70);
        switch( c )
           {case ZCAN:
            case RCDO:
            case ZTIMEOUT:
            case ZFIN:
            case ZABORT:
               return ZERROR;
            case ZRINIT:
               break;
            case ZCRC:
               V120(V106(V44));
               V139(ZCRC,V101);
               break;
            case ZSKIP:
               return c;
            case ZRPOS:
               if(lseek(V44,V71,SEEK_SET)<0)
                  {WriteLongMsg("File positioning error to ",V71);
                   V139(ZFERR,V101);
                   return ZERROR;
                  }
               WriteLongMsg("Setting start position =",V71);
               V82 = V71;
               V102 = V71;
               return V138();
           } 
       } while (c == ZRINIT);
   } while (TRUE);
}


BOOL V129(int V62,char *TheFile,BOOL LastFile)
{int i, n;
 long V96;
 char V87[STRING_SIZE];
 
 V23 = 0;
 V63 = V62;
 if(!V105())
    {WriteMsg("Lost carrier");
     SioDelay(V99);
     return FALSE;
    }
 if(!FileSDT(TheFile,&V26,&V27,&V31))
    {sprintf(V87,"Unable to open(2) %s",TheFile);
     WriteMsg(V87);
     V136();
     return FALSE;
    }
 sprintf(V87,"Sending %s, size=%ld",TheFile,V26);
 WriteMsg(V87);
 if(V26==0L)
    {WriteMsg("File is empty!");
     SioDelay(V59);
     return FALSE;
    }
 
 for(i=0;i<ZBUFSIZE;i++) V100[i] = '\0';
 n = strlen(TheFile);
 for(i=0;i<n;i++) V28[i] = tolower(TheFile[i]);
 V28[i] = '\0';
 sprintf(V100,"%s %ld ",V28,V26);
 Dos2Zdate(V27,V31,V87,STRING_SIZE);
 strcat(V100,V87);
 V100[n] = '\0';
 V72 = 10 * V59;
 V3[0] = 'r';
 V3[1] = 'z';
 V3[3] = 13;
 V3[4] = 0;
 V121(V3);
 for(i=0;i<ZATTNLEN;i++) V3[i] = 0;
 V120(0L);
 V139(ZRQINIT,V101);
 if(V85() == ZERROR) return FALSE;
 V44 = open(V28,O_RDONLY|O_BINARY,S_IREAD);
 if(V44<0)
    {sprintf(V87,"Cannot open '%s'",V28);
     WriteMsg(V87);
     V133();
     return FALSE;
    }
 
 V96 = SioTimer();
 n = V137();
 WriteCPS(V96,V26,V28,(n==ZSKIP));
 close(V44);
 if(LastFile)  V136();
 return TRUE;
}



BOOL ZmodemTx(int V62, char *V29,int V83)
{char V95[15];
 char V57[15];
 BOOL V46;
 BOOL V64;
 char V87[40];
 V84 = V83;
 V64 = FALSE;
 V46 = FALSE;
 
 if(!FetchName(V29)) return FALSE;
 
 if(!FindFirst(V29,V95,NULL))
   {sprintf(V87,"Cannot open %s",V29);
    WriteMsg(V87);
    return FALSE;
   }
 
 do
    {if(!FindNext(V57,NULL)) V46 = TRUE;
     sprintf(V87,"Sending %s",V95);
     WriteMsg(V87);
     SioDelay(V90+ZDELAY);
     V64 = V129(V62,V95,V46);
     if(!V46) strcpy(V95,V57);
    } while (!V46);
 if(V64) WriteMsg("ZMODEM completed");
 else WriteMsg("ZMODEM failed");
 ModemQuiet(V62,9);
 return V64;
}



BOOL ZmodemRx(int V62,int V83)
{BOOL V64;
 V84 = V83;
 V64 = V125(V62);
 if(V64) WriteMsg("ZMODEM completed");
 else WriteMsg("ZMODEM failed");
 ModemQuiet(V62,9);
 return V64;
}
