;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                Automatic centermarks and centerlines.                       
;              Copied from Cadence magazine November 1992.
;             
; 
;                                  
;    This program searches the current drawing for all occurrences of circles,
;arcs, and blocks and places centermarks at the centers of each circle and arc
;and at the insertion points of each block.  It will then add centerlines
;between all perpendicular points.
;
;    You are first prompted for the entities to centermark.  You can choose
;arcs or blocks, a combination of any two, or all three (arcs/blocks/circles).
;You also have the option of selecting individual entities to include entities 
;that you may have added after running the program a first time or to
;selectively mark only a few entities that could include text and lines. 
;
;    After you have made a selection, a tally of all centermarked circles, arcs, and
;blocks are echoed to the text screen as processed.  If objects were selected 
;individually, the total entities centermarked are echoed instead.  If there 
;are no perpindicular points, no centerlines will be drawn.  A message will
;indicate when centerlines are being calculated and drawn.
;
;     Occasionally, two points that seem perpendicular are off slightly; no
;centerline will be placed between these two points.  To correct this a fuzz
;factor in a variable labeled fuz preset to 0.0002.  A different value may be
;placed here instead by changing the variable fuz in the main program.  The
;centermarks and lines are drawn on a new layer "Center" with the linetype
;"Center".  If this layer and/or linetype does not exist, they will be created.
;
;     Centermarks are drawn to twice the length specified in the Dimcen dimvar
;and to the scale specified in the Dimscale dimvar.  The gap between the ends 
;of the centermarks and the beginnings and ends of the centerlines is governed
;by the Dimexo dimvar and to the scale specified in the Dimscale dimvar.  By
;changing these system variables, you can alter the size of the centermarks 
;and the spacing between the ends of the lines.  Responding with a "?" will
;display a simple help screen that displays the current settings of the above-
;stated dimvars.
;
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


(defun DOARCS ()
  (setq sset (ssget "x" (list (cons 0 "ARC"))))
  (if (/= sset nil)
    (progn
      (setq ssl (sslength sset))
      (while (> ssl 0)
        (setq temp (ssname sset (setq ssl (1- ssl))))
        (setq ctr (cdr (assoc 10 (entget temp))))
        (command "Line" (list (- (car ctr) dcen) (cadr ctr) (caddr ctr))
                        (list (+ (car ctr) dcen) (cadr ctr) (caddr ctr))
             ""  "Line" (list (car ctr) (- (cadr ctr) dcen) (caddr ctr))
                        (list (car ctr) (+ (cadr ctr) dcen) (caddr ctr))
              ""
          ))))
    (if (= sset nil) (setq ssl 0) (setq ssl (sslength sset)))
    (princ ssl) (princ "Arcs marked. ")
  )

   (defun DOBLKS ()
      (setq sset (ssget "x" (list (cons 0 "INSERT") (cons 2 "*"))))
      (if (/= sset nil)
       (progn
         (setq ssl (sslength sset))
         (while (> ssl 0)
           (setq temp (ssname sset (setq ssl (1- ssl))))
           (setq ctr (cdr (assoc 10 (entget temp))))
           (command "Line" (list (- (car ctr) dcen) (cadr ctr) (caddr ctr))
                           (list (+ (car ctr) dcen) (cadr ctr) (caddr ctr))
                "" "Line"  (list (car ctr) (- (cadr ctr) dcen) (caddr ctr))
                           (list (car ctr) (+ (cadr ctr) dcen) (caddr ctr))
                      ""))))
       (if (= sset nil) (setq ssl 0) (setq ssl (sslength sset)))
       (princ ssl) (princ " Blocks marked. ")
    )

    (defun DOCRCLS ()
       (setq sset (ssget "x" (list (cons 0 "CIRCLE"))))
       (if (/= sset nil)
        (progn
          (setq ssl (sslength sset))
          (while (> ssl 0)
            (setq temp (ssname sset (setq ssl (1- ssl))))
            (setq ctr (cdr (assoc 10 (entget temp))))
            (command "Line" (list (- (car ctr) dcen) (cadr ctr) (caddr ctr))
                            (list (+ (car ctr) dcen) (cadr ctr) (caddr ctr))
                  "" "Line" (list (car ctr) (- (cadr ctr) dcen) (caddr ctr))
                            (list (car ctr) (+ (cadr ctr) dcen) (caddr ctr))
                    ""))))
         (if (= sset nil) (setq ssl 0) (setq ssl (sslength sset)))
         (princ ssl) (princ "Circles marked.")
     )             
    (defun DOSEL ()
      (setq sset (ssget))
      (if (/= sset nil)
         (progn
          (setq ssl (sslength sset))
          (while (> ssl 0)
           (setq temp (ssname sset (setq ssl (1- ssl))))
           (setq ctr (cdr (assoc 10 (entget temp))))
           (command "Line" (list (- (car ctr) dcen) (cadr ctr) (caddr ctr))
                           (list (+ (car ctr) dcen) (cadr ctr) (caddr ctr))
                 "" "Line" (list (car ctr) (- (cadr ctr) dcen) (caddr ctr))
                           (list (car ctr) (+ (cadr ctr) dcen) (caddr ctr))
                 ""))))
        (if (= sset nil) (setq ssl 0) (setq ssl (sslength sset)))
        (princ ssl) (princ "Entities marked.")
     )

   (defun CLINE ()
     (cond 
   ((= what "A") (setq sset (ssget "X" (list (cons 0 "ARC")))))
   ((= what "B") (setq sset (ssget "X" (list (cons 0 "INSERT") (cons 2 "*")))))
   ((= what "C") (setq sset (ssget "X" (list (cons 0 "CIRCLE")))))
   ((= what "AB") (setq sset (ssget "X" (list (cons 0 "ARC,INSERT")))))
   ((= what "AC") (setq sset (ssget "X" (list (cons 0 "ARC,CIRCLE")))))
   ((= what "BC") (setq sset (ssget "X" (list (cons 0 "INSERT,CIRCLE")))))
   ((= what "ABC") (setq sset (ssget "X" (list (cons 0 "ARC,INSERT,CIRCLE")))))
   ((= what nil) (if (/= sset nil) (setq sset (ssget "p"))))
    )
       (if (/= sset nil) (setq ssl (sslength sset)) (setq ssl -1))
       (while (> ssl 0)
         (setq temp (ssname sset (setq ssl (1- ssl))))
         (setq ctr (cdr (assoc 10 (entget temp))))
         (setq holdx nil holdy nil ydist nil xdist nil)
         (setq newssl (sslength sset))
         (while (> newssl 0)
           (setq newtemp (ssname sset (setq newssl (1- newssl)))
                 newctr (cdr (assoc 10 (entget newtemp))))
           (if
             (and (not (equal ctr newctr))
             (equal (list (car ctr) (caddr ctr))
               (list (car newctr) (caddr newctr))fuz)
              (< (cadr ctr) (cadr newctr)))
            (progn
             (if (= ydist nil) (setq ydist (distance ctr newctr)))
             (if (<= (distance ctr newctr) ydist)
               (setq ydist (distance ctr newctr) holdy newctr))))
          (if
             (and (not (equal ctr newctr))
                  (equal (list (cadr ctr) (caddr ctr))
                   (list (cadr newctr) (caddr newctr))fuz)
                   (< (car ctr) (car newctr)))
            (progn
             (if (= xdist nil) (setq xdist (distance ctr newctr)))
             (if (<= (distance ctr newctr) xdist)
              (setq xdist (distance ctr newctr) holdx newctr)))))
       (if (/= holdx nil)
        (command "Line"
            (list (+ (car ctr) dcen dgap) (cadr ctr) (caddr ctr))
            (list (- (car holdx) dcen dgap) (cadr holdx) (caddr holdx))
           ""))
         (if (/= holdy nil)
          (command "Line"
            (list (car ctr) (+ (cadr ctr) dcen dgap) (caddr ctr))
            (list (car holdy) (- (cadr holdy) dcen dgap) (caddr holdy))
            "")))

   )
                              
(defun DOLINE ()
   (setvar "BLIPMODE" blip)
   (setq holdx T)
   (while (= holdx T)
     (setq ctr (getpoint "\nPick first point: "))
     (if /= ctr nil) (setq newctr (getpoint ctr "Pick second point: ")))
     (if (or (= ctr nil) (= newctr nil))
       (setq holdx nil)
       (cond
        ((= (angle ctr newctr) (angle '(1.0 1.0) '(2.0 1.0)))
           (command "Line"
             (list (+ (car ctr) dgap) (cadr ctr) (caddr ctr)) 
             (list (- (car newctr) dgap) (cadr newctr) (caddr newctr)) ""))
        ((= (angle ctr newctr) (angle '(2.0 1.0) '(1.0 1.0)))
          (command "Line"
            (list (- (car ctr) dgap) (cadr ctr) (caddr ctr))
            (list (+ (car newctr) dgap) (cadr newctr) (caddr newctr)) ""))
        ((= (angle ctr newctr) (angle '(1.0 1.0) '(1.0 2.0)))
           (command "Line"
             (list (car ctr) (+ (cadr ctr) dgap) (caddr ctr))
             (list (car newctr) (- (cadr newctr) dgap) (caddr newctr)) ""))
         ((= (angle ctr newctr) (angle '(1.0 2.0) '(1.0 1.0)))
            (command "Line"
              (list (car ctr) (- (cadr ctr) dgap) (caddr ctr))
              (list (car newctr) (+ (cadr newctr) dgap) (caddr newctr)) ""))
          ((and
              (/= (angle ctr newctr) (angle '(1.0 1.0) '(2.0 1.0)))
              (/= (angle ctr newctr) (angle '(2.0 1.0) '(1.0 1.0)))
              (/= (angle ctr newctr) (angle '(1.0 1.0) '(1.0 2.0)))
              (/= (angle ctr newctr) (angle '(1.0 2.0) '(1.0 1.0))))
                 (prompt "NOT PERPENDICULAR!"))
 )))
 
               
 (defun C:CL (/ err dcen dgap blip echo sset ssl temp ctr holdx holdy
                    xdist ydist newctr newtemp newssl what fuz)
    (setq err *error*)
    (setq dcen (* (getvar "DIMCEN") (getvar "DIMSCALE")))
    (setq dgap (* (getvar "DIMEXO") (getvar "DIMSCALE")))
    (setq blip (getvar "BLIPMODE"))
    (setq echo (getvar "CMDECHO"))
    (setvar "BLIPMODE" 0)
    (setvar "CMDECHO" 0)
    (setq fuz 0.0002);;
    (if (not (tblsearch "LTYPE" "CENTER"))
      (command "LINETYPE" "LOAD" "CENTER" "" ""))
    (command "LAYER" "M" "CENTER" "C" "RED" "CENTER" "LT" "CENTER" "CENTER" "")
    (initget "A B C AB AC BC ABC I L ?")
    (setq what
      (getkword "\nArcs/Blocks/Circles/AB/AC/BC/ABC/Line <Individual>: "))
    (terpri)
    (cond
     ((= what "A") (doarcs))
     ((= what "B") (doblks))
     ((= what "C") (docrcls))
     ((= what "AB") (doarcs) (doblks))
     ((= what "AC") (doarcs) (docrcls))
     ((= what "BC") (doblks) (docrcls))
     ((= what "ABC") (doarcs) (doblks) (docrcls))
     ((= what "I") (dosel))
     ((= what nil) (dosel))
     ((= what "L") (doline))
  )
  (if (and (/= what "?") (> ssl 1))
  (progn
    (prompt "\nAdding centerlines...")
    (if (> ssl 4) (prompt "Please wait..."))
    (cline)
    (prompt "Complete"))
   (prompt "\n"))
  (setq *error* err)
  (command "LAYER" "S" "0" "")
   (setvar "BLIPMODE" blip)
   (setvar "CMDECHO" echo)
   (princ)
 )
   











      
                








                  
